package lmcoursier.definitions

import dataclass.data

@data final class Info private (val description: String, val homePage: String, val licenses: Seq[(String, Option[String])], val developers: Seq[Developer], val publication: Option[DateTime]) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: Info =>
    this.description == c.description && this.homePage == c.homePage && this.licenses == c.licenses && this.developers == c.developers && this.publication == c.publication
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(description, homePage, licenses, developers, publication)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(description: String = this.description, homePage: String = this.homePage, licenses: Seq[(String, Option[String])] = this.licenses, developers: Seq[Developer] = this.developers, publication: Option[DateTime] = this.publication): Info = new Info(description, homePage, licenses, developers, publication)
override def canEqual(obj: Any): Boolean = obj match {
  case c: Info => true
  case _ => false
}
override def productArity = 5
override def productElement(n: Int) = n match {
  case 0 =>
    description
  case 1 =>
    homePage
  case 2 =>
    licenses
  case 3 =>
    developers
  case 4 =>
    publication
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "description"
  case 1 =>
    "homePage"
  case 2 =>
    "licenses"
  case 3 =>
    "developers"
  case 4 =>
    "publication"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("description", "homePage", "licenses", "developers", "publication")
}
override def productIterator = {
  Iterator(description, homePage, licenses, developers, publication)
}
override def productPrefix = "Info"
def withDescription(description: String): Info = copy(description = description)
def withHomePage(homePage: String): Info = copy(homePage = homePage)
def withLicenses(licenses: Seq[(String, Option[String])]): Info = copy(licenses = licenses)
def withDevelopers(developers: Seq[Developer]): Info = copy(developers = developers)
def withPublication(publication: Option[DateTime]): Info = copy(publication = publication)
override def toString = {
  val sb = new StringBuilder("Info")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object Info {
def apply(description: String, homePage: String, licenses: Seq[(String, Option[String])], developers: Seq[Developer], publication: Option[DateTime]): Info = new Info(description, homePage, licenses, developers, publication)
}

