package lmcoursier.definitions
import dataclass.data

@data final class Module private (val organization: Organization, val name: ModuleName, val attributes: Map[String, String]) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: Module =>
    this.organization == c.organization && this.name == c.name && this.attributes == c.attributes
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(organization, name, attributes)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(organization: Organization = this.organization, name: ModuleName = this.name, attributes: Map[String, String] = this.attributes): Module = new Module(organization, name, attributes)
override def canEqual(obj: Any): Boolean = obj match {
  case c: Module => true
  case _ => false
}
override def productArity = 3
override def productElement(n: Int) = n match {
  case 0 =>
    organization
  case 1 =>
    name
  case 2 =>
    attributes
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "organization"
  case 1 =>
    "name"
  case 2 =>
    "attributes"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("organization", "name", "attributes")
}
override def productIterator = {
  Iterator(organization, name, attributes)
}
override def productPrefix = "Module"
def withOrganization(organization: Organization): Module = copy(organization = organization)
def withName(name: ModuleName): Module = copy(name = name)
def withAttributes(attributes: Map[String, String]): Module = copy(attributes = attributes)
override def toString = {
  val sb = new StringBuilder("Module")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object Module {
def apply(organization: Organization, name: ModuleName, attributes: Map[String, String]): Module = new Module(organization, name, attributes)
}

