package lmcoursier

import java.io.File
import dataclass.{data, since}
import coursier.cache.CacheDefaults
import coursier.params.rule.{Rule, RuleResolution}
import lmcoursier.credentials.Credentials
import lmcoursier.definitions.{Authentication, CacheLogger, CachePolicy, FromCoursier, Module, ModuleMatchers, Project, Reconciliation, Strict}
import sbt.librarymanagement.{CrossVersion, InclExclRule, ModuleDescriptorConfiguration, ModuleID, ModuleInfo, Resolver, UpdateConfiguration}
import xsbti.Logger

import scala.concurrent.duration.{Duration, FiniteDuration}
import java.net.URL
import java.net.URLClassLoader

@data final class CoursierConfiguration private (val log: Option[Logger], val resolvers: Vector[Resolver], val parallelDownloads: Int, val maxIterations: Int, val sbtScalaOrganization: Option[String], val sbtScalaVersion: Option[String], val sbtScalaJars: Vector[File], val interProjectDependencies: Vector[Project], val excludeDependencies: Vector[(String, String)], val fallbackDependencies: Vector[FallbackDependency], val autoScalaLibrary: Boolean, val hasClassifiers: Boolean, val classifiers: Vector[String], val mavenProfiles: Vector[String], val scalaOrganization: Option[String], val scalaVersion: Option[String], val authenticationByRepositoryId: Vector[(String, Authentication)], val credentials: Seq[Credentials], val logger: Option[CacheLogger], val cache: Option[File], @since val ivyHome: Option[File], @since val followHttpToHttpsRedirections: Option[Boolean], @since val strict: Option[Strict], val extraProjects: Vector[Project], val forceVersions: Vector[(Module, String)], @since val reconciliation: Vector[(ModuleMatchers, Reconciliation)], @since val classpathOrder: Boolean, @since val verbosityLevel: Int, val ttl: Option[Duration], val checksums: Vector[Option[String]], val cachePolicies: Vector[CachePolicy], @since val missingOk: Boolean, @since val sbtClassifiers: Boolean, @since val providedInCompile: Boolean, @since val protocolHandlerDependencies: Seq[ModuleID], val retry: Option[(FiniteDuration, Int)], val sameVersions: Seq[Set[InclExclRule]], @since val enableDependencyOverrides: Option[Boolean]) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: CoursierConfiguration =>
    this.log == c.log && this.resolvers == c.resolvers && this.parallelDownloads == c.parallelDownloads && this.maxIterations == c.maxIterations && this.sbtScalaOrganization == c.sbtScalaOrganization && this.sbtScalaVersion == c.sbtScalaVersion && this.sbtScalaJars == c.sbtScalaJars && this.interProjectDependencies == c.interProjectDependencies && this.excludeDependencies == c.excludeDependencies && this.fallbackDependencies == c.fallbackDependencies && this.autoScalaLibrary == c.autoScalaLibrary && this.hasClassifiers == c.hasClassifiers && this.classifiers == c.classifiers && this.mavenProfiles == c.mavenProfiles && this.scalaOrganization == c.scalaOrganization && this.scalaVersion == c.scalaVersion && this.authenticationByRepositoryId == c.authenticationByRepositoryId && this.credentials == c.credentials && this.logger == c.logger && this.cache == c.cache && this.ivyHome == c.ivyHome && this.followHttpToHttpsRedirections == c.followHttpToHttpsRedirections && this.strict == c.strict && this.extraProjects == c.extraProjects && this.forceVersions == c.forceVersions && this.reconciliation == c.reconciliation && this.classpathOrder == c.classpathOrder && this.verbosityLevel == c.verbosityLevel && this.ttl == c.ttl && this.checksums == c.checksums && this.cachePolicies == c.cachePolicies && this.missingOk == c.missingOk && this.sbtClassifiers == c.sbtClassifiers && this.providedInCompile == c.providedInCompile && this.protocolHandlerDependencies == c.protocolHandlerDependencies && this.retry == c.retry && this.sameVersions == c.sameVersions && this.enableDependencyOverrides == c.enableDependencyOverrides
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(log, resolvers, parallelDownloads, maxIterations, sbtScalaOrganization, sbtScalaVersion, sbtScalaJars, interProjectDependencies, excludeDependencies, fallbackDependencies, autoScalaLibrary, hasClassifiers, classifiers, mavenProfiles, scalaOrganization, scalaVersion, authenticationByRepositoryId, credentials, logger, cache, ivyHome, followHttpToHttpsRedirections, strict, extraProjects, forceVersions, reconciliation, classpathOrder, verbosityLevel, ttl, checksums, cachePolicies, missingOk, sbtClassifiers, providedInCompile, protocolHandlerDependencies, retry, sameVersions, enableDependencyOverrides)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(log: Option[Logger] = this.log, resolvers: Vector[Resolver] = this.resolvers, parallelDownloads: Int = this.parallelDownloads, maxIterations: Int = this.maxIterations, sbtScalaOrganization: Option[String] = this.sbtScalaOrganization, sbtScalaVersion: Option[String] = this.sbtScalaVersion, sbtScalaJars: Vector[File] = this.sbtScalaJars, interProjectDependencies: Vector[Project] = this.interProjectDependencies, excludeDependencies: Vector[(String, String)] = this.excludeDependencies, fallbackDependencies: Vector[FallbackDependency] = this.fallbackDependencies, autoScalaLibrary: Boolean = this.autoScalaLibrary, hasClassifiers: Boolean = this.hasClassifiers, classifiers: Vector[String] = this.classifiers, mavenProfiles: Vector[String] = this.mavenProfiles, scalaOrganization: Option[String] = this.scalaOrganization, scalaVersion: Option[String] = this.scalaVersion, authenticationByRepositoryId: Vector[(String, Authentication)] = this.authenticationByRepositoryId, credentials: Seq[Credentials] = this.credentials, logger: Option[CacheLogger] = this.logger, cache: Option[File] = this.cache, ivyHome: Option[File] = this.ivyHome, followHttpToHttpsRedirections: Option[Boolean] = this.followHttpToHttpsRedirections, strict: Option[Strict] = this.strict, extraProjects: Vector[Project] = this.extraProjects, forceVersions: Vector[(Module, String)] = this.forceVersions, reconciliation: Vector[(ModuleMatchers, Reconciliation)] = this.reconciliation, classpathOrder: Boolean = this.classpathOrder, verbosityLevel: Int = this.verbosityLevel, ttl: Option[Duration] = this.ttl, checksums: Vector[Option[String]] = this.checksums, cachePolicies: Vector[CachePolicy] = this.cachePolicies, missingOk: Boolean = this.missingOk, sbtClassifiers: Boolean = this.sbtClassifiers, providedInCompile: Boolean = this.providedInCompile, protocolHandlerDependencies: Seq[ModuleID] = this.protocolHandlerDependencies, retry: Option[(FiniteDuration, Int)] = this.retry, sameVersions: Seq[Set[InclExclRule]] = this.sameVersions, enableDependencyOverrides: Option[Boolean] = this.enableDependencyOverrides): CoursierConfiguration = new CoursierConfiguration(log, resolvers, parallelDownloads, maxIterations, sbtScalaOrganization, sbtScalaVersion, sbtScalaJars, interProjectDependencies, excludeDependencies, fallbackDependencies, autoScalaLibrary, hasClassifiers, classifiers, mavenProfiles, scalaOrganization, scalaVersion, authenticationByRepositoryId, credentials, logger, cache, ivyHome, followHttpToHttpsRedirections, strict, extraProjects, forceVersions, reconciliation, classpathOrder, verbosityLevel, ttl, checksums, cachePolicies, missingOk, sbtClassifiers, providedInCompile, protocolHandlerDependencies, retry, sameVersions, enableDependencyOverrides)
override def canEqual(obj: Any): Boolean = obj match {
  case c: CoursierConfiguration => true
  case _ => false
}
override def productArity = 38
override def productElement(n: Int) = n match {
  case 0 =>
    log
  case 1 =>
    resolvers
  case 2 =>
    parallelDownloads
  case 3 =>
    maxIterations
  case 4 =>
    sbtScalaOrganization
  case 5 =>
    sbtScalaVersion
  case 6 =>
    sbtScalaJars
  case 7 =>
    interProjectDependencies
  case 8 =>
    excludeDependencies
  case 9 =>
    fallbackDependencies
  case 10 =>
    autoScalaLibrary
  case 11 =>
    hasClassifiers
  case 12 =>
    classifiers
  case 13 =>
    mavenProfiles
  case 14 =>
    scalaOrganization
  case 15 =>
    scalaVersion
  case 16 =>
    authenticationByRepositoryId
  case 17 =>
    credentials
  case 18 =>
    logger
  case 19 =>
    cache
  case 20 =>
    ivyHome
  case 21 =>
    followHttpToHttpsRedirections
  case 22 =>
    strict
  case 23 =>
    extraProjects
  case 24 =>
    forceVersions
  case 25 =>
    reconciliation
  case 26 =>
    classpathOrder
  case 27 =>
    verbosityLevel
  case 28 =>
    ttl
  case 29 =>
    checksums
  case 30 =>
    cachePolicies
  case 31 =>
    missingOk
  case 32 =>
    sbtClassifiers
  case 33 =>
    providedInCompile
  case 34 =>
    protocolHandlerDependencies
  case 35 =>
    retry
  case 36 =>
    sameVersions
  case 37 =>
    enableDependencyOverrides
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "log"
  case 1 =>
    "resolvers"
  case 2 =>
    "parallelDownloads"
  case 3 =>
    "maxIterations"
  case 4 =>
    "sbtScalaOrganization"
  case 5 =>
    "sbtScalaVersion"
  case 6 =>
    "sbtScalaJars"
  case 7 =>
    "interProjectDependencies"
  case 8 =>
    "excludeDependencies"
  case 9 =>
    "fallbackDependencies"
  case 10 =>
    "autoScalaLibrary"
  case 11 =>
    "hasClassifiers"
  case 12 =>
    "classifiers"
  case 13 =>
    "mavenProfiles"
  case 14 =>
    "scalaOrganization"
  case 15 =>
    "scalaVersion"
  case 16 =>
    "authenticationByRepositoryId"
  case 17 =>
    "credentials"
  case 18 =>
    "logger"
  case 19 =>
    "cache"
  case 20 =>
    "ivyHome"
  case 21 =>
    "followHttpToHttpsRedirections"
  case 22 =>
    "strict"
  case 23 =>
    "extraProjects"
  case 24 =>
    "forceVersions"
  case 25 =>
    "reconciliation"
  case 26 =>
    "classpathOrder"
  case 27 =>
    "verbosityLevel"
  case 28 =>
    "ttl"
  case 29 =>
    "checksums"
  case 30 =>
    "cachePolicies"
  case 31 =>
    "missingOk"
  case 32 =>
    "sbtClassifiers"
  case 33 =>
    "providedInCompile"
  case 34 =>
    "protocolHandlerDependencies"
  case 35 =>
    "retry"
  case 36 =>
    "sameVersions"
  case 37 =>
    "enableDependencyOverrides"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("log", "resolvers", "parallelDownloads", "maxIterations", "sbtScalaOrganization", "sbtScalaVersion", "sbtScalaJars", "interProjectDependencies", "excludeDependencies", "fallbackDependencies", "autoScalaLibrary", "hasClassifiers", "classifiers", "mavenProfiles", "scalaOrganization", "scalaVersion", "authenticationByRepositoryId", "credentials", "logger", "cache", "ivyHome", "followHttpToHttpsRedirections", "strict", "extraProjects", "forceVersions", "reconciliation", "classpathOrder", "verbosityLevel", "ttl", "checksums", "cachePolicies", "missingOk", "sbtClassifiers", "providedInCompile", "protocolHandlerDependencies", "retry", "sameVersions", "enableDependencyOverrides")
}
override def productIterator = {
  Iterator(log, resolvers, parallelDownloads, maxIterations, sbtScalaOrganization, sbtScalaVersion, sbtScalaJars, interProjectDependencies, excludeDependencies, fallbackDependencies, autoScalaLibrary, hasClassifiers, classifiers, mavenProfiles, scalaOrganization, scalaVersion, authenticationByRepositoryId, credentials, logger, cache, ivyHome, followHttpToHttpsRedirections, strict, extraProjects, forceVersions, reconciliation, classpathOrder, verbosityLevel, ttl, checksums, cachePolicies, missingOk, sbtClassifiers, providedInCompile, protocolHandlerDependencies, retry, sameVersions, enableDependencyOverrides)
}
override def productPrefix = "CoursierConfiguration"
def withLog(log: Option[Logger]): CoursierConfiguration = copy(log = log)
def withResolvers(resolvers: Vector[Resolver]): CoursierConfiguration = copy(resolvers = resolvers)
def withParallelDownloads(parallelDownloads: Int): CoursierConfiguration = copy(parallelDownloads = parallelDownloads)
def withMaxIterations(maxIterations: Int): CoursierConfiguration = copy(maxIterations = maxIterations)
def withSbtScalaOrganization(sbtScalaOrganization: Option[String]): CoursierConfiguration = copy(sbtScalaOrganization = sbtScalaOrganization)
def withSbtScalaVersion(sbtScalaVersion: Option[String]): CoursierConfiguration = copy(sbtScalaVersion = sbtScalaVersion)
def withSbtScalaJars(sbtScalaJars: Vector[File]): CoursierConfiguration = copy(sbtScalaJars = sbtScalaJars)
def withInterProjectDependencies(interProjectDependencies: Vector[Project]): CoursierConfiguration = copy(interProjectDependencies = interProjectDependencies)
def withExcludeDependencies(excludeDependencies: Vector[(String, String)]): CoursierConfiguration = copy(excludeDependencies = excludeDependencies)
def withFallbackDependencies(fallbackDependencies: Vector[FallbackDependency]): CoursierConfiguration = copy(fallbackDependencies = fallbackDependencies)
def withAutoScalaLibrary(autoScalaLibrary: Boolean): CoursierConfiguration = copy(autoScalaLibrary = autoScalaLibrary)
def withHasClassifiers(hasClassifiers: Boolean): CoursierConfiguration = copy(hasClassifiers = hasClassifiers)
def withClassifiers(classifiers: Vector[String]): CoursierConfiguration = copy(classifiers = classifiers)
def withMavenProfiles(mavenProfiles: Vector[String]): CoursierConfiguration = copy(mavenProfiles = mavenProfiles)
def withScalaOrganization(scalaOrganization: Option[String]): CoursierConfiguration = copy(scalaOrganization = scalaOrganization)
def withScalaVersion(scalaVersion: Option[String]): CoursierConfiguration = copy(scalaVersion = scalaVersion)
def withAuthenticationByRepositoryId(authenticationByRepositoryId: Vector[(String, Authentication)]): CoursierConfiguration = copy(authenticationByRepositoryId = authenticationByRepositoryId)
def withCredentials(credentials: Seq[Credentials]): CoursierConfiguration = copy(credentials = credentials)
def withLogger(logger: Option[CacheLogger]): CoursierConfiguration = copy(logger = logger)
def withCache(cache: Option[File]): CoursierConfiguration = copy(cache = cache)
def withIvyHome(ivyHome: Option[File]): CoursierConfiguration = copy(ivyHome = ivyHome)
def withFollowHttpToHttpsRedirections(followHttpToHttpsRedirections: Option[Boolean]): CoursierConfiguration = copy(followHttpToHttpsRedirections = followHttpToHttpsRedirections)
def withStrict(strict: Option[Strict]): CoursierConfiguration = copy(strict = strict)
def withExtraProjects(extraProjects: Vector[Project]): CoursierConfiguration = copy(extraProjects = extraProjects)
def withForceVersions(forceVersions: Vector[(Module, String)]): CoursierConfiguration = copy(forceVersions = forceVersions)
def withReconciliation(reconciliation: Vector[(ModuleMatchers, Reconciliation)]): CoursierConfiguration = copy(reconciliation = reconciliation)
def withClasspathOrder(classpathOrder: Boolean): CoursierConfiguration = copy(classpathOrder = classpathOrder)
def withVerbosityLevel(verbosityLevel: Int): CoursierConfiguration = copy(verbosityLevel = verbosityLevel)
def withTtl(ttl: Option[Duration]): CoursierConfiguration = copy(ttl = ttl)
def withChecksums(checksums: Vector[Option[String]]): CoursierConfiguration = copy(checksums = checksums)
def withCachePolicies(cachePolicies: Vector[CachePolicy]): CoursierConfiguration = copy(cachePolicies = cachePolicies)
def withMissingOk(missingOk: Boolean): CoursierConfiguration = copy(missingOk = missingOk)
def withSbtClassifiers(sbtClassifiers: Boolean): CoursierConfiguration = copy(sbtClassifiers = sbtClassifiers)
def withProvidedInCompile(providedInCompile: Boolean): CoursierConfiguration = copy(providedInCompile = providedInCompile)
def withProtocolHandlerDependencies(protocolHandlerDependencies: Seq[ModuleID]): CoursierConfiguration = copy(protocolHandlerDependencies = protocolHandlerDependencies)
def withRetry(retry: Option[(FiniteDuration, Int)]): CoursierConfiguration = copy(retry = retry)
def withSameVersions(sameVersions: Seq[Set[InclExclRule]]): CoursierConfiguration = copy(sameVersions = sameVersions)
def withEnableDependencyOverrides(enableDependencyOverrides: Option[Boolean]): CoursierConfiguration = copy(enableDependencyOverrides = enableDependencyOverrides)
override def toString = {
  val sb = new StringBuilder("CoursierConfiguration")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object CoursierConfiguration {
def apply(log: Option[Logger], resolvers: Vector[Resolver], parallelDownloads: Int, maxIterations: Int, sbtScalaOrganization: Option[String], sbtScalaVersion: Option[String], sbtScalaJars: Vector[File], interProjectDependencies: Vector[Project], excludeDependencies: Vector[(String, String)], fallbackDependencies: Vector[FallbackDependency], autoScalaLibrary: Boolean, hasClassifiers: Boolean, classifiers: Vector[String], mavenProfiles: Vector[String], scalaOrganization: Option[String], scalaVersion: Option[String], authenticationByRepositoryId: Vector[(String, Authentication)], credentials: Seq[Credentials], logger: Option[CacheLogger], cache: Option[File], ivyHome: Option[File], followHttpToHttpsRedirections: Option[Boolean], strict: Option[Strict], extraProjects: Vector[Project], forceVersions: Vector[(Module, String)], reconciliation: Vector[(ModuleMatchers, Reconciliation)], classpathOrder: Boolean, verbosityLevel: Int, ttl: Option[Duration], checksums: Vector[Option[String]], cachePolicies: Vector[CachePolicy], missingOk: Boolean, sbtClassifiers: Boolean, providedInCompile: Boolean, protocolHandlerDependencies: Seq[ModuleID], retry: Option[(FiniteDuration, Int)], sameVersions: Seq[Set[InclExclRule]], enableDependencyOverrides: Option[Boolean]): CoursierConfiguration = new CoursierConfiguration(log, resolvers, parallelDownloads, maxIterations, sbtScalaOrganization, sbtScalaVersion, sbtScalaJars, interProjectDependencies, excludeDependencies, fallbackDependencies, autoScalaLibrary, hasClassifiers, classifiers, mavenProfiles, scalaOrganization, scalaVersion, authenticationByRepositoryId, credentials, logger, cache, ivyHome, followHttpToHttpsRedirections, strict, extraProjects, forceVersions, reconciliation, classpathOrder, verbosityLevel, ttl, checksums, cachePolicies, missingOk, sbtClassifiers, providedInCompile, protocolHandlerDependencies, retry, sameVersions, enableDependencyOverrides)
def apply(log: Option[Logger], resolvers: Vector[Resolver], parallelDownloads: Int, maxIterations: Int, sbtScalaOrganization: Option[String], sbtScalaVersion: Option[String], sbtScalaJars: Vector[File], interProjectDependencies: Vector[Project], excludeDependencies: Vector[(String, String)], fallbackDependencies: Vector[FallbackDependency], autoScalaLibrary: Boolean, hasClassifiers: Boolean, classifiers: Vector[String], mavenProfiles: Vector[String], scalaOrganization: Option[String], scalaVersion: Option[String], authenticationByRepositoryId: Vector[(String, Authentication)], credentials: Seq[Credentials], logger: Option[CacheLogger], cache: Option[File], extraProjects: Vector[Project], forceVersions: Vector[(Module, String)], ttl: Option[Duration], checksums: Vector[Option[String]], cachePolicies: Vector[CachePolicy], retry: Option[(FiniteDuration, Int)], sameVersions: Seq[Set[InclExclRule]]): CoursierConfiguration = new CoursierConfiguration(log, resolvers, parallelDownloads, maxIterations, sbtScalaOrganization, sbtScalaVersion, sbtScalaJars, interProjectDependencies, excludeDependencies, fallbackDependencies, autoScalaLibrary, hasClassifiers, classifiers, mavenProfiles, scalaOrganization, scalaVersion, authenticationByRepositoryId, credentials, logger, cache, None, None, None, extraProjects, forceVersions, Vector.empty, true, 0, ttl, checksums, cachePolicies, false, false, false, Vector.empty, retry, sameVersions, None)
def apply(): CoursierConfiguration = new CoursierConfiguration(None, Resolver.defaults, 6, 100, None, None, Vector.empty, Vector.empty, Vector.empty, Vector.empty, true, false, Vector.empty, Vector.empty, None, None, Vector.empty, Vector.empty, None, None, None, None, None, Vector.empty, Vector.empty, Vector.empty, true, 0, CacheDefaults.ttl, CacheDefaults.checksums.toVector, CacheDefaults.cachePolicies.toVector.map(FromCoursier.cachePolicy), false, false, false, Vector.empty, None, Nil, None)
}

