package lmcoursier.definitions

import dataclass.data

@data final class DateTime private (val year: Int, val month: Int, val day: Int, val hour: Int, val minute: Int, val second: Int) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: DateTime =>
    this.year == c.year && this.month == c.month && this.day == c.day && this.hour == c.hour && this.minute == c.minute && this.second == c.second
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(year, month, day, hour, minute, second)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(year: Int = this.year, month: Int = this.month, day: Int = this.day, hour: Int = this.hour, minute: Int = this.minute, second: Int = this.second): DateTime = new DateTime(year, month, day, hour, minute, second)
override def canEqual(obj: Any): Boolean = obj match {
  case c: DateTime => true
  case _ => false
}
override def productArity = 6
override def productElement(n: Int) = n match {
  case 0 =>
    year
  case 1 =>
    month
  case 2 =>
    day
  case 3 =>
    hour
  case 4 =>
    minute
  case 5 =>
    second
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "year"
  case 1 =>
    "month"
  case 2 =>
    "day"
  case 3 =>
    "hour"
  case 4 =>
    "minute"
  case 5 =>
    "second"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("year", "month", "day", "hour", "minute", "second")
}
override def productIterator = {
  Iterator(year, month, day, hour, minute, second)
}
override def productPrefix = "DateTime"
def withYear(year: Int): DateTime = copy(year = year)
def withMonth(month: Int): DateTime = copy(month = month)
def withDay(day: Int): DateTime = copy(day = day)
def withHour(hour: Int): DateTime = copy(hour = hour)
def withMinute(minute: Int): DateTime = copy(minute = minute)
def withSecond(second: Int): DateTime = copy(second = second)
override def toString = {
  val sb = new StringBuilder("DateTime")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object DateTime {
def apply(year: Int, month: Int, day: Int, hour: Int, minute: Int, second: Int): DateTime = new DateTime(year, month, day, hour, minute, second)
}

