package lmcoursier.definitions

import dataclass.data

@data final class Dependency private (val module: Module, val version: String, val configuration: Configuration, val exclusions: Set[(Organization, ModuleName)], val publication: Publication, val optional: Boolean, val transitive: Boolean) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: Dependency =>
    this.module == c.module && this.version == c.version && this.configuration == c.configuration && this.exclusions == c.exclusions && this.publication == c.publication && this.optional == c.optional && this.transitive == c.transitive
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(module, version, configuration, exclusions, publication, optional, transitive)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(module: Module = this.module, version: String = this.version, configuration: Configuration = this.configuration, exclusions: Set[(Organization, ModuleName)] = this.exclusions, publication: Publication = this.publication, optional: Boolean = this.optional, transitive: Boolean = this.transitive): Dependency = new Dependency(module, version, configuration, exclusions, publication, optional, transitive)
override def canEqual(obj: Any): Boolean = obj match {
  case c: Dependency => true
  case _ => false
}
override def productArity = 7
override def productElement(n: Int) = n match {
  case 0 =>
    module
  case 1 =>
    version
  case 2 =>
    configuration
  case 3 =>
    exclusions
  case 4 =>
    publication
  case 5 =>
    optional
  case 6 =>
    transitive
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "module"
  case 1 =>
    "version"
  case 2 =>
    "configuration"
  case 3 =>
    "exclusions"
  case 4 =>
    "publication"
  case 5 =>
    "optional"
  case 6 =>
    "transitive"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("module", "version", "configuration", "exclusions", "publication", "optional", "transitive")
}
override def productIterator = {
  Iterator(module, version, configuration, exclusions, publication, optional, transitive)
}
override def productPrefix = "Dependency"
def withModule(module: Module): Dependency = copy(module = module)
def withVersion(version: String): Dependency = copy(version = version)
def withConfiguration(configuration: Configuration): Dependency = copy(configuration = configuration)
def withExclusions(exclusions: Set[(Organization, ModuleName)]): Dependency = copy(exclusions = exclusions)
def withPublication(publication: Publication): Dependency = copy(publication = publication)
def withOptional(optional: Boolean): Dependency = copy(optional = optional)
def withTransitive(transitive: Boolean): Dependency = copy(transitive = transitive)
override def toString = {
  val sb = new StringBuilder("Dependency")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object Dependency {
def apply(module: Module, version: String, configuration: Configuration, exclusions: Set[(Organization, ModuleName)], publication: Publication, optional: Boolean, transitive: Boolean): Dependency = new Dependency(module, version, configuration, exclusions, publication, optional, transitive)
}

