package lmcoursier.definitions

import dataclass.data

@data final class Publication private (val name: String, val `type`: Type, val ext: Extension, val classifier: Classifier) extends Product with Serializable {

override def equals(obj: Any): Boolean = obj match {
  case c: Publication =>
    this.name == c.name && this.`type` == c.`type` && this.ext == c.ext && this.classifier == c.classifier
  case _ =>
    false
}
override lazy val hashCode: Int = {
  val state = Seq(name, `type`, ext, classifier)
  state.foldLeft(0)((a, b) => 31 * a.hashCode() + b.hashCode())
}
private def copy(name: String = this.name, `type`: Type = this.`type`, ext: Extension = this.ext, classifier: Classifier = this.classifier): Publication = new Publication(name, `type`, ext, classifier)
override def canEqual(obj: Any): Boolean = obj match {
  case c: Publication => true
  case _ => false
}
override def productArity = 4
override def productElement(n: Int) = n match {
  case 0 =>
    name
  case 1 =>
    `type`
  case 2 =>
    ext
  case 3 =>
    classifier
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementName(n: Int) = n match {
  case 0 =>
    "name"
  case 1 =>
    "type"
  case 2 =>
    "ext"
  case 3 =>
    "classifier"
  case _ =>
    throw new IndexOutOfBoundsException()
}
def productElementNames = {
  Iterator("name", "type", "ext", "classifier")
}
override def productIterator = {
  Iterator(name, `type`, ext, classifier)
}
override def productPrefix = "Publication"
def withName(name: String): Publication = copy(name = name)
def withType(`type`: Type): Publication = copy(`type` = `type`)
def withExt(ext: Extension): Publication = copy(ext = ext)
def withClassifier(classifier: Classifier): Publication = copy(classifier = classifier)
override def toString = {
  val sb = new StringBuilder("Publication")
  sb.append(productElementNames.zip(productIterator).map {
    case (name, value) =>
      s"$name=$value"
  }.mkString("(", ",", ")"))
  sb.toString
}


}
object Publication {
def apply(name: String, `type`: Type, ext: Extension, classifier: Classifier): Publication = new Publication(name, `type`, ext, classifier)
}

