/*
 * Decompiled with CFR 0.152.
 */
package coursier.publish.checksum.logger;

import coursier.publish.checksum.ChecksumType;
import coursier.publish.checksum.logger.ChecksumLogger;
import coursier.publish.checksum.logger.InteractiveChecksumLogger$;
import coursier.publish.fileset.FileSet;
import coursier.publish.logging.ProgressLogger;
import coursier.publish.logging.ProgressLogger$;
import java.io.OutputStream;
import java.io.Writer;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\t\u0012\u0005iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)!\u0007\u0001C\u0001g!9q\u0007\u0001b\u0001\n\u0013A\u0004BB#\u0001A\u0003%\u0011\bC\u0003G\u0001\u0011\u0005s\tC\u0003V\u0001\u0011\u0005c\u000bC\u0003l\u0001\u0011\u0005C\u000eC\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f\u001d9\u0011qC\t\t\u0002\u0005eaA\u0002\t\u0012\u0011\u0003\tY\u0002\u0003\u00043\u001b\u0011\u0005\u0011Q\u0004\u0005\b\u0003?iA\u0011AA\u0011\u0005eIe\u000e^3sC\u000e$\u0018N^3DQ\u0016\u001c7n];n\u0019><w-\u001a:\u000b\u0005I\u0019\u0012A\u00027pO\u001e,'O\u0003\u0002\u0015+\u0005A1\r[3dWN,XN\u0003\u0002\u0017/\u00059\u0001/\u001e2mSND'\"\u0001\r\u0002\u0011\r|WO]:jKJ\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012$\u001b\u0005\t\u0012B\u0001\u0013\u0012\u00059\u0019\u0005.Z2lgVlGj\\4hKJ\f1a\\;u!\t9C&D\u0001)\u0015\tI#&\u0001\u0002j_*\t1&\u0001\u0003kCZ\f\u0017BA\u0017)\u0005\u00199&/\u001b;fe\u0006Ia/\u001a:c_NLG/\u001f\t\u00039AJ!!M\u000f\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0004iU2\u0004C\u0001\u0012\u0001\u0011\u0015)3\u00011\u0001'\u0011\u0015q3\u00011\u00010\u0003))h\u000eZ3sYfLgnZ\u000b\u0002sA\u0019!(P \u000e\u0003mR!\u0001P\u000b\u0002\u000f1|wmZ5oO&\u0011ah\u000f\u0002\u000f!J|wM]3tg2{wmZ3s!\t\u00015)D\u0001B\u0015\t\u0011%&\u0001\u0003mC:<\u0017B\u0001#B\u0005\u0019y%M[3di\u0006YQO\u001c3fe2L\u0018N\\4!\u00031\u0019w.\u001c9vi&twmU3u)\rA5*\u0014\t\u00039%K!AS\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0019\u001a\u0001\raP\u0001\u0003S\u0012DQA\u0014\u0004A\u0002=\u000b!AZ:\u0011\u0005A\u001bV\"A)\u000b\u0005I+\u0012a\u00024jY\u0016\u001cX\r^\u0005\u0003)F\u0013qAR5mKN+G/A\u0005d_6\u0004X\u000f^5oOR!\u0001j\u0016-_\u0011\u0015au\u00011\u0001@\u0011\u0015Iv\u00011\u0001[\u0003\u0015!\u0018\u0010]31!\tYF,D\u0001\u0014\u0013\ti6C\u0001\u0007DQ\u0016\u001c7n];n)f\u0004X\rC\u0003`\u000f\u0001\u0007\u0001-\u0001\u0003qCRD\u0007CA1i\u001d\t\u0011g\r\u0005\u0002d;5\tAM\u0003\u0002f3\u00051AH]8pizJ!aZ\u000f\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003Ov\t\u0001bY8naV$X\r\u001a\u000b\u0006\u00116tw\u000e\u001d\u0005\u0006\u0019\"\u0001\ra\u0010\u0005\u00063\"\u0001\rA\u0017\u0005\u0006?\"\u0001\r\u0001\u0019\u0005\u0006c\"\u0001\rA]\u0001\tKJ\u0014xN](qiB\u0019Ad];\n\u0005Ql\"AB(qi&|g\u000e\u0005\u0002ww:\u0011q/\u001f\b\u0003GbL\u0011AH\u0005\u0003uv\tq\u0001]1dW\u0006<W-\u0003\u0002}{\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003uv\t1bY8naV$X\rZ*fiR)\u0001*!\u0001\u0002\u0004!)A*\u0003a\u0001\u007f!)a*\u0003a\u0001\u001f\u0006)1\u000f^1siR\t\u0001*\u0001\u0003ti>\u0004Hc\u0001%\u0002\u000e!I\u0011qB\u0006\u0011\u0002\u0003\u0007\u0011\u0011C\u0001\u0005W\u0016,\u0007\u000fE\u0002\u001d\u0003'I1!!\u0006\u001e\u0005\u001d\u0011un\u001c7fC:\f\u0011$\u00138uKJ\f7\r^5wK\u000eCWmY6tk6dunZ4feB\u0011!%D\n\u0003\u001bm!\"!!\u0007\u0002\r\r\u0014X-\u0019;f)\u0015!\u00141EA\u0016\u0011\u0019)s\u00021\u0001\u0002&A\u0019q%a\n\n\u0007\u0005%\u0002F\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003/\u001f\u0001\u0007q\u0006")
public final class InteractiveChecksumLogger
implements ChecksumLogger {
    private final Writer out;
    private final int verbosity;
    private final ProgressLogger<Object> underlying;

    public static InteractiveChecksumLogger create(OutputStream out, int verbosity) {
        return InteractiveChecksumLogger$.MODULE$.create(out, verbosity);
    }

    @Override
    public boolean stop$default$1() {
        return ChecksumLogger.stop$default$1$(this);
    }

    private ProgressLogger<Object> underlying() {
        return this.underlying;
    }

    @Override
    public void computingSet(Object id, FileSet fs) {
        this.underlying().processingSet(id, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)fs.elements().length())));
    }

    @Override
    public void computing(Object id, ChecksumType type0, String path) {
        if (this.verbosity >= 2) {
            this.out.write(new StringBuilder(23).append("Computing ").append(type0.name()).append(" checksum of ").append(Predef$.MODULE$.wrapString(path).repr()).append(System.lineSeparator()).toString());
        }
        this.underlying().processing(path, id);
    }

    @Override
    public void computed(Object id, ChecksumType type0, String path, Option<Throwable> errorOpt) {
        if (this.verbosity >= 2) {
            this.out.write(new StringBuilder(22).append("Computed ").append(type0.name()).append(" checksum of ").append(Predef$.MODULE$.wrapString(path).repr()).append(System.lineSeparator()).toString());
        }
        this.underlying().processed(path, id, errorOpt.nonEmpty());
    }

    @Override
    public void computedSet(Object id, FileSet fs) {
        this.underlying().processedSet(id);
    }

    @Override
    public void start() {
        this.underlying().start();
    }

    @Override
    public void stop(boolean keep) {
        this.underlying().stop(keep);
    }

    public InteractiveChecksumLogger(Writer out, int verbosity) {
        this.out = out;
        this.verbosity = verbosity;
        ChecksumLogger.$init$(this);
        this.underlying = new ProgressLogger("Computed", "checksums", out, ProgressLogger$.MODULE$.$lessinit$greater$default$4(), ProgressLogger$.MODULE$.$lessinit$greater$default$5());
    }
}

