/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar.util;

import com.eed3si9n.jarjar.util.DuplicateJarEntryException;
import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjar.util.IoUtil;
import com.eed3si9n.jarjar.util.JarProcessor;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;

public class CoursierJarProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(File[] fileArray, File file, JarProcessor jarProcessor, boolean bl) throws IOException {
        byte[] byArray = new byte[8192];
        File file2 = File.createTempFile("jarjar", ".jar");
        HashSet<String> hashSet = new HashSet<String>();
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            zipOutputStream = new JarOutputStream(bufferedOutputStream);
            for (File file3 : fileArray) {
                try (JarFile jarFile = null;){
                    jarFile = new JarFile(file3);
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        EntryStruct entryStruct = new EntryStruct();
                        JarEntry jarEntry = enumeration.nextElement();
                        entryStruct.name = jarEntry.getName();
                        entryStruct.time = jarEntry.getTime();
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        IoUtil.pipe((InputStream)jarFile.getInputStream(jarEntry), (OutputStream)byteArrayOutputStream, (byte[])byArray);
                        entryStruct.data = byteArrayOutputStream.toByteArray();
                        if (!jarProcessor.process(entryStruct)) continue;
                        if (hashSet.add(entryStruct.name)) {
                            jarEntry = new JarEntry(entryStruct.name);
                            jarEntry.setTime(entryStruct.time);
                            jarEntry.setCompressedSize(-1L);
                            ((JarOutputStream)zipOutputStream).putNextEntry(jarEntry);
                            zipOutputStream.write(entryStruct.data);
                            continue;
                        }
                        if (entryStruct.name.endsWith("/") || bl) continue;
                        throw new DuplicateJarEntryException(file3.getAbsolutePath(), entryStruct.name);
                    }
                }
            }
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        IoUtil.copyZipWithoutEmptyDirectories((File)file2, (File)file);
        file2.delete();
    }
}

