/*
 * Decompiled with CFR 0.152.
 */
package dev.dirs;

import dev.dirs.Constants;
import dev.dirs.UnsupportedOperatingSystemException;
import dev.dirs.impl.Linux;
import dev.dirs.impl.MacOs;
import dev.dirs.impl.Util;
import dev.dirs.impl.Windows;
import java.util.Objects;
import java.util.function.Supplier;

public final class ProjectDirectories {
    public final String projectPath;
    public final String cacheDir;
    public final String configDir;
    public final String dataDir;
    public final String dataLocalDir;
    public final String preferenceDir;
    public final String runtimeDir;

    private ProjectDirectories(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Objects.requireNonNull(string);
        this.projectPath = string;
        this.cacheDir = string2;
        this.configDir = string3;
        this.dataDir = string4;
        this.dataLocalDir = string5;
        this.preferenceDir = string6;
        this.runtimeDir = string7;
    }

    public static ProjectDirectories fromPath(String string) {
        return ProjectDirectories.fromPath(string, Windows.getDefaultSupplier());
    }

    public static ProjectDirectories fromPath(String string, Supplier<Windows> supplier) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = null;
        switch (Constants.operatingSystem) {
            case 'a': 
            case 'b': 
            case 'i': 
            case 'l': 
            case 's': {
                String string8 = System.getProperty("user.home");
                string6 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_CACHE_HOME"), string, string8 + "/.cache/", string);
                string5 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_CONFIG_HOME"), string, string8 + "/.config/", string);
                string3 = string4 = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_DATA_HOME"), string, string8 + "/.local/share/", string);
                string2 = string5;
                string7 = Linux.runtimeDir(string);
                break;
            }
            case 'm': {
                String string9 = System.getProperty("user.home");
                string6 = string9 + "/Library/Caches/" + string;
                string5 = string9 + "/Library/Application Support/" + string;
                string3 = string4 = string9 + "/Library/Application Support/" + string;
                string2 = string9 + "/Library/Preferences/" + string;
                break;
            }
            case 'w': {
                String[] stringArray = supplier.get().winDirs("3EB685DB-65F9-4CF6-A03A-E3EF65729F3D", "F1B32785-6FBA-4FCF-9D55-7B8E7F157091");
                String string10 = stringArray[0] + '\\' + string;
                String string11 = stringArray[1] + '\\' + string;
                string4 = string10 + "\\data";
                string3 = string11 + "\\data";
                string5 = string10 + "\\config";
                string6 = string11 + "\\cache";
                string2 = string5;
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Project directories are not supported on " + Constants.operatingSystemName);
            }
        }
        return new ProjectDirectories(string, string6, string5, string4, string3, string2, string7);
    }

    public static ProjectDirectories from(String string, String string2, String string3) {
        return ProjectDirectories.from(string, string2, string3, Windows.getDefaultSupplier());
    }

    public static ProjectDirectories from(String string, String string2, String string3, Supplier<Windows> supplier) {
        String string4;
        if (Util.isNullOrEmpty(string2) && Util.isNullOrEmpty(string3)) {
            throw new UnsupportedOperationException("organization and application arguments cannot both be null/empty");
        }
        switch (Constants.operatingSystem) {
            case 'a': 
            case 'b': 
            case 'i': 
            case 'l': 
            case 's': {
                string4 = Util.trimLowercaseReplaceWhitespace(string3, "", true);
                break;
            }
            case 'm': {
                string4 = MacOs.applicationPath(string, string2, string3);
                break;
            }
            case 'w': {
                string4 = Windows.applicationPath(string, string2, string3);
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Project directories are not supported on " + Constants.operatingSystemName);
            }
        }
        return ProjectDirectories.fromPath(string4, supplier);
    }

    public String toString() {
        return "ProjectDirectories (" + Constants.operatingSystemName + "):\n  projectPath   = '" + this.projectPath + "'\n  cacheDir      = '" + this.cacheDir + "'\n  configDir     = '" + this.configDir + "'\n  dataDir       = '" + this.dataDir + "'\n  dataLocalDir  = '" + this.dataLocalDir + "'\n  preferenceDir = '" + this.preferenceDir + "'\n  runtimeDir    = '" + this.runtimeDir + "'\n";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProjectDirectories projectDirectories = (ProjectDirectories)object;
        if (!this.projectPath.equals(projectDirectories.projectPath)) {
            return false;
        }
        if (this.cacheDir != null ? !this.cacheDir.equals(projectDirectories.cacheDir) : projectDirectories.cacheDir != null) {
            return false;
        }
        if (this.configDir != null ? !this.configDir.equals(projectDirectories.configDir) : projectDirectories.configDir != null) {
            return false;
        }
        if (this.dataDir != null ? !this.dataDir.equals(projectDirectories.dataDir) : projectDirectories.dataDir != null) {
            return false;
        }
        if (this.dataLocalDir != null ? !this.dataLocalDir.equals(projectDirectories.dataLocalDir) : projectDirectories.dataLocalDir != null) {
            return false;
        }
        if (this.preferenceDir != null ? !this.preferenceDir.equals(projectDirectories.preferenceDir) : projectDirectories.preferenceDir != null) {
            return false;
        }
        return !(this.runtimeDir != null ? !this.runtimeDir.equals(projectDirectories.runtimeDir) : projectDirectories.runtimeDir != null);
    }

    public int hashCode() {
        int n = this.projectPath.hashCode();
        n = 31 * n + (this.cacheDir != null ? this.cacheDir.hashCode() : 0);
        n = 31 * n + (this.configDir != null ? this.configDir.hashCode() : 0);
        n = 31 * n + (this.dataDir != null ? this.dataDir.hashCode() : 0);
        n = 31 * n + (this.dataLocalDir != null ? this.dataLocalDir.hashCode() : 0);
        n = 31 * n + (this.preferenceDir != null ? this.preferenceDir.hashCode() : 0);
        n = 31 * n + (this.runtimeDir != null ? this.runtimeDir.hashCode() : 0);
        return n;
    }
}

