/*
 * Decompiled with CFR 0.152.
 */
package kyo.kernel.internal;

import java.util.Arrays;
import kyo.kernel.internal.Trace;
import kyo.kernel.internal.Trace$;
import kyo.kernel.internal.TracePool$;
import org.jctools.queues.MessagePassingQueue;
import scala.math.package$;

public final class TracePool {

    public static abstract class Local {
        private final Trace[] pool = new Trace[32];
        private int size = 0;
        private final MessagePassingQueue.Consumer<Trace> add = trace -> {
            int idx = this.size;
            if (trace != null && idx < 32) {
                this.pool[idx] = trace;
                this.size = idx + 1;
                return;
            }
        };

        public final Trace borrow() {
            int idx;
            if (this.size == 0) {
                int n = TracePool$.kyo$kernel$internal$TracePool$$$global.drain(this.add, 32);
            }
            if (this.size == 0) {
                return Trace$.MODULE$.init();
            }
            this.size = idx = this.size - 1;
            Trace buffer = this.pool[idx];
            this.pool[idx] = null;
            return buffer;
        }

        public final void release(Trace trace) {
            this.clear(trace);
            if (this.size < 32) {
                int idx = this.size;
                this.size = idx + 1;
                this.pool[idx] = trace;
                return;
            }
            boolean bl = TracePool$.kyo$kernel$internal$TracePool$$$global.offer((Object)trace);
        }

        private final void clear(Trace trace) {
            Object[] arr = trace.frames();
            int len = package$.MODULE$.min(trace.index(), 16);
            Arrays.fill(arr, 0, len, null);
            trace.index_$eq(0);
        }
    }
}

