/*
 * Decompiled with CFR 0.152.
 */
package kyo.internal;

import java.io.Serializable;
import kyo.Layer;
import kyo.internal.LayerMacros$;
import kyo.internal.LayerMacros$Graph$;
import kyo.internal.LayerMacros$GraphError$;
import kyo.internal.LayerMacros$GraphError$AmbiguousInputs$;
import kyo.internal.LayerMacros$GraphError$CircularDependency$;
import kyo.internal.LayerMacros$GraphError$MissingInput$;
import kyo.internal.LayerMacros$LayerLike$;
import kyo.internal.LayerMacros$LayerLike$And$;
import kyo.internal.LayerMacros$LayerLike$To$;
import kyo.internal.LayerMacros$LayerLike$Value$;
import kyo.internal.LayerMacros$Node$;
import kyo.internal.LayerMacros$Validated$;
import kyo.internal.LayerMacros$Validated$Error$;
import kyo.internal.LayerMacros$Validated$Success$;
import scala.CanEqual;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.quoted.Expr;
import scala.quoted.Quotes;
import scala.quoted.Type;
import scala.reflect.Enum;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class LayerMacros {
    public static Set<Object> extractEnvs(Quotes quotes, Object object) {
        return LayerMacros$.MODULE$.extractEnvs(quotes, object);
    }

    public static Set<Object> extractInputsFromPending(Quotes quotes, Object object) {
        return LayerMacros$.MODULE$.extractInputsFromPending(quotes, object);
    }

    public static Set<Object> flattenAnd(Quotes quotes, Object object) {
        return LayerMacros$.MODULE$.flattenAnd(quotes, object);
    }

    public static Node<Object, Expr<Layer<?, ?>>> layerToNode(Quotes quotes, Expr<Layer<?, ?>> expr) {
        return LayerMacros$.MODULE$.layerToNode(quotes, expr);
    }

    public static <Target> Expr<Layer<Target, ?>> makeImpl(Quotes quotes, Expr<Seq<Layer<?, ?>>> expr, Type<Target> type) {
        return LayerMacros$.MODULE$.makeImpl(quotes, expr, type);
    }

    public static Nothing$ reportErrors(Quotes quotes, .colon.colon<GraphError<Object, Expr<Layer<?, ?>>>> colon2) {
        return LayerMacros$.MODULE$.reportErrors(quotes, colon2);
    }

    public static LayerMacros$ inline$LayerMacros() {
        return LayerMacros$.MODULE$.inline$LayerMacros();
    }

    public static final class Graph<Key, Value>
    implements Product,
    Serializable {
        private final Set<Node<Key, Value>> nodes;
        private final Function2<Key, Key, Object> equals;

        public static <Key, Value> Graph<Key, Value> apply(Set<Node<Key, Value>> set, Function2<Key, Key, Object> function2) {
            return LayerMacros$Graph$.MODULE$.apply(set, function2);
        }

        public static <Key, Value> Graph<Key, Value> unapply(Graph<Key, Value> graph) {
            return LayerMacros$Graph$.MODULE$.unapply(graph);
        }

        public Graph(Set<Node<Key, Value>> nodes, Function2<Key, Key, Object> equals) {
            this.nodes = nodes;
            this.equals = equals;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Graph)) return false;
            Graph graph = (Graph)object;
            Set<Node<Key, Value>> set = this.nodes();
            Set<Node<Key, Value>> set2 = graph.nodes();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Graph;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Graph";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "nodes";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<Node<Key, Value>> nodes() {
            return this.nodes;
        }

        public Validated<GraphError<Key, Value>, LayerLike<Node<Key, Value>>> buildTargets(Set<Key> targets, Option<Node<Key, Value>> parent, Set<Node<Key, Value>> seen) {
            return this.findNodesWithOutputs(targets, parent, seen).flatMap((Function1 & Serializable)nodes -> LayerMacros$Validated$.MODULE$.traverse(nodes, (Function1 & Serializable)node -> {
                if (node.inputs().isEmpty()) {
                    return LayerMacros$Validated$.MODULE$.succeed(LayerMacros$LayerLike$Value$.MODULE$.apply(node));
                }
                return this.buildTargets(node.inputs(), (Option<Node<Key, Value>>)Some$.MODULE$.apply(node), (Set<Node<Key, Value>>)((Set)seen.$plus(node))).map(arg_0 -> LayerMacros$.kyo$internal$LayerMacros$Graph$$_$buildTargets$$anonfun$1$$anonfun$1$$anonfun$1(node, arg_0));
            }).map(LayerMacros$::kyo$internal$LayerMacros$Graph$$_$buildTargets$$anonfun$1$$anonfun$2));
        }

        public Set<Node<Key, Value>> buildTargets$default$3() {
            return Predef$.MODULE$.Set().empty();
        }

        public Validated<GraphError<Key, Value>, Set<Node<Key, Value>>> findNodesWithOutputs(Set<Key> targets, Option<Node<Key, Value>> parent, Set<Node<Key, Value>> seen) {
            return LayerMacros$Validated$.MODULE$.traverse(targets, (Function1 & Serializable)target -> this.findNodeWithOutputFor(target, parent, seen));
        }

        public Validated<GraphError<Key, Value>, Node<Key, Value>> findNodeWithOutputFor(Key target, Option<Node<Key, Value>> parent, Set<Node<Key, Value>> seen) {
            Set matching = (Set)this.nodes().filter((Function1 & Serializable)node -> node.outputs().exists((Function1 & Serializable)output -> BoxesRunTime.unboxToBoolean((Object)this.equals.apply(output, target))));
            int n = matching.size();
            if (1 == n) {
                Node matched = (Node)matching.head();
                if (seen.contains((Object)matched)) {
                    return LayerMacros$Validated$.MODULE$.error(LayerMacros$GraphError$CircularDependency$.MODULE$.apply(matched));
                }
                return LayerMacros$Validated$.MODULE$.succeed(matched);
            }
            if (0 == n) {
                return LayerMacros$Validated$.MODULE$.error(LayerMacros$GraphError$MissingInput$.MODULE$.apply(target, parent));
            }
            return LayerMacros$Validated$.MODULE$.error(LayerMacros$GraphError$AmbiguousInputs$.MODULE$.apply(target, matching, parent));
        }

        public <Key, Value> Graph<Key, Value> copy(Set<Node<Key, Value>> nodes, Function2<Key, Key, Object> equals) {
            return new Graph<Key, Value>(nodes, equals);
        }

        public <Key, Value> Set<Node<Key, Value>> copy$default$1() {
            return this.nodes();
        }

        public Set<Node<Key, Value>> _1() {
            return this.nodes();
        }
    }

    public static abstract class GraphError<Key, Value>
    implements Enum {
        public static GraphError<?, ?> fromOrdinal(int n) {
            return LayerMacros$GraphError$.MODULE$.fromOrdinal(n);
        }
    }

    public static abstract class LayerLike<A>
    implements Enum {
        public static <A> LayerLike<A> apply(A a) {
            return LayerMacros$LayerLike$.MODULE$.apply(a);
        }

        public static LayerLike<?> fromOrdinal(int n) {
            return LayerMacros$LayerLike$.MODULE$.fromOrdinal(n);
        }

        public static <A> CanEqual<LayerLike<A>, LayerLike<A>> given_CanEqual_LayerLike_LayerLike() {
            return LayerMacros$LayerLike$.MODULE$.given_CanEqual_LayerLike_LayerLike();
        }

        public <A1> LayerLike<A1> and(LayerLike<A1> that) {
            return LayerMacros$LayerLike$And$.MODULE$.apply(this, that);
        }

        public <A1> LayerLike<A1> to(LayerLike<A1> that) {
            return LayerMacros$LayerLike$To$.MODULE$.apply(this, that);
        }

        public <B> B fold(Function2<B, B, B> andCase, Function2<B, B, B> toCase, Function1<A, B> valueCase, Function0<B> emptyCase) {
            LayerLike layerLike = this;
            if (layerLike instanceof And) {
                And and = LayerMacros$LayerLike$And$.MODULE$.unapply((And)layerLike);
                LayerLike<A> layerLike2 = and._1();
                LayerLike<A> layerLike3 = and._2();
                LayerLike<A> left = layerLike2;
                LayerLike<A> right = layerLike3;
                return (B)andCase.apply(left.fold(andCase, toCase, valueCase, emptyCase), right.fold(andCase, toCase, valueCase, emptyCase));
            }
            if (layerLike instanceof To) {
                To to = LayerMacros$LayerLike$To$.MODULE$.unapply((To)layerLike);
                LayerLike<A> layerLike4 = to._1();
                LayerLike<A> layerLike5 = to._2();
                LayerLike<A> left = layerLike4;
                LayerLike<A> right = layerLike5;
                return (B)toCase.apply(left.fold(andCase, toCase, valueCase, emptyCase), right.fold(andCase, toCase, valueCase, emptyCase));
            }
            if (layerLike instanceof Value) {
                Object a;
                Value value = LayerMacros$LayerLike$Value$.MODULE$.unapply((Value)layerLike);
                Object value2 = a = value._1();
                return (B)valueCase.apply(value2);
            }
            LayerLike<Nothing$> layerLike6 = LayerMacros$LayerLike$.Empty;
            LayerLike layerLike7 = layerLike;
            if (!(layerLike6 != null ? !layerLike6.equals(layerLike7) : layerLike7 != null)) {
                return (B)emptyCase.apply();
            }
            throw new MatchError((Object)layerLike);
        }

        public static final class And<A>
        extends LayerLike<A> {
            private final LayerLike<A> left;
            private final LayerLike<A> right;

            public static <A> And<A> apply(LayerLike<A> layerLike, LayerLike<A> layerLike2) {
                return LayerMacros$LayerLike$And$.MODULE$.apply(layerLike, layerLike2);
            }

            public static And<?> fromProduct(Product product) {
                return LayerMacros$LayerLike$And$.MODULE$.fromProduct(product);
            }

            public static <A> And<A> unapply(And<A> and) {
                return LayerMacros$LayerLike$And$.MODULE$.unapply(and);
            }

            public And(LayerLike<A> layerLike, LayerLike<A> layerLike2) {
                this.left = left;
                this.right = (LayerLike<A>)right;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof And)) return false;
                And and = (And)object;
                LayerLike<A> layerLike = this.left();
                LayerLike<A> layerLike2 = and.left();
                if (layerLike == null) {
                    if (layerLike2 != null) {
                        return false;
                    }
                } else if (!layerLike.equals(layerLike2)) return false;
                LayerLike<A> layerLike3 = this.right();
                LayerLike<A> layerLike4 = and.right();
                if (layerLike3 == null) {
                    if (layerLike4 == null) return true;
                    return false;
                } else {
                    if (!layerLike3.equals(layerLike4)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof And;
            }

            public int productArity() {
                return 2;
            }

            @Override
            public String productPrefix() {
                return "And";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "left";
                }
                if (1 == n2) {
                    return "right";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public LayerLike<A> left() {
                return this.left;
            }

            public LayerLike<A> right() {
                return this.right;
            }

            public <A> And<A> copy(LayerLike<A> left, LayerLike<A> right) {
                return new And(left, right);
            }

            public <A> LayerLike<A> copy$default$1() {
                return this.left();
            }

            public <A> LayerLike<A> copy$default$2() {
                return this.right();
            }

            public int ordinal() {
                return 0;
            }

            public LayerLike<A> _1() {
                return this.left();
            }

            public LayerLike<A> _2() {
                return this.right();
            }
        }

        public static final class To<A>
        extends LayerLike<A> {
            private final LayerLike<A> left;
            private final LayerLike<A> right;

            public static <A> To<A> apply(LayerLike<A> layerLike, LayerLike<A> layerLike2) {
                return LayerMacros$LayerLike$To$.MODULE$.apply(layerLike, layerLike2);
            }

            public static To<?> fromProduct(Product product) {
                return LayerMacros$LayerLike$To$.MODULE$.fromProduct(product);
            }

            public static <A> To<A> unapply(To<A> to) {
                return LayerMacros$LayerLike$To$.MODULE$.unapply(to);
            }

            public To(LayerLike<A> layerLike, LayerLike<A> layerLike2) {
                this.left = left;
                this.right = (LayerLike<A>)right;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof To)) return false;
                To to = (To)object;
                LayerLike<A> layerLike = this.left();
                LayerLike<A> layerLike2 = to.left();
                if (layerLike == null) {
                    if (layerLike2 != null) {
                        return false;
                    }
                } else if (!layerLike.equals(layerLike2)) return false;
                LayerLike<A> layerLike3 = this.right();
                LayerLike<A> layerLike4 = to.right();
                if (layerLike3 == null) {
                    if (layerLike4 == null) return true;
                    return false;
                } else {
                    if (!layerLike3.equals(layerLike4)) return false;
                    return true;
                }
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof To;
            }

            public int productArity() {
                return 2;
            }

            @Override
            public String productPrefix() {
                return "To";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "left";
                }
                if (1 == n2) {
                    return "right";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public LayerLike<A> left() {
                return this.left;
            }

            public LayerLike<A> right() {
                return this.right;
            }

            public <A> To<A> copy(LayerLike<A> left, LayerLike<A> right) {
                return new To(left, right);
            }

            public <A> LayerLike<A> copy$default$1() {
                return this.left();
            }

            public <A> LayerLike<A> copy$default$2() {
                return this.right();
            }

            public int ordinal() {
                return 1;
            }

            public LayerLike<A> _1() {
                return this.left();
            }

            public LayerLike<A> _2() {
                return this.right();
            }
        }

        public static final class Value<A>
        extends LayerLike<A> {
            private final A value;

            public static <A> Value<A> apply(A a) {
                return LayerMacros$LayerLike$Value$.MODULE$.apply(a);
            }

            public static Value<?> fromProduct(Product product) {
                return LayerMacros$LayerLike$Value$.MODULE$.fromProduct(product);
            }

            public static <A> Value<A> unapply(Value<A> value) {
                return LayerMacros$LayerLike$Value$.MODULE$.unapply(value);
            }

            public Value(A a) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Value)) return false;
                Value value = (Value)object;
                if (!BoxesRunTime.equals(this.value(), value.value())) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Value;
            }

            public int productArity() {
                return 1;
            }

            @Override
            public String productPrefix() {
                return "Value";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public A value() {
                return this.value;
            }

            public <A> Value<A> copy(A value) {
                return new Value(value);
            }

            public <A> A copy$default$1() {
                return this.value();
            }

            public int ordinal() {
                return 2;
            }

            public A _1() {
                return this.value();
            }
        }
    }

    public static final class Node<Key, Value>
    implements Product,
    Serializable {
        private final Set<Key> inputs;
        private final Set<Key> outputs;
        private final Value value;

        public static <Key, Value> Node<Key, Value> apply(Set<Key> set, Set<Key> set2, Value Value2) {
            return LayerMacros$Node$.MODULE$.apply(set, set2, Value2);
        }

        public static Node<?, ?> fromProduct(Product product) {
            return LayerMacros$Node$.MODULE$.fromProduct(product);
        }

        public static <Key, Value> CanEqual<Node<Key, Value>, Node<Key, Value>> given_CanEqual_Node_Node() {
            return LayerMacros$Node$.MODULE$.given_CanEqual_Node_Node();
        }

        public static <Key, Value> Node<Key, Value> unapply(Node<Key, Value> node) {
            return LayerMacros$Node$.MODULE$.unapply(node);
        }

        public Node(Set<Key> inputs, Set<Key> outputs, Value value) {
            this.inputs = inputs;
            this.outputs = outputs;
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Node)) return false;
            Node node = (Node)object;
            Set<Key> set = this.inputs();
            Set<Key> set2 = node.inputs();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<Key> set3 = this.outputs();
            Set<Key> set4 = node.outputs();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            if (!BoxesRunTime.equals(this.value(), node.value())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Node;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Node";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "inputs";
                }
                case 1: {
                    return "outputs";
                }
                case 2: {
                    return "value";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<Key> inputs() {
            return this.inputs;
        }

        public Set<Key> outputs() {
            return this.outputs;
        }

        public Value value() {
            return this.value;
        }

        public <Key, Value> Node<Key, Value> copy(Set<Key> inputs, Set<Key> outputs, Value value) {
            return new Node<Key, Value>(inputs, outputs, value);
        }

        public <Key, Value> Set<Key> copy$default$1() {
            return this.inputs();
        }

        public <Key, Value> Set<Key> copy$default$2() {
            return this.outputs();
        }

        public <Key, Value> Value copy$default$3() {
            return this.value();
        }

        public Set<Key> _1() {
            return this.inputs();
        }

        public Set<Key> _2() {
            return this.outputs();
        }

        public Value _3() {
            return this.value();
        }
    }

    public static abstract class Validated<E, A>
    implements Enum {
        public static <E, A> Validated<E, A> error(E e) {
            return LayerMacros$Validated$.MODULE$.error(e);
        }

        public static Validated<?, ?> fromOrdinal(int n) {
            return LayerMacros$Validated$.MODULE$.fromOrdinal(n);
        }

        public static <E, A> Validated<E, Set<A>> sequence(Set<Validated<E, A>> set) {
            return LayerMacros$Validated$.MODULE$.sequence(set);
        }

        public static <E, A> Validated<E, A> succeed(A a) {
            return LayerMacros$Validated$.MODULE$.succeed(a);
        }

        public static <E, A, B> Validated<E, Set<B>> traverse(Set<A> set, Function1<A, Validated<E, B>> function1) {
            return LayerMacros$Validated$.MODULE$.traverse(set, function1);
        }

        public <B> Validated<E, B> map(Function1<A, B> f) {
            Validated validated = this;
            if (validated instanceof Success) {
                Object a;
                Success success = LayerMacros$Validated$Success$.MODULE$.unapply((Success)validated);
                Object value = a = success._1();
                return LayerMacros$Validated$Success$.MODULE$.apply(f.apply(value));
            }
            if (validated instanceof Error) {
                .colon.colon colon2;
                Error error = LayerMacros$Validated$Error$.MODULE$.unapply((Error)validated);
                .colon.colon errors = colon2 = error._1();
                return LayerMacros$Validated$Error$.MODULE$.apply(errors);
            }
            throw new MatchError((Object)validated);
        }

        public <E1, B> Validated<E1, B> flatMap(Function1<A, Validated<E1, B>> f) {
            Validated validated = this;
            if (validated instanceof Success) {
                Object a;
                Success success = LayerMacros$Validated$Success$.MODULE$.unapply((Success)validated);
                Object value = a = success._1();
                return (Validated)f.apply(value);
            }
            if (validated instanceof Error) {
                .colon.colon colon2;
                Error error = LayerMacros$Validated$Error$.MODULE$.unapply((Error)validated);
                .colon.colon errors = colon2 = error._1();
                return LayerMacros$Validated$Error$.MODULE$.apply(errors);
            }
            throw new MatchError((Object)validated);
        }

        public <E1, B, C> Validated<E1, C> zipWith(Validated<E1, B> that, Function2<A, B, C> f) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this, that);
            if (tuple2 != null) {
                Validated validated = (Validated)tuple2._1();
                Validated validated2 = (Validated)tuple2._2();
                if (validated instanceof Success) {
                    Object a;
                    Success success = LayerMacros$Validated$Success$.MODULE$.unapply((Success)validated);
                    Object value1 = a = success._1();
                    if (validated2 instanceof Success) {
                        Object a2;
                        Success success2 = LayerMacros$Validated$Success$.MODULE$.unapply((Success)validated2);
                        Object value2 = a2 = success2._1();
                        return LayerMacros$Validated$Success$.MODULE$.apply(f.apply(value1, value2));
                    }
                }
                if (validated instanceof Error) {
                    Error error = LayerMacros$Validated$Error$.MODULE$.unapply((Error)validated);
                    .colon.colon colon2 = error._1();
                    if (colon2 != null) {
                        List list = colon2.next();
                        Object e = colon2.head();
                        List es = list;
                        if (validated2 instanceof Error) {
                            .colon.colon colon3;
                            Error error2 = LayerMacros$Validated$Error$.MODULE$.unapply((Error)validated2);
                            .colon.colon es2 = colon3 = error2._1();
                            return LayerMacros$Validated$Error$.MODULE$.apply(package$.MODULE$.$colon$colon().apply(e, (List)es.$plus$plus(es2)));
                        }
                    }
                    .colon.colon errors1 = colon2;
                    return LayerMacros$Validated$Error$.MODULE$.apply(errors1);
                }
                if (validated2 instanceof Error) {
                    .colon.colon colon4;
                    Error error = LayerMacros$Validated$Error$.MODULE$.unapply((Error)validated2);
                    .colon.colon errors2 = colon4 = error._1();
                    return LayerMacros$Validated$Error$.MODULE$.apply(errors2);
                }
            }
            throw new MatchError((Object)tuple2);
        }

        public static final class Error<E, A>
        extends Validated<E, A> {
            private final .colon.colon<E> errors;

            public static <E, A> Error<E, A> apply(.colon.colon<E> colon2) {
                return LayerMacros$Validated$Error$.MODULE$.apply(colon2);
            }

            public static Error<?, ?> fromProduct(Product product) {
                return LayerMacros$Validated$Error$.MODULE$.fromProduct(product);
            }

            public static <E, A> Error<E, A> unapply(Error<E, A> error) {
                return LayerMacros$Validated$Error$.MODULE$.unapply(error);
            }

            public Error(.colon.colon<E> colon2) {
                this.errors = errors;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Error)) return false;
                Error error = (Error)object;
                .colon.colon<E> colon2 = this.errors();
                .colon.colon<E> colon3 = error.errors();
                if (colon2 != null) {
                    if (!colon2.equals(colon3)) return false;
                    return true;
                }
                if (colon3 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Error;
            }

            public int productArity() {
                return 1;
            }

            @Override
            public String productPrefix() {
                return "Error";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "errors";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public .colon.colon<E> errors() {
                return this.errors;
            }

            public <E, A> Error<E, A> copy(.colon.colon<E> errors) {
                return new Error(errors);
            }

            public <E, A> .colon.colon<E> copy$default$1() {
                return this.errors();
            }

            public int ordinal() {
                return 1;
            }

            public .colon.colon<E> _1() {
                return this.errors();
            }
        }

        public static final class Success<E, A>
        extends Validated<E, A> {
            private final A value;

            public static <E, A> Success<E, A> apply(A a) {
                return LayerMacros$Validated$Success$.MODULE$.apply(a);
            }

            public static Success<?, ?> fromProduct(Product product) {
                return LayerMacros$Validated$Success$.MODULE$.fromProduct(product);
            }

            public static <E, A> Success<E, A> unapply(Success<E, A> success) {
                return LayerMacros$Validated$Success$.MODULE$.unapply(success);
            }

            public Success(A a) {
                this.value = value;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Success)) return false;
                Success success = (Success)object;
                if (!BoxesRunTime.equals(this.value(), success.value())) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Success;
            }

            public int productArity() {
                return 1;
            }

            @Override
            public String productPrefix() {
                return "Success";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "value";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public A value() {
                return this.value;
            }

            public <E, A> Success<E, A> copy(A value) {
                return new Success(value);
            }

            public <E, A> A copy$default$1() {
                return this.value();
            }

            public int ordinal() {
                return 0;
            }

            public A _1() {
                return this.value();
            }
        }
    }
}

