/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler.regulator;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.LongAdder;
import kyo.scheduler.InternalClock;
import kyo.scheduler.InternalTimer;
import kyo.scheduler.Task;
import kyo.scheduler.Task$;
import kyo.scheduler.regulator.Admission$;
import kyo.scheduler.regulator.Admission$AdmissionStatus$;
import kyo.scheduler.regulator.Config;
import kyo.scheduler.regulator.Regulator;
import kyo.stats.internal.MetricReceiver;
import kyo.stats.internal.MetricReceiver$;
import kyo.stats.internal.UnsafeGauge;
import kyo.stats.internal.UnsafeGauge$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public final class Admission
extends Regulator {
    private final Function1<Task, BoxedUnit> schedule;
    public final Function0<Object> kyo$scheduler$regulator$Admission$$nowMillis;
    private volatile int admissionPercent;
    private final LongAdder rejected;
    private final LongAdder allowed;
    private final UnsafeGauge gauges;

    public static Config defaultConfig() {
        return Admission$.MODULE$.defaultConfig();
    }

    public static Config $lessinit$greater$default$5() {
        return Admission$.MODULE$.$lessinit$greater$default$5();
    }

    public Admission(Function0<Object> loadAvg, Function1<Task, BoxedUnit> schedule, Function0<Object> nowMillis, InternalTimer timer, Config config) {
        this.schedule = schedule;
        this.kyo$scheduler$regulator$Admission$$nowMillis = nowMillis;
        super(loadAvg, timer, config);
        this.admissionPercent = 100;
        this.rejected = new LongAdder();
        this.allowed = new LongAdder();
        MetricReceiver receiver = MetricReceiver$.MODULE$.get();
        this.gauges = UnsafeGauge$.MODULE$.all((Seq<UnsafeGauge>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnsafeGauge[]{receiver.gauge(this.statsScope(), "percent", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$1)), receiver.gauge(this.statsScope(), "allowed", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$2)), receiver.gauge(this.statsScope(), "rejected", receiver.gauge$default$3(), receiver.gauge$default$4(), receiver.gauge$default$5(), (Function0<Object>)((Function0 & Serializable)this::$init$$$anonfun$3))}));
    }

    public int percent() {
        return this.admissionPercent;
    }

    public boolean reject(String key) {
        return this.reject(MurmurHash3$.MODULE$.stringHash(key));
    }

    public boolean reject() {
        return this.reject(ThreadLocalRandom.current().nextInt());
    }

    public boolean reject(int key) {
        boolean r;
        boolean bl = r = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(key)) % 100 > this.admissionPercent;
        if (r) {
            this.rejected.increment();
        } else {
            this.allowed.increment();
        }
        return r;
    }

    @Override
    public void probe() {
        this.schedule.apply((Object)new ProbeTask());
    }

    @Override
    public void update(int diff) {
        this.admissionPercent = Math.max(0, Math.min(100, this.admissionPercent + diff));
    }

    @Override
    public void stop() {
        this.gauges.close();
        super.stop();
    }

    public AdmissionStatus status() {
        return Admission$AdmissionStatus$.MODULE$.apply(this.admissionPercent, this.allowed.sum(), this.rejected.sum(), this.regulatorStatus());
    }

    private final double $init$$$anonfun$1() {
        return Int$.MODULE$.int2double(this.admissionPercent);
    }

    private final double $init$$$anonfun$2() {
        return this.allowed.sum();
    }

    private final double $init$$$anonfun$3() {
        return this.rejected.sum();
    }

    public static class AdmissionStatus
    implements Product,
    Serializable {
        private final int admissionPercent;
        private final long allowed;
        private final long rejected;
        private final Regulator.Status regulator;

        public static AdmissionStatus apply(int n, long l, long l2, Regulator.Status status) {
            return Admission$AdmissionStatus$.MODULE$.apply(n, l, l2, status);
        }

        public static AdmissionStatus fromProduct(Product product) {
            return Admission$AdmissionStatus$.MODULE$.fromProduct(product);
        }

        public static AdmissionStatus unapply(AdmissionStatus admissionStatus) {
            return Admission$AdmissionStatus$.MODULE$.unapply(admissionStatus);
        }

        public AdmissionStatus(int admissionPercent, long allowed, long rejected, Regulator.Status regulator) {
            this.admissionPercent = admissionPercent;
            this.allowed = allowed;
            this.rejected = rejected;
            this.regulator = regulator;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.admissionPercent());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.allowed()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.rejected()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.regulator()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AdmissionStatus)) return false;
            AdmissionStatus admissionStatus = (AdmissionStatus)object;
            if (this.admissionPercent() != admissionStatus.admissionPercent()) return false;
            if (this.allowed() != admissionStatus.allowed()) return false;
            if (this.rejected() != admissionStatus.rejected()) return false;
            Regulator.Status status = this.regulator();
            Regulator.Status status2 = admissionStatus.regulator();
            if (status == null) {
                if (status2 != null) {
                    return false;
                }
            } else if (!((Object)status).equals(status2)) return false;
            if (!admissionStatus.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AdmissionStatus;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "AdmissionStatus";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "admissionPercent";
                }
                case 1: {
                    return "allowed";
                }
                case 2: {
                    return "rejected";
                }
                case 3: {
                    return "regulator";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int admissionPercent() {
            return this.admissionPercent;
        }

        public long allowed() {
            return this.allowed;
        }

        public long rejected() {
            return this.rejected;
        }

        public Regulator.Status regulator() {
            return this.regulator;
        }

        public AdmissionStatus $minus(AdmissionStatus other) {
            return Admission$AdmissionStatus$.MODULE$.apply(this.admissionPercent() - other.admissionPercent(), this.allowed() - other.allowed(), this.rejected() - other.rejected(), this.regulator().$minus(other.regulator()));
        }

        public AdmissionStatus copy(int admissionPercent, long allowed, long rejected, Regulator.Status regulator) {
            return new AdmissionStatus(admissionPercent, allowed, rejected, regulator);
        }

        public int copy$default$1() {
            return this.admissionPercent();
        }

        public long copy$default$2() {
            return this.allowed();
        }

        public long copy$default$3() {
            return this.rejected();
        }

        public Regulator.Status copy$default$4() {
            return this.regulator();
        }

        public int _1() {
            return this.admissionPercent();
        }

        public long _2() {
            return this.allowed();
        }

        public long _3() {
            return this.rejected();
        }

        public Regulator.Status _4() {
            return this.regulator();
        }
    }

    public final class ProbeTask
    implements Task {
        private volatile int kyo$scheduler$Task$$state;
        private final long start;

        public ProbeTask() {
            if (Admission.this == null) {
                throw new NullPointerException();
            }
            Task.$init$(this);
            this.start = Admission.this.kyo$scheduler$regulator$Admission$$nowMillis.apply$mcJ$sp();
        }

        @Override
        public int kyo$scheduler$Task$$state() {
            return this.kyo$scheduler$Task$$state;
        }

        @Override
        public void kyo$scheduler$Task$$state_$eq(int x$1) {
            this.kyo$scheduler$Task$$state = x$1;
        }

        public long start() {
            return this.start;
        }

        @Override
        public boolean run(long startMillis, InternalClock clock) {
            Admission.this.measure(Admission.this.kyo$scheduler$regulator$Admission$$nowMillis.apply$mcJ$sp() - this.start());
            return Task$.MODULE$.Done();
        }

        public final /* synthetic */ Admission kyo$scheduler$regulator$Admission$ProbeTask$$$outer() {
            return Admission.this;
        }
    }
}

