/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler.regulator;

import java.io.Serializable;
import java.util.concurrent.atomic.LongAdder;
import kyo.scheduler.InternalTimer;
import kyo.scheduler.package$;
import kyo.scheduler.regulator.Config;
import kyo.scheduler.regulator.Regulator$Status$;
import kyo.scheduler.regulator.Regulator$stats$;
import kyo.scheduler.util.MovingStdDev;
import scala.Function0;
import scala.Int$;
import scala.Product;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public abstract class Regulator {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Regulator.class.getDeclaredField("stats$lzy1"));
    private final Function0<Object> loadAvg;
    private final Config config;
    private int step;
    private final MovingStdDev measurements;
    private final LongAdder probesSent;
    private final LongAdder probesCompleted;
    private final LongAdder adjustments;
    private final LongAdder updates;
    private final InternalTimer.TimerTask collectTask;
    private final InternalTimer.TimerTask regulateTask;
    private final List<String> statsScope;
    private volatile Object stats$lzy1;

    public Regulator(Function0<Object> loadAvg, InternalTimer timer, Config config) {
        this.loadAvg = loadAvg;
        this.config = config;
        this.step = 0;
        this.measurements = new MovingStdDev(config.collectWindow());
        this.probesSent = new LongAdder();
        this.probesCompleted = new LongAdder();
        this.adjustments = new LongAdder();
        this.updates = new LongAdder();
        this.collectTask = timer.schedule(config.collectInterval(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        this.regulateTask = timer.schedule(config.regulateInterval(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$2();
            return BoxedUnit.UNIT;
        });
        this.statsScope = package$.MODULE$.statsScope((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"regulator", this.getClass().getSimpleName()}));
    }

    public abstract void probe();

    public abstract void update(int var1);

    private final void collect() {
        try {
            this.probesSent.increment();
            this.probe();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                package$.MODULE$.bug(this.getClass().getSimpleName() + " regulator's probe collection has failed.", ex);
            }
            throw throwable;
        }
    }

    public void measure(long v) {
        this.probesCompleted.increment();
        this.stats().measurement().observe(v);
        Regulator regulator = this;
        synchronized (regulator) {
            this.measurements.observe(v);
        }
    }

    private final void adjust() {
        try {
            double d;
            this.adjustments.increment();
            Regulator regulator = this;
            synchronized (regulator) {
                d = this.measurements.dev();
            }
            double jitter = d;
            double load = this.loadAvg.apply$mcD$sp();
            this.step = jitter > this.config.jitterUpperThreshold() ? (this.step < 0 ? --this.step : -1) : (jitter < this.config.jitterLowerThreshold() && load >= this.config.loadAvgTarget() ? (this.step > 0 ? ++this.step : 1) : 0);
            if (this.step != 0) {
                int pow = (int)Math.pow(Int$.MODULE$.int2double(Math.abs(this.step)), this.config.stepExp());
                int delta = this.step < 0 ? -pow : pow;
                this.stats().update().observe(Int$.MODULE$.int2double(delta));
                this.updates.increment();
                this.update(delta);
            } else {
                this.stats().update().observe(0.0);
            }
            this.stats().jitter().observe(jitter);
            this.stats().loadavg().observe(load);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                package$.MODULE$.bug(this.getClass().getSimpleName() + " regulator's adjustment has failed.", ex);
            }
            throw throwable;
        }
    }

    public void stop() {
        this.collectTask.cancel();
        this.regulateTask.cancel();
        this.stats().gauges().close();
    }

    public List<String> statsScope() {
        return this.statsScope;
    }

    private final Regulator$stats$ stats() {
        Object object = this.stats$lzy1;
        if (object instanceof Regulator$stats$) {
            return (Regulator$stats$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Regulator$stats$)this.stats$lzyINIT1();
    }

    private Object stats$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.stats$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Regulator$stats$ regulator$stats$ = null;
                    try {
                        regulator$stats$ = new Regulator$stats$(this);
                        object2 = regulator$stats$ == null ? LazyVals.NullValue$.MODULE$ : regulator$stats$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.stats$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return regulator$stats$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Status regulatorStatus() {
        return Regulator$Status$.MODULE$.apply(this.step, this.measurements.avg(), this.measurements.dev(), this.probesSent.sum(), this.probesCompleted.sum(), this.adjustments.sum(), this.updates.sum());
    }

    private final void $init$$$anonfun$1() {
        this.collect();
    }

    private final void $init$$$anonfun$2() {
        this.adjust();
    }

    public static final double kyo$scheduler$regulator$Regulator$stats$$$_$$lessinit$greater$$anonfun$3(Regulator $outer$1) {
        return $outer$1.probesSent.sum();
    }

    public static final double kyo$scheduler$regulator$Regulator$stats$$$_$$lessinit$greater$$anonfun$4(Regulator $outer$2) {
        return $outer$2.probesSent.sum();
    }

    public static final double kyo$scheduler$regulator$Regulator$stats$$$_$$lessinit$greater$$anonfun$5(Regulator $outer$3) {
        return $outer$3.adjustments.sum();
    }

    public static final double kyo$scheduler$regulator$Regulator$stats$$$_$$lessinit$greater$$anonfun$6(Regulator $outer$4) {
        return $outer$4.updates.sum();
    }

    public static class Status
    implements Product,
    Serializable {
        private final int step;
        private final double measurementsAvg;
        private final double measurementsJitter;
        private final long probesSent;
        private final long probesCompleted;
        private final long adjustments;
        private final long updates;

        public static Status apply(int n, double d, double d2, long l, long l2, long l3, long l4) {
            return Regulator$Status$.MODULE$.apply(n, d, d2, l, l2, l3, l4);
        }

        public static Status fromProduct(Product product) {
            return Regulator$Status$.MODULE$.fromProduct(product);
        }

        public static Status unapply(Status status) {
            return Regulator$Status$.MODULE$.unapply(status);
        }

        public Status(int step, double measurementsAvg, double measurementsJitter, long probesSent, long probesCompleted, long adjustments, long updates) {
            this.step = step;
            this.measurementsAvg = measurementsAvg;
            this.measurementsJitter = measurementsJitter;
            this.probesSent = probesSent;
            this.probesCompleted = probesCompleted;
            this.adjustments = adjustments;
            this.updates = updates;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.step());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.measurementsAvg()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.measurementsJitter()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.probesSent()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.probesCompleted()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.adjustments()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.updates()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Status)) return false;
            Status status = (Status)object;
            if (this.step() != status.step()) return false;
            if (this.measurementsAvg() != status.measurementsAvg()) return false;
            if (this.measurementsJitter() != status.measurementsJitter()) return false;
            if (this.probesSent() != status.probesSent()) return false;
            if (this.probesCompleted() != status.probesCompleted()) return false;
            if (this.adjustments() != status.adjustments()) return false;
            if (this.updates() != status.updates()) return false;
            if (!status.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Status;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "Status";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToLong((long)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToLong((long)this._6());
                }
                case 6: {
                    return BoxesRunTime.boxToLong((long)this._7());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "step";
                }
                case 1: {
                    return "measurementsAvg";
                }
                case 2: {
                    return "measurementsJitter";
                }
                case 3: {
                    return "probesSent";
                }
                case 4: {
                    return "probesCompleted";
                }
                case 5: {
                    return "adjustments";
                }
                case 6: {
                    return "updates";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int step() {
            return this.step;
        }

        public double measurementsAvg() {
            return this.measurementsAvg;
        }

        public double measurementsJitter() {
            return this.measurementsJitter;
        }

        public long probesSent() {
            return this.probesSent;
        }

        public long probesCompleted() {
            return this.probesCompleted;
        }

        public long adjustments() {
            return this.adjustments;
        }

        public long updates() {
            return this.updates;
        }

        public Status $minus(Status other) {
            return Regulator$Status$.MODULE$.apply(this.step(), this.measurementsAvg(), this.measurementsJitter(), this.probesSent() - other.probesSent(), this.probesCompleted() - other.probesCompleted(), this.adjustments() - other.adjustments(), this.updates() - other.updates());
        }

        public Status copy(int step, double measurementsAvg, double measurementsJitter, long probesSent, long probesCompleted, long adjustments, long updates) {
            return new Status(step, measurementsAvg, measurementsJitter, probesSent, probesCompleted, adjustments, updates);
        }

        public int copy$default$1() {
            return this.step();
        }

        public double copy$default$2() {
            return this.measurementsAvg();
        }

        public double copy$default$3() {
            return this.measurementsJitter();
        }

        public long copy$default$4() {
            return this.probesSent();
        }

        public long copy$default$5() {
            return this.probesCompleted();
        }

        public long copy$default$6() {
            return this.adjustments();
        }

        public long copy$default$7() {
            return this.updates();
        }

        public int _1() {
            return this.step();
        }

        public double _2() {
            return this.measurementsAvg();
        }

        public double _3() {
            return this.measurementsJitter();
        }

        public long _4() {
            return this.probesSent();
        }

        public long _5() {
            return this.probesCompleted();
        }

        public long _6() {
            return this.adjustments();
        }

        public long _7() {
            return this.updates();
        }
    }
}

