/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import kyo.scheduler.InternalClock;
import kyo.scheduler.InternalTimer;
import kyo.scheduler.InternalTimer$;
import kyo.scheduler.Scheduler$;
import kyo.scheduler.Scheduler$Config$;
import kyo.scheduler.Task;
import kyo.scheduler.Task$;
import kyo.scheduler.Worker;
import kyo.scheduler.Worker$;
import kyo.scheduler.package$;
import kyo.scheduler.regulator.Admission;
import kyo.scheduler.regulator.Admission$;
import kyo.scheduler.regulator.Concurrency;
import kyo.scheduler.regulator.Concurrency$;
import kyo.scheduler.top.Reporter;
import kyo.scheduler.top.Status;
import kyo.scheduler.top.Status$;
import kyo.scheduler.top.WorkerStatus;
import kyo.scheduler.util.LoomSupport$;
import kyo.scheduler.util.XSRandom$;
import kyo.stats.internal.StatsRegistry;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class Scheduler {
    private final Executor workerExecutor;
    public final Config kyo$scheduler$Scheduler$$config;
    public final Executor kyo$scheduler$Scheduler$$pool;
    public final InternalClock kyo$scheduler$Scheduler$$clock;
    private final Worker[] workers;
    private final LongAdder flushes;
    private volatile int allocatedWorkers;
    public volatile int kyo$scheduler$Scheduler$$currentWorkers;
    private final Admission admissionRegulator;
    private final Concurrency concurrencyRegulator;
    private final Reporter top;
    private final ScheduledFuture<?> cycleTask;
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(Scheduler$.class.getDeclaredField("defaultTimerExecutor$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Scheduler$.class.getDeclaredField("defaultClockExecutor$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Scheduler$.class.getDeclaredField("defaultWorkerExecutor$lzy1"));

    public static Scheduler get() {
        return Scheduler$.MODULE$.get();
    }

    public static Executor $lessinit$greater$default$1() {
        return Scheduler$.MODULE$.$lessinit$greater$default$1();
    }

    public static Executor $lessinit$greater$default$2() {
        return Scheduler$.MODULE$.$lessinit$greater$default$2();
    }

    public static ScheduledExecutorService $lessinit$greater$default$3() {
        return Scheduler$.MODULE$.$lessinit$greater$default$3();
    }

    public static Config $lessinit$greater$default$4() {
        return Scheduler$.MODULE$.$lessinit$greater$default$4();
    }

    public Scheduler(Executor workerExecutor, Executor clockExecutor, ScheduledExecutorService timerExecutor, Config config) {
        this.workerExecutor = workerExecutor;
        this.kyo$scheduler$Scheduler$$config = config;
        this.kyo$scheduler$Scheduler$$pool = LoomSupport$.MODULE$.tryVirtualize(config.virtualizeWorkers(), workerExecutor);
        this.kyo$scheduler$Scheduler$$clock = new InternalClock(clockExecutor);
        this.workers = new Worker[config.maxWorkers()];
        this.flushes = new LongAdder();
        this.allocatedWorkers = 0;
        this.kyo$scheduler$Scheduler$$currentWorkers = config.coreWorkers();
        this.ensureWorkers();
        InternalTimer timer = InternalTimer$.MODULE$.apply(timerExecutor);
        this.admissionRegulator = new Admission((Function0<Object>)(Function0 & Serializable)() -> this.loadAvg(), (Function1<Task, BoxedUnit>)(JProcedure1 & Serializable)task -> this.schedule((Task)task), (Function0<Object>)(Function0 & Serializable)() -> System.currentTimeMillis(), timer, Admission$.MODULE$.$lessinit$greater$default$5());
        this.concurrencyRegulator = new Concurrency((Function0<Object>)(Function0 & Serializable)() -> this.loadAvg(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable)delta -> this.updateWorkers(delta), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable)_$1 -> Thread.sleep(Int$.MODULE$.int2long(_$1)), (Function0<Object>)(Function0 & Serializable)() -> System.nanoTime(), timer, Concurrency$.MODULE$.$lessinit$greater$default$6());
        this.top = new Reporter((Function0<Status>)(Function0 & Serializable)() -> this.status(), config.enableTopJMX(), config.enableTopConsoleMs(), timer);
        this.cycleTask = timerExecutor.scheduleAtFixedRate(() -> this.cycleWorkers(), Int$.MODULE$.int2long(config.cycleNs()), Int$.MODULE$.int2long(config.cycleNs()), TimeUnit.NANOSECONDS);
        StatsRegistry.Scope scope = package$.MODULE$.statsScope();
        StatsRegistry.Scope scope2 = package$.MODULE$.statsScope();
        StatsRegistry.Scope scope3 = package$.MODULE$.statsScope();
        StatsRegistry.Scope scope4 = package$.MODULE$.statsScope();
        List gauges = (List)new .colon.colon((Object)scope.gauge("current_workers", scope.gauge$default$2(), this::$init$$$anonfun$10), (List)new .colon.colon((Object)scope2.gauge("allocated_workers", scope2.gauge$default$2(), this::$init$$$anonfun$11), (List)new .colon.colon((Object)scope3.gauge("load_avg", scope3.gauge$default$2(), this::$init$$$anonfun$12), (List)new .colon.colon((Object)scope4.gauge("flushes", scope4.gauge$default$2(), this::$init$$$anonfun$13), (List)Nil$.MODULE$))));
    }

    public void schedule(Task task) {
        this.schedule(task, null);
    }

    public boolean reject() {
        return this.admissionRegulator.reject();
    }

    public boolean reject(String key) {
        return this.admissionRegulator.reject(key);
    }

    public boolean reject(int key) {
        return this.admissionRegulator.reject(key);
    }

    public Executor asExecutor() {
        return r -> this.schedule(Task$.MODULE$.apply((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            Scheduler.asExecutor$$anonfun$1$$anonfun$1(r);
            return BoxedUnit.UNIT;
        }));
    }

    public ExecutionContext asExecutionContext() {
        return ExecutionContext$.MODULE$.fromExecutor(this.asExecutor());
    }

    private void schedule(Task task, Worker submitter) {
        long nowMs = this.kyo$scheduler$Scheduler$$clock.currentMillis();
        Worker worker = null;
        if (submitter == null && (worker = Worker$.MODULE$.current()) != null && !worker.checkAvailability(nowMs)) {
            worker = null;
        }
        if (worker == null) {
            int currentWorkers = this.kyo$scheduler$Scheduler$$currentWorkers;
            int position = XSRandom$.MODULE$.nextInt(currentWorkers);
            int minLoad = Integer.MAX_VALUE;
            for (int stride = Math.min(currentWorkers, this.kyo$scheduler$Scheduler$$config.scheduleStride()); stride > 0 && minLoad != 0; --stride) {
                int l;
                Worker candidate = this.workers[position];
                if (candidate != null && candidate != submitter && candidate.checkAvailability(nowMs) && (l = candidate.load()) < minLoad) {
                    minLoad = l;
                    worker = candidate;
                }
                if (++position != currentWorkers) continue;
                position = 0;
            }
        }
        while (worker == null) {
            worker = this.workers[XSRandom$.MODULE$.nextInt(this.kyo$scheduler$Scheduler$$currentWorkers)];
        }
        worker.enqueue(task);
    }

    private Task steal(Worker thief) {
        long nowMs = this.kyo$scheduler$Scheduler$$clock.currentMillis();
        int currentWorkers = this.kyo$scheduler$Scheduler$$currentWorkers;
        Worker worker = null;
        int maxLoad = 1;
        int position = XSRandom$.MODULE$.nextInt(currentWorkers);
        for (int stride = Math.min(currentWorkers, this.kyo$scheduler$Scheduler$$config.stealStride()); stride > 0; --stride) {
            int load;
            Worker candidate = this.workers[position];
            if (candidate != null && candidate != thief && (load = candidate.load()) > maxLoad) {
                maxLoad = load;
                worker = candidate;
            }
            if (++position != currentWorkers) continue;
            position = 0;
        }
        if (worker != null) {
            return worker.stealingBy(thief);
        }
        return null;
    }

    public void flush() {
        Worker worker = Worker$.MODULE$.current();
        if (worker != null) {
            this.flushes.increment();
            worker.drain();
            return;
        }
    }

    public double loadAvg() {
        int currentWorkers = this.kyo$scheduler$Scheduler$$currentWorkers;
        int sum = 0;
        for (int position = 0; position < currentWorkers; ++position) {
            Worker w = this.workers[position];
            if (w == null) continue;
            sum += w.load();
        }
        return (double)sum / (double)currentWorkers;
    }

    public void shutdown() {
        this.cycleTask.cancel(true);
        this.admissionRegulator.stop();
        this.concurrencyRegulator.stop();
        this.top.close();
    }

    private void updateWorkers(int delta) {
        this.kyo$scheduler$Scheduler$$currentWorkers = Math.max(this.kyo$scheduler$Scheduler$$config.minWorkers(), Math.min(this.kyo$scheduler$Scheduler$$config.maxWorkers(), this.kyo$scheduler$Scheduler$$currentWorkers + delta));
        this.ensureWorkers();
    }

    private void ensureWorkers() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.allocatedWorkers), this.kyo$scheduler$Scheduler$$currentWorkers).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            this.workers[idx] = new Worker(idx, this){
                private final int idx$2;
                private final /* synthetic */ Scheduler $outer;
                {
                    this.idx$2 = idx$1;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(idx$1, $outer.kyo$scheduler$Scheduler$$pool, (Function2<Task, Worker, BoxedUnit>)$outer.kyo$scheduler$Scheduler$$_$$anon$superArg$1$1(), (Function1<Worker, Task>)$outer.kyo$scheduler$Scheduler$$_$$anon$superArg$2$1(), $outer.kyo$scheduler$Scheduler$$clock, $outer.kyo$scheduler$Scheduler$$config.timeSliceMs());
                }

                public boolean shouldStop() {
                    return this.idx$2 >= this.$outer.kyo$scheduler$Scheduler$$currentWorkers;
                }
            };
            ++this.allocatedWorkers;
        });
    }

    private void cycleWorkers() {
        try {
            long nowMs = this.kyo$scheduler$Scheduler$$clock.currentMillis();
            for (int position = 0; position < this.allocatedWorkers; ++position) {
                Worker worker = this.workers[position];
                if (worker == null) continue;
                if (position >= this.kyo$scheduler$Scheduler$$currentWorkers) {
                    worker.drain();
                }
                worker.checkAvailability(nowMs);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                package$.MODULE$.bug("Worker cyclying has failed.", ex);
            }
            throw throwable;
        }
    }

    public Status status() {
        Tuple2.mcII.sp sp2;
        Executor executor = this.workerExecutor;
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor exec = (ThreadPoolExecutor)executor;
            sp2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)exec.getActiveCount()), (Object)BoxesRunTime.boxToInteger((int)exec.getPoolSize()));
        } else {
            sp2 = new Tuple2.mcII.sp(-1, -1);
        }
        Tuple2.mcII.sp sp3 = sp2;
        int activeThreads = sp3._1$mcI$sp();
        int totalThreads = sp3._2$mcI$sp();
        return Status$.MODULE$.apply(this.kyo$scheduler$Scheduler$$currentWorkers, this.allocatedWorkers, this.loadAvg(), this.flushes.sum(), activeThreads, totalThreads, (Seq<WorkerStatus>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.allocatedWorkers).map((Function1 & Serializable)i -> this.status$$anonfun$1(BoxesRunTime.unboxToInt((Object)i))), this.admissionRegulator.status(), this.concurrencyRegulator.status());
    }

    private final double $init$$$anonfun$10() {
        return Int$.MODULE$.int2double(this.kyo$scheduler$Scheduler$$currentWorkers);
    }

    private final double $init$$$anonfun$11() {
        return Int$.MODULE$.int2double(this.allocatedWorkers);
    }

    private final double $init$$$anonfun$12() {
        return this.loadAvg();
    }

    private final double $init$$$anonfun$13() {
        return this.flushes.sum();
    }

    private static final void asExecutor$$anonfun$1$$anonfun$1(Runnable r$1) {
        r$1.run();
    }

    public final Function2 kyo$scheduler$Scheduler$$_$$anon$superArg$1$1() {
        return (JProcedure2 & Serializable)(task, submitter) -> this.schedule((Task)task, (Worker)submitter);
    }

    public final Function1 kyo$scheduler$Scheduler$$_$$anon$superArg$2$1() {
        return (Function1 & Serializable)thief -> this.steal((Worker)thief);
    }

    private final WorkerStatus workerStatus$1(int i) {
        Worker worker = this.workers[i];
        if (worker == null) {
            return null;
        }
        Worker worker2 = worker;
        return worker2.status();
    }

    private final /* synthetic */ WorkerStatus status$$anonfun$1(int i) {
        return this.workerStatus$1(i);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Config
    implements Product,
    Serializable {
        private final int cores;
        private final int coreWorkers;
        private final int minWorkers;
        private final int maxWorkers;
        private final int scheduleStride;
        private final int stealStride;
        private final boolean virtualizeWorkers;
        private final int timeSliceMs;
        private final int cycleNs;
        private final boolean enableTopJMX;
        private final int enableTopConsoleMs;

        public static Config apply(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, int n8, boolean bl2, int n9) {
            return Scheduler$Config$.MODULE$.apply(n, n2, n3, n4, n5, n6, bl, n7, n8, bl2, n9);
        }

        public static Config default() {
            return Scheduler$Config$.MODULE$.default();
        }

        public static Config fromProduct(Product product) {
            return Scheduler$Config$.MODULE$.fromProduct(product);
        }

        public static Config unapply(Config config) {
            return Scheduler$Config$.MODULE$.unapply(config);
        }

        public Config(int cores, int coreWorkers, int minWorkers, int maxWorkers, int scheduleStride, int stealStride, boolean virtualizeWorkers, int timeSliceMs, int cycleNs, boolean enableTopJMX, int enableTopConsoleMs) {
            this.cores = cores;
            this.coreWorkers = coreWorkers;
            this.minWorkers = minWorkers;
            this.maxWorkers = maxWorkers;
            this.scheduleStride = scheduleStride;
            this.stealStride = stealStride;
            this.virtualizeWorkers = virtualizeWorkers;
            this.timeSliceMs = timeSliceMs;
            this.cycleNs = cycleNs;
            this.enableTopJMX = enableTopJMX;
            this.enableTopConsoleMs = enableTopConsoleMs;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.cores());
            n = Statics.mix((int)n, (int)this.coreWorkers());
            n = Statics.mix((int)n, (int)this.minWorkers());
            n = Statics.mix((int)n, (int)this.maxWorkers());
            n = Statics.mix((int)n, (int)this.scheduleStride());
            n = Statics.mix((int)n, (int)this.stealStride());
            n = Statics.mix((int)n, (int)(this.virtualizeWorkers() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.timeSliceMs());
            n = Statics.mix((int)n, (int)this.cycleNs());
            n = Statics.mix((int)n, (int)(this.enableTopJMX() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.enableTopConsoleMs());
            return Statics.finalizeHash((int)n, (int)11);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Config)) return false;
            Config config = (Config)object;
            if (this.cores() != config.cores()) return false;
            if (this.coreWorkers() != config.coreWorkers()) return false;
            if (this.minWorkers() != config.minWorkers()) return false;
            if (this.maxWorkers() != config.maxWorkers()) return false;
            if (this.scheduleStride() != config.scheduleStride()) return false;
            if (this.stealStride() != config.stealStride()) return false;
            if (this.virtualizeWorkers() != config.virtualizeWorkers()) return false;
            if (this.timeSliceMs() != config.timeSliceMs()) return false;
            if (this.cycleNs() != config.cycleNs()) return false;
            if (this.enableTopJMX() != config.enableTopJMX()) return false;
            if (this.enableTopConsoleMs() != config.enableTopConsoleMs()) return false;
            if (!config.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Config;
        }

        public int productArity() {
            return 11;
        }

        public String productPrefix() {
            return "Config";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this._6());
                }
                case 6: {
                    return BoxesRunTime.boxToBoolean((boolean)this._7());
                }
                case 7: {
                    return BoxesRunTime.boxToInteger((int)this._8());
                }
                case 8: {
                    return BoxesRunTime.boxToInteger((int)this._9());
                }
                case 9: {
                    return BoxesRunTime.boxToBoolean((boolean)this._10());
                }
                case 10: {
                    return BoxesRunTime.boxToInteger((int)this._11());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "cores";
                }
                case 1: {
                    return "coreWorkers";
                }
                case 2: {
                    return "minWorkers";
                }
                case 3: {
                    return "maxWorkers";
                }
                case 4: {
                    return "scheduleStride";
                }
                case 5: {
                    return "stealStride";
                }
                case 6: {
                    return "virtualizeWorkers";
                }
                case 7: {
                    return "timeSliceMs";
                }
                case 8: {
                    return "cycleNs";
                }
                case 9: {
                    return "enableTopJMX";
                }
                case 10: {
                    return "enableTopConsoleMs";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int cores() {
            return this.cores;
        }

        public int coreWorkers() {
            return this.coreWorkers;
        }

        public int minWorkers() {
            return this.minWorkers;
        }

        public int maxWorkers() {
            return this.maxWorkers;
        }

        public int scheduleStride() {
            return this.scheduleStride;
        }

        public int stealStride() {
            return this.stealStride;
        }

        public boolean virtualizeWorkers() {
            return this.virtualizeWorkers;
        }

        public int timeSliceMs() {
            return this.timeSliceMs;
        }

        public int cycleNs() {
            return this.cycleNs;
        }

        public boolean enableTopJMX() {
            return this.enableTopJMX;
        }

        public int enableTopConsoleMs() {
            return this.enableTopConsoleMs;
        }

        public Config copy(int cores, int coreWorkers, int minWorkers, int maxWorkers, int scheduleStride, int stealStride, boolean virtualizeWorkers, int timeSliceMs, int cycleNs, boolean enableTopJMX, int enableTopConsoleMs) {
            return new Config(cores, coreWorkers, minWorkers, maxWorkers, scheduleStride, stealStride, virtualizeWorkers, timeSliceMs, cycleNs, enableTopJMX, enableTopConsoleMs);
        }

        public int copy$default$1() {
            return this.cores();
        }

        public int copy$default$2() {
            return this.coreWorkers();
        }

        public int copy$default$3() {
            return this.minWorkers();
        }

        public int copy$default$4() {
            return this.maxWorkers();
        }

        public int copy$default$5() {
            return this.scheduleStride();
        }

        public int copy$default$6() {
            return this.stealStride();
        }

        public boolean copy$default$7() {
            return this.virtualizeWorkers();
        }

        public int copy$default$8() {
            return this.timeSliceMs();
        }

        public int copy$default$9() {
            return this.cycleNs();
        }

        public boolean copy$default$10() {
            return this.enableTopJMX();
        }

        public int copy$default$11() {
            return this.enableTopConsoleMs();
        }

        public int _1() {
            return this.cores();
        }

        public int _2() {
            return this.coreWorkers();
        }

        public int _3() {
            return this.minWorkers();
        }

        public int _4() {
            return this.maxWorkers();
        }

        public int _5() {
            return this.scheduleStride();
        }

        public int _6() {
            return this.stealStride();
        }

        public boolean _7() {
            return this.virtualizeWorkers();
        }

        public int _8() {
            return this.timeSliceMs();
        }

        public int _9() {
            return this.cycleNs();
        }

        public boolean _10() {
            return this.enableTopJMX();
        }

        public int _11() {
            return this.enableTopConsoleMs();
        }
    }
}

