/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler.util;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import kyo.scheduler.Scheduler;
import kyo.scheduler.Task;
import kyo.scheduler.Task$;
import kyo.scheduler.util.SelfCheck$;
import scala.Function0;
import scala.Int$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SelfCheck {
    private final Scheduler scheduler;
    private final Executor executor;
    private final double rejectionThreshold;
    private final int taskDurationMs;
    private final int monitorIntervalMs;
    private final int stepMs;
    private int clients;
    private final AtomicLong admissions;
    private final AtomicLong rejections;
    private volatile boolean stop;

    public static void delayedInit(Function0<BoxedUnit> function0) {
        SelfCheck$.MODULE$.delayedInit(function0);
    }

    public static long executionStart() {
        return SelfCheck$.MODULE$.executionStart();
    }

    public static void main(String[] stringArray) {
        SelfCheck$.MODULE$.main(stringArray);
    }

    public static Scheduler $lessinit$greater$default$1() {
        return SelfCheck$.MODULE$.$lessinit$greater$default$1();
    }

    public static Executor $lessinit$greater$default$2() {
        return SelfCheck$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$3() {
        return SelfCheck$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return SelfCheck$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$5() {
        return SelfCheck$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$6() {
        return SelfCheck$.MODULE$.$lessinit$greater$default$6();
    }

    public static /* synthetic */ void scala$App$_setter_$executionStart_$eq(long l) {
        SelfCheck$.MODULE$.scala$App$_setter_$executionStart_$eq(l);
    }

    public static /* synthetic */ void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer listBuffer) {
        SelfCheck$.MODULE$.scala$App$_setter_$scala$App$$initCode_$eq(listBuffer);
    }

    public SelfCheck(Scheduler scheduler, Executor executor, double rejectionThreshold, int taskDurationMs, int monitorIntervalMs, int stepMs) {
        this.scheduler = scheduler;
        this.executor = executor;
        this.rejectionThreshold = rejectionThreshold;
        this.taskDurationMs = taskDurationMs;
        this.monitorIntervalMs = monitorIntervalMs;
        this.stepMs = stepMs;
        this.clients = 0;
        this.admissions = new AtomicLong();
        this.rejections = new AtomicLong();
        this.stop = false;
    }

    public void run() {
        this.startMonitor();
        this.loop$1();
        this.stop = true;
    }

    public void startMonitor() {
        this.executor.execute(() -> {
            while (!this.stop) {
                long l = this.scheduler.reject() ? this.rejections.incrementAndGet() : this.admissions.incrementAndGet();
                Thread.sleep(Int$.MODULE$.int2long(this.monitorIntervalMs));
            }
        });
    }

    public void startClient() {
        this.executor.execute(() -> {
            while (!this.stop) {
                this.runClient();
            }
        });
    }

    public void runClient() {
        CountDownLatch cdl = new CountDownLatch(1);
        Task task = Task$.MODULE$.apply((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$anonfun$1(cdl);
            return BoxedUnit.UNIT;
        });
        this.scheduler.schedule(task);
        cdl.await();
    }

    private final void loop$1() {
        while (true) {
            long a = this.admissions.getAndSet(0L);
            long b = this.rejections.getAndSet(0L);
            double rejectionPercent = a > 0L ? (double)b / (double)a : (b > 0L ? 1.0 : 0.0);
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"clients");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)this.clients));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rejectionPercent");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToDouble((double)rejectionPercent));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rejectionThreshold");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToDouble((double)this.rejectionThreshold));
            Predef$.MODULE$.println(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            if (!(rejectionPercent <= this.rejectionThreshold)) break;
            ++this.clients;
            this.startClient();
            Thread.sleep(Int$.MODULE$.int2long(this.stepMs));
        }
        int cores = Runtime.getRuntime().availableProcessors();
        double high = (double)cores * 1.5 + (double)2;
        double low = (double)cores * 0.8;
        if ((double)this.clients > high || (double)this.clients < low) {
            Predef$.MODULE$.println((Object)("Failure: Expected between " + low + " and " + high + " clients for " + cores + " cores but found " + this.clients + "."));
            return;
        }
        Predef$.MODULE$.println((Object)"Success");
    }

    private final void $anonfun$1(CountDownLatch cdl$1) {
        double acc = 0.0;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)this.taskDurationMs) {
            acc += package$.MODULE$.BigInt().apply(2).pow(1000000).toDouble();
        }
        cdl$1.countDown();
    }
}

