/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class Queue<A>
extends AtomicBoolean {
    private final PriorityQueue<A> queue;
    private int items;

    public Queue(Ordering<A> ord) {
        this.queue = (PriorityQueue)PriorityQueue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), ord);
        this.items = 0;
    }

    private PriorityQueue<A> queue() {
        return this.queue;
    }

    private int items() {
        return this.items;
    }

    private void items_$eq(int x$0) {
        this.items = x$0;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        VarHandle.acquireFence();
        return this.items();
    }

    public void add(A value) {
        this.lock();
        try {
            this.items_$eq(this.items() + 1);
            this.queue().$plus$eq(value);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean offer(A value) {
        boolean bl;
        if (!this.tryLock()) return false;
        try {
            this.items_$eq(this.items() + 1);
            this.queue().$plus$eq(value);
            bl = true;
        }
        finally {
            this.unlock();
        }
        if (!bl) return false;
        return true;
    }

    public A poll() {
        Object object;
        if (this.isEmpty()) {
            return null;
        }
        this.lock();
        try {
            if (this.isEmpty()) {
                object = null;
            } else {
                this.items_$eq(this.items() - 1);
                object = this.queue().dequeue();
            }
        }
        finally {
            this.unlock();
        }
        return (A)object;
    }

    /*
     * WARNING - void declaration
     */
    public A addAndPoll(A value) {
        A a;
        if (this.isEmpty()) {
            return value;
        }
        this.lock();
        try {
            if (this.isEmpty()) {
                a = value;
            } else {
                void var2_2;
                Object r = this.queue().dequeue();
                this.queue().$plus$eq(value);
                a = var2_2;
            }
        }
        finally {
            this.unlock();
        }
        return a;
    }

    /*
     * Unable to fully structure code
     */
    public A stealingBy(Queue<A> to) {
        t = null;
        if (this.isEmpty() || !this.tryLock()) ** GOTO lbl-1000
        try {
            if (this.isEmpty() || !to.isEmpty() || !super.tryLock()) ** GOTO lbl-1000
            try {
                t = this.queue().dequeue();
                s = this.size() - 1;
                this.items_$eq(this.items() - (i + 1));
                super.items_$eq(super.items() + i);
                for (i = s - Predef$.MODULE$.double2Double(Math.ceil((double)s / (double)2)).intValue(); i > 0; --i) {
                    super.queue().$plus$eq(this.queue().dequeue());
                }
                v0 = true;
            }
            finally {
                super.unlock();
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        finally {
            this.unlock();
        }
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        return (A)t;
    }

    public void drain(Function1<A, BoxedUnit> f) {
        if (!this.isEmpty()) {
            Seq seq;
            this.lock();
            try {
                this.items_$eq(0);
                seq = this.queue().dequeueAll();
            }
            finally {
                this.unlock();
            }
            Seq tasks = seq;
            tasks.foreach(f);
            return;
        }
    }

    private void lock() {
        while (!this.compareAndSet(false, true)) {
        }
    }

    private boolean tryLock() {
        return this.compareAndSet(false, true);
    }

    private void unlock() {
        this.set(false);
    }
}

