/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler.regulator;

import java.io.Serializable;
import java.util.concurrent.atomic.LongAdder;
import kyo.scheduler.InternalTimer;
import kyo.scheduler.package$;
import kyo.scheduler.regulator.Config;
import kyo.scheduler.regulator.Regulator$stats$;
import kyo.scheduler.top.RegulatorStatus;
import kyo.scheduler.top.RegulatorStatus$;
import kyo.scheduler.util.MovingStdDev;
import kyo.stats.internal.StatsRegistry;
import scala.Function0;
import scala.Int$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public abstract class Regulator {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Regulator.class.getDeclaredField("stats$lzy1"));
    private final Function0<Object> loadAvg;
    private final Config config;
    private int step;
    private final MovingStdDev measurements;
    private final LongAdder probesSent;
    private final LongAdder probesCompleted;
    private final LongAdder adjustments;
    private final LongAdder updates;
    private final InternalTimer.TimerTask collectTask;
    private final InternalTimer.TimerTask regulateTask;
    private final StatsRegistry.Scope statsScope;
    private volatile Object stats$lzy1;

    public Regulator(Function0<Object> loadAvg, InternalTimer timer, Config config) {
        this.loadAvg = loadAvg;
        this.config = config;
        this.step = 0;
        this.measurements = new MovingStdDev(config.collectWindow());
        this.probesSent = new LongAdder();
        this.probesCompleted = new LongAdder();
        this.adjustments = new LongAdder();
        this.updates = new LongAdder();
        this.collectTask = timer.schedule(config.collectInterval(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        this.regulateTask = timer.schedule(config.regulateInterval(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$init$$$anonfun$2();
            return BoxedUnit.UNIT;
        });
        this.statsScope = package$.MODULE$.statsScope().scope((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"regulator", this.getClass().getSimpleName().toLowerCase()}));
    }

    public abstract void probe();

    public abstract void update(int var1);

    private final void collect() {
        try {
            this.probesSent.increment();
            this.probe();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                package$.MODULE$.bug(this.getClass().getSimpleName() + " regulator's probe collection has failed.", ex);
            }
            throw throwable;
        }
    }

    public void measure(long v) {
        this.probesCompleted.increment();
        this.stats().measurement().observe(Math.max(0.0, (double)v));
        Regulator regulator = this;
        synchronized (regulator) {
            this.measurements.observe(v);
        }
    }

    private final void adjust() {
        try {
            double d;
            this.adjustments.increment();
            Regulator regulator = this;
            synchronized (regulator) {
                d = this.measurements.dev();
            }
            double jitter = d;
            double load = this.loadAvg.apply$mcD$sp();
            this.step = jitter > this.config.jitterUpperThreshold() ? (this.step < 0 ? --this.step : -1) : (jitter < this.config.jitterLowerThreshold() && load >= this.config.loadAvgTarget() ? (this.step > 0 ? ++this.step : 1) : 0);
            if (this.step != 0) {
                int pow = (int)Math.pow(Int$.MODULE$.int2double(Math.abs(this.step)), this.config.stepExp());
                int delta = this.step < 0 ? -pow : pow;
                this.updates.increment();
                this.update(delta);
            }
            this.stats().jitter().observe(jitter);
            this.stats().loadavg().observe(load);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                package$.MODULE$.bug(this.getClass().getSimpleName() + " regulator's adjustment has failed.", ex);
            }
            throw throwable;
        }
    }

    public void stop() {
        this.collectTask.cancel();
        boolean bl = this.regulateTask.cancel();
    }

    public StatsRegistry.Scope statsScope() {
        return this.statsScope;
    }

    private final Regulator$stats$ stats() {
        Object object = this.stats$lzy1;
        if (object instanceof Regulator$stats$) {
            return (Regulator$stats$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Regulator$stats$)this.stats$lzyINIT1();
    }

    private Object stats$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.stats$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Regulator$stats$ regulator$stats$ = null;
                    try {
                        regulator$stats$ = new Regulator$stats$(this);
                        object2 = regulator$stats$ == null ? LazyVals.NullValue$.MODULE$ : regulator$stats$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.stats$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return regulator$stats$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public RegulatorStatus regulatorStatus() {
        return RegulatorStatus$.MODULE$.apply(this.step, this.measurements.avg(), this.measurements.dev(), this.probesSent.sum(), this.probesCompleted.sum(), this.adjustments.sum(), this.updates.sum());
    }

    private final void $init$$$anonfun$1() {
        this.collect();
    }

    private final void $init$$$anonfun$2() {
        this.adjust();
    }

    public static final double kyo$scheduler$regulator$Regulator$stats$$$_$$lessinit$greater$$anonfun$3(Regulator $outer$1) {
        return $outer$1.probesSent.sum();
    }

    public static final double kyo$scheduler$regulator$Regulator$stats$$$_$$lessinit$greater$$anonfun$4(Regulator $outer$2) {
        return $outer$2.probesSent.sum();
    }

    public static final double kyo$scheduler$regulator$Regulator$stats$$$_$$lessinit$greater$$anonfun$5(Regulator $outer$3) {
        return $outer$3.adjustments.sum();
    }

    public static final double kyo$scheduler$regulator$Regulator$stats$$$_$$lessinit$greater$$anonfun$6(Regulator $outer$4) {
        return $outer$4.updates.sum();
    }
}

