/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler;

import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import kyo.scheduler.InternalClock;
import kyo.scheduler.Queue;
import kyo.scheduler.Task;
import kyo.scheduler.Task$;
import kyo.scheduler.Worker$;
import kyo.scheduler.Worker$State$;
import kyo.scheduler.Worker$State$Idle$;
import kyo.scheduler.Worker$State$Running$;
import kyo.scheduler.Worker$State$Stalled$;
import kyo.scheduler.Worker$internal$;
import kyo.scheduler.package$;
import kyo.scheduler.top.WorkerStatus;
import kyo.scheduler.top.WorkerStatus$;
import kyo.stats.internal.StatsRegistry;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public abstract class Worker
implements Runnable {
    private final int id;
    private final Executor exec;
    private final Function2<Task, Worker, BoxedUnit> scheduleTask;
    private final Function1<Worker, Task> stealTask;
    private final InternalClock clock;
    private final int timeSliceMs;
    private final long a1;
    private final long a2;
    private final long a3;
    private final long a4;
    private final long a5;
    private final long a6;
    private final long a7;
    private final AtomicReference<State> state;
    private volatile Thread mount;
    private final long b1;
    private final long b2;
    private final long b3;
    private final long b4;
    private final long b5;
    private final long b6;
    private final long b7;
    private volatile long taskStartMs;
    private volatile Task currentTask;
    private final long c1;
    private final long c2;
    private final long c3;
    private final long c4;
    private final long c5;
    private final long c6;
    private final long c7;
    private long executions;
    private long preemptions;
    private long completions;
    private long mounts;
    private long stolenTasks;
    private final LongAdder lostTasks;
    private final Queue<Task> queue;
    private final Function1<Task, BoxedUnit> schedule;

    public static Worker current() {
        return Worker$.MODULE$.current();
    }

    public Worker(int id, Executor exec, Function2<Task, Worker, BoxedUnit> scheduleTask, Function1<Worker, Task> stealTask, InternalClock clock, int timeSliceMs) {
        this.id = id;
        this.exec = exec;
        this.scheduleTask = scheduleTask;
        this.stealTask = stealTask;
        this.clock = clock;
        this.timeSliceMs = timeSliceMs;
        this.a1 = 0L;
        this.a2 = 0L;
        this.a3 = 0L;
        this.a4 = 0L;
        this.a5 = 0L;
        this.a6 = 0L;
        this.a7 = 0L;
        this.state = new AtomicReference<Worker$State$Idle$>(Worker$State$Idle$.MODULE$);
        this.mount = null;
        this.b1 = 0L;
        this.b2 = 0L;
        this.b3 = 0L;
        this.b4 = 0L;
        this.b5 = 0L;
        this.b6 = 0L;
        this.b7 = 0L;
        this.taskStartMs = 0L;
        this.currentTask = null;
        this.c1 = 0L;
        this.c2 = 0L;
        this.c3 = 0L;
        this.c4 = 0L;
        this.c5 = 0L;
        this.c6 = 0L;
        this.c7 = 0L;
        this.executions = 0L;
        this.preemptions = 0L;
        this.completions = 0L;
        this.mounts = 0L;
        this.stolenTasks = 0L;
        this.lostTasks = new LongAdder();
        this.queue = new Queue<Task>(Task$.MODULE$.taskOrdering());
        this.schedule = (JProcedure1 & Serializable)_$1 -> scheduleTask.apply(_$1, (Object)this);
        StatsRegistry.Scope scope = package$.MODULE$.statsScope();
        StatsRegistry.Scope scope2 = package$.MODULE$.statsScope();
        StatsRegistry.Scope scope3 = package$.MODULE$.statsScope();
        StatsRegistry.Scope scope4 = package$.MODULE$.statsScope();
        StatsRegistry.Scope scope5 = package$.MODULE$.statsScope();
        StatsRegistry.Scope scope6 = package$.MODULE$.statsScope();
        StatsRegistry.Scope scope7 = package$.MODULE$.statsScope();
        List gauges = (List)new .colon.colon((Object)scope.gauge("queue_size", scope.gauge$default$2(), this::$init$$$anonfun$2), (List)new .colon.colon((Object)scope2.counterGauge("executions", scope2.counterGauge$default$2(), this::$init$$$anonfun$3), (List)new .colon.colon((Object)scope3.counterGauge("preemptions", scope3.counterGauge$default$2(), this::$init$$$anonfun$4), (List)new .colon.colon((Object)scope4.counterGauge("completions", scope4.counterGauge$default$2(), this::$init$$$anonfun$5), (List)new .colon.colon((Object)scope5.counterGauge("mounts", scope5.counterGauge$default$2(), this::$init$$$anonfun$6), (List)new .colon.colon((Object)scope6.counterGauge("stolen_tasks", scope6.counterGauge$default$2(), this::$init$$$anonfun$7), (List)new .colon.colon((Object)scope7.counterGauge("lost_tasks", scope7.counterGauge$default$2(), this::$init$$$anonfun$8), (List)Nil$.MODULE$)))))));
    }

    public abstract boolean shouldStop();

    public long a1() {
        return this.a1;
    }

    public long a2() {
        return this.a2;
    }

    public long a3() {
        return this.a3;
    }

    public long a4() {
        return this.a4;
    }

    public long a5() {
        return this.a5;
    }

    public long a6() {
        return this.a6;
    }

    public long a7() {
        return this.a7;
    }

    public long b1() {
        return this.b1;
    }

    public long b2() {
        return this.b2;
    }

    public long b3() {
        return this.b3;
    }

    public long b4() {
        return this.b4;
    }

    public long b5() {
        return this.b5;
    }

    public long b6() {
        return this.b6;
    }

    public long b7() {
        return this.b7;
    }

    public long c1() {
        return this.c1;
    }

    public long c2() {
        return this.c2;
    }

    public long c3() {
        return this.c3;
    }

    public long c4() {
        return this.c4;
    }

    public long c5() {
        return this.c5;
    }

    public long c6() {
        return this.c6;
    }

    public long c7() {
        return this.c7;
    }

    private Queue<Task> queue() {
        return this.queue;
    }

    public void enqueue(Task task) {
        this.queue().add(task);
        this.wakeup();
    }

    public void wakeup() {
        if (this.state.get() == Worker$State$Idle$.MODULE$ && this.state.compareAndSet(Worker$State$Idle$.MODULE$, Worker$State$Running$.MODULE$)) {
            this.exec.execute(this);
            return;
        }
    }

    public int load() {
        int load = this.queue().size();
        if (this.currentTask != null) {
            ++load;
        }
        return load;
    }

    public Task stealingBy(Worker thief) {
        Task task = this.queue().stealingBy(thief.queue());
        if (task != null) {
            this.lostTasks.add(Int$.MODULE$.int2long(thief.queue().size() + 1));
        }
        return task;
    }

    public void drain() {
        this.queue().drain(this.schedule);
    }

    public boolean checkAvailability(long nowMs) {
        boolean available;
        State st = this.state.get();
        boolean bl = available = !this.checkStalling(nowMs) && st != Worker$State$Stalled$.MODULE$ && !this.isBlocked();
        if (!available && st == Worker$State$Running$.MODULE$ && this.state.compareAndSet(Worker$State$Running$.MODULE$, Worker$State$Stalled$.MODULE$)) {
            this.drain();
        }
        return available;
    }

    private boolean checkStalling(long nowMs) {
        boolean stalled;
        Task task = this.currentTask;
        long start = this.taskStartMs;
        boolean bl = stalled = task != null && start > 0L && start < nowMs - (long)this.timeSliceMs;
        if (stalled && !this.queue().isEmpty()) {
            task.doPreempt();
        }
        return stalled;
    }

    private boolean isBlocked() {
        int state;
        Thread mount = this.mount;
        return mount != null && ((state = mount.getState().ordinal()) == Thread.State.BLOCKED.ordinal() || state == Thread.State.WAITING.ordinal() || state == Thread.State.TIMED_WAITING.ordinal());
    }

    @Override
    public void run() {
        ++this.mounts;
        this.mount = Thread.currentThread();
        Worker$internal$.MODULE$.setCurrent(this);
        Task task = null;
        while (true) {
            this.state.set(Worker$State$Running$.MODULE$);
            if (task == null) {
                task = this.queue().poll();
            }
            if (task == null && (task = (Task)this.stealTask.apply((Object)this)) != null) {
                this.stolenTasks += (long)(this.queue().size() + 1);
            }
            if (task != null) {
                ++this.executions;
                if (this.runTask(task) == Task$.MODULE$.Preempted()) {
                    ++this.preemptions;
                    task = this.queue().addAndPoll(task);
                } else {
                    ++this.completions;
                    task = null;
                }
            } else {
                this.state.set(Worker$State$Idle$.MODULE$);
                if (this.queue().isEmpty() || !this.state.compareAndSet(Worker$State$Idle$.MODULE$, Worker$State$Running$.MODULE$)) {
                    this.mount = null;
                    Worker$internal$.MODULE$.clearCurrent();
                    return;
                }
            }
            if (!this.shouldStop()) continue;
            this.state.set(Worker$State$Idle$.MODULE$);
            if (task != null) {
                this.schedule.apply((Object)task);
            }
            this.drain();
            return;
        }
    }

    private boolean runTask(Task task) {
        boolean bl;
        block6: {
            long start;
            this.currentTask = task;
            this.taskStartMs = start = this.clock.currentMillis();
            try {
                try {
                    bl = task.run(start, this.clock);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = throwable;
                    if (NonFatal$.MODULE$.apply(ex)) {
                        Thread thread = Thread.currentThread();
                        thread.getUncaughtExceptionHandler().uncaughtException(thread, ex);
                        bl = Task$.MODULE$.Done();
                        break block6;
                    }
                    throw throwable;
                }
            }
            finally {
                this.currentTask = null;
                this.taskStartMs = 0L;
                task.addRuntime((int)(this.clock.currentMillis() - start));
            }
        }
        return bl;
    }

    public WorkerStatus status() {
        Tuple2 tuple2;
        Thread thread = this.mount;
        if (thread == null) {
            tuple2 = Tuple2$.MODULE$.apply((Object)"", (Object)"");
        } else if (thread != null) {
            Thread mount = thread;
            Object object = Predef$.MODULE$.refArrayOps((Object[])mount.getStackTrace());
            tuple2 = Tuple2$.MODULE$.apply((Object)mount.getName(), (Object)((StackTraceElement)ArrayOps$.MODULE$.head$extension(object)).toString());
        } else {
            throw new MatchError((Object)thread);
        }
        Tuple2 tuple22 = tuple2;
        String thread2 = (String)tuple22._1();
        String frame = (String)tuple22._2();
        return WorkerStatus$.MODULE$.apply(this.id, this.state.get() == Worker$State$Running$.MODULE$, thread2, frame, this.isBlocked(), this.checkStalling(this.clock.currentMillis()), this.executions, this.preemptions, this.completions, this.stolenTasks, this.lostTasks.sum(), this.load(), this.mounts);
    }

    private final double $init$$$anonfun$2() {
        return Int$.MODULE$.int2double(this.queue().size());
    }

    private final long $init$$$anonfun$3() {
        return this.executions;
    }

    private final long $init$$$anonfun$4() {
        return this.preemptions;
    }

    private final long $init$$$anonfun$5() {
        return this.completions;
    }

    private final long $init$$$anonfun$6() {
        return this.mounts;
    }

    private final long $init$$$anonfun$7() {
        return this.stolenTasks;
    }

    private final long $init$$$anonfun$8() {
        return this.lostTasks.sum();
    }

    public static interface State {
        public static int ordinal(State state) {
            return Worker$State$.MODULE$.ordinal(state);
        }
    }

    public static final class WorkerThread
    extends Thread {
        private Worker currentWorker = null;

        public WorkerThread(Runnable init) {
            super(init);
        }

        public Worker currentWorker() {
            return this.currentWorker;
        }

        public void currentWorker_$eq(Worker x$1) {
            this.currentWorker = x$1;
        }
    }
}

