/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler.regulator;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import kyo.scheduler.InternalClock;
import kyo.scheduler.InternalTimer;
import kyo.scheduler.Task;
import kyo.scheduler.Task$;
import kyo.scheduler.regulator.Admission$;
import kyo.scheduler.regulator.Config;
import kyo.scheduler.regulator.Regulator;
import kyo.scheduler.top.AdmissionStatus;
import kyo.scheduler.top.AdmissionStatus$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.util.hashing.MurmurHash3$;

public final class Admission
extends Regulator {
    private final Function1<Task, BoxedUnit> schedule;
    public final LongSupplier kyo$scheduler$regulator$Admission$$nowMillis;
    private final Duration rotationWindow;
    private final int largePrime;
    private volatile int admissionPercent;
    private final LongAdder rejected;
    private final LongAdder allowed;

    public static Config defaultConfig() {
        return Admission$.MODULE$.defaultConfig();
    }

    public static Config $lessinit$greater$default$5() {
        return Admission$.MODULE$.$lessinit$greater$default$5();
    }

    public static Duration $lessinit$greater$default$6() {
        return Admission$.MODULE$.$lessinit$greater$default$6();
    }

    public Admission(DoubleSupplier loadAvg, Function1<Task, BoxedUnit> schedule, LongSupplier nowMillis, InternalTimer timer, Config config, Duration rotationWindow) {
        this.schedule = schedule;
        this.kyo$scheduler$regulator$Admission$$nowMillis = nowMillis;
        this.rotationWindow = rotationWindow;
        super(loadAvg, timer, config);
        this.largePrime = (int)(Math.pow(2.0, 31.0) - 1.0);
        this.admissionPercent = 100;
        this.rejected = new LongAdder();
        this.allowed = new LongAdder();
        List gauges = (List)new .colon.colon((Object)this.statsScope().gauge("percent", this.statsScope().gauge$default$2(), this::$init$$$anonfun$1), (List)new .colon.colon((Object)this.statsScope().counterGauge("allowed", this.statsScope().counterGauge$default$2(), this::$init$$$anonfun$2), (List)new .colon.colon((Object)this.statsScope().counterGauge("rejected", this.statsScope().counterGauge$default$2(), this::$init$$$anonfun$3), (List)Nil$.MODULE$)));
    }

    public int percent() {
        return this.admissionPercent;
    }

    public boolean reject() {
        return this.reject(ThreadLocalRandom.current().nextInt());
    }

    public boolean reject(String key) {
        return this.reject(MurmurHash3$.MODULE$.stringHash(key));
    }

    public boolean reject(int key) {
        boolean r;
        int windowId = (int)(this.kyo$scheduler$regulator$Admission$$nowMillis.getAsLong() / this.rotationWindow.toMillis()) + 1;
        boolean bl = r = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(key * this.largePrime * windowId)) % 100 > this.admissionPercent;
        if (r) {
            this.rejected.increment();
        } else {
            this.allowed.increment();
        }
        return r;
    }

    @Override
    public void probe() {
        this.schedule.apply((Object)new ProbeTask());
    }

    @Override
    public void update(int diff) {
        this.admissionPercent = Math.max(0, Math.min(100, this.admissionPercent + diff));
    }

    public AdmissionStatus status() {
        return AdmissionStatus$.MODULE$.apply(this.admissionPercent, this.allowed.sum(), this.rejected.sum(), this.regulatorStatus());
    }

    private final double $init$$$anonfun$1() {
        return Int$.MODULE$.int2double(this.admissionPercent);
    }

    private final long $init$$$anonfun$2() {
        return this.allowed.sum();
    }

    private final long $init$$$anonfun$3() {
        return this.rejected.sum();
    }

    public final class ProbeTask
    implements Task {
        private volatile int kyo$scheduler$Task$$state;
        private final long start;

        public ProbeTask() {
            if (Admission.this == null) {
                throw new NullPointerException();
            }
            Task.$init$(this);
            this.start = Admission.this.kyo$scheduler$regulator$Admission$$nowMillis.getAsLong();
        }

        @Override
        public int kyo$scheduler$Task$$state() {
            return this.kyo$scheduler$Task$$state;
        }

        @Override
        public void kyo$scheduler$Task$$state_$eq(int x$1) {
            this.kyo$scheduler$Task$$state = x$1;
        }

        public long start() {
            return this.start;
        }

        @Override
        public boolean run(long startMillis, InternalClock clock) {
            Admission.this.measure(Admission.this.kyo$scheduler$regulator$Admission$$nowMillis.getAsLong() - this.start());
            return Task$.MODULE$.Done();
        }

        public final /* synthetic */ Admission kyo$scheduler$regulator$Admission$ProbeTask$$$outer() {
            return Admission.this;
        }
    }
}

