/*
 * Decompiled with CFR 0.152.
 */
package kyo.scheduler.util;

public final class MovingStdDev {
    private final int window;
    private final long[] values;
    private long idx;

    public MovingStdDev(int window) {
        this.window = window;
        this.values = new long[window];
        this.idx = 0L;
    }

    public double dev() {
        long n = Math.min(this.idx, (long)this.window);
        if (n <= 1L) {
            return 0.0;
        }
        long sum = 0L;
        long sumSq = 0L;
        int i = 0;
        while ((long)i < n) {
            long value = this.values[i % this.window];
            sum += value;
            sumSq += value * value;
            ++i;
        }
        double mean = (double)sum / (double)n;
        double variance = (double)sumSq / (double)n - mean * mean;
        if (n > 1L) {
            return Math.sqrt(variance * (double)n / (double)(n - 1L));
        }
        return 0.0;
    }

    public double avg() {
        long n = Math.min(this.idx, (long)this.window);
        double sum = 0.0;
        int i = 0;
        while ((long)i < n) {
            sum += (double)this.values[i % this.window];
            ++i;
        }
        return sum / (double)n;
    }

    public void observe(long v) {
        this.values[(int)(this.idx % (long)this.window)] = v;
        ++this.idx;
    }
}

