/*
 * Decompiled with CFR 0.152.
 */
package kyo.stats.internal;

import java.util.concurrent.atomic.LongAdder;

public class UnsafeCounter {
    private long last = 0L;
    private final LongAdder adder = new LongAdder();

    public long get() {
        return this.adder.sumThenReset();
    }

    public void inc() {
        this.adder.increment();
    }

    public void add(long v) {
        this.adder.add(v);
    }

    private long addExact(long a, long b) {
        long sum = a + b;
        if (sum < 0L) {
            return Long.MAX_VALUE + sum + 2L;
        }
        return sum;
    }

    private long findDelta(long a, long b) {
        return Long.MAX_VALUE - a + b;
    }

    public long delta() {
        long curr = this.addExact(this.get(), this.last);
        long delta = curr >= this.last ? curr - this.last : this.findDelta(this.last, curr);
        this.last = curr;
        return delta;
    }

    public long getLast() {
        return this.last;
    }
}

