/*
 * Decompiled with CFR 0.152.
 */
package kyo.stats.internal;

import kyo.stats.internal.Summary;
import kyo.stats.internal.Summary$;
import org.HdrHistogram.ConcurrentDoubleHistogram;

public class UnsafeHistogram {
    private final ConcurrentDoubleHistogram hdr;

    public UnsafeHistogram(int numberOfSignificantValueDigits, long highestToLowestValueRatio) {
        this.hdr = new ConcurrentDoubleHistogram(highestToLowestValueRatio, numberOfSignificantValueDigits);
        this.hdr.setAutoResize(true);
    }

    public void observe(long v) {
        this.hdr.recordValue((double)v);
    }

    public void observe(double v) {
        this.hdr.recordValue(v);
    }

    public long count() {
        return this.hdr.getTotalCount();
    }

    public double valueAtPercentile(double v) {
        return this.hdr.getValueAtPercentile(v);
    }

    public double maxValue() {
        return this.hdr.getMaxValue();
    }

    public double minValue() {
        return this.hdr.getMinValue();
    }

    public double meanValue() {
        return this.hdr.getMean();
    }

    public Summary summary() {
        return Summary$.MODULE$.apply(this.valueAtPercentile(0.5), this.valueAtPercentile(0.9), this.valueAtPercentile(0.99), this.valueAtPercentile(0.999), this.valueAtPercentile(0.9999), this.minValue(), this.maxValue(), this.meanValue(), this.count());
    }
}

