package io.getquill.idiom

import io.getquill.ast._
import io.getquill.context.{ExecutionType, IdiomReturningCapability}
import io.getquill.quat.Quat
import io.getquill.{IdiomContext, NamingStrategy}

trait Idiom extends IdiomReturningCapability {
  private val _emptySetContainsToken: StringToken     = StringToken("FALSE")
  private val _defaultAutoGeneratedToken: StringToken = StringToken("DEFAULT VALUES")

  def emptySetContainsToken(field: Token): Token = _emptySetContainsToken

  def defaultAutoGeneratedToken(field: Token): Token = _defaultAutoGeneratedToken

  def liftingPlaceholder(index: Int): String

  def translate(ast: Ast, topLevelQuat: Quat, executionType: ExecutionType, transpileConfig: IdiomContext)(implicit
    naming: NamingStrategy
  ): (Ast, Statement, ExecutionType)

  def translateCached(ast: Ast, topLevelQuat: Quat, executionType: ExecutionType, transpileConfig: IdiomContext)(
    implicit naming: NamingStrategy
  ): (Ast, Statement, ExecutionType)

  def format(queryString: String): String = queryString

  def prepareForProbing(string: String): String
}
