/*
 * Decompiled with CFR 0.152.
 */
package io.getquill.context.cassandra;

import io.getquill.ast.Aggregation;
import io.getquill.ast.Aggregation$;
import io.getquill.ast.AggregationOperator;
import io.getquill.ast.AggregationOperator$size$;
import io.getquill.ast.Ast;
import io.getquill.ast.CaseClass;
import io.getquill.ast.CaseClass$;
import io.getquill.ast.Constant$;
import io.getquill.ast.Distinct;
import io.getquill.ast.Distinct$;
import io.getquill.ast.Entity;
import io.getquill.ast.Filter;
import io.getquill.ast.Filter$;
import io.getquill.ast.FlatMap;
import io.getquill.ast.GroupBy;
import io.getquill.ast.Ident;
import io.getquill.ast.Join;
import io.getquill.ast.Join$;
import io.getquill.ast.JoinType;
import io.getquill.ast.Lift;
import io.getquill.ast.Map;
import io.getquill.ast.Map$;
import io.getquill.ast.Ordering;
import io.getquill.ast.Property;
import io.getquill.ast.PropertyOrdering;
import io.getquill.ast.Query;
import io.getquill.ast.ScalarTag;
import io.getquill.ast.SortBy;
import io.getquill.ast.SortBy$;
import io.getquill.ast.Take;
import io.getquill.ast.Take$;
import io.getquill.ast.Tuple;
import io.getquill.ast.Tuple$;
import io.getquill.ast.TupleOrdering;
import io.getquill.ast.TupleOrdering$;
import io.getquill.ast.Union;
import io.getquill.ast.UnionAll;
import io.getquill.context.cassandra.CqlQuery;
import io.getquill.context.cassandra.OrderByCriteria;
import io.getquill.context.cassandra.OrderByCriteria$;
import io.getquill.util.Messages$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class CqlQuery$
implements Mirror.Product,
Serializable {
    public static final CqlQuery$ MODULE$ = new CqlQuery$();

    private CqlQuery$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CqlQuery$.class);
    }

    public CqlQuery apply(Entity entity, Option<Ast> filter, List<OrderByCriteria> orderBy, Option<Ast> limit, List<Ast> select, boolean distinct) {
        return new CqlQuery(entity, filter, orderBy, limit, select, distinct);
    }

    public CqlQuery unapply(CqlQuery x$1) {
        return x$1;
    }

    public CqlQuery apply(Query q) {
        Distinct distinct;
        Ast ast;
        Query query = q;
        if (query instanceof Distinct && (ast = (distinct = Distinct$.MODULE$.unapply((Distinct)query))._1()) instanceof Query) {
            Query q2 = (Query)ast;
            return this.apply(q2, true);
        }
        Query other = query;
        return this.apply(q, false);
    }

    private CqlQuery apply(Query q, boolean distinct) {
        Query query = q;
        if (query instanceof Map) {
            Map map = Map$.MODULE$.unapply((Map)query);
            Ast ast = map._1();
            Ident ident = map._2();
            Ast ast2 = map._3();
            if (ast instanceof Query) {
                Query q2 = (Query)ast;
                Ident x = ident;
                Ast p = ast2;
                return this.apply(q2, this.select(p), distinct);
            }
        }
        if (query instanceof Aggregation) {
            Aggregation aggregation = Aggregation$.MODULE$.unapply((Aggregation)query);
            AggregationOperator aggregationOperator = aggregation._1();
            Ast ast = aggregation._2();
            if (AggregationOperator$size$.MODULE$.equals(aggregationOperator) && ast instanceof Query) {
                Query q3 = (Query)ast;
                return this.apply(q3, (List<Ast>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Aggregation[]{Aggregation$.MODULE$.apply(AggregationOperator$size$.MODULE$, Constant$.MODULE$.auto(BoxesRunTime.boxToInteger((int)1)))}))), distinct);
            }
        }
        Query other = query;
        return this.apply(q, (List<Ast>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))), distinct);
    }

    private CqlQuery apply(Query q, List<Ast> select, boolean distinct) {
        Query query = q;
        if (query instanceof Take) {
            Take take = Take$.MODULE$.unapply((Take)query);
            Ast ast = take._1();
            Ast ast2 = take._2();
            if (ast instanceof Query) {
                Query q2 = (Query)ast;
                Ast limit = ast2;
                return this.apply(q2, (Option<Ast>)Some$.MODULE$.apply((Object)limit), select, distinct);
            }
        }
        Query other = query;
        return this.apply(q, (Option<Ast>)None$.MODULE$, select, distinct);
    }

    private CqlQuery apply(Query q, Option<Ast> limit, List<Ast> select, boolean distinct) {
        Query query = q;
        if (query instanceof SortBy) {
            SortBy sortBy = SortBy$.MODULE$.unapply((SortBy)query);
            Ast ast = sortBy._1();
            Ident ident = sortBy._2();
            Ast ast2 = sortBy._3();
            Ast ast3 = sortBy._4();
            if (ast instanceof Query) {
                Query q2 = (Query)ast;
                Ident x = ident;
                Ast p = ast2;
                Ast o = ast3;
                return this.apply(q2, this.orderByCriteria(p, o), limit, select, distinct);
            }
        }
        Query other = query;
        return this.apply(q, (List<OrderByCriteria>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))), limit, select, distinct);
    }

    private CqlQuery apply(Query q, List<OrderByCriteria> orderBy, Option<Ast> limit, List<Ast> select, boolean distinct) {
        Query query = q;
        if (query instanceof Filter) {
            Filter filter = Filter$.MODULE$.unapply((Filter)query);
            Ast ast = filter._1();
            Ident ident = filter._2();
            Ast ast2 = filter._3();
            if (ast instanceof Query) {
                Query q2 = (Query)ast;
                Ident x = ident;
                Ast p = ast2;
                return this.apply(q2, (Option<Ast>)Some$.MODULE$.apply((Object)p), orderBy, limit, select, distinct);
            }
        }
        Query other = query;
        return this.apply(q, (Option<Ast>)None$.MODULE$, orderBy, limit, select, distinct);
    }

    private CqlQuery apply(Query q, Option<Ast> filter, List<OrderByCriteria> orderBy, Option<Ast> limit, List<Ast> select, boolean distinct) {
        Query query = q;
        if (query instanceof Entity) {
            Entity q2 = (Entity)query;
            return new CqlQuery(q2, filter, orderBy, limit, select, distinct);
        }
        if (query instanceof FlatMap) {
            throw Messages$.MODULE$.fail("Cql doesn't support flatMap.");
        }
        if (query instanceof Union || query instanceof UnionAll) {
            throw Messages$.MODULE$.fail("Cql doesn't support union/unionAll.");
        }
        if (query instanceof Join) {
            Join join = Join$.MODULE$.unapply((Join)query);
            JoinType joinType = join._1();
            Ast ast = join._2();
            Ast ast2 = join._3();
            Ident ident = join._4();
            Ident ident2 = join._5();
            Ast ast3 = join._6();
            JoinType joinType2 = joinType;
            throw Messages$.MODULE$.fail(new StringBuilder(21).append("Cql doesn't support ").append(joinType2).append(".").toString());
        }
        if (query instanceof GroupBy) {
            throw Messages$.MODULE$.fail("Cql doesn't support groupBy.");
        }
        Query q3 = query;
        throw Messages$.MODULE$.fail(new StringBuilder(19).append("Invalid cql query: ").append(q3).toString());
    }

    private List<Ast> select(Ast ast2) {
        Ast ast3 = ast2;
        if (ast3 instanceof Tuple) {
            List<Ast> list;
            Tuple tuple = Tuple$.MODULE$.unapply((Tuple)ast3);
            List<Ast> values = list = tuple._1();
            return values.flatMap((Function1 & Serializable)ast -> this.select((Ast)ast));
        }
        if (ast3 instanceof CaseClass) {
            List<Tuple2<String, Ast>> list;
            CaseClass caseClass = CaseClass$.MODULE$.unapply((CaseClass)ast3);
            String string = caseClass._1();
            List<Tuple2<String, Ast>> values = list = caseClass._2();
            return values.flatMap((Function1 & Serializable)v -> this.select((Ast)v._2()));
        }
        if (ast3 instanceof Property) {
            Property p = (Property)ast3;
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{p}));
        }
        if (ast3 instanceof Ident) {
            Ident i = (Ident)ast3;
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        if (ast3 instanceof Lift) {
            Lift l = (Lift)ast3;
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Lift[]{l}));
        }
        if (ast3 instanceof ScalarTag) {
            ScalarTag l = (ScalarTag)ast3;
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ScalarTag[]{l}));
        }
        Ast other = ast3;
        throw Messages$.MODULE$.fail(new StringBuilder(56).append("Cql supports only properties as select elements. Found: ").append(other).toString());
    }

    private List<OrderByCriteria> orderByCriteria(Ast ast, Ast ordering) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)ast, (Object)ordering);
        if (tuple2 != null) {
            Ast ast2 = (Ast)tuple2._1();
            Ast ast3 = (Ast)tuple2._2();
            if (ast2 instanceof Tuple) {
                List<Ast> list;
                Tuple tuple = Tuple$.MODULE$.unapply((Tuple)ast2);
                List<Ast> properties = list = tuple._1();
                if (ast3 instanceof PropertyOrdering) {
                    PropertyOrdering ord = (PropertyOrdering)ast3;
                    return properties.flatMap((Function1 & Serializable)_$1 -> this.orderByCriteria((Ast)_$1, ord));
                }
                List<Ast> properties2 = list;
                if (ast3 instanceof TupleOrdering) {
                    List<Ordering> list2;
                    TupleOrdering tupleOrdering = TupleOrdering$.MODULE$.unapply((TupleOrdering)ast3);
                    List<Ordering> ord = list2 = tupleOrdering._1();
                    return ((List)properties2.zip(ord)).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Ast a = (Ast)tuple2._1();
                            Ordering o = (Ordering)tuple2._2();
                            return this.orderByCriteria(a, o);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
            }
            if (ast2 instanceof Property) {
                Property a = (Property)ast2;
                if (ast3 instanceof PropertyOrdering) {
                    PropertyOrdering o = (PropertyOrdering)ast3;
                    return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OrderByCriteria[]{OrderByCriteria$.MODULE$.apply(a, o)}));
                }
            }
        }
        Tuple2 other = tuple2;
        throw Messages$.MODULE$.fail(new StringBuilder(26).append("Invalid order by criteria ").append(ast).toString());
    }

    public CqlQuery fromProduct(Product x$0) {
        return new CqlQuery((Entity)x$0.productElement(0), (Option<Ast>)((Option)x$0.productElement(1)), (List<OrderByCriteria>)((List)x$0.productElement(2)), (Option<Ast>)((Option)x$0.productElement(3)), (List<Ast>)((List)x$0.productElement(4)), BoxesRunTime.unboxToBoolean((Object)x$0.productElement(5)));
    }
}

