/*
 * Decompiled with CFR 0.152.
 */
package io.getquill.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import io.getquill.util.ContextLogger$;
import io.getquill.util.Messages$;
import java.io.Serializable;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.ScalaRunTime$;

public class ContextLogger {
    private final Logger underlying;
    private final String nullToken;

    public static ContextLogger apply(Class<?> clazz) {
        return ContextLogger$.MODULE$.apply(clazz);
    }

    public ContextLogger(String name) {
        this.underlying = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)name));
        this.nullToken = "null";
    }

    public Logger underlying() {
        return this.underlying;
    }

    private boolean bindsEnabled() {
        return Messages$.MODULE$.logBinds() || this.underlying().underlying().isTraceEnabled();
    }

    private int maxQueryLen() {
        return Messages$.MODULE$.queryTooLongForLogs();
    }

    private final TrimQueryOps TrimQueryOps(String str) {
        return new TrimQueryOps(this, str);
    }

    public String io$getquill$util$ContextLogger$$trimQuery(String query) {
        if (this.maxQueryLen() > 0) {
            return new StringBuilder(0).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(query), this.maxQueryLen())).append(query.length() > this.maxQueryLen() ? "..." : "").toString();
        }
        return query;
    }

    public void logQuery(String msg, String query) {
        Logger LoggerImpl_this = this.underlying();
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug(new StringBuilder(3).append(msg).append(":{}").toString(), (Object)this.TrimQueryOps(query).trimTooLong());
            return;
        }
    }

    public void logQuery(String query, Seq<Object> params) {
        if (!this.bindsEnabled() || params.isEmpty()) {
            Logger LoggerImpl_this = this.underlying();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug(this.TrimQueryOps(query).trimTooLong());
                return;
            }
            return;
        }
        Logger LoggerImpl_this = this.underlying();
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("{} - binds: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.TrimQueryOps(query).trimTooLong(), this.prepareParams(params)}), Object.class));
            return;
        }
    }

    public void logBatchItem(String query, Seq<Object> params) {
        if (this.bindsEnabled()) {
            Logger LoggerImpl_this = this.underlying();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("{} - batch item: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.TrimQueryOps(query).trimTooLong(), this.prepareParams(params)}), Object.class));
                return;
            }
            return;
        }
    }

    private String prepareParams(Seq<Object> params) {
        return ((IterableOnceOps)((IterableOps)params.reverse()).map((Function1 & Serializable)param -> this.prepareParam(param))).mkString("[", ", ", "]");
    }

    private String prepareParam(Object param) {
        Object object;
        while (true) {
            Object x;
            if (None$.MODULE$.equals(object = param) || object == null) {
                return this.nullToken;
            }
            if (!(object instanceof Some)) break;
            param = x = ((Some)object).value();
        }
        if (object instanceof String) {
            String str = (String)object;
            return new StringBuilder(2).append("'").append(str).append("'").toString();
        }
        return param.toString();
    }

    public class TrimQueryOps {
        private final String str;
        private final /* synthetic */ ContextLogger $outer;

        public TrimQueryOps(ContextLogger $outer, String str) {
            this.str = str;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String trimTooLong() {
            return this.$outer.io$getquill$util$ContextLogger$$trimQuery(this.str);
        }

        public final /* synthetic */ ContextLogger io$getquill$util$ContextLogger$TrimQueryOps$$$outer() {
            return this.$outer;
        }
    }
}

