/*
 * Decompiled with CFR 0.152.
 */
package io.getquill.context.qzio;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.NoSuchElementException;
import scala.Function2;
import scala.collection.BufferedIterator;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;

public class ResultSetIterator<T>
implements BufferedIterator<T> {
    private final ResultSet rs;
    private final Connection conn;
    private final Function2<ResultSet, Connection, T> extractor;
    private int state;
    private T cached;

    public ResultSetIterator(ResultSet rs, Connection conn, Function2<ResultSet, Connection, T> extractor) {
        this.rs = rs;
        this.conn = conn;
        this.extractor = extractor;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        Iterator.$init$((Iterator)this);
        BufferedIterator.$init$((BufferedIterator)this);
        this.state = 0;
        this.cached = null;
    }

    public final T finished() {
        this.state = 2;
        return null;
    }

    public T fetchNext() {
        if (this.rs.next()) {
            return (T)this.extractor.apply((Object)this.rs, (Object)this.conn);
        }
        return this.finished();
    }

    public T head() {
        this.prefetchIfNeeded();
        if (this.state == 1) {
            return this.cached;
        }
        throw new NoSuchElementException("head on empty iterator");
    }

    private void prefetchIfNeeded() {
        if (this.state == 0) {
            this.cached = this.fetchNext();
            if (this.state == 0) {
                this.state = 1;
                return;
            }
            return;
        }
    }

    public boolean hasNext() {
        this.prefetchIfNeeded();
        return this.state == 1;
    }

    public T next() {
        this.prefetchIfNeeded();
        if (this.state == 1) {
            this.state = 0;
            return this.cached;
        }
        throw new NoSuchElementException("next on empty iterator");
    }
}

