/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.photoview.dialog;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Px;
import androidx.core.content.ContextCompat;
import io.getstream.photoview.dialog.listeners.OnDismissListener;
import io.getstream.photoview.dialog.listeners.OnImageChangeListener;
import io.getstream.photoview.dialog.loader.ImageLoader;
import io.getstream.photoview.dialog.viewer.builder.BuilderData;
import io.getstream.photoview.dialog.viewer.dialog.ImageViewerDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001cB\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rJ\u0012\u0010\u0011\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u0019\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0010\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/getstream/photoview/dialog/PhotoViewDialog;", "T", "", "context", "Landroid/content/Context;", "builderData", "Lio/getstream/photoview/dialog/viewer/builder/BuilderData;", "(Landroid/content/Context;Lio/getstream/photoview/dialog/viewer/builder/BuilderData;)V", "dialog", "Lio/getstream/photoview/dialog/viewer/dialog/ImageViewerDialog;", "close", "", "currentPosition", "", "dismiss", "setCurrentPosition", "position", "show", "animate", "", "updateImages", "images", "", "([Ljava/lang/Object;)V", "", "updateTransitionImage", "imageView", "Landroid/widget/ImageView;", "Builder", "photoview-dialog_release"})
public final class PhotoViewDialog<T> {
    @NotNull
    private final BuilderData<T> builderData;
    @NotNull
    private final ImageViewerDialog<T> dialog;

    public PhotoViewDialog(@NotNull Context context, @NotNull BuilderData<T> builderData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(builderData, (String)"builderData");
        this.builderData = builderData;
        this.dialog = new ImageViewerDialog<T>(context, this.builderData);
    }

    @JvmOverloads
    public final void show(boolean animate) {
        if (!((Collection)this.builderData.getImages()).isEmpty()) {
            this.dialog.show(animate);
        } else {
            Log.w((String)"PhotoView", (String)"Images list cannot be empty! Viewer ignored.");
        }
    }

    public static /* synthetic */ void show$default(PhotoViewDialog photoViewDialog, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        photoViewDialog.show(bl);
    }

    public final void close() {
        this.dialog.close();
    }

    public final void dismiss() {
        this.dialog.dismiss();
    }

    public final void updateImages(@NotNull T[] images) {
        Intrinsics.checkNotNullParameter(images, (String)"images");
        this.updateImages(new ArrayList(CollectionsKt.listOf((Object[])Arrays.copyOf(images, images.length))));
    }

    public final void updateImages(@NotNull List<? extends T> images) {
        Intrinsics.checkNotNullParameter(images, (String)"images");
        if (!((Collection)images).isEmpty()) {
            this.dialog.updateImages(images);
        } else {
            this.dialog.close();
        }
    }

    public final int currentPosition() {
        return this.dialog.getCurrentPosition();
    }

    public final int setCurrentPosition(int position) {
        return this.dialog.setCurrentPosition(position);
    }

    public final void updateTransitionImage(@Nullable ImageView imageView) {
        this.dialog.updateTransitionImage(imageView);
    }

    @JvmOverloads
    public final void show() {
        PhotoViewDialog.show$default(this, false, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B+\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tB)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0010H\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010\u001b\u001a\u00020\u0018J4\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010\u001c\u001a\u00020\u00182\b\b\u0001\u0010\u001d\u001a\u00020\u00182\b\b\u0001\u0010\u001e\u001a\u00020\u00182\b\b\u0001\u0010\u001f\u001a\u00020\u0018J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010\u001b\u001a\u00020\u0018J,\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0018J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010\"\u001a\u0004\u0018\u00010#J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010&\u001a\u0004\u0018\u00010'J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010)\u001a\u00020\u0018J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0001\u0010+\u001a\u00020\u0018J\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010-\u001a\u00020.J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u00100\u001a\u00020\u0018J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\u00102\u001a\u0004\u0018\u000103R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lio/getstream/photoview/dialog/PhotoViewDialog$Builder;", "T", "", "context", "Landroid/content/Context;", "images", "", "imageLoader", "Lio/getstream/photoview/dialog/loader/ImageLoader;", "(Landroid/content/Context;[Ljava/lang/Object;Lio/getstream/photoview/dialog/loader/ImageLoader;)V", "", "(Landroid/content/Context;Ljava/util/List;Lio/getstream/photoview/dialog/loader/ImageLoader;)V", "data", "Lio/getstream/photoview/dialog/viewer/builder/BuilderData;", "allowSwipeToDismiss", "value", "", "allowZooming", "build", "Lio/getstream/photoview/dialog/PhotoViewDialog;", "show", "animate", "withBackgroundColor", "color", "", "withBackgroundColorResource", "withContainerPadding", "padding", "start", "top", "end", "bottom", "withContainerPaddingPixels", "withDismissListener", "onDismissListener", "Lio/getstream/photoview/dialog/listeners/OnDismissListener;", "withHiddenStatusBar", "withImageChangeListener", "imageChangeListener", "Lio/getstream/photoview/dialog/listeners/OnImageChangeListener;", "withImageMarginPixels", "marginPixels", "withImagesMargin", "dimen", "withOverlayView", "view", "Landroid/view/View;", "withStartPosition", "position", "withTransitionFrom", "imageView", "Landroid/widget/ImageView;", "photoview-dialog_release"})
    public static final class Builder<T> {
        @NotNull
        private final Context context;
        @NotNull
        private final BuilderData<T> data;

        public Builder(@NotNull Context context, @NotNull List<? extends T> images, @NotNull ImageLoader<T> imageLoader) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(images, (String)"images");
            Intrinsics.checkNotNullParameter(imageLoader, (String)"imageLoader");
            this.context = context;
            this.data = new BuilderData<T>(images, imageLoader);
        }

        public Builder(@NotNull Context context, @NotNull T[] images, @NotNull ImageLoader<T> imageLoader) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(images, (String)"images");
            Intrinsics.checkNotNullParameter(imageLoader, (String)"imageLoader");
            this(context, new ArrayList(CollectionsKt.listOf((Object[])Arrays.copyOf(images, images.length))), imageLoader);
        }

        @NotNull
        public final Builder<T> withStartPosition(int position) {
            this.data.setStartPosition(position);
            return this;
        }

        @NotNull
        public final Builder<T> withBackgroundColor(@ColorInt int color) {
            this.data.setBackgroundColor(color);
            return this;
        }

        @NotNull
        public final Builder<T> withBackgroundColorResource(@ColorRes int color) {
            return this.withBackgroundColor(ContextCompat.getColor((Context)this.context, (int)color));
        }

        @NotNull
        public final Builder<T> withOverlayView(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            this.data.setOverlayView(view);
            return this;
        }

        @NotNull
        public final Builder<T> withImagesMargin(@DimenRes int dimen) {
            this.data.setImageMarginPixels(MathKt.roundToInt((float)this.context.getResources().getDimension(dimen)));
            return this;
        }

        @NotNull
        public final Builder<T> withImageMarginPixels(int marginPixels) {
            this.data.setImageMarginPixels(marginPixels);
            return this;
        }

        @NotNull
        public final Builder<T> withContainerPadding(@DimenRes int padding) {
            int paddingPx = MathKt.roundToInt((float)this.context.getResources().getDimension(padding));
            return this.withContainerPaddingPixels(paddingPx, paddingPx, paddingPx, paddingPx);
        }

        @NotNull
        public final Builder<T> withContainerPadding(@DimenRes int start, @DimenRes int top, @DimenRes int end, @DimenRes int bottom) {
            this.withContainerPaddingPixels(MathKt.roundToInt((float)this.context.getResources().getDimension(start)), MathKt.roundToInt((float)this.context.getResources().getDimension(top)), MathKt.roundToInt((float)this.context.getResources().getDimension(end)), MathKt.roundToInt((float)this.context.getResources().getDimension(bottom)));
            return this;
        }

        @NotNull
        public final Builder<T> withContainerPaddingPixels(@Px int padding) {
            int[] nArray = new int[]{padding, padding, padding, padding};
            this.data.setContainerPaddingPixels(nArray);
            return this;
        }

        @NotNull
        public final Builder<T> withContainerPaddingPixels(int start, int top, int end, int bottom) {
            int[] nArray = new int[]{start, top, end, bottom};
            this.data.setContainerPaddingPixels(nArray);
            return this;
        }

        @NotNull
        public final Builder<T> withHiddenStatusBar(boolean value) {
            this.data.setShouldStatusBarHide(value);
            return this;
        }

        @NotNull
        public final Builder<T> allowZooming(boolean value) {
            this.data.setZoomingAllowed(value);
            return this;
        }

        @NotNull
        public final Builder<T> allowSwipeToDismiss(boolean value) {
            this.data.setSwipeToDismissAllowed(value);
            return this;
        }

        @NotNull
        public final Builder<T> withTransitionFrom(@Nullable ImageView imageView) {
            this.data.setTransitionView(imageView);
            return this;
        }

        @NotNull
        public final Builder<T> withImageChangeListener(@Nullable OnImageChangeListener imageChangeListener) {
            this.data.setImageChangeListener(imageChangeListener);
            return this;
        }

        @NotNull
        public final Builder<T> withDismissListener(@Nullable OnDismissListener onDismissListener) {
            this.data.setOnDismissListener(onDismissListener);
            return this;
        }

        @NotNull
        public final PhotoViewDialog<T> build() {
            return new PhotoViewDialog<T>(this.context, this.data);
        }

        @JvmOverloads
        @NotNull
        public final PhotoViewDialog<T> show(boolean animate) {
            PhotoViewDialog<T> viewer = this.build();
            viewer.show(animate);
            return viewer;
        }

        public static /* synthetic */ PhotoViewDialog show$default(Builder builder, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return builder.show(bl);
        }

        @JvmOverloads
        @NotNull
        public final PhotoViewDialog<T> show() {
            return Builder.show$default(this, false, 1, null);
        }
    }
}

