/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.photoview.dialog.viewer.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.app.AlertDialog;
import io.getstream.photoview.dialog.R;
import io.getstream.photoview.dialog.listeners.OnDismissListener;
import io.getstream.photoview.dialog.listeners.OnImageChangeListener;
import io.getstream.photoview.dialog.viewer.builder.BuilderData;
import io.getstream.photoview.dialog.viewer.view.ImageViewerView;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\rJ\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rJ\b\u0010\u001c\u001a\u00020\u0013H\u0002J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\tJ\u0014\u0010\u001f\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!J\u0010\u0010\"\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/getstream/photoview/dialog/viewer/dialog/ImageViewerDialog;", "T", "", "context", "Landroid/content/Context;", "builderData", "Lio/getstream/photoview/dialog/viewer/builder/BuilderData;", "(Landroid/content/Context;Lio/getstream/photoview/dialog/viewer/builder/BuilderData;)V", "animateOpen", "", "dialog", "Landroidx/appcompat/app/AlertDialog;", "dialogStyle", "", "getDialogStyle", "()I", "viewerView", "Lio/getstream/photoview/dialog/viewer/view/ImageViewerView;", "close", "", "dismiss", "getCurrentPosition", "onDialogKeyEvent", "keyCode", "event", "Landroid/view/KeyEvent;", "setCurrentPosition", "position", "setupViewerView", "show", "animate", "updateImages", "images", "", "updateTransitionImage", "imageView", "Landroid/widget/ImageView;", "photoview-dialog_release"})
public final class ImageViewerDialog<T> {
    @NotNull
    private final BuilderData<T> builderData;
    @NotNull
    private final AlertDialog dialog;
    @NotNull
    private final ImageViewerView<T> viewerView;
    private boolean animateOpen;

    /*
     * WARNING - void declaration
     */
    public ImageViewerDialog(@NotNull Context context, @NotNull BuilderData<T> builderData) {
        void $this$_init__u24lambda_u243;
        AlertDialog alertDialog;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(builderData, (String)"builderData");
        this.builderData = builderData;
        this.viewerView = new ImageViewerView(context, null, 0, 6, null);
        this.animateOpen = true;
        this.setupViewerView();
        AlertDialog alertDialog2 = new AlertDialog.Builder(context, this.getDialogStyle()).setView((View)this.viewerView).setOnKeyListener((arg_0, arg_1, arg_2) -> ImageViewerDialog._init_$lambda$0(this, arg_0, arg_1, arg_2)).create();
        Intrinsics.checkNotNullExpressionValue((Object)alertDialog2, (String)"create(...)");
        AlertDialog alertDialog3 = alertDialog = alertDialog2;
        ImageViewerDialog imageViewerDialog = this;
        boolean bl = false;
        $this$_init__u24lambda_u243.setOnShowListener(arg_0 -> ImageViewerDialog.lambda$3$lambda$1(this, arg_0));
        $this$_init__u24lambda_u243.setOnDismissListener(arg_0 -> ImageViewerDialog.lambda$3$lambda$2(this, arg_0));
        imageViewerDialog.dialog = alertDialog;
    }

    private final int getDialogStyle() {
        return this.builderData.getShouldStatusBarHide() ? R.style.ImageViewerDialog_NoStatusBar : R.style.ImageViewerDialog_Default;
    }

    public final void show(boolean animate) {
        this.animateOpen = animate;
        this.dialog.show();
    }

    public final void close() {
        this.viewerView.close$photoview_dialog_release();
    }

    public final void dismiss() {
        this.dialog.dismiss();
    }

    public final void updateImages(@NotNull List<? extends T> images) {
        Intrinsics.checkNotNullParameter(images, (String)"images");
        this.viewerView.updateImages$photoview_dialog_release(images);
    }

    public final int getCurrentPosition() {
        return this.viewerView.getCurrentPosition$photoview_dialog_release();
    }

    public final int setCurrentPosition(int position) {
        this.viewerView.setCurrentPosition$photoview_dialog_release(position);
        return this.viewerView.getCurrentPosition$photoview_dialog_release();
    }

    public final void updateTransitionImage(@Nullable ImageView imageView) {
        this.viewerView.updateTransitionImage$photoview_dialog_release(imageView);
    }

    private final boolean onDialogKeyEvent(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1 && !event.isCanceled()) {
            if (this.viewerView.isScaled$photoview_dialog_release()) {
                this.viewerView.resetScale$photoview_dialog_release();
            } else {
                this.viewerView.close$photoview_dialog_release();
            }
            return true;
        }
        return false;
    }

    private final void setupViewerView() {
        ImageViewerView<T> imageViewerView;
        ImageViewerView<T> $this$setupViewerView_u24lambda_u244 = imageViewerView = this.viewerView;
        boolean bl = false;
        $this$setupViewerView_u24lambda_u244.setZoomingAllowed$photoview_dialog_release(this.builderData.isZoomingAllowed());
        $this$setupViewerView_u24lambda_u244.setSwipeToDismissAllowed$photoview_dialog_release(this.builderData.isSwipeToDismissAllowed());
        $this$setupViewerView_u24lambda_u244.setContainerPadding$photoview_dialog_release(this.builderData.getContainerPaddingPixels());
        $this$setupViewerView_u24lambda_u244.setImagesMargin$photoview_dialog_release(this.builderData.getImageMarginPixels());
        $this$setupViewerView_u24lambda_u244.setOverlayView$photoview_dialog_release(this.builderData.getOverlayView());
        $this$setupViewerView_u24lambda_u244.setBackgroundColor(this.builderData.getBackgroundColor());
        $this$setupViewerView_u24lambda_u244.setImages$photoview_dialog_release(this.builderData.getImages(), this.builderData.getStartPosition(), this.builderData.getImageLoader());
        $this$setupViewerView_u24lambda_u244.setOnPageChange$photoview_dialog_release((Function1<Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ImageViewerDialog<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int position) {
                block0: {
                    OnImageChangeListener onImageChangeListener = ImageViewerDialog.access$getBuilderData$p(this.this$0).getImageChangeListener();
                    if (onImageChangeListener == null) break block0;
                    onImageChangeListener.onImageChange(position);
                }
            }
        }));
        $this$setupViewerView_u24lambda_u244.setOnDismiss$photoview_dialog_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ImageViewerDialog<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ImageViewerDialog.access$getDialog$p(this.this$0).dismiss();
            }
        }));
    }

    private static final boolean _init_$lambda$0(ImageViewerDialog this$0, DialogInterface dialogInterface, int keyCode, KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)event);
        return this$0.onDialogKeyEvent(keyCode, event);
    }

    private static final void lambda$3$lambda$1(ImageViewerDialog this$0, DialogInterface it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewerView.open$photoview_dialog_release(this$0.builderData.getTransitionView(), this$0.animateOpen);
    }

    private static final void lambda$3$lambda$2(ImageViewerDialog this$0, DialogInterface it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            OnDismissListener onDismissListener = this$0.builderData.getOnDismissListener();
            if (onDismissListener == null) break block0;
            onDismissListener.onDismiss();
        }
    }

    public static final /* synthetic */ BuilderData access$getBuilderData$p(ImageViewerDialog $this) {
        return $this.builderData;
    }

    public static final /* synthetic */ AlertDialog access$getDialog$p(ImageViewerDialog $this) {
        return $this.dialog;
    }
}

