/*
 * Copyright 2024 Stream.IO, Inc.
 * Copyright 2011, 2012 Chris Banes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.getstream.photoview

import android.graphics.RectF

/**
 * Interface definition for a callback to be invoked when the internal Matrix has changed for
 * this View.
 */
public fun interface OnMatrixChangedListener {
  /**
   * Callback for when the Matrix displaying the Drawable has changed. This could be because
   * the View's bounds have changed, or the user has zoomed.
   *
   * @param rect - Rectangle displaying the Drawable's new bounds.
   */
  public fun onMatrixChanged(rect: RectF?)
}
