/*
 * Copyright 2024 Stream.IO, Inc.
 * Copyright 2011, 2012 Chris Banes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.getstream.photoview

import android.widget.ImageView

/**
 * A callback to be invoked when the Photo is tapped with a single
 * tap.
 */
public fun interface OnPhotoTapListener {
  /**
   * A callback to receive where the user taps on a photo. You will only receive a callback if
   * the user taps on the actual photo, tapping on 'whitespace' will be ignored.
   *
   * @param view ImageView the user tapped.
   * @param x    where the user tapped from the of the Drawable, as percentage of the
   * Drawable width.
   * @param y    where the user tapped from the top of the Drawable, as percentage of the
   * Drawable height.
   */
  public fun onPhotoTap(view: ImageView?, x: Float, y: Float)
}
