/*
 * Copyright 2024 Stream.IO, Inc.
 * Copyright 2011, 2012 Chris Banes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.getstream.photoview

import android.view.MotionEvent

/**
 * A callback to be invoked when the ImageView is flung with a single
 * touch
 */
public fun interface OnSingleFlingListener {
  /**
   * A callback to receive where the user flings on a ImageView. You will receive a callback if
   * the user flings anywhere on the view.
   *
   * @param e1        MotionEvent the user first touch.
   * @param e2        MotionEvent the user last touch.
   * @param velocityX distance of user's horizontal fling.
   * @param velocityY distance of user's vertical fling.
   */
  public fun onFling(
    e1: MotionEvent?,
    e2: MotionEvent?,
    velocityX: Float,
    velocityY: Float,
  ): Boolean
}
