/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.photoview;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import io.getstream.photoview.Compat;
import io.getstream.photoview.CustomGestureDetector;
import io.getstream.photoview.OnGestureListener;
import io.getstream.photoview.OnMatrixChangedListener;
import io.getstream.photoview.OnOutsidePhotoTapListener;
import io.getstream.photoview.OnPhotoTapListener;
import io.getstream.photoview.OnScaleChangedListener;
import io.getstream.photoview.OnSingleFlingListener;
import io.getstream.photoview.OnViewDragListener;
import io.getstream.photoview.OnViewTapListener;
import io.getstream.photoview.Util;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u0099\u00012\u00020\u00012\u00020\u0002:\u0006\u0098\u0001\u0099\u0001\u009a\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010Y\u001a\u00020ZH\u0002J\b\u0010[\u001a\u00020ZH\u0002J\b\u0010\\\u001a\u00020\u0011H\u0002J\u0010\u0010]\u001a\u00020Z2\b\u0010^\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010^\u001a\u00020\u000bH\u0002J\u0010\u0010_\u001a\u00020#2\u0006\u0010`\u001a\u00020\u0004H\u0002J\u0010\u0010a\u001a\u00020#2\u0006\u0010`\u001a\u00020\u0004H\u0002J\u0010\u0010b\u001a\u00020Z2\b\u0010^\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010c\u001a\u00020\u001b2\u0006\u0010^\u001a\u00020\u000b2\u0006\u0010d\u001a\u00020#H\u0002JP\u0010e\u001a\u00020Z2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020#2\u0006\u0010i\u001a\u00020#2\u0006\u0010j\u001a\u00020#2\u0006\u0010k\u001a\u00020#2\u0006\u0010l\u001a\u00020#2\u0006\u0010m\u001a\u00020#2\u0006\u0010n\u001a\u00020#2\u0006\u0010o\u001a\u00020#H\u0016J\u0018\u0010p\u001a\u00020\u00112\u0006\u0010f\u001a\u00020g2\u0006\u0010q\u001a\u00020rH\u0016J\b\u0010s\u001a\u00020ZH\u0002J\u000e\u0010t\u001a\u00020Z2\u0006\u0010u\u001a\u00020\u0011J\u000e\u0010v\u001a\u00020Z2\u0006\u0010w\u001a\u00020\u001bJ\u0010\u0010x\u001a\u00020\u00112\b\u0010y\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010z\u001a\u00020Z2\u0006\u0010^\u001a\u00020\u000bH\u0002J\u0010\u0010{\u001a\u00020Z2\b\u0010|\u001a\u0004\u0018\u000100J\u0010\u0010}\u001a\u00020Z2\b\u0010~\u001a\u0004\u0018\u00010\u007fJ\u0011\u0010\u0080\u0001\u001a\u00020Z2\b\u0010|\u001a\u0004\u0018\u00010'J\u0011\u0010\u0081\u0001\u001a\u00020Z2\b\u0010|\u001a\u0004\u0018\u00010)J\u0011\u0010\u0082\u0001\u001a\u00020Z2\b\u00103\u001a\u0004\u0018\u000104J\u0011\u0010\u0083\u0001\u001a\u00020Z2\b\u0010|\u001a\u0004\u0018\u000106J\u0012\u0010\u0084\u0001\u001a\u00020Z2\t\u0010\u0085\u0001\u001a\u0004\u0018\u000108J\u0012\u0010\u0086\u0001\u001a\u00020Z2\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010>J\u0011\u0010\u0088\u0001\u001a\u00020Z2\b\u0010|\u001a\u0004\u0018\u000102J\u0011\u0010\u0089\u0001\u001a\u00020Z2\b\u0010|\u001a\u0004\u0018\u00010BJ\u000f\u0010\u008a\u0001\u001a\u00020Z2\u0006\u0010w\u001a\u00020\u001bJ\u000f\u0010\u008b\u0001\u001a\u00020Z2\u0006\u0010w\u001a\u00020\u001bJ\u0017\u0010S\u001a\u00020Z2\u0006\u0010Q\u001a\u00020\u001b2\u0007\u0010\u008c\u0001\u001a\u00020\u0011J)\u0010S\u001a\u00020Z2\u0006\u0010Q\u001a\u00020\u001b2\u0007\u0010\u008d\u0001\u001a\u00020\u001b2\u0007\u0010\u008e\u0001\u001a\u00020\u001b2\u0007\u0010\u008c\u0001\u001a\u00020\u0011J\u001f\u0010\u008f\u0001\u001a\u00020Z2\u0006\u0010L\u001a\u00020\u001b2\u0006\u0010I\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020\u001bJ\u0010\u0010\u0090\u0001\u001a\u00020Z2\u0007\u0010\u0091\u0001\u001a\u00020%J\u0010\u0010\u0092\u0001\u001a\u00020Z2\u0007\u0010\u0093\u0001\u001a\u00020#J\u0007\u0010\u0094\u0001\u001a\u00020ZJ\u0015\u0010\u0095\u0001\u001a\u00020Z2\n\u0010\u0096\u0001\u001a\u0005\u0018\u00010\u0097\u0001H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0018\u00010\u001eR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010D\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR$\u0010I\u001a\u00020\u001b2\u0006\u0010I\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bJ\u0010F\"\u0004\bK\u0010HR$\u0010L\u001a\u00020\u001b2\u0006\u0010L\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010F\"\u0004\bN\u0010HR\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010Q\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bR\u0010F\"\u0004\bS\u0010HR$\u0010T\u001a\u00020<2\u0006\u0010T\u001a\u00020<8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bU\u0010V\"\u0004\bW\u0010X\u00a8\u0006\u009b\u0001"}, d2={"Lio/getstream/photoview/PhotoViewAttacher;", "Landroid/view/View$OnTouchListener;", "Landroid/view/View$OnLayoutChangeListener;", "mImageView", "Landroid/widget/ImageView;", "(Landroid/widget/ImageView;)V", "displayRect", "Landroid/graphics/RectF;", "getDisplayRect", "()Landroid/graphics/RectF;", "drawMatrix", "Landroid/graphics/Matrix;", "getDrawMatrix", "()Landroid/graphics/Matrix;", "imageMatrix", "getImageMatrix$photoview_release", "<set-?>", "", "isZoomEnabled", "()Z", "zoomable", "isZoomable", "setZoomable", "(Z)V", "mAllowParentInterceptOnEdge", "mBaseMatrix", "mBaseRotation", "", "mBlockParentIntercept", "mCurrentFlingRunnable", "Lio/getstream/photoview/PhotoViewAttacher$FlingRunnable;", "mDisplayRect", "mGestureDetector", "Landroid/view/GestureDetector;", "mHorizontalScrollEdge", "", "mInterpolator", "Landroid/view/animation/Interpolator;", "mLongClickListener", "Landroid/view/View$OnLongClickListener;", "mMatrixChangeListener", "Lio/getstream/photoview/OnMatrixChangedListener;", "mMatrixValues", "", "mMaxScale", "mMidScale", "mMinScale", "mOnClickListener", "Landroid/view/View$OnClickListener;", "mOnViewDragListener", "Lio/getstream/photoview/OnViewDragListener;", "mOutsidePhotoTapListener", "Lio/getstream/photoview/OnOutsidePhotoTapListener;", "mPhotoTapListener", "Lio/getstream/photoview/OnPhotoTapListener;", "mScaleChangeListener", "Lio/getstream/photoview/OnScaleChangedListener;", "mScaleDragDetector", "Lio/getstream/photoview/CustomGestureDetector;", "mScaleType", "Landroid/widget/ImageView$ScaleType;", "mSingleFlingListener", "Lio/getstream/photoview/OnSingleFlingListener;", "mSuppMatrix", "mVerticalScrollEdge", "mViewTapListener", "Lio/getstream/photoview/OnViewTapListener;", "mZoomDuration", "maximumScale", "getMaximumScale", "()F", "setMaximumScale", "(F)V", "mediumScale", "getMediumScale", "setMediumScale", "minimumScale", "getMinimumScale", "setMinimumScale", "onGestureListener", "Lio/getstream/photoview/OnGestureListener;", "scale", "getScale", "setScale", "scaleType", "getScaleType", "()Landroid/widget/ImageView$ScaleType;", "setScaleType", "(Landroid/widget/ImageView$ScaleType;)V", "cancelFling", "", "checkAndDisplayMatrix", "checkMatrixBounds", "getDisplayMatrix", "matrix", "getImageViewHeight", "imageView", "getImageViewWidth", "getSuppMatrix", "getValue", "whichValue", "onLayoutChange", "v", "Landroid/view/View;", "left", "top", "right", "bottom", "oldLeft", "oldTop", "oldRight", "oldBottom", "onTouch", "ev", "Landroid/view/MotionEvent;", "resetMatrix", "setAllowParentInterceptOnEdge", "allow", "setBaseRotation", "degrees", "setDisplayMatrix", "finalMatrix", "setImageViewMatrix", "setOnClickListener", "listener", "setOnDoubleTapListener", "newOnDoubleTapListener", "Landroid/view/GestureDetector$OnDoubleTapListener;", "setOnLongClickListener", "setOnMatrixChangeListener", "setOnOutsidePhotoTapListener", "setOnPhotoTapListener", "setOnScaleChangeListener", "onScaleChangeListener", "setOnSingleFlingListener", "onSingleFlingListener", "setOnViewDragListener", "setOnViewTapListener", "setRotationBy", "setRotationTo", "animate", "focalX", "focalY", "setScaleLevels", "setZoomInterpolator", "interpolator", "setZoomTransitionDuration", "milliseconds", "update", "updateBaseMatrix", "drawable", "Landroid/graphics/drawable/Drawable;", "AnimatedZoomRunnable", "Companion", "FlingRunnable", "photoview_release"})
@SourceDebugExtension(value={"SMAP\nPhotoViewAttacher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhotoViewAttacher.kt\nio/getstream/photoview/PhotoViewAttacher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,859:1\n1#2:860\n*E\n"})
public final class PhotoViewAttacher
implements View.OnTouchListener,
View.OnLayoutChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageView mImageView;
    @NotNull
    private Interpolator mInterpolator;
    private int mZoomDuration;
    private float mMinScale;
    private float mMidScale;
    private float mMaxScale;
    private boolean mAllowParentInterceptOnEdge;
    private boolean mBlockParentIntercept;
    @NotNull
    private GestureDetector mGestureDetector;
    @Nullable
    private CustomGestureDetector mScaleDragDetector;
    @NotNull
    private final Matrix mBaseMatrix;
    @NotNull
    private final Matrix imageMatrix;
    @NotNull
    private final Matrix mSuppMatrix;
    @NotNull
    private final RectF mDisplayRect;
    @NotNull
    private final float[] mMatrixValues;
    @Nullable
    private OnMatrixChangedListener mMatrixChangeListener;
    @Nullable
    private OnPhotoTapListener mPhotoTapListener;
    @Nullable
    private OnOutsidePhotoTapListener mOutsidePhotoTapListener;
    @Nullable
    private OnViewTapListener mViewTapListener;
    @Nullable
    private View.OnClickListener mOnClickListener;
    @Nullable
    private View.OnLongClickListener mLongClickListener;
    @Nullable
    private OnScaleChangedListener mScaleChangeListener;
    @Nullable
    private OnSingleFlingListener mSingleFlingListener;
    @Nullable
    private OnViewDragListener mOnViewDragListener;
    @Nullable
    private FlingRunnable mCurrentFlingRunnable;
    private int mHorizontalScrollEdge;
    private int mVerticalScrollEdge;
    private float mBaseRotation;
    private boolean isZoomEnabled;
    @NotNull
    private ImageView.ScaleType mScaleType;
    @NotNull
    private final OnGestureListener onGestureListener;
    private static final float DEFAULT_MAX_SCALE = 3.0f;
    private static final float DEFAULT_MID_SCALE = 1.75f;
    private static final float DEFAULT_MIN_SCALE = 1.0f;
    private static final int DEFAULT_ZOOM_DURATION = 200;
    private static final int HORIZONTAL_EDGE_NONE = -1;
    private static final int HORIZONTAL_EDGE_LEFT = 0;
    private static final int HORIZONTAL_EDGE_RIGHT = 1;
    private static final int HORIZONTAL_EDGE_BOTH = 2;
    private static final int VERTICAL_EDGE_NONE = -1;
    private static final int VERTICAL_EDGE_TOP = 0;
    private static final int VERTICAL_EDGE_BOTTOM = 1;
    private static final int VERTICAL_EDGE_BOTH = 2;
    private static final int SINGLE_TOUCH = 1;

    public PhotoViewAttacher(@NotNull ImageView mImageView) {
        Intrinsics.checkNotNullParameter((Object)mImageView, (String)"mImageView");
        this.mImageView = mImageView;
        this.mInterpolator = (Interpolator)new AccelerateDecelerateInterpolator();
        this.mZoomDuration = 200;
        this.mMinScale = 1.0f;
        this.mMidScale = 1.75f;
        this.mMaxScale = 3.0f;
        this.mAllowParentInterceptOnEdge = true;
        this.mGestureDetector = new GestureDetector(this.mImageView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(this){
            final /* synthetic */ PhotoViewAttacher this$0;
            {
                this.this$0 = $receiver;
            }

            public void onLongPress(@NotNull MotionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (PhotoViewAttacher.access$getMLongClickListener$p(this.this$0) != null) {
                    View.OnLongClickListener onLongClickListener = PhotoViewAttacher.access$getMLongClickListener$p(this.this$0);
                    Intrinsics.checkNotNull((Object)onLongClickListener);
                    onLongClickListener.onLongClick((View)PhotoViewAttacher.access$getMImageView$p(this.this$0));
                }
            }

            public boolean onFling(@Nullable MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
                if (PhotoViewAttacher.access$getMSingleFlingListener$p(this.this$0) != null) {
                    boolean bl;
                    if (this.this$0.getScale() > 1.0f) {
                        return false;
                    }
                    MotionEvent motionEvent = e1;
                    Intrinsics.checkNotNull((Object)motionEvent);
                    if (motionEvent.getPointerCount() > 1 || e2.getPointerCount() > 1) {
                        bl = false;
                    } else {
                        OnSingleFlingListener onSingleFlingListener = PhotoViewAttacher.access$getMSingleFlingListener$p(this.this$0);
                        Intrinsics.checkNotNull((Object)onSingleFlingListener);
                        bl = onSingleFlingListener.onFling(e1, e2, velocityX, velocityY);
                    }
                    return bl;
                }
                return false;
            }
        });
        this.mBaseMatrix = new Matrix();
        this.imageMatrix = new Matrix();
        this.mSuppMatrix = new Matrix();
        this.mDisplayRect = new RectF();
        this.mMatrixValues = new float[9];
        this.mHorizontalScrollEdge = 2;
        this.mVerticalScrollEdge = 2;
        this.isZoomEnabled = true;
        this.mScaleType = ImageView.ScaleType.FIT_CENTER;
        this.onGestureListener = new OnGestureListener(this){
            final /* synthetic */ PhotoViewAttacher this$0;
            {
                this.this$0 = $receiver;
            }

            public void onDrag(float dx, float dy) {
                block4: {
                    ViewParent parent;
                    block3: {
                        CustomGestureDetector customGestureDetector = PhotoViewAttacher.access$getMScaleDragDetector$p(this.this$0);
                        boolean bl = customGestureDetector != null ? customGestureDetector.isScaling() : false;
                        if (bl) {
                            return;
                        }
                        if (PhotoViewAttacher.access$getMOnViewDragListener$p(this.this$0) != null) {
                            OnViewDragListener onViewDragListener = PhotoViewAttacher.access$getMOnViewDragListener$p(this.this$0);
                            Intrinsics.checkNotNull((Object)onViewDragListener);
                            onViewDragListener.onDrag(dx, dy);
                        }
                        PhotoViewAttacher.access$getMSuppMatrix$p(this.this$0).postTranslate(dx, dy);
                        PhotoViewAttacher.access$checkAndDisplayMatrix(this.this$0);
                        parent = PhotoViewAttacher.access$getMImageView$p(this.this$0).getParent();
                        if (!PhotoViewAttacher.access$getMAllowParentInterceptOnEdge$p(this.this$0)) break block3;
                        CustomGestureDetector customGestureDetector2 = PhotoViewAttacher.access$getMScaleDragDetector$p(this.this$0);
                        if ((customGestureDetector2 != null ? customGestureDetector2.isScaling() : false) || PhotoViewAttacher.access$getMBlockParentIntercept$p(this.this$0)) break block3;
                        if (!(PhotoViewAttacher.access$getMHorizontalScrollEdge$p(this.this$0) == 2 || PhotoViewAttacher.access$getMHorizontalScrollEdge$p(this.this$0) == 0 && dx >= 1.0f || PhotoViewAttacher.access$getMHorizontalScrollEdge$p(this.this$0) == 1 && dx <= -1.0f || PhotoViewAttacher.access$getMVerticalScrollEdge$p(this.this$0) == 0 && dy >= 1.0f) && (PhotoViewAttacher.access$getMVerticalScrollEdge$p(this.this$0) != 1 || !(dy <= -1.0f))) break block4;
                        ViewParent viewParent = parent;
                        if (viewParent != null) {
                            viewParent.requestDisallowInterceptTouchEvent(false);
                        }
                        break block4;
                    }
                    ViewParent viewParent = parent;
                    if (viewParent == null) break block4;
                    viewParent.requestDisallowInterceptTouchEvent(true);
                }
            }

            public void onFling(float startX, float startY, float velocityX, float velocityY) {
                PhotoViewAttacher.access$setMCurrentFlingRunnable$p(this.this$0, this.this$0.new FlingRunnable(PhotoViewAttacher.access$getMImageView$p(this.this$0).getContext()));
                FlingRunnable flingRunnable = PhotoViewAttacher.access$getMCurrentFlingRunnable$p(this.this$0);
                Intrinsics.checkNotNull((Object)flingRunnable);
                flingRunnable.fling(PhotoViewAttacher.access$getImageViewWidth(this.this$0, PhotoViewAttacher.access$getMImageView$p(this.this$0)), PhotoViewAttacher.access$getImageViewHeight(this.this$0, PhotoViewAttacher.access$getMImageView$p(this.this$0)), (int)velocityX, (int)velocityY);
                PhotoViewAttacher.access$getMImageView$p(this.this$0).post((Runnable)PhotoViewAttacher.access$getMCurrentFlingRunnable$p(this.this$0));
            }

            public void onScale(float scaleFactor, float focusX, float focusY) {
                this.onScale(scaleFactor, focusX, focusY, 0.0f, 0.0f);
            }

            public void onScale(float scaleFactor, float focusX, float focusY, float dx, float dy) {
                if (this.this$0.getScale() < PhotoViewAttacher.access$getMMaxScale$p(this.this$0) || scaleFactor < 1.0f) {
                    if (PhotoViewAttacher.access$getMScaleChangeListener$p(this.this$0) != null) {
                        OnScaleChangedListener onScaleChangedListener = PhotoViewAttacher.access$getMScaleChangeListener$p(this.this$0);
                        Intrinsics.checkNotNull((Object)onScaleChangedListener);
                        onScaleChangedListener.onScaleChange(scaleFactor, focusX, focusY);
                    }
                    PhotoViewAttacher.access$getMSuppMatrix$p(this.this$0).postScale(scaleFactor, scaleFactor, focusX, focusY);
                    PhotoViewAttacher.access$getMSuppMatrix$p(this.this$0).postTranslate(dx, dy);
                    PhotoViewAttacher.access$checkAndDisplayMatrix(this.this$0);
                }
            }
        };
        this.mImageView.setOnTouchListener((View.OnTouchListener)this);
        this.mImageView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        if (!this.mImageView.isInEditMode()) {
            Context context = this.mImageView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            this.mScaleDragDetector = new CustomGestureDetector(context, this.onGestureListener);
            this.mGestureDetector.setOnDoubleTapListener(new GestureDetector.OnDoubleTapListener(){

                public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (mOnClickListener != null) {
                        View.OnClickListener onClickListener = mOnClickListener;
                        Intrinsics.checkNotNull((Object)onClickListener);
                        onClickListener.onClick((View)mImageView);
                    }
                    RectF displayRect = this.getDisplayRect();
                    float x = e.getX();
                    float y = e.getY();
                    if (mViewTapListener != null) {
                        OnViewTapListener onViewTapListener = mViewTapListener;
                        Intrinsics.checkNotNull((Object)onViewTapListener);
                        onViewTapListener.onViewTap((View)mImageView, x, y);
                    }
                    if (displayRect != null) {
                        if (displayRect.contains(x, y)) {
                            float xResult = (x - displayRect.left) / displayRect.width();
                            float yResult = (y - displayRect.top) / displayRect.height();
                            if (mPhotoTapListener != null) {
                                OnPhotoTapListener onPhotoTapListener = mPhotoTapListener;
                                Intrinsics.checkNotNull((Object)onPhotoTapListener);
                                onPhotoTapListener.onPhotoTap(mImageView, xResult, yResult);
                            }
                            return true;
                        }
                        if (mOutsidePhotoTapListener != null) {
                            OnOutsidePhotoTapListener onOutsidePhotoTapListener = mOutsidePhotoTapListener;
                            Intrinsics.checkNotNull((Object)onOutsidePhotoTapListener);
                            onOutsidePhotoTapListener.onOutsidePhotoTap(mImageView);
                        }
                    }
                    return false;
                }

                public boolean onDoubleTap(@NotNull MotionEvent ev) {
                    Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
                    try {
                        float scale = this.getScale();
                        float x = ev.getX();
                        float y = ev.getY();
                        if (scale < this.getMediumScale()) {
                            this.setScale(this.getMediumScale(), x, y, true);
                        } else if (scale >= this.getMediumScale() && scale < this.getMaximumScale()) {
                            this.setScale(this.getMaximumScale(), x, y, true);
                        } else {
                            this.setScale(this.getMinimumScale(), x, y, true);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    return true;
                }

                public boolean onDoubleTapEvent(@NotNull MotionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    return false;
                }
            });
        }
    }

    @NotNull
    public final Matrix getImageMatrix$photoview_release() {
        return this.imageMatrix;
    }

    @Deprecated(message="")
    public final boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public final void setOnDoubleTapListener(@Nullable GestureDetector.OnDoubleTapListener newOnDoubleTapListener) {
        this.mGestureDetector.setOnDoubleTapListener(newOnDoubleTapListener);
    }

    public final void setOnScaleChangeListener(@Nullable OnScaleChangedListener onScaleChangeListener) {
        this.mScaleChangeListener = onScaleChangeListener;
    }

    public final void setOnSingleFlingListener(@Nullable OnSingleFlingListener onSingleFlingListener) {
        this.mSingleFlingListener = onSingleFlingListener;
    }

    @Nullable
    public final RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDrawMatrix());
    }

    public final boolean setDisplayMatrix(@Nullable Matrix finalMatrix) {
        if (finalMatrix == null) {
            boolean bl = false;
            String string = "Matrix cannot be null";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.mImageView.getDrawable() == null) {
            return false;
        }
        this.mSuppMatrix.set(finalMatrix);
        this.checkAndDisplayMatrix();
        return true;
    }

    public final void setBaseRotation(float degrees) {
        this.mBaseRotation = degrees % (float)360;
        this.update();
        this.setRotationBy(this.mBaseRotation);
        this.checkAndDisplayMatrix();
    }

    public final void setRotationTo(float degrees) {
        this.mSuppMatrix.setRotate(degrees % (float)360);
        this.checkAndDisplayMatrix();
    }

    public final void setRotationBy(float degrees) {
        this.mSuppMatrix.postRotate(degrees % (float)360);
        this.checkAndDisplayMatrix();
    }

    public final float getMinimumScale() {
        return this.mMinScale;
    }

    public final void setMinimumScale(float minimumScale) {
        Util.checkZoomLevels(minimumScale, this.mMidScale, this.mMaxScale);
        this.mMinScale = minimumScale;
    }

    public final float getMediumScale() {
        return this.mMidScale;
    }

    public final void setMediumScale(float mediumScale) {
        Util.checkZoomLevels(this.mMinScale, mediumScale, this.mMaxScale);
        this.mMidScale = mediumScale;
    }

    public final float getMaximumScale() {
        return this.mMaxScale;
    }

    public final void setMaximumScale(float maximumScale) {
        Util.checkZoomLevels(this.mMinScale, this.mMidScale, maximumScale);
        this.mMaxScale = maximumScale;
    }

    public final float getScale() {
        return (float)Math.sqrt((float)Math.pow(this.getValue(this.mSuppMatrix, 0), 2.0) + (float)Math.pow(this.getValue(this.mSuppMatrix, 3), 2.0));
    }

    public final void setScale(float scale) {
        this.setScale(scale, false);
    }

    @NotNull
    public final ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public final void setScaleType(@NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        if (Util.isSupportedScaleType(scaleType) && scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
        }
    }

    public void onLayoutChange(@NotNull View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
            this.updateBaseMatrix(this.mImageView.getDrawable());
        }
    }

    public boolean onTouch(@NotNull View v, @NotNull MotionEvent ev) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        boolean handled = false;
        if (this.isZoomEnabled && Util.hasDrawable((ImageView)v)) {
            switch (ev.getAction()) {
                case 0: {
                    ViewParent parent;
                    ViewParent viewParent = parent = v.getParent();
                    if (viewParent != null) {
                        viewParent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.cancelFling();
                    break;
                }
                case 1: 
                case 3: {
                    RectF rect;
                    if (this.getScale() < this.mMinScale) {
                        rect = this.getDisplayRect();
                        if (rect == null) break;
                        v.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.mMinScale, rect.centerX(), rect.centerY()));
                        handled = true;
                        break;
                    }
                    if (!(this.getScale() > this.mMaxScale) || (rect = this.getDisplayRect()) == null) break;
                    v.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.mMaxScale, rect.centerX(), rect.centerY()));
                    handled = true;
                }
            }
            CustomGestureDetector dragDetector = this.mScaleDragDetector;
            if (dragDetector != null) {
                boolean wasScaling = dragDetector.isScaling();
                boolean wasDragging = dragDetector.isDragging();
                handled = dragDetector.onTouchEvent(ev);
                boolean didntScale = !wasScaling && !dragDetector.isScaling();
                boolean didntDrag = !wasDragging && !dragDetector.isDragging();
                boolean bl = this.mBlockParentIntercept = didntScale && didntDrag;
            }
            if (this.mGestureDetector.onTouchEvent(ev)) {
                handled = true;
            }
        }
        return handled;
    }

    public final void setAllowParentInterceptOnEdge(boolean allow) {
        this.mAllowParentInterceptOnEdge = allow;
    }

    public final void setScaleLevels(float minimumScale, float mediumScale, float maximumScale) {
        Util.checkZoomLevels(minimumScale, mediumScale, maximumScale);
        this.mMinScale = minimumScale;
        this.mMidScale = mediumScale;
        this.mMaxScale = maximumScale;
    }

    public final void setOnLongClickListener(@Nullable View.OnLongClickListener listener) {
        this.mLongClickListener = listener;
    }

    public final void setOnClickListener(@Nullable View.OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    public final void setOnMatrixChangeListener(@Nullable OnMatrixChangedListener listener) {
        this.mMatrixChangeListener = listener;
    }

    public final void setOnPhotoTapListener(@Nullable OnPhotoTapListener listener) {
        this.mPhotoTapListener = listener;
    }

    public final void setOnOutsidePhotoTapListener(@Nullable OnOutsidePhotoTapListener mOutsidePhotoTapListener) {
        this.mOutsidePhotoTapListener = mOutsidePhotoTapListener;
    }

    public final void setOnViewTapListener(@Nullable OnViewTapListener listener) {
        this.mViewTapListener = listener;
    }

    public final void setOnViewDragListener(@Nullable OnViewDragListener listener) {
        this.mOnViewDragListener = listener;
    }

    public final void setScale(float scale, boolean animate) {
        this.setScale(scale, this.mImageView.getRight() / 2, this.mImageView.getBottom() / 2, animate);
    }

    public final void setScale(float scale, float focalX, float focalY, boolean animate) {
        if (!(!(scale < this.mMinScale) && !(scale > this.mMaxScale))) {
            boolean bl = false;
            String string = "Scale must be within the range of minScale and maxScale";
            throw new IllegalArgumentException(string.toString());
        }
        if (animate) {
            this.mImageView.post((Runnable)new AnimatedZoomRunnable(this.getScale(), scale, focalX, focalY));
        } else {
            this.mSuppMatrix.setScale(scale, scale, focalX, focalY);
            this.checkAndDisplayMatrix();
        }
    }

    public final void setZoomInterpolator(@NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        this.mInterpolator = interpolator;
    }

    public final boolean isZoomable() {
        return this.isZoomEnabled;
    }

    public final void setZoomable(boolean zoomable) {
        this.isZoomEnabled = zoomable;
        this.update();
    }

    public final void update() {
        if (this.isZoomEnabled) {
            this.updateBaseMatrix(this.mImageView.getDrawable());
        } else {
            this.resetMatrix();
        }
    }

    public final void getDisplayMatrix(@Nullable Matrix matrix) {
        block0: {
            Matrix matrix2 = matrix;
            if (matrix2 == null) break block0;
            matrix2.set(this.getDrawMatrix());
        }
    }

    public final void getSuppMatrix(@Nullable Matrix matrix) {
        block0: {
            Matrix matrix2 = matrix;
            if (matrix2 == null) break block0;
            matrix2.set(this.mSuppMatrix);
        }
    }

    private final Matrix getDrawMatrix() {
        this.imageMatrix.set(this.mBaseMatrix);
        this.imageMatrix.postConcat(this.mSuppMatrix);
        return this.imageMatrix;
    }

    public final void setZoomTransitionDuration(int milliseconds) {
        this.mZoomDuration = milliseconds;
    }

    private final float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    private final void resetMatrix() {
        this.mSuppMatrix.reset();
        this.setRotationBy(this.mBaseRotation);
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
    }

    private final void setImageViewMatrix(Matrix matrix) {
        RectF displayRect;
        this.mImageView.setImageMatrix(matrix);
        if (this.mMatrixChangeListener != null && (displayRect = this.getDisplayRect(matrix)) != null) {
            OnMatrixChangedListener onMatrixChangedListener = this.mMatrixChangeListener;
            Intrinsics.checkNotNull((Object)onMatrixChangedListener);
            onMatrixChangedListener.onMatrixChanged(displayRect);
        }
    }

    private final void checkAndDisplayMatrix() {
        if (this.checkMatrixBounds()) {
            this.setImageViewMatrix(this.getDrawMatrix());
        }
    }

    private final RectF getDisplayRect(Matrix matrix) {
        Drawable d = this.mImageView.getDrawable();
        if (d != null) {
            this.mDisplayRect.set(0.0f, 0.0f, (float)d.getIntrinsicWidth(), (float)d.getIntrinsicHeight());
            matrix.mapRect(this.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    private final void updateBaseMatrix(Drawable drawable) {
        if (drawable == null) {
            return;
        }
        float viewWidth = this.getImageViewWidth(this.mImageView);
        float viewHeight = this.getImageViewHeight(this.mImageView);
        int drawableWidth = drawable.getIntrinsicWidth();
        int drawableHeight = drawable.getIntrinsicHeight();
        this.mBaseMatrix.reset();
        float widthScale = viewWidth / (float)drawableWidth;
        float heightScale = viewHeight / (float)drawableHeight;
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[this.mScaleType.ordinal()]) {
            case 5: {
                this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth) / 2.0f, (viewHeight - (float)drawableHeight) / 2.0f);
                break;
            }
            case 6: {
                float scale = RangesKt.coerceAtLeast((float)widthScale, (float)heightScale);
                this.mBaseMatrix.postScale(scale, scale);
                this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
                break;
            }
            case 7: {
                float scale = RangesKt.coerceAtMost((float)1.0f, (float)RangesKt.coerceAtMost((float)widthScale, (float)heightScale));
                this.mBaseMatrix.postScale(scale, scale);
                this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
                break;
            }
            default: {
                RectF mTempSrc = new RectF(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
                RectF mTempDst = new RectF(0.0f, 0.0f, viewWidth, viewHeight);
                if ((int)this.mBaseRotation % 180 != 0) {
                    mTempSrc = new RectF(0.0f, 0.0f, (float)drawableHeight, (float)drawableWidth);
                }
                switch (WhenMappings.$EnumSwitchMapping$0[this.mScaleType.ordinal()]) {
                    case 1: {
                        this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.CENTER);
                        break block0;
                    }
                    case 2: {
                        this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.START);
                        break block0;
                    }
                    case 3: {
                        this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.END);
                        break block0;
                    }
                    case 4: {
                        this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.FILL);
                    }
                }
            }
        }
        this.resetMatrix();
    }

    private final boolean checkMatrixBounds() {
        RectF rectF = this.getDisplayRect(this.getDrawMatrix());
        if (rectF == null) {
            return false;
        }
        RectF rect = rectF;
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int viewHeight = this.getImageViewHeight(this.mImageView);
        if (height <= (float)viewHeight) {
            deltaY = switch (WhenMappings.$EnumSwitchMapping$0[this.mScaleType.ordinal()]) {
                case 2 -> -rect.top;
                case 3 -> (float)viewHeight - height - rect.top;
                default -> ((float)viewHeight - height) / (float)2 - rect.top;
            };
            this.mVerticalScrollEdge = 2;
        } else if (rect.top > 0.0f) {
            this.mVerticalScrollEdge = 0;
            deltaY = -rect.top;
        } else if (rect.bottom < (float)viewHeight) {
            this.mVerticalScrollEdge = 1;
            deltaY = (float)viewHeight - rect.bottom;
        } else {
            this.mVerticalScrollEdge = -1;
        }
        int viewWidth = this.getImageViewWidth(this.mImageView);
        if (width <= (float)viewWidth) {
            deltaX = switch (WhenMappings.$EnumSwitchMapping$0[this.mScaleType.ordinal()]) {
                case 2 -> -rect.left;
                case 3 -> (float)viewWidth - width - rect.left;
                default -> ((float)viewWidth - width) / (float)2 - rect.left;
            };
            this.mHorizontalScrollEdge = 2;
        } else if (rect.left > 0.0f) {
            this.mHorizontalScrollEdge = 0;
            deltaX = -rect.left;
        } else if (rect.right < (float)viewWidth) {
            deltaX = (float)viewWidth - rect.right;
            this.mHorizontalScrollEdge = 1;
        } else {
            this.mHorizontalScrollEdge = -1;
        }
        this.mSuppMatrix.postTranslate(deltaX, deltaY);
        return true;
    }

    private final int getImageViewWidth(ImageView imageView) {
        return imageView.getWidth() - imageView.getPaddingLeft() - imageView.getPaddingRight();
    }

    private final int getImageViewHeight(ImageView imageView) {
        return imageView.getHeight() - imageView.getPaddingTop() - imageView.getPaddingBottom();
    }

    private final void cancelFling() {
        if (this.mCurrentFlingRunnable != null) {
            FlingRunnable flingRunnable = this.mCurrentFlingRunnable;
            Intrinsics.checkNotNull((Object)flingRunnable);
            flingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    public static final /* synthetic */ View.OnLongClickListener access$getMLongClickListener$p(PhotoViewAttacher $this) {
        return $this.mLongClickListener;
    }

    public static final /* synthetic */ OnSingleFlingListener access$getMSingleFlingListener$p(PhotoViewAttacher $this) {
        return $this.mSingleFlingListener;
    }

    public static final /* synthetic */ CustomGestureDetector access$getMScaleDragDetector$p(PhotoViewAttacher $this) {
        return $this.mScaleDragDetector;
    }

    public static final /* synthetic */ OnViewDragListener access$getMOnViewDragListener$p(PhotoViewAttacher $this) {
        return $this.mOnViewDragListener;
    }

    public static final /* synthetic */ boolean access$getMAllowParentInterceptOnEdge$p(PhotoViewAttacher $this) {
        return $this.mAllowParentInterceptOnEdge;
    }

    public static final /* synthetic */ boolean access$getMBlockParentIntercept$p(PhotoViewAttacher $this) {
        return $this.mBlockParentIntercept;
    }

    public static final /* synthetic */ int access$getMHorizontalScrollEdge$p(PhotoViewAttacher $this) {
        return $this.mHorizontalScrollEdge;
    }

    public static final /* synthetic */ int access$getMVerticalScrollEdge$p(PhotoViewAttacher $this) {
        return $this.mVerticalScrollEdge;
    }

    public static final /* synthetic */ void access$setMCurrentFlingRunnable$p(PhotoViewAttacher $this, FlingRunnable flingRunnable) {
        $this.mCurrentFlingRunnable = flingRunnable;
    }

    public static final /* synthetic */ FlingRunnable access$getMCurrentFlingRunnable$p(PhotoViewAttacher $this) {
        return $this.mCurrentFlingRunnable;
    }

    public static final /* synthetic */ int access$getImageViewWidth(PhotoViewAttacher $this, ImageView imageView) {
        return $this.getImageViewWidth(imageView);
    }

    public static final /* synthetic */ int access$getImageViewHeight(PhotoViewAttacher $this, ImageView imageView) {
        return $this.getImageViewHeight(imageView);
    }

    public static final /* synthetic */ float access$getMMaxScale$p(PhotoViewAttacher $this) {
        return $this.mMaxScale;
    }

    public static final /* synthetic */ OnScaleChangedListener access$getMScaleChangeListener$p(PhotoViewAttacher $this) {
        return $this.mScaleChangeListener;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0003H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/getstream/photoview/PhotoViewAttacher$AnimatedZoomRunnable;", "Ljava/lang/Runnable;", "mZoomStart", "", "mZoomEnd", "mFocalX", "mFocalY", "(Lio/getstream/photoview/PhotoViewAttacher;FFFF)V", "mStartTime", "", "interpolate", "run", "", "photoview_release"})
    public final class AnimatedZoomRunnable
    implements Runnable {
        private final float mZoomStart;
        private final float mZoomEnd;
        private final float mFocalX;
        private final float mFocalY;
        private final long mStartTime;

        public AnimatedZoomRunnable(float mZoomStart, float mZoomEnd, float mFocalX, float mFocalY) {
            this.mZoomStart = mZoomStart;
            this.mZoomEnd = mZoomEnd;
            this.mFocalX = mFocalX;
            this.mFocalY = mFocalY;
            this.mStartTime = System.currentTimeMillis();
        }

        @Override
        public void run() {
            float t = this.interpolate();
            float scale = this.mZoomStart + t * (this.mZoomEnd - this.mZoomStart);
            float deltaScale = scale / PhotoViewAttacher.this.getScale();
            PhotoViewAttacher.this.onGestureListener.onScale(deltaScale, this.mFocalX, this.mFocalY);
            if (t < 1.0f) {
                Compat.postOnAnimation((View)PhotoViewAttacher.this.mImageView, this);
            }
        }

        private final float interpolate() {
            float t = 1.0f * (float)(System.currentTimeMillis() - this.mStartTime) / (float)PhotoViewAttacher.this.mZoomDuration;
            t = Math.min(1.0f, t);
            t = PhotoViewAttacher.this.mInterpolator.getInterpolation(t);
            return t;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/getstream/photoview/PhotoViewAttacher$Companion;", "", "()V", "DEFAULT_MAX_SCALE", "", "DEFAULT_MID_SCALE", "DEFAULT_MIN_SCALE", "DEFAULT_ZOOM_DURATION", "", "HORIZONTAL_EDGE_BOTH", "HORIZONTAL_EDGE_LEFT", "HORIZONTAL_EDGE_NONE", "HORIZONTAL_EDGE_RIGHT", "SINGLE_TOUCH", "VERTICAL_EDGE_BOTH", "VERTICAL_EDGE_BOTTOM", "VERTICAL_EDGE_NONE", "VERTICAL_EDGE_TOP", "photoview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\b\u0010\u0011\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/getstream/photoview/PhotoViewAttacher$FlingRunnable;", "Ljava/lang/Runnable;", "context", "Landroid/content/Context;", "(Lio/getstream/photoview/PhotoViewAttacher;Landroid/content/Context;)V", "mCurrentX", "", "mCurrentY", "mScroller", "Landroid/widget/OverScroller;", "cancelFling", "", "fling", "viewWidth", "viewHeight", "velocityX", "velocityY", "run", "photoview_release"})
    private final class FlingRunnable
    implements Runnable {
        @NotNull
        private final OverScroller mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable(Context context) {
            this.mScroller = new OverScroller(context);
        }

        public final void cancelFling() {
            this.mScroller.forceFinished(true);
        }

        public final void fling(int viewWidth, int viewHeight, int velocityX, int velocityY) {
            RectF rectF = PhotoViewAttacher.this.getDisplayRect();
            if (rectF == null) {
                return;
            }
            RectF rect = rectF;
            int startX = Math.round(-rect.left);
            int minX = 0;
            int maxX = 0;
            int minY = 0;
            int maxY = 0;
            if ((float)viewWidth < rect.width()) {
                minX = 0;
                maxX = Math.round(rect.width() - (float)viewWidth);
            } else {
                minX = maxX = startX;
            }
            int startY = Math.round(-rect.top);
            if ((float)viewHeight < rect.height()) {
                minY = 0;
                maxY = Math.round(rect.height() - (float)viewHeight);
            } else {
                minY = maxY = startY;
            }
            this.mCurrentX = startX;
            this.mCurrentY = startY;
            if (startX != maxX || startY != maxY) {
                this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
            }
        }

        @Override
        public void run() {
            if (this.mScroller.isFinished()) {
                return;
            }
            if (this.mScroller.computeScrollOffset()) {
                int newX = this.mScroller.getCurrX();
                int newY = this.mScroller.getCurrY();
                PhotoViewAttacher.this.mSuppMatrix.postTranslate((float)(this.mCurrentX - newX), (float)(this.mCurrentY - newY));
                PhotoViewAttacher.this.checkAndDisplayMatrix();
                this.mCurrentX = newX;
                this.mCurrentY = newY;
                Compat.postOnAnimation((View)PhotoViewAttacher.this.mImageView, this);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageView.ScaleType.values().length];
            try {
                nArray[ImageView.ScaleType.FIT_CENTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_START.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_XY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.CENTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.CENTER_CROP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.CENTER_INSIDE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

