/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.photoview;

import android.widget.ImageView;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007\u00a8\u0006\u0013"}, d2={"Lio/getstream/photoview/Util;", "", "()V", "checkZoomLevels", "", "minZoom", "", "midZoom", "maxZoom", "getPointerIndex", "", "action", "hasDrawable", "", "imageView", "Landroid/widget/ImageView;", "isSupportedScaleType", "scaleType", "Landroid/widget/ImageView$ScaleType;", "photoview_release"})
public final class Util {
    @NotNull
    public static final Util INSTANCE = new Util();

    private Util() {
    }

    @JvmStatic
    public static final void checkZoomLevels(float minZoom, float midZoom, float maxZoom) {
        if (!(!(minZoom >= midZoom))) {
            boolean $i$a$-require-Util$checkZoomLevels$32 = false;
            String $i$a$-require-Util$checkZoomLevels$32 = "Minimum zoom has to be less than Medium zoom. Call setMinimumZoom() with a more appropriate value";
            throw new IllegalArgumentException($i$a$-require-Util$checkZoomLevels$32.toString());
        }
        if (!(!(midZoom >= maxZoom))) {
            boolean bl = false;
            String string = "Medium zoom has to be less than Maximum zoom. Call setMaximumZoom() with a more appropriate value";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @JvmStatic
    public static final boolean hasDrawable(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        return imageView.getDrawable() != null;
    }

    @JvmStatic
    public static final boolean isSupportedScaleType(@Nullable ImageView.ScaleType scaleType) {
        if (scaleType == null) {
            return false;
        }
        if (scaleType == ImageView.ScaleType.MATRIX) {
            throw new IllegalStateException("Matrix scale type is not supported");
        }
        return true;
    }

    @JvmStatic
    public static final int getPointerIndex(int action) {
        return (action & 0xFF00) >> 8;
    }
}

