/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.contract.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.ui.common.R;
import io.getstream.chat.android.ui.common.contract.internal.CaptureMediaContractKt;
import io.getstream.chat.android.ui.common.utils.StreamFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalStreamChatApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u001e\u001a\u00020\n*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/getstream/chat/android/ui/common/contract/internal/CaptureMediaContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "", "Ljava/io/File;", "mode", "Lio/getstream/chat/android/ui/common/contract/internal/CaptureMediaContract$Mode;", "(Lio/getstream/chat/android/ui/common/contract/internal/CaptureMediaContract$Mode;)V", "pictureFile", "videoFile", "createFileName", "", "prefix", "extension", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "(Landroid/content/Context;Lkotlin/Unit;)Landroid/content/Intent;", "createIntentList", "", "action", "destinationFile", "getRecordVideoIntents", "getTakePictureIntents", "parseResult", "resultCode", "", "intent", "intents", "label", "Mode", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCaptureMediaContract.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaptureMediaContract.kt\nio/getstream/chat/android/ui/common/contract/internal/CaptureMediaContract\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n37#2,2:128\n1549#3:130\n1620#3,3:131\n1#4:134\n*S KotlinDebug\n*F\n+ 1 CaptureMediaContract.kt\nio/getstream/chat/android/ui/common/contract/internal/CaptureMediaContract\n*L\n51#1:128,2\n90#1:130\n90#1:131,3\n*E\n"})
public final class CaptureMediaContract
extends ActivityResultContract<Unit, File> {
    @NotNull
    private final Mode mode;
    @Nullable
    private File pictureFile;
    @Nullable
    private File videoFile;
    public static final int $stable = 8;

    public CaptureMediaContract(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.mode = mode;
    }

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Unit input) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List<Intent> intents = this.intents(this.mode, context);
        Intent intent2 = (Intent)CollectionsKt.lastOrNull(intents);
        if (intent2 == null) {
            intent2 = new Intent();
        }
        Intent initialIntent = intent2;
        Intent $this$createIntent_u24lambda_u240 = intent = Intent.createChooser((Intent)initialIntent, (CharSequence)this.label(this.mode, context));
        boolean bl = false;
        Collection $this$toTypedArray$iv = CollectionsKt.minus((Iterable)intents, (Object)initialIntent);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$createIntent_u24lambda_u240.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])thisCollection$iv.toArray(new Intent[0]));
        Intent intent3 = intent;
        Intrinsics.checkNotNullExpressionValue((Object)intent3, (String)"apply(...)");
        return intent3;
    }

    private final List<Intent> getRecordVideoIntents(Context context) {
        File file = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
        if (file == null) {
            file = context.getCacheDir();
        }
        File it = new File(file, this.createFileName("STREAM_VID", "mp4"));
        boolean bl = false;
        this.videoFile = it;
        return this.createIntentList(context, "android.media.action.VIDEO_CAPTURE", it);
    }

    private final List<Intent> getTakePictureIntents(Context context) {
        File file = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (file == null) {
            file = context.getCacheDir();
        }
        File it = new File(file, this.createFileName("STREAM_IMG", "jpg"));
        boolean bl = false;
        this.pictureFile = it;
        return this.createIntentList(context, "android.media.action.IMAGE_CAPTURE", it);
    }

    private final String createFileName(String prefix, String extension) {
        return prefix + "_" + CaptureMediaContractKt.access$getDateFormat$p().format(new Date().getTime()) + "." + extension;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Intent> createIntentList(Context context, String action, File destinationFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Uri destinationUri = StreamFileUtil.INSTANCE.getUriForFile(context, destinationFile);
        Intent actionIntent = new Intent(action);
        List list = context.getPackageManager().queryIntentActivities(actionIntent, 65536);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryIntentActivities(...)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Intent intent;
            ResolveInfo resolveInfo = (ResolveInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intent $this$createIntentList_u24lambda_u244_u24lambda_u243 = intent = new Intent(actionIntent);
            boolean bl2 = false;
            $this$createIntentList_u24lambda_u244_u24lambda_u243.putExtra("output", (Parcelable)destinationUri);
            $this$createIntentList_u24lambda_u244_u24lambda_u243.setFlags(2);
            $this$createIntentList_u24lambda_u244_u24lambda_u243.setComponent(new ComponentName(it.activityInfo.packageName, it.activityInfo.name));
            $this$createIntentList_u24lambda_u244_u24lambda_u243.setPackage(it.activityInfo.packageName);
            collection.add(intent);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public File parseResult(int resultCode, @Nullable Intent intent) {
        File file;
        File file2 = CaptureMediaContractKt.access$takeIfCaptured(this.pictureFile);
        if (file2 == null) {
            file2 = CaptureMediaContractKt.access$takeIfCaptured(this.videoFile);
        }
        File it = file = file2;
        boolean bl = false;
        return resultCode == -1 ? file : null;
    }

    private final List<Intent> intents(Mode $this$intents, Context context) {
        List list;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$intents.ordinal()]) {
            case 1: {
                list = this.getTakePictureIntents(context);
                break;
            }
            case 2: {
                list = this.getRecordVideoIntents(context);
                break;
            }
            case 3: {
                list = CollectionsKt.plus((Collection)this.getTakePictureIntents(context), (Iterable)this.getRecordVideoIntents(context));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final String label(Mode $this$label, Context context) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$label.ordinal()]) {
            case 1: {
                n = R.string.stream_ui_message_composer_capture_media_take_photo;
                break;
            }
            case 2: {
                n = R.string.stream_ui_message_composer_capture_media_video;
                break;
            }
            case 3: {
                n = R.string.stream_ui_message_composer_capture_media;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String string2 = context.getString(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return string2;
    }

    @InternalStreamChatApi
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/common/contract/internal/CaptureMediaContract$Mode;", "", "(Ljava/lang/String;I)V", "PHOTO", "VIDEO", "PHOTO_AND_VIDEO", "stream-chat-android-ui-common_release"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode PHOTO = new Mode();
        public static final /* enum */ Mode VIDEO = new Mode();
        public static final /* enum */ Mode PHOTO_AND_VIDEO = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.PHOTO, Mode.VIDEO, Mode.PHOTO_AND_VIDEO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.PHOTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.VIDEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.PHOTO_AND_VIDEO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

