/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.feature.documents;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.ui.common.R;
import io.getstream.log.StreamLog;
import io.getstream.log.TaggedLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class AttachmentDocumentActivity
extends AppCompatActivity {
    private static final String KEY_URL = "url";
    WebView webView;
    ProgressBar progressBar;
    int reloadCount = 0;
    final int maxReloadCount = 5;
    private final TaggedLogger logger = StreamLog.getLogger((String)"Chat:AttachmentDocumentActivity");

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.stream_activity_attachment_document);
        this.webView = (WebView)this.findViewById(R.id.webView);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.configUIs();
        this.init();
    }

    private void init() {
        Intent intent = this.getIntent();
        String filePath = intent.getStringExtra(KEY_URL);
        this.loadDocument(filePath);
    }

    private void configUIs() {
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setLoadWithOverviewMode(true);
        this.webView.getSettings().setUseWideViewPort(true);
        this.webView.getSettings().setBuiltInZoomControls(true);
        this.webView.getSettings().setPluginState(WebSettings.PluginState.ON);
        this.webView.setWebViewClient((WebViewClient)new AppWebViewClients());
    }

    private String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return url;
        }
    }

    public void loadDocument(String url) {
        this.progressBar.setVisibility(0);
        if (ChatClient.instance().isSocketConnected()) {
            this.webView.loadUrl("https://docs.google.com/gview?embedded=true&url=" + this.encodeUrl(url));
        } else {
            this.finish();
        }
    }

    public static Intent getIntent(Context context, String url) {
        Intent intent = new Intent(context, AttachmentDocumentActivity.class);
        intent.putExtra(KEY_URL, url);
        return intent;
    }

    private class AppWebViewClients
    extends WebViewClient {
        private AppWebViewClients() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            view.loadUrl(url);
            return true;
        }

        public void onPageFinished(WebView view, String url) {
            if (view.getTitle().equals("")) {
                if (AttachmentDocumentActivity.this.reloadCount < 5) {
                    view.reload();
                    ++AttachmentDocumentActivity.this.reloadCount;
                } else {
                    AttachmentDocumentActivity.this.progressBar.setVisibility(8);
                    String errorMsg = AttachmentDocumentActivity.this.getString(R.string.stream_ui_message_list_attachment_load_failed);
                    Toast.makeText((Context)AttachmentDocumentActivity.this, (CharSequence)errorMsg, (int)0).show();
                }
            } else {
                AttachmentDocumentActivity.this.progressBar.setVisibility(8);
            }
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            AttachmentDocumentActivity.this.logger.e(() -> "The load failed due to an unknown error: " + error);
            if (error == null) {
                return;
            }
            Toast.makeText((Context)AttachmentDocumentActivity.this, (CharSequence)error.toString(), (int)0).show();
        }
    }
}

