/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.feature.messages.composer;

import androidx.compose.runtime.internal.StabilityInferred;
import io.getstream.chat.android.client.audio.AudioPlayer;
import io.getstream.chat.android.client.audio.AudioState;
import io.getstream.chat.android.client.audio.ProgressData;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.common.state.messages.composer.RecordingState;
import io.getstream.chat.android.ui.common.state.messages.composer.RecordingStateKt;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import io.getstream.result.Result;
import io.getstream.sdk.chat.audio.recording.MediaRecorderState;
import io.getstream.sdk.chat.audio.recording.RecordedMedia;
import io.getstream.sdk.chat.audio.recording.StreamMediaRecorder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0014\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020%H\u0002J\u0006\u0010'\u001a\u00020%J\u0006\u0010(\u001a\u00020%J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0010\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u000200H\u0002J\u0006\u00101\u001a\u00020%J\u0006\u00102\u001a\u00020%J\u0010\u00103\u001a\u00020%2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0010\u00104\u001a\u00020%2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u000e\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020 J\b\u00107\u001a\u00020%H\u0002J\u0006\u00108\u001a\u00020%J\u0006\u00109\u001a\u00020%J\u0006\u0010:\u001a\u00020%J\f\u0010;\u001a\u00020 *\u00020<H\u0002J \u0010;\u001a\b\u0012\u0004\u0012\u00020 0=*\b\u0012\u0004\u0012\u00020 0=2\u0006\u0010>\u001a\u00020\u000fH\u0002J\f\u0010?\u001a\u00020 *\u00020<H\u0002J\f\u0010@\u001a\u00020\u000f*\u00020\"H\u0002J \u0010@\u001a\b\u0012\u0004\u0012\u00020\u000f0=*\b\u0012\u0004\u0012\u00020\u000f0=2\u0006\u0010>\u001a\u00020\u000fH\u0002J\f\u0010A\u001a\u00020 *\u00020<H\u0002J\f\u0010A\u001a\u00020\u000f*\u00020\"H\u0002J\u0012\u0010B\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u000f0=H\u0002J\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020 0=*\b\u0012\u0004\u0012\u00020\u000f0=H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0019j\b\u0012\u0004\u0012\u00020\u000f`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0019j\b\u0012\u0004\u0012\u00020\u000f`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020 0\u0019j\b\u0012\u0004\u0012\u00020 `\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lio/getstream/chat/android/ui/common/feature/messages/composer/AudioRecordingController;", "", "channelId", "", "audioPlayer", "Lio/getstream/chat/android/client/audio/AudioPlayer;", "mediaRecorder", "Lio/getstream/sdk/chat/audio/recording/StreamMediaRecorder;", "fileToUri", "Lkotlin/Function1;", "Ljava/io/File;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Ljava/lang/String;Lio/getstream/chat/android/client/audio/AudioPlayer;Lio/getstream/sdk/chat/audio/recording/StreamMediaRecorder;Lkotlin/jvm/functions/Function1;Lkotlinx/coroutines/CoroutineScope;)V", "drawPollingInterval", "", "logger", "Lio/getstream/log/TaggedLogger;", "realPollingInterval", "recordingState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/getstream/chat/android/ui/common/state/messages/composer/RecordingState;", "getRecordingState", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "samples", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "samplesBuffer", "samplesBufferLimit", "samplesLimit", "samplesTarget", "waveform", "", "waveformBuffer", "", "waveformBufferCount", "cancelRecording", "", "clearData", "completeRecording", "lockRecording", "normalize", "maxAmplitude", "onAudioPlayingProgress", "progressState", "Lio/getstream/chat/android/client/audio/ProgressData;", "onAudioStateChanged", "playbackState", "Lio/getstream/chat/android/client/audio/AudioState;", "onCleared", "pauseRecording", "processWave", "saveSamples", "seekRecordingTo", "progress", "setupMediaRecorder", "startRecording", "stopRecording", "toggleRecordingPlayback", "downsample", "", "", "targetSamples", "downsampleAverage", "downsampleMax", "downsampleRms", "downsampleToSingleMax", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAudioRecordingController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioRecordingController.kt\nio/getstream/chat/android/ui/common/feature/messages/composer/AudioRecordingController\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 3 Result.kt\nio/getstream/result/Result\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,467:1\n314#2,4:468\n314#2,4:472\n281#2,4:476\n292#2,4:480\n281#2,4:484\n292#2,4:488\n281#2,4:492\n292#2,4:496\n281#2,4:500\n292#2,4:504\n281#2,4:508\n314#2,4:512\n314#2,4:516\n314#2,4:520\n303#2,4:524\n303#2,4:528\n281#2,4:532\n292#2,4:536\n270#2,4:541\n314#2,4:545\n281#2,4:549\n281#2,4:553\n292#2,4:557\n281#2,4:561\n292#2,4:565\n281#2,4:569\n281#2,4:573\n303#2,4:577\n270#2,4:582\n303#2,4:586\n292#2,4:590\n314#2,4:594\n281#2,4:602\n292#2,4:606\n292#2,4:610\n292#2,4:614\n270#2,4:618\n292#2,4:622\n33#3:540\n33#3:581\n1549#4:598\n1620#4,3:599\n*S KotlinDebug\n*F\n+ 1 AudioRecordingController.kt\nio/getstream/chat/android/ui/common/feature/messages/composer/AudioRecordingController\n*L\n137#1:468,4\n155#1:472,4\n163#1:476,4\n166#1:480,4\n175#1:484,4\n178#1:488,4\n185#1:492,4\n188#1:496,4\n197#1:500,4\n200#1:504,4\n202#1:508,4\n206#1:512,4\n212#1:516,4\n218#1:520,4\n232#1:524,4\n235#1:528,4\n262#1:532,4\n265#1:536,4\n268#1:541,4\n277#1:545,4\n284#1:549,4\n288#1:553,4\n292#1:557,4\n302#1:561,4\n305#1:565,4\n312#1:569,4\n314#1:573,4\n318#1:577,4\n333#1:582,4\n350#1:586,4\n356#1:590,4\n366#1:594,4\n394#1:602,4\n91#1:606,4\n94#1:610,4\n97#1:614,4\n100#1:618,4\n103#1:622,4\n267#1:540\n332#1:581\n376#1:598\n376#1:599,3\n*E\n"})
public final class AudioRecordingController {
    @NotNull
    private final String channelId;
    @NotNull
    private final AudioPlayer audioPlayer;
    @NotNull
    private final StreamMediaRecorder mediaRecorder;
    @NotNull
    private final Function1<File, String> fileToUri;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final TaggedLogger logger;
    @NotNull
    private final MutableStateFlow<RecordingState> recordingState;
    private final int drawPollingInterval;
    private final int realPollingInterval;
    @NotNull
    private final ArrayList<Integer> samples;
    private final int samplesTarget;
    private final int samplesLimit;
    @NotNull
    private final ArrayList<Integer> samplesBuffer;
    private int samplesBufferLimit;
    @NotNull
    private final ArrayList<Float> waveform;
    @NotNull
    private final int[] waveformBuffer;
    private int waveformBufferCount;
    public static final int $stable = 8;

    public AudioRecordingController(@NotNull String channelId, @NotNull AudioPlayer audioPlayer, @NotNull StreamMediaRecorder mediaRecorder, @NotNull Function1<? super File, String> fileToUri, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)audioPlayer, (String)"audioPlayer");
        Intrinsics.checkNotNullParameter((Object)mediaRecorder, (String)"mediaRecorder");
        Intrinsics.checkNotNullParameter(fileToUri, (String)"fileToUri");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.channelId = channelId;
        this.audioPlayer = audioPlayer;
        this.mediaRecorder = mediaRecorder;
        this.fileToUri = fileToUri;
        this.scope = scope;
        this.logger = StreamLog.getLogger((String)"Chat:RecordController");
        this.recordingState = StateFlowKt.MutableStateFlow((Object)RecordingState.Idle.INSTANCE);
        this.drawPollingInterval = 100;
        this.realPollingInterval = 10;
        this.samples = new ArrayList();
        this.samplesTarget = 100;
        this.samplesLimit = this.samplesTarget * this.realPollingInterval;
        this.samplesBuffer = new ArrayList();
        this.samplesBufferLimit = 1;
        this.waveform = new ArrayList();
        this.waveformBuffer = new int[this.drawPollingInterval / this.realPollingInterval];
        if (this.drawPollingInterval < this.realPollingInterval) {
            throw new IllegalArgumentException("drawPollingInterval must be greater than realPollingInterval");
        }
        this.setupMediaRecorder();
    }

    @NotNull
    public final MutableStateFlow<RecordingState> getRecordingState() {
        return this.recordingState;
    }

    private final void setupMediaRecorder() {
        this.mediaRecorder.setOnRecordingStartedListener(() -> AudioRecordingController.setupMediaRecorder$lambda$1(this));
        this.mediaRecorder.setOnRecordingStoppedListener(() -> AudioRecordingController.setupMediaRecorder$lambda$3(this));
        this.mediaRecorder.setOnMediaRecorderStateChangedListener(arg_0 -> AudioRecordingController.setupMediaRecorder$lambda$5(this, arg_0));
        this.mediaRecorder.setOnErrorListener((arg_0, arg_1, arg_2) -> AudioRecordingController.setupMediaRecorder$lambda$7(this, arg_0, arg_1, arg_2));
        this.mediaRecorder.setOnInfoListener((arg_0, arg_1, arg_2) -> AudioRecordingController.setupMediaRecorder$lambda$9(this, arg_0, arg_1, arg_2));
        this.mediaRecorder.setOnCurrentRecordingDurationChangedListener(arg_0 -> AudioRecordingController.setupMediaRecorder$lambda$10(this, arg_0));
        this.mediaRecorder.setOnMaxAmplitudeSampledListener(arg_0 -> AudioRecordingController.setupMediaRecorder$lambda$11(this, arg_0));
    }

    private final void saveSamples(int maxAmplitude) {
        this.samplesBuffer.add(maxAmplitude);
        if (this.samplesBuffer.size() < this.samplesBufferLimit) {
            return;
        }
        int amplitude = ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)this.samplesBuffer))).intValue();
        this.samplesBuffer.clear();
        this.samples.add(amplitude);
        if (this.samples.size() > this.samplesLimit) {
            List<Integer> newSamples = this.downsampleMax((List<Integer>)this.samples, this.samplesTarget);
            this.samples.clear();
            this.samples.addAll((Collection<Integer>)newSamples);
            this.samplesBufferLimit *= this.samplesLimit / this.samplesTarget;
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$v = false;
            if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.VERBOSE;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[saveSamples] reached samples limit; samplesBufferLimit: " + this.samplesBufferLimit;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
        }
    }

    private final void processWave(int maxAmplitude) {
        int n = this.waveformBufferCount;
        this.waveformBufferCount = n + 1;
        this.waveformBuffer[n] = maxAmplitude;
        if (this.waveformBufferCount < this.waveformBuffer.length) {
            return;
        }
        int amplitude = this.downsampleMax(this.waveformBuffer);
        float normalized = this.normalize(amplitude);
        this.waveformBufferCount = 0;
        this.waveform.add(Float.valueOf(normalized));
        RecordingState state = (RecordingState)this.recordingState.getValue();
        if (state instanceof RecordingState.Recording) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$v = false;
            if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.VERBOSE;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[processWave] waveform.size(" + normalized + "): " + this.waveform.size();
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            this.recordingState.setValue((Object)RecordingStateKt.copy$default((RecordingState.Recording)state, 0, new ArrayList(this.waveform), 1, null));
        }
    }

    public final void startRecording() {
        RecordingState state = (RecordingState)this.recordingState.getValue();
        if (!(state instanceof RecordingState.Idle)) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[startRecording] rejected (state is not Idle): " + state;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            return;
        }
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string4 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string5 = "[startRecording] state: " + state;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string4, (String)string5, null, (int)8, null);
        }
        String recordingName = "audio_recording_" + new Date();
        StreamMediaRecorder.DefaultImpls.startAudioRecording$default(this.mediaRecorder, recordingName, this.realPollingInterval, false, 4, null);
        this.recordingState.setValue((Object)new RecordingState.Hold(0, null, 3, null));
    }

    public final void lockRecording() {
        RecordingState state = (RecordingState)this.recordingState.getValue();
        if (!(state instanceof RecordingState.Hold)) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[lockRecording] rejected (state is not Hold): " + state;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            return;
        }
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string4 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string5 = "[lockRecording] state: " + state;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string4, (String)string5, null, (int)8, null);
        }
        this.recordingState.setValue((Object)new RecordingState.Locked(((RecordingState.Hold)state).getDurationInMs(), ((RecordingState.Hold)state).getWaveform()));
    }

    public final void cancelRecording() {
        RecordingState state = (RecordingState)this.recordingState.getValue();
        if (state instanceof RecordingState.Idle) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[cancelRecording] rejected (state is not Idle)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            return;
        }
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string4 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string5 = "[cancelRecording] state: " + state;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string4, (String)string5, null, (int)8, null);
        }
        this.mediaRecorder.release();
        this.clearData();
        this.recordingState.setValue((Object)RecordingState.Idle.INSTANCE);
    }

    public final void toggleRecordingPlayback() {
        boolean $i$f$v;
        Object object;
        StreamLogger streamLogger;
        Priority priority;
        String string2;
        RecordingState state = (RecordingState)this.recordingState.getValue();
        if (!(state instanceof RecordingState.Overview)) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string3 = this_$iv.getTag();
                Priority priority2 = Priority.WARN;
                StreamLogger streamLogger2 = this_$iv.getDelegate();
                boolean bl = false;
                String string4 = "[toggleRecordingPlayback] rejected (state is not Locked): " + state;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger2, (Priority)priority2, (String)string3, (String)string4, null, (int)8, null);
            }
            return;
        }
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            string2 = this_$iv.getTag();
            priority = Priority.INFO;
            streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            object = "[toggleRecordingPlayback] state: " + state;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)object, null, (int)8, null);
        }
        File file = ((RecordingState.Overview)state).getAttachment().getUpload();
        if (file == null) {
            AudioRecordingController $this$toggleRecordingPlayback_u24lambda_u2423 = this;
            boolean bl = false;
            TaggedLogger this_$iv2 = $this$toggleRecordingPlayback_u24lambda_u2423.logger;
            boolean $i$f$w = false;
            if (this_$iv2.getValidator().isLoggable(Priority.WARN, this_$iv2.getTag())) {
                String string5 = this_$iv2.getTag();
                Priority priority3 = Priority.WARN;
                StreamLogger streamLogger3 = this_$iv2.getDelegate();
                boolean bl2 = false;
                String string6 = "[toggleRecordingPlayback] rejected (audioFile is null)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger3, (Priority)priority3, (String)string5, (String)string6, null, (int)8, null);
            }
            return;
        }
        File audioFile = file;
        if (((RecordingState.Overview)state).isPlaying()) {
            TaggedLogger this_$iv3 = this.logger;
            $i$f$v = false;
            if (this_$iv3.getValidator().isLoggable(Priority.VERBOSE, this_$iv3.getTag())) {
                string2 = this_$iv3.getTag();
                priority = Priority.VERBOSE;
                streamLogger = this_$iv3.getDelegate();
                boolean bl = false;
                object = "[toggleRecordingPlayback] pause playback";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)object, null, (int)8, null);
            }
            this.audioPlayer.pause();
            this.recordingState.setValue((Object)RecordingState.Overview.copy$default((RecordingState.Overview)state, 0, null, null, false, 0.0f, 0, 55, null));
            return;
        }
        if (((RecordingState.Overview)state).getPlayingId() != -1) {
            TaggedLogger this_$iv4 = this.logger;
            $i$f$v = false;
            if (this_$iv4.getValidator().isLoggable(Priority.VERBOSE, this_$iv4.getTag())) {
                string2 = this_$iv4.getTag();
                priority = Priority.VERBOSE;
                streamLogger = this_$iv4.getDelegate();
                boolean bl = false;
                object = "[toggleRecordingPlayback] resume playback";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)object, null, (int)8, null);
            }
            this.audioPlayer.resume(((RecordingState.Overview)state).getPlayingId());
            this.recordingState.setValue((Object)RecordingState.Overview.copy$default((RecordingState.Overview)state, 0, null, null, true, 0.0f, 0, 55, null));
            return;
        }
        TaggedLogger this_$iv5 = this.logger;
        $i$f$v = false;
        if (this_$iv5.getValidator().isLoggable(Priority.VERBOSE, this_$iv5.getTag())) {
            string2 = this_$iv5.getTag();
            priority = Priority.VERBOSE;
            streamLogger = this_$iv5.getDelegate();
            boolean bl = false;
            object = "[toggleRecordingPlayback] start playback";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)object, null, (int)8, null);
        }
        int hash = audioFile.hashCode();
        this.audioPlayer.registerOnProgressStateChange(hash, (Function1)new Function1<ProgressData, Unit>((Object)this){

            public final void invoke(@NotNull ProgressData p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AudioRecordingController.access$onAudioPlayingProgress((AudioRecordingController)this.receiver, p0);
            }
        });
        this.audioPlayer.registerOnAudioStateChange(hash, (Function1)new Function1<AudioState, Unit>((Object)this){

            public final void invoke(@NotNull AudioState p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                AudioRecordingController.access$onAudioStateChanged((AudioRecordingController)this.receiver, p0);
            }
        });
        this.audioPlayer.play((String)this.fileToUri.invoke((Object)audioFile), hash);
        this.recordingState.setValue((Object)RecordingState.Overview.copy$default((RecordingState.Overview)state, 0, null, null, true, 0.0f, hash, 23, null));
    }

    private final void onAudioStateChanged(AudioState playbackState) {
        float f;
        RecordingState state = (RecordingState)this.recordingState.getValue();
        if (!(state instanceof RecordingState.Overview)) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$d = false;
            if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.DEBUG;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[onAudioStateChanged] rejected (state is not Overview): " + state;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            return;
        }
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string4 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string5 = "[onAudioStateChanged] playbackState: " + playbackState;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string4, (String)string5, null, (int)8, null);
        }
        RecordingState.Overview overview = (RecordingState.Overview)state;
        boolean bl = playbackState == AudioState.PLAYING;
        switch (WhenMappings.$EnumSwitchMapping$0[playbackState.ordinal()]) {
            case 1: 
            case 2: {
                f = ((RecordingState.Overview)state).getPlayingProgress();
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        this.recordingState.setValue((Object)RecordingState.Overview.copy$default(overview, 0, null, null, bl, f, 0, 39, null));
    }

    private final void onAudioPlayingProgress(ProgressData progressState) {
        RecordingState curState = (RecordingState)this.recordingState.getValue();
        if (curState instanceof RecordingState.Overview) {
            RecordingState.Overview overview = (RecordingState.Overview)curState;
            float f = progressState.getProgress();
            int n = progressState.getDuration();
            this.recordingState.setValue((Object)RecordingState.Overview.copy$default(overview, n, null, null, true, f, 0, 38, null));
        }
    }

    public final void stopRecording() {
        TaggedLogger result;
        String string2;
        StreamLogger streamLogger;
        Priority priority;
        String string3;
        RecordingState state = (RecordingState)this.recordingState.getValue();
        if (!(state instanceof RecordingState.Locked)) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string4 = this_$iv.getTag();
                Priority priority2 = Priority.WARN;
                StreamLogger streamLogger2 = this_$iv.getDelegate();
                boolean bl = false;
                String string5 = "[stopRecording] rejected (state is not Locked): " + state;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger2, (Priority)priority2, (String)string4, (String)string5, null, (int)8, null);
            }
            return;
        }
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            string3 = this_$iv.getTag();
            priority = Priority.INFO;
            streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            string2 = "[stopRecording] no args: " + state;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
        }
        TaggedLogger this_$iv2 = result = this.mediaRecorder.stopRecording();
        boolean $i$f$isFailure = false;
        if (this_$iv2 instanceof Result.Failure) {
            this_$iv2 = this.logger;
            boolean $i$f$e = false;
            if (this_$iv2.getValidator().isLoggable(Priority.ERROR, this_$iv2.getTag())) {
                string3 = this_$iv2.getTag();
                priority = Priority.ERROR;
                streamLogger = this_$iv2.getDelegate();
                boolean bl = false;
                string2 = "[stopRecording] failed: " + result.errorOrNull();
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
            }
            this.clearData();
            this.recordingState.setValue((Object)RecordingState.Idle.INSTANCE);
            return;
        }
        List<Integer> adjusted = this.downsampleMax((List<Integer>)this.samples, this.samplesTarget);
        List<Float> normalized = this.normalize(adjusted);
        this.clearData();
        RecordedMedia recorded = (RecordedMedia)result.getOrThrow();
        TaggedLogger this_$iv3 = this.logger;
        boolean $i$f$v = false;
        if (this_$iv3.getValidator().isLoggable(Priority.VERBOSE, this_$iv3.getTag())) {
            string3 = this_$iv3.getTag();
            priority = Priority.VERBOSE;
            streamLogger = this_$iv3.getDelegate();
            boolean bl = false;
            string2 = "[stopRecording] recorded: " + recorded;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
        }
        this.recordingState.setValue((Object)new RecordingState.Overview(recorded.getDurationInMs(), normalized, recorded.getAttachment(), false, 0.0f, 0, 56, null));
    }

    public final void seekRecordingTo(float progress) {
        RecordingState state = (RecordingState)this.recordingState.getValue();
        if (!(state instanceof RecordingState.Overview)) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[seekRecordingTo] rejected (state is not Overview)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            return;
        }
        File file = ((RecordingState.Overview)state).getAttachment().getUpload();
        if (file == null) {
            AudioRecordingController $this$seekRecordingTo_u24lambda_u2435 = this;
            boolean bl = false;
            TaggedLogger this_$iv = $this$seekRecordingTo_u24lambda_u2435.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string4 = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl2 = false;
                String string5 = "[seekRecordingTo] rejected (audioFile is null)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string4, (String)string5, null, (int)8, null);
            }
            return;
        }
        File audioFile = file;
        int positionInMs = (int)(progress * (float)((RecordingState.Overview)state).getDurationInMs());
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string6 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string7 = "[seekRecordingTo] progress: " + progress + " (" + positionInMs + "ms), state: " + state;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string6, (String)string7, null, (int)8, null);
        }
        int hash = audioFile.hashCode();
        this.audioPlayer.seekTo(positionInMs, hash);
        this.recordingState.setValue((Object)RecordingState.Overview.copy$default((RecordingState.Overview)state, 0, null, null, false, progress, hash, 15, null));
    }

    public final void pauseRecording() {
        RecordingState state = (RecordingState)this.recordingState.getValue();
        if (!(state instanceof RecordingState.Overview)) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[pauseRecording] rejected (state is not Overview)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            return;
        }
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string4 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string5 = "[pauseRecording] state: " + state;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string4, (String)string5, null, (int)8, null);
        }
        this.audioPlayer.startSeek(((RecordingState.Overview)state).getPlayingId());
        this.recordingState.setValue((Object)RecordingState.Overview.copy$default((RecordingState.Overview)state, 0, null, null, false, 0.0f, 0, 55, null));
    }

    public final void completeRecording() {
        TaggedLogger result;
        Object object;
        StreamLogger streamLogger;
        Priority priority;
        String string2;
        RecordingState state = (RecordingState)this.recordingState.getValue();
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$w = false;
        if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
            string2 = this_$iv.getTag();
            priority = Priority.WARN;
            streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            object = "[completeRecording] state: " + state;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)object, null, (int)8, null);
        }
        if (state instanceof RecordingState.Idle) {
            this_$iv = this.logger;
            $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                string2 = this_$iv.getTag();
                priority = Priority.WARN;
                streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                object = "[completeRecording] rejected (state is Idle)";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)object, null, (int)8, null);
            }
            return;
        }
        if (state instanceof RecordingState.Overview) {
            this_$iv = this.logger;
            boolean $i$f$d = false;
            if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                string2 = this_$iv.getTag();
                priority = Priority.DEBUG;
                streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                object = "[completeRecording] completing from Overview state";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)object, null, (int)8, null);
            }
            this.audioPlayer.resetAudio(((RecordingState.Overview)state).getPlayingId());
            this.clearData();
            this.recordingState.setValue((Object)new RecordingState.Complete(Attachment.copy$default((Attachment)((RecordingState.Overview)state).getAttachment(), null, null, null, null, null, null, null, null, (int)0, null, null, null, null, null, null, null, null, null, null, null, (Map)MapsKt.plus((Map)((RecordingState.Overview)state).getAttachment().getExtraData(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"waveform_data", ((RecordingState.Overview)state).getWaveform()))), (int)1048575, null)));
            this.recordingState.setValue((Object)RecordingState.Idle.INSTANCE);
            return;
        }
        TaggedLogger this_$iv2 = result = this.mediaRecorder.stopRecording();
        boolean $i$f$isFailure = false;
        if (this_$iv2 instanceof Result.Failure) {
            this_$iv2 = this.logger;
            boolean $i$f$e = false;
            if (this_$iv2.getValidator().isLoggable(Priority.ERROR, this_$iv2.getTag())) {
                string2 = this_$iv2.getTag();
                priority = Priority.ERROR;
                streamLogger = this_$iv2.getDelegate();
                boolean bl = false;
                object = "[completeRecording] failed: " + result.errorOrNull();
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)object, null, (int)8, null);
            }
            this.clearData();
            this.recordingState.setValue((Object)RecordingState.Idle.INSTANCE);
            return;
        }
        List<Integer> adjusted = this.downsampleMax((List<Integer>)this.samples, this.samplesTarget);
        List<Float> normalized = this.normalize(adjusted);
        this.clearData();
        RecordedMedia it = (RecordedMedia)result.getOrThrow();
        boolean bl = false;
        RecordedMedia recorded = RecordedMedia.copy$default(it, 0, Attachment.copy$default((Attachment)it.getAttachment(), null, null, null, null, null, null, null, null, (int)0, null, null, null, null, null, null, null, null, null, null, null, (Map)MapsKt.plus((Map)it.getAttachment().getExtraData(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"waveform_data", normalized))), (int)1048575, null), 1, null);
        TaggedLogger this_$iv3 = this.logger;
        boolean $i$f$d = false;
        if (this_$iv3.getValidator().isLoggable(Priority.DEBUG, this_$iv3.getTag())) {
            string2 = this_$iv3.getTag();
            priority = Priority.DEBUG;
            streamLogger = this_$iv3.getDelegate();
            boolean bl2 = false;
            object = "[completeRecording] complete from state: " + state;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)object, null, (int)8, null);
        }
        this.recordingState.setValue((Object)new RecordingState.Complete(recorded.getAttachment()));
        this.recordingState.setValue((Object)RecordingState.Idle.INSTANCE);
    }

    public final void onCleared() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onCleared] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.mediaRecorder.release();
        RecordingState state = (RecordingState)this.recordingState.getValue();
        if (state instanceof RecordingState.Overview) {
            this.audioPlayer.resetAudio(((RecordingState.Overview)state).getPlayingId());
        }
        this.clearData();
    }

    private final void clearData() {
        TaggedLogger this_$iv = this.logger;
        boolean $i$f$v = false;
        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.VERBOSE;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[clearData] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        this.waveform.clear();
        ArraysKt.fill$default((int[])this.waveformBuffer, (int)0, (int)0, (int)0, (int)6, null);
        this.waveformBufferCount = 0;
        this.samples.clear();
        this.samplesBuffer.clear();
        this.samplesBufferLimit = 1;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Float> normalize(List<Integer> $this$normalize) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$normalize;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void amplitude;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(this.normalize((int)amplitude)));
        }
        return (List)destination$iv$iv;
    }

    private final float normalize(int maxAmplitude) {
        float normalized = (float)maxAmplitude / (float)Short.MAX_VALUE;
        float MAX_AMPLITUDE = 32767.0f;
        double MAX_DB = 90.0;
        float decibels = (float)20 * (float)Math.log10((float)maxAmplitude / MAX_AMPLITUDE);
        float normalizedValue = Math.abs(((float)50 + decibels) / (float)50);
        if (maxAmplitude > 20000) {
            TaggedLogger this_$iv = this.logger;
            boolean $i$f$w = false;
            if (this_$iv.getValidator().isLoggable(Priority.WARN, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.WARN;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[normalize] normalizedValue: " + normalizedValue + ", maxAmplitude: " + maxAmplitude;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
        }
        if (normalizedValue == Float.NEGATIVE_INFINITY || normalizedValue == Float.POSITIVE_INFINITY) {
            return 0.0f;
        }
        return normalizedValue;
    }

    private final List<Float> downsample(List<Float> $this$downsample, int targetSamples) {
        int sourceSamples = $this$downsample.size();
        int sourceStep = sourceSamples / targetSamples;
        ArrayList<Float> target = new ArrayList<Float>(targetSamples);
        for (int targetIndex = 0; targetIndex < targetSamples; ++targetIndex) {
            float sum = 0.0f;
            for (int sourceIndex = 0; sourceIndex < sourceStep; ++sourceIndex) {
                float sourceSample = ((Number)$this$downsample.get(targetIndex * sourceStep + sourceIndex)).floatValue();
                sum += (float)Math.pow(sourceSample, 2);
            }
            target.add(Float.valueOf((float)Math.sqrt(sum / (float)sourceStep)));
        }
        return target;
    }

    private final List<Integer> downsampleMax(List<Integer> $this$downsampleMax, int targetSamples) {
        int sourceSamples = $this$downsampleMax.size();
        int sourceStep = sourceSamples / targetSamples;
        ArrayList<Integer> target = new ArrayList<Integer>(targetSamples);
        for (int targetIndex = 0; targetIndex < targetSamples; ++targetIndex) {
            int max = 0;
            for (int sourceIndex = 0; sourceIndex < sourceStep; ++sourceIndex) {
                int sourceSample = ((Number)$this$downsampleMax.get(targetIndex * sourceStep + sourceIndex)).intValue();
                max = Math.max(max, sourceSample);
            }
            target.add(max);
        }
        return target;
    }

    private final float downsampleRms(float[] $this$downsampleRms) {
        float sumOfSquaredSamples = 0.0f;
        int n = $this$downsampleRms.length;
        for (int i = 0; i < n; ++i) {
            float sample = $this$downsampleRms[i];
            sumOfSquaredSamples += (float)Math.pow(sample, 2);
        }
        return (float)Math.sqrt(sumOfSquaredSamples / (float)$this$downsampleRms.length);
    }

    private final float downsampleAverage(float[] $this$downsampleAverage) {
        return ArraysKt.sum((float[])$this$downsampleAverage) / (float)$this$downsampleAverage.length;
    }

    private final float downsample(float[] $this$downsample) {
        return ArraysKt.last((float[])$this$downsample);
    }

    private final int downsampleRms(int[] $this$downsampleRms) {
        int sumOfSquaredSamples = 0;
        int n = $this$downsampleRms.length;
        for (int i = 0; i < n; ++i) {
            int sample = $this$downsampleRms[i];
            sumOfSquaredSamples += sample * sample;
        }
        if (sumOfSquaredSamples == 0) {
            return 0;
        }
        return MathKt.roundToInt((double)Math.sqrt((double)sumOfSquaredSamples / (double)$this$downsampleRms.length));
    }

    private final int downsampleMax(int[] $this$downsampleMax) {
        return ArraysKt.maxOrThrow((int[])$this$downsampleMax);
    }

    private final int downsampleToSingleMax(List<Integer> $this$downsampleToSingleMax) {
        return ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)$this$downsampleToSingleMax))).intValue();
    }

    private static final void setupMediaRecorder$lambda$1(AudioRecordingController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TaggedLogger this_$iv = this$0.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onRecorderStarted] no args";
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
    }

    private static final void setupMediaRecorder$lambda$3(AudioRecordingController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TaggedLogger this_$iv = this$0.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onRecorderStopped] recordingState: " + this$0.recordingState.getValue();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
    }

    private static final void setupMediaRecorder$lambda$5(AudioRecordingController this$0, MediaRecorderState state) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        TaggedLogger this_$iv = this$0.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onRecorderStateChanged] state: " + state + "; recordingState: " + this$0.recordingState.getValue();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
    }

    private static final void setupMediaRecorder$lambda$7(AudioRecordingController this$0, StreamMediaRecorder streamMediaRecorder, int what, int extra) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)streamMediaRecorder, (String)"<anonymous parameter 0>");
        TaggedLogger this_$iv = this$0.logger;
        boolean $i$f$e = false;
        if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.ERROR;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onRecorderError] what: " + what + ", extra: " + extra;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
    }

    private static final void setupMediaRecorder$lambda$9(AudioRecordingController this$0, StreamMediaRecorder streamMediaRecorder, int what, int extra) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)streamMediaRecorder, (String)"<anonymous parameter 0>");
        TaggedLogger this_$iv = this$0.logger;
        boolean $i$f$i = false;
        if (this_$iv.getValidator().isLoggable(Priority.INFO, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.INFO;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[onRecorderInfo] what: " + what + ", extra: " + extra;
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
    }

    private static final void setupMediaRecorder$lambda$10(AudioRecordingController this$0, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BuildersKt.launch$default((CoroutineScope)this$0.scope, (CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, durationMs, null){
            int label;
            final /* synthetic */ AudioRecordingController this$0;
            final /* synthetic */ long $durationMs;
            {
                this.this$0 = $receiver;
                this.$durationMs = $durationMs;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void this_$iv;
                        ResultKt.throwOnFailure((Object)object);
                        RecordingState state = (RecordingState)this.this$0.getRecordingState().getValue();
                        TaggedLogger taggedLogger = AudioRecordingController.access$getLogger$p(this.this$0);
                        long l = this.$durationMs;
                        boolean $i$f$v = false;
                        if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
                            String string2 = this_$iv.getTag();
                            Priority priority = Priority.VERBOSE;
                            StreamLogger streamLogger = this_$iv.getDelegate();
                            boolean bl = false;
                            String string3 = "[onRecorderDurationChanged] duration: " + l + ", state: " + state;
                            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                        }
                        if (state instanceof RecordingState.Recording) {
                            this.this$0.getRecordingState().setValue((Object)RecordingStateKt.copy$default((RecordingState.Recording)state, (int)this.$durationMs, null, 2, null));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private static final void setupMediaRecorder$lambda$11(AudioRecordingController this$0, int maxAmplitude) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        BuildersKt.launch$default((CoroutineScope)this$0.scope, (CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, maxAmplitude, null){
            int label;
            final /* synthetic */ AudioRecordingController this$0;
            final /* synthetic */ int $maxAmplitude;
            {
                this.this$0 = $receiver;
                this.$maxAmplitude = $maxAmplitude;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        AudioRecordingController.access$saveSamples(this.this$0, this.$maxAmplitude);
                        AudioRecordingController.access$processWave(this.this$0, this.$maxAmplitude);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public static final /* synthetic */ void access$onAudioPlayingProgress(AudioRecordingController $this, ProgressData progressState) {
        $this.onAudioPlayingProgress(progressState);
    }

    public static final /* synthetic */ void access$onAudioStateChanged(AudioRecordingController $this, AudioState playbackState) {
        $this.onAudioStateChanged(playbackState);
    }

    public static final /* synthetic */ TaggedLogger access$getLogger$p(AudioRecordingController $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$saveSamples(AudioRecordingController $this, int maxAmplitude) {
        $this.saveSamples(maxAmplitude);
    }

    public static final /* synthetic */ void access$processWave(AudioRecordingController $this, int maxAmplitude) {
        $this.processWave(maxAmplitude);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AudioState.values().length];
            try {
                nArray[AudioState.PLAYING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioState.PAUSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

