/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.feature.messages.composer.mention;

import androidx.compose.runtime.internal.StabilityInferred;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.channel.state.ChannelState;
import io.getstream.chat.android.client.extensions.StringExtensionsKt;
import io.getstream.chat.android.models.Member;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.state.extensions.ChatClientExtensions;
import io.getstream.chat.android.ui.common.feature.messages.composer.mention.UserLookupHandler;
import io.getstream.chat.android.ui.common.feature.messages.composer.query.filter.DefaultQueryFilter;
import io.getstream.chat.android.ui.common.feature.messages.composer.query.filter.QueryFilter;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lio/getstream/chat/android/ui/common/feature/messages/composer/mention/LocalUserLookupHandler;", "Lio/getstream/chat/android/ui/common/feature/messages/composer/mention/UserLookupHandler;", "chatClient", "Lio/getstream/chat/android/client/ChatClient;", "channelCid", "", "filter", "Lio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/QueryFilter;", "Lio/getstream/chat/android/models/User;", "(Lio/getstream/chat/android/client/ChatClient;Ljava/lang/String;Lio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/QueryFilter;)V", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "handleUserLookup", "", "query", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLocalUserLookupHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalUserLookupHandler.kt\nio/getstream/chat/android/ui/common/feature/messages/composer/mention/LocalUserLookupHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StreamLog.kt\nio/getstream/log/TaggedLogger\n*L\n1#1,68:1\n1549#2:69\n1620#2,3:70\n259#3,4:73\n*S KotlinDebug\n*F\n+ 1 LocalUserLookupHandler.kt\nio/getstream/chat/android/ui/common/feature/messages/composer/mention/LocalUserLookupHandler\n*L\n47#1:69\n47#1:70,3\n59#1:73,4\n*E\n"})
public final class LocalUserLookupHandler
implements UserLookupHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatClient chatClient;
    @NotNull
    private final String channelCid;
    @NotNull
    private final QueryFilter<User> filter;
    @NotNull
    private final Lazy logger$delegate;
    public static final int $stable = 8;
    private static final boolean DEBUG = false;

    @JvmOverloads
    public LocalUserLookupHandler(@NotNull ChatClient chatClient, @NotNull String channelCid, @NotNull QueryFilter<User> filter2) {
        Intrinsics.checkNotNullParameter((Object)chatClient, (String)"chatClient");
        Intrinsics.checkNotNullParameter((Object)channelCid, (String)"channelCid");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        this.chatClient = chatClient;
        this.channelCid = channelCid;
        this.filter = filter2;
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)this, (String)"Chat:UserLookupLocal");
    }

    public /* synthetic */ LocalUserLookupHandler(ChatClient chatClient, String string2, QueryFilter queryFilter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            queryFilter = new DefaultQueryFilter(null, 1.INSTANCE, 1, null);
        }
        this(chatClient, string2, queryFilter);
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object handleUserLookup(@NotNull String query, @NotNull Continuation<? super List<User>> $completion) {
        try {
            List<User> list;
            void $this$mapTo$iv$iv;
            Pair pair = StringExtensionsKt.cidToTypeAndId((String)this.channelCid);
            String channelType = (String)pair.component1();
            String channelId = (String)pair.component2();
            ChannelState channelState = ChatClientExtensions.getState((ChatClient)this.chatClient).channel(channelType, channelId);
            List<User> $this$map$iv = (List<User>)channelState.getMembers().getValue();
            boolean $i$f$map = false;
            List<User> list2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Member member = (Member)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getUser());
            }
            List localUsers = (List)destination$iv$iv;
            int membersCount = ((Number)channelState.getMembersCount().getValue()).intValue();
            if (membersCount == localUsers.size()) {
                List<User> it = list2 = this.filter.filter(localUsers, query);
                boolean bl = false;
                list = list2;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        catch (Exception e) {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[handleUserLookup] failed: " + e;
                streamLogger.log(priority, string2, string3, (Throwable)e);
            }
            return CollectionsKt.emptyList();
        }
    }

    @JvmOverloads
    public LocalUserLookupHandler(@NotNull ChatClient chatClient, @NotNull String channelCid) {
        Intrinsics.checkNotNullParameter((Object)chatClient, (String)"chatClient");
        Intrinsics.checkNotNullParameter((Object)channelCid, (String)"channelCid");
        this(chatClient, channelCid, null, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/common/feature/messages/composer/mention/LocalUserLookupHandler$Companion;", "", "()V", "DEBUG", "", "stream-chat-android-ui-common_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

