/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.feature.messages.composer.query.filter;

import androidx.compose.runtime.internal.StabilityInferred;
import io.getstream.chat.android.ui.common.feature.messages.composer.query.filter.DefaultQueryFilter;
import io.getstream.chat.android.ui.common.feature.messages.composer.query.filter.QueryFilter;
import io.getstream.chat.android.ui.common.feature.messages.composer.query.formatter.Combine;
import io.getstream.chat.android.ui.common.feature.messages.composer.query.formatter.IgnoreDiacritics;
import io.getstream.chat.android.ui.common.feature.messages.composer.query.formatter.Lowercase;
import io.getstream.chat.android.ui.common.feature.messages.composer.query.formatter.QueryFormatter;
import io.getstream.chat.android.ui.common.feature.messages.composer.query.formatter.Transliterate;
import io.getstream.chat.android.ui.common.feature.messages.composer.transliteration.DefaultStreamTransliterator;
import io.getstream.chat.android.ui.common.feature.messages.composer.transliteration.StreamTransliterator;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u001e\u001fB#\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0007H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0007H\u0002J\u001f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b*\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001dR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/DefaultQueryFilter;", "T", "Lio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/QueryFilter;", "transliterator", "Lio/getstream/chat/android/ui/common/feature/messages/composer/transliteration/StreamTransliterator;", "target", "Lkotlin/Function1;", "", "(Lio/getstream/chat/android/ui/common/feature/messages/composer/transliteration/StreamTransliterator;Lkotlin/jvm/functions/Function1;)V", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "queryFormatter", "Lio/getstream/chat/android/ui/common/feature/messages/composer/query/formatter/QueryFormatter;", "filter", "", "items", "query", "levenshteinDistance", "", "search", "minLevenshteinDistance", "wordLevenshteinDistance", "measureDistance", "Lio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/DefaultQueryFilter$MeasuredItem;", "formattedQuery", "(Ljava/lang/Object;Ljava/lang/String;)Lio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/DefaultQueryFilter$MeasuredItem;", "Companion", "MeasuredItem", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDefaultQueryFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultQueryFilter.kt\nio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/DefaultQueryFilter\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n*L\n1#1,164:1\n303#2,4:165\n314#2,4:169\n259#2,4:173\n*S KotlinDebug\n*F\n+ 1 DefaultQueryFilter.kt\nio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/DefaultQueryFilter\n*L\n54#1:165,4\n68#1:169,4\n120#1:173,4\n*E\n"})
public final class DefaultQueryFilter<T>
implements QueryFilter<T> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final StreamTransliterator transliterator;
    @NotNull
    private final Function1<T, String> target;
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final QueryFormatter queryFormatter;
    public static final int $stable = 8;
    private static final int MAX_DISTANCE = 3;
    private static final char SPACE = ' ';

    public DefaultQueryFilter(@NotNull StreamTransliterator transliterator, @NotNull Function1<? super T, String> target) {
        Intrinsics.checkNotNullParameter((Object)transliterator, (String)"transliterator");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        this.transliterator = transliterator;
        this.target = target;
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)this, (String)"Chat:InputQueryFilter");
        QueryFormatter[] queryFormatterArray = new QueryFormatter[]{new Lowercase(), new IgnoreDiacritics(), new Transliterate(this.transliterator)};
        this.queryFormatter = new Combine(queryFormatterArray);
    }

    public /* synthetic */ DefaultQueryFilter(StreamTransliterator streamTransliterator, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            streamTransliterator = new DefaultStreamTransliterator(null, 1, null);
        }
        this(streamTransliterator, function1);
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    @Override
    @NotNull
    public List<T> filter(@NotNull List<? extends T> items, @NotNull String query) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        TaggedLogger this_$iv = this.getLogger();
        boolean $i$f$d = false;
        if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
            String string2 = this_$iv.getTag();
            Priority priority = Priority.DEBUG;
            StreamLogger streamLogger = this_$iv.getDelegate();
            boolean bl = false;
            String string3 = "[filter] query: \"" + query + "\", items.size: " + items.size();
            StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
        }
        String formattedQuery = this.queryFormatter.format(query);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)SequencesKt.sorted((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)items), (Function1)new Function1<T, MeasuredItem<T>>(this, formattedQuery){
            final /* synthetic */ DefaultQueryFilter<T> this$0;
            final /* synthetic */ String $formattedQuery;
            {
                this.this$0 = $receiver;
                this.$formattedQuery = $formattedQuery;
                super(1);
            }

            @NotNull
            public final MeasuredItem<T> invoke(T it) {
                return DefaultQueryFilter.access$measureDistance(this.this$0, it, this.$formattedQuery);
            }
        }), (Function1)filter.3.INSTANCE)), (Function1)new Function1<MeasuredItem<T>, Unit>(this){
            final /* synthetic */ DefaultQueryFilter<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull MeasuredItem<T> it) {
                void this_$iv;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                TaggedLogger taggedLogger = DefaultQueryFilter.access$getLogger(this.this$0);
                DefaultQueryFilter<T> defaultQueryFilter = this.this$0;
                boolean $i$f$v = false;
                if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
                    String string2 = this_$iv.getTag();
                    Priority priority = Priority.VERBOSE;
                    StreamLogger streamLogger = this_$iv.getDelegate();
                    boolean bl = false;
                    String string3 = "[filter] target: \"" + DefaultQueryFilter.access$getTarget$p(defaultQueryFilter).invoke(it.getItem()) + "\", distance: " + it.getDistance();
                    StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
                }
            }
        }), (Function1)filter.5.INSTANCE));
    }

    private final MeasuredItem<T> measureDistance(T $this$measureDistance, String formattedQuery) {
        int n;
        String target = (String)this.target.invoke($this$measureDistance);
        if (((CharSequence)target).length() == 0 || formattedQuery.length() > target.length()) {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$v = false;
            if (this_$iv.getValidator().isLoggable(Priority.VERBOSE, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.VERBOSE;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[measureDistance] #skip; target: \"" + target + "\", formattedQuery: \"" + formattedQuery + "\"";
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            return new MeasuredItem<T>($this$measureDistance, Integer.MAX_VALUE);
        }
        String formattedTarget = this.queryFormatter.format(target);
        if (StringsKt.contains((CharSequence)formattedTarget, (CharSequence)formattedQuery, (boolean)true)) {
            n = 0;
        } else {
            String string4;
            if (formattedTarget.length() > formattedQuery.length()) {
                String string5 = formattedTarget.substring(0, formattedQuery.length());
                string4 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            } else {
                string4 = formattedTarget;
            }
            String finalTarget = string4;
            n = this.levenshteinDistance(formattedQuery, finalTarget);
        }
        int distance = n;
        return new MeasuredItem<T>($this$measureDistance, distance);
    }

    private final int minLevenshteinDistance(String search, String target) {
        int totalDistance = this.levenshteinDistance(search, target);
        int wordDistance = this.wordLevenshteinDistance(search, target);
        return Math.min(totalDistance, wordDistance);
    }

    private final int wordLevenshteinDistance(String search, String target) {
        try {
            if (((CharSequence)search).length() == 0 || ((CharSequence)target).length() == 0) {
                return Integer.MAX_VALUE;
            }
            int distance = Integer.MAX_VALUE;
            int sStartIndex = 0;
            int tStartIndex = 0;
            while (true) {
                String subTarget;
                String string2;
                int n = sStartIndex;
                int sEndIndex = StringsKt.indexOf$default((CharSequence)search, (char)' ', (int)n, (boolean)false, (int)4, null);
                int n2 = tStartIndex;
                int tEndIndex = StringsKt.indexOf$default((CharSequence)target, (char)' ', (int)n2, (boolean)false, (int)4, null);
                if (tEndIndex == -1) break;
                if (sEndIndex == -1) {
                    string2 = search;
                } else {
                    String string3 = search.substring(sStartIndex, sEndIndex);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                }
                String subSearch = string2;
                Intrinsics.checkNotNullExpressionValue((Object)target.substring(tStartIndex, tEndIndex), (String)"substring(...)");
                int subDistance = this.levenshteinDistance(subSearch, subTarget);
                distance = Math.min(distance, subDistance);
                sStartIndex = sEndIndex + 1;
                tStartIndex = tEndIndex + 1;
            }
            return distance;
        }
        catch (Throwable e) {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string4 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string5 = "[wordLevenshteinDistance] failed: " + e;
                streamLogger.log(priority, string4, string5, e);
            }
            return Integer.MAX_VALUE;
        }
    }

    private final int levenshteinDistance(String search, String target) {
        if (Intrinsics.areEqual((Object)search, (Object)target)) {
            return 0;
        }
        if (((CharSequence)search).length() == 0) {
            return target.length();
        }
        if (((CharSequence)target).length() == 0) {
            return search.length();
        }
        int searchLength = search.length() + 1;
        int targetLength = target.length() + 1;
        int n = 0;
        Integer[] integerArray = new Integer[searchLength];
        while (n < searchLength) {
            int n2 = n++;
            integerArray[n2] = n2;
        }
        Integer[] cost = integerArray;
        int n3 = 0;
        Integer[] integerArray2 = new Integer[searchLength];
        while (n3 < searchLength) {
            int n4 = n3++;
            integerArray2[n4] = 0;
        }
        Integer[] newCost = integerArray2;
        for (int i = 1; i < targetLength; ++i) {
            newCost[0] = i;
            for (int j = 1; j < searchLength; ++j) {
                int match = search.charAt(j - 1) == target.charAt(i - 1) ? 0 : 1;
                int costReplace = cost[j - 1] + match;
                int costInsert = cost[j] + 1;
                int costDelete = newCost[j - 1] + 1;
                newCost[j] = Math.min(Math.min(costInsert, costDelete), costReplace);
            }
            Integer[] swap = cost;
            cost = newCost;
            newCost = swap;
        }
        return cost[searchLength - 1];
    }

    public static final /* synthetic */ MeasuredItem access$measureDistance(DefaultQueryFilter $this, Object $receiver, String formattedQuery) {
        return $this.measureDistance($receiver, formattedQuery);
    }

    public static final /* synthetic */ TaggedLogger access$getLogger(DefaultQueryFilter $this) {
        return $this.getLogger();
    }

    public static final /* synthetic */ Function1 access$getTarget$p(DefaultQueryFilter $this) {
        return $this.target;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/DefaultQueryFilter$Companion;", "", "()V", "MAX_DISTANCE", "", "SPACE", "", "stream-chat-android-ui-common_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0096\u0002J\u000e\u0010\u000e\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/DefaultQueryFilter$MeasuredItem;", "T", "", "item", "distance", "", "(Ljava/lang/Object;I)V", "getDistance", "()I", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "compareTo", "other", "component1", "component2", "copy", "(Ljava/lang/Object;I)Lio/getstream/chat/android/ui/common/feature/messages/composer/query/filter/DefaultQueryFilter$MeasuredItem;", "equals", "", "", "hashCode", "toString", "", "stream-chat-android-ui-common_release"})
    private static final class MeasuredItem<T>
    implements Comparable<MeasuredItem<T>> {
        private final T item;
        private final int distance;

        public MeasuredItem(T item, int distance) {
            this.item = item;
            this.distance = distance;
        }

        public final T getItem() {
            return this.item;
        }

        public final int getDistance() {
            return this.distance;
        }

        @Override
        public int compareTo(@NotNull MeasuredItem<T> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return Intrinsics.compare((int)this.distance, (int)other.distance);
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.distance;
        }

        @NotNull
        public final MeasuredItem<T> copy(T item, int distance) {
            return new MeasuredItem<T>(item, distance);
        }

        public static /* synthetic */ MeasuredItem copy$default(MeasuredItem measuredItem, Object object, int n, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                object = measuredItem.item;
            }
            if ((n2 & 2) != 0) {
                n = measuredItem.distance;
            }
            return measuredItem.copy(object, n);
        }

        @NotNull
        public String toString() {
            return "MeasuredItem(item=" + this.item + ", distance=" + this.distance + ")";
        }

        public int hashCode() {
            int result = this.item == null ? 0 : this.item.hashCode();
            result = result * 31 + Integer.hashCode(this.distance);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MeasuredItem)) {
                return false;
            }
            MeasuredItem measuredItem = (MeasuredItem)other;
            if (!Intrinsics.areEqual(this.item, measuredItem.item)) {
                return false;
            }
            return this.distance == measuredItem.distance;
        }
    }
}

