/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import androidx.annotation.RequiresApi;
import androidx.compose.runtime.internal.StabilityInferred;
import io.getstream.chat.android.ui.common.R;
import io.getstream.chat.android.ui.common.helper.DateFormatter;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 /2\u00020\u0001:\u0003/01B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010#\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010$\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0014\u0010%\u001a\u00020&*\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\f\u0010)\u001a\u00020&*\u00020\"H\u0002J\u0014\u0010*\u001a\u00020&*\u00020\"2\u0006\u0010+\u001a\u00020,H\u0002J\f\u0010-\u001a\u00020&*\u00020\"H\u0002J\f\u0010.\u001a\u00020&*\u00020\"H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\r8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\r8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0011\u001a\u0004\b\u0019\u0010\u000fR\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\r8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001d\u0010\u000f\u00a8\u00062"}, d2={"Lio/getstream/chat/android/ui/common/helper/DefaultDateFormatter;", "Lio/getstream/chat/android/ui/common/helper/DateFormatter;", "context", "Landroid/content/Context;", "locale", "Ljava/util/Locale;", "(Landroid/content/Context;Ljava/util/Locale;)V", "dateContext", "Lio/getstream/chat/android/ui/common/helper/DefaultDateFormatter$DateContext;", "(Lio/getstream/chat/android/ui/common/helper/DefaultDateFormatter$DateContext;Ljava/util/Locale;)V", "dateFormatterDayOfWeek", "Ljava/text/SimpleDateFormat;", "dateFormatterDayOfWeekNew", "Ljava/time/format/DateTimeFormatter;", "getDateFormatterDayOfWeekNew", "()Ljava/time/format/DateTimeFormatter;", "dateFormatterDayOfWeekNew$delegate", "Lkotlin/Lazy;", "dateFormatterFullDate", "getDateFormatterFullDate", "()Ljava/text/SimpleDateFormat;", "dateFormatterFullDateNew", "getDateFormatterFullDateNew", "timeFormatter12h", "timeFormatter12hNew", "getTimeFormatter12hNew", "timeFormatter12hNew$delegate", "timeFormatter24h", "timeFormatter24hNew", "getTimeFormatter24hNew", "timeFormatter24hNew$delegate", "formatDate", "", "date", "Ljava/util/Date;", "formatRelativeTime", "formatTime", "isBeforeDay", "", "Ljava/util/Calendar;", "calendar", "isToday", "isWithinDays", "days", "", "isWithinLastWeek", "isYesterday", "Companion", "DateContext", "DefaultDateContext", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDateFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateFormatter.kt\nio/getstream/chat/android/ui/common/helper/DefaultDateFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n1#2:293\n*E\n"})
public final class DefaultDateFormatter
implements DateFormatter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final DateContext dateContext;
    @NotNull
    private final Locale locale;
    @NotNull
    private final SimpleDateFormat timeFormatter12h;
    @NotNull
    private final SimpleDateFormat timeFormatter24h;
    @NotNull
    private final SimpleDateFormat dateFormatterDayOfWeek;
    @RequiresApi(value=26)
    @NotNull
    private final Lazy timeFormatter12hNew$delegate;
    @RequiresApi(value=26)
    @NotNull
    private final Lazy timeFormatter24hNew$delegate;
    @RequiresApi(value=26)
    @NotNull
    private final Lazy dateFormatterDayOfWeekNew$delegate;
    public static final int $stable = 8;
    @Deprecated
    @NotNull
    public static final String TIME_FORMAT_12H = "h:mm a";
    @Deprecated
    @NotNull
    public static final String TIME_FORMAT_24H = "HH:mm";
    @Deprecated
    @NotNull
    public static final String DATE_FORMAT_DAY_OF_WEEK = "EEEE";

    public DefaultDateFormatter(@NotNull DateContext dateContext, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)dateContext, (String)"dateContext");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.dateContext = dateContext;
        this.locale = locale;
        this.timeFormatter12h = new SimpleDateFormat(TIME_FORMAT_12H, this.locale);
        this.timeFormatter24h = new SimpleDateFormat(TIME_FORMAT_24H, this.locale);
        this.dateFormatterDayOfWeek = new SimpleDateFormat(DATE_FORMAT_DAY_OF_WEEK, this.locale);
        this.timeFormatter12hNew$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DateTimeFormatter>(this){
            final /* synthetic */ DefaultDateFormatter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DateTimeFormatter invoke() {
                return DateTimeFormatter.ofPattern("h:mm a").withLocale(DefaultDateFormatter.access$getLocale$p(this.this$0)).withZone(ZoneId.systemDefault());
            }
        }));
        this.timeFormatter24hNew$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DateTimeFormatter>(this){
            final /* synthetic */ DefaultDateFormatter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DateTimeFormatter invoke() {
                return DateTimeFormatter.ofPattern("HH:mm").withLocale(DefaultDateFormatter.access$getLocale$p(this.this$0)).withZone(ZoneId.systemDefault());
            }
        }));
        this.dateFormatterDayOfWeekNew$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DateTimeFormatter>(this){
            final /* synthetic */ DefaultDateFormatter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DateTimeFormatter invoke() {
                return DateTimeFormatter.ofPattern("EEEE").withLocale(DefaultDateFormatter.access$getLocale$p(this.this$0)).withZone(ZoneId.systemDefault());
            }
        }));
    }

    public DefaultDateFormatter(@NotNull Context context, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this(new DefaultDateContext(context, locale), locale);
    }

    private final SimpleDateFormat getDateFormatterFullDate() {
        return new SimpleDateFormat(this.dateContext.dateTimePattern(), this.locale);
    }

    private final DateTimeFormatter getTimeFormatter12hNew() {
        Lazy lazy = this.timeFormatter12hNew$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (DateTimeFormatter)object;
    }

    private final DateTimeFormatter getTimeFormatter24hNew() {
        Lazy lazy = this.timeFormatter24hNew$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (DateTimeFormatter)object;
    }

    private final DateTimeFormatter getDateFormatterDayOfWeekNew() {
        Lazy lazy = this.dateFormatterDayOfWeekNew$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (DateTimeFormatter)object;
    }

    @SuppressLint(value={"NewApi"})
    private final DateTimeFormatter getDateFormatterFullDateNew() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.dateContext.dateTimePattern()).withLocale(this.locale).withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        return dateTimeFormatter;
    }

    @Override
    @NotNull
    public String formatDate(@Nullable Date date) {
        String string2;
        if (date == null) {
            return "";
        }
        if (this.isToday(date)) {
            string2 = this.formatTime(date);
        } else if (this.isYesterday(date)) {
            string2 = this.dateContext.yesterdayString();
        } else if (this.isWithinLastWeek(date)) {
            String string3 = Build.VERSION.SDK_INT >= 26 ? this.getDateFormatterDayOfWeekNew().format(date.toInstant()) : this.dateFormatterDayOfWeek.format(date);
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        } else {
            String string4 = Build.VERSION.SDK_INT >= 26 ? this.getDateFormatterFullDateNew().format(date.toInstant()) : this.getDateFormatterFullDate().format(date);
            Intrinsics.checkNotNull((Object)string4);
            string2 = string4;
        }
        return string2;
    }

    @Override
    @NotNull
    public String formatTime(@Nullable Date date) {
        String string2;
        if (date == null) {
            return "";
        }
        if (Build.VERSION.SDK_INT >= 26) {
            DateTimeFormatter dateFormat = this.dateContext.is24Hour() ? this.getTimeFormatter24hNew() : this.getTimeFormatter12hNew();
            String string3 = dateFormat.format(date.toInstant());
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        } else {
            SimpleDateFormat dateFormat = this.dateContext.is24Hour() ? this.timeFormatter24h : this.timeFormatter12h;
            String string4 = dateFormat.format(date);
            Intrinsics.checkNotNull((Object)string4);
            string2 = string4;
        }
        return string2;
    }

    @Override
    @NotNull
    public String formatRelativeTime(@Nullable Date date) {
        if (date == null) {
            return "";
        }
        return ((Object)DateUtils.getRelativeDateTimeString((Context)this.dateContext.context(), (long)date.getTime(), (long)60000L, (long)604800000L, (int)0)).toString();
    }

    private final boolean isToday(Date $this$isToday) {
        Calendar calendar;
        Calendar calendar2;
        Calendar it = calendar2 = Calendar.getInstance();
        boolean bl = false;
        it.setTime(this.dateContext.now());
        Calendar calendar1 = calendar2;
        Calendar it2 = calendar = Calendar.getInstance();
        boolean bl2 = false;
        it2.setTime($this$isToday);
        Calendar calendar22 = calendar;
        return calendar1.get(1) == calendar22.get(1) && calendar1.get(6) == calendar22.get(6);
    }

    private final boolean isYesterday(Date $this$isYesterday) {
        return this.isToday(new Date($this$isYesterday.getTime() + 86400000L));
    }

    private final boolean isWithinLastWeek(Date $this$isWithinLastWeek) {
        return this.isWithinDays($this$isWithinLastWeek, 6);
    }

    private final boolean isWithinDays(Date $this$isWithinDays, int days) {
        Calendar calendar;
        Calendar calendar2;
        Calendar calendar3;
        Calendar it = calendar3 = Calendar.getInstance();
        boolean bl = false;
        it.setTime($this$isWithinDays);
        Calendar calendar4 = calendar3;
        Intrinsics.checkNotNullExpressionValue((Object)calendar4, (String)"also(...)");
        Calendar calendar5 = calendar4;
        Date currentDate = this.dateContext.now();
        Calendar it2 = calendar2 = Calendar.getInstance();
        boolean bl2 = false;
        it2.setTime(currentDate);
        it2.add(6, -days);
        Calendar calendar6 = calendar2;
        Intrinsics.checkNotNullExpressionValue((Object)calendar6, (String)"also(...)");
        Calendar start = calendar6;
        Calendar it3 = calendar = Calendar.getInstance();
        boolean bl3 = false;
        it3.setTime(currentDate);
        Calendar calendar7 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar7, (String)"also(...)");
        Calendar end = calendar7;
        return this.isBeforeDay(calendar5, end) && !this.isBeforeDay(calendar5, start);
    }

    private final boolean isBeforeDay(Calendar $this$isBeforeDay, Calendar calendar) {
        return $this$isBeforeDay.get(1) < calendar.get(1) ? true : ($this$isBeforeDay.get(1) > calendar.get(1) ? false : $this$isBeforeDay.get(6) < calendar.get(6));
    }

    public static final /* synthetic */ Locale access$getLocale$p(DefaultDateFormatter $this) {
        return $this.locale;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/ui/common/helper/DefaultDateFormatter$Companion;", "", "()V", "DATE_FORMAT_DAY_OF_WEEK", "", "TIME_FORMAT_12H", "TIME_FORMAT_24H", "stream-chat-android-ui-common_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u0005H&\u00a8\u0006\u000b"}, d2={"Lio/getstream/chat/android/ui/common/helper/DefaultDateFormatter$DateContext;", "", "context", "Landroid/content/Context;", "dateTimePattern", "", "is24Hour", "", "now", "Ljava/util/Date;", "yesterdayString", "stream-chat-android-ui-common_release"})
    public static interface DateContext {
        @NotNull
        public Date now();

        @NotNull
        public String yesterdayString();

        public boolean is24Hour();

        @NotNull
        public String dateTimePattern();

        @NotNull
        public Context context();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/getstream/chat/android/ui/common/helper/DefaultDateFormatter$DefaultDateContext;", "Lio/getstream/chat/android/ui/common/helper/DefaultDateFormatter$DateContext;", "context", "Landroid/content/Context;", "locale", "Ljava/util/Locale;", "(Landroid/content/Context;Ljava/util/Locale;)V", "dateTimePatternLazy", "", "kotlin.jvm.PlatformType", "getDateTimePatternLazy", "()Ljava/lang/String;", "dateTimePatternLazy$delegate", "Lkotlin/Lazy;", "dateTimePattern", "is24Hour", "", "now", "Ljava/util/Date;", "yesterdayString", "stream-chat-android-ui-common_release"})
    private static final class DefaultDateContext
    implements DateContext {
        @NotNull
        private final Context context;
        @NotNull
        private final Locale locale;
        @NotNull
        private final Lazy dateTimePatternLazy$delegate;

        public DefaultDateContext(@NotNull Context context, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            this.context = context;
            this.locale = locale;
            this.dateTimePatternLazy$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ DefaultDateContext this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final String invoke() {
                    return DateFormat.getBestDateTimePattern((Locale)DefaultDateContext.access$getLocale$p(this.this$0), (String)"yy MM dd");
                }
            }));
        }

        private final String getDateTimePatternLazy() {
            Lazy lazy = this.dateTimePatternLazy$delegate;
            return (String)lazy.getValue();
        }

        @Override
        @NotNull
        public Date now() {
            return new Date();
        }

        @Override
        @NotNull
        public String yesterdayString() {
            String string2 = this.context.getString(R.string.stream_ui_yesterday);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            return string2;
        }

        @Override
        public boolean is24Hour() {
            return DateFormat.is24HourFormat((Context)this.context);
        }

        @Override
        @NotNull
        public String dateTimePattern() {
            String string2 = this.getDateTimePatternLazy();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-dateTimePatternLazy>(...)");
            return string2;
        }

        @Override
        @NotNull
        public Context context() {
            return this.context;
        }

        public static final /* synthetic */ Locale access$getLocale$p(DefaultDateContext $this) {
            return $this.locale;
        }
    }
}

