/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.helper.internal;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.MimeTypeFilter;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.models.FileUploadConfig;
import io.getstream.chat.android.ui.common.state.messages.composer.AttachmentMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@InternalStreamChatApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006H\u0002J1\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J#\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013JM\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/getstream/chat/android/ui/common/helper/internal/AttachmentFilter;", "", "chatClient", "Lio/getstream/chat/android/client/ChatClient;", "(Lio/getstream/chat/android/client/ChatClient;)V", "filterAttachments", "", "Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;", "attachments", "matchesFileExtension", "", "attachment", "fileExtensions", "", "matchesFileExtensionOrMimeType", "mimeTypes", "", "(Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;Ljava/util/List;[Ljava/lang/String;)Z", "matchesMimeType", "(Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;[Ljava/lang/String;)Z", "matchesUploadConfig", "allowedFileExtensions", "allowedMimeTypes", "blockedFileExtensions", "blockedMimeTypes", "(Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;Ljava/util/List;[Ljava/lang/String;Ljava/util/List;[Ljava/lang/String;)Z", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAttachmentFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentFilter.kt\nio/getstream/chat/android/ui/common/helper/internal/AttachmentFilter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n37#2,2:150\n37#2,2:152\n37#2,2:154\n37#2,2:156\n766#3:158\n857#3,2:159\n1747#3,3:161\n*S KotlinDebug\n*F\n+ 1 AttachmentFilter.kt\nio/getstream/chat/android/ui/common/helper/internal/AttachmentFilter\n*L\n47#1:150,2\n49#1:152,2\n53#1:154,2\n55#1:156,2\n57#1:158\n57#1:159,2\n144#1:161,3\n*E\n"})
public final class AttachmentFilter {
    @NotNull
    private final ChatClient chatClient;
    public static final int $stable = 8;

    public AttachmentFilter(@NotNull ChatClient chatClient) {
        Intrinsics.checkNotNullParameter((Object)chatClient, (String)"chatClient");
        this.chatClient = chatClient;
    }

    public /* synthetic */ AttachmentFilter(ChatClient chatClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            chatClient = ChatClient.Companion.instance();
        }
        this(chatClient);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AttachmentMetaData> filterAttachments(@NotNull List<AttachmentMetaData> attachments) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        FileUploadConfig fileUploadConfig = this.chatClient.getAppSettings().getApp().getFileUploadConfig();
        List allowedFileExtensions = fileUploadConfig.getAllowedFileExtensions();
        Collection $this$toTypedArray$iv = fileUploadConfig.getAllowedMimeTypes();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] allowedFileMimeTypes = thisCollection$iv.toArray(new String[0]);
        List blockedFileExtensions = fileUploadConfig.getBlockedFileExtensions();
        Collection $this$toTypedArray$iv2 = fileUploadConfig.getBlockedMimeTypes();
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] blockedFileMimeTypes = thisCollection$iv2.toArray(new String[0]);
        FileUploadConfig imageUploadConfig = this.chatClient.getAppSettings().getApp().getImageUploadConfig();
        List allowedImageExtensions = imageUploadConfig.getAllowedFileExtensions();
        Collection $this$toTypedArray$iv3 = imageUploadConfig.getAllowedMimeTypes();
        boolean $i$f$toTypedArray3 = false;
        Collection thisCollection$iv3 = $this$toTypedArray$iv3;
        String[] allowedImageMimeTypes = thisCollection$iv3.toArray(new String[0]);
        List blockedImageExtensions = imageUploadConfig.getBlockedFileExtensions();
        Collection $this$toTypedArray$iv4 = imageUploadConfig.getBlockedMimeTypes();
        boolean $i$f$toTypedArray4 = false;
        Iterable thisCollection$iv4 = $this$toTypedArray$iv4;
        String[] blockedImageMimeTypes = thisCollection$iv4.toArray(new String[0]);
        Iterable $this$filter$iv = attachments;
        boolean $i$f$filter = false;
        thisCollection$iv4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AttachmentMetaData attachment = (AttachmentMetaData)element$iv$iv;
            boolean bl = false;
            boolean isImage = Intrinsics.areEqual((Object)attachment.getType(), (Object)"image");
            if (!this.matchesUploadConfig(attachment, isImage ? allowedImageExtensions : allowedFileExtensions, isImage ? allowedImageMimeTypes : allowedFileMimeTypes, isImage ? blockedImageExtensions : blockedFileExtensions, isImage ? blockedImageMimeTypes : blockedFileMimeTypes)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean matchesUploadConfig(AttachmentMetaData attachment, List<String> allowedFileExtensions, String[] allowedMimeTypes, List<String> blockedFileExtensions, String[] blockedMimeTypes) {
        boolean isWhiteList = !((Collection)allowedFileExtensions).isEmpty() || !(allowedMimeTypes.length == 0);
        boolean isBlackList = !((Collection)blockedFileExtensions).isEmpty() || !(blockedMimeTypes.length == 0);
        return isWhiteList ? this.matchesFileExtensionOrMimeType(attachment, allowedFileExtensions, allowedMimeTypes) : (isBlackList ? !this.matchesFileExtensionOrMimeType(attachment, blockedFileExtensions, blockedMimeTypes) : true);
    }

    private final boolean matchesFileExtensionOrMimeType(AttachmentMetaData attachment, List<String> fileExtensions, String[] mimeTypes) {
        return this.matchesFileExtension(attachment, fileExtensions) || this.matchesMimeType(attachment, mimeTypes);
    }

    private final boolean matchesMimeType(AttachmentMetaData attachment, String[] mimeTypes) {
        boolean bl;
        try {
            bl = MimeTypeFilter.matches((String)attachment.getMimeType(), (String[])mimeTypes) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    private final boolean matchesFileExtension(AttachmentMetaData attachment, List<String> fileExtensions) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = fileExtensions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String extension = (String)element$iv;
                    boolean bl2 = false;
                    String string2 = attachment.getTitle();
                    if (!(string2 != null ? StringsKt.endsWith((String)string2, (String)extension, (boolean)true) : false)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public AttachmentFilter() {
        this(null, 1, null);
    }
}

