/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.helper.internal;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.compose.runtime.internal.StabilityInferred;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.ui.common.helper.internal.StorageHelperKt;
import io.getstream.chat.android.ui.common.state.messages.composer.AttachmentMetaData;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalStreamChatApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0006J\u001a\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u001b\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0012\u0010\u001f\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/getstream/chat/android/ui/common/helper/internal/StorageHelper;", "", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "getAttachmentFromCursor", "Lio/getstream/chat/android/ui/common/state/messages/composer/AttachmentMetaData;", "cursor", "Landroid/database/Cursor;", "getAttachmentsFromUriList", "", "context", "Landroid/content/Context;", "uriList", "Landroid/net/Uri;", "getCachedFileFromUri", "Ljava/io/File;", "attachmentMetaData", "getContentUri", "mimeType", "", "id", "", "getFileAttachments", "getFilteredAttachments", "selection", "getMediaAttachments", "getModelType", "getUniqueCacheFolder", "isImage", "", "isVideo", "Companion", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStorageHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageHelper.kt\nio/getstream/chat/android/ui/common/helper/internal/StorageHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1603#2,9:250\n1855#2:259\n1856#2:261\n1612#2:262\n1#3:260\n*S KotlinDebug\n*F\n+ 1 StorageHelper.kt\nio/getstream/chat/android/ui/common/helper/internal/StorageHelper\n*L\n111#1:250,9\n111#1:259\n111#1:261\n111#1:262\n111#1:260\n*E\n"})
public final class StorageHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HHmmssSSS", Locale.US);
    public static final int $stable = 8;
    @NotNull
    public static final String TIME_FORMAT = "HHmmssSSS";
    @NotNull
    public static final String FILE_NAME_PREFIX = "STREAM_";
    private static final int MILISECOND_IN_A_SECOND = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final File getCachedFileFromUri(@NotNull Context context, @NotNull AttachmentMetaData attachmentMetaData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attachmentMetaData, (String)"attachmentMetaData");
        if (attachmentMetaData.getFile() == null && attachmentMetaData.getUri() == null) {
            return null;
        }
        if (attachmentMetaData.getFile() != null) {
            File file = attachmentMetaData.getFile();
            Intrinsics.checkNotNull((Object)file);
            return file;
        }
        File cachedFile = new File(this.getUniqueCacheFolder(context), StorageHelperKt.access$getTitleWithExtension(attachmentMetaData));
        ContentResolver contentResolver = context.getContentResolver();
        Uri uri = attachmentMetaData.getUri();
        Intrinsics.checkNotNull((Object)uri);
        InputStream inputStream = contentResolver.openInputStream(uri);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream2 = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileOutputStream(cachedFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream it = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream2, (OutputStream)it, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return cachedFile;
    }

    @NotNull
    public final List<AttachmentMetaData> getFileAttachments(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getFilteredAttachments(context, "mime_type IS NOT NULL AND mime_type != ''");
    }

    @NotNull
    public final List<AttachmentMetaData> getMediaAttachments(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String selection = "media_type=1 OR media_type=3";
        return this.getFilteredAttachments(context, selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AttachmentMetaData> getFilteredAttachments(Context context, String selection) {
        String[] stringArray = new String[]{"_id", "_display_name", "mime_type", "_size", "duration"};
        String[] columns = stringArray;
        stringArray = context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), columns, selection, null, "date_added DESC");
        if (stringArray != null) {
            Closeable closeable = (Closeable)stringArray;
            Throwable throwable = null;
            try {
                List list;
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                List $this$getFilteredAttachments_u24lambda_u243_u24lambda_u242 = list = (List)new ArrayList();
                boolean bl2 = false;
                while (cursor.moveToNext()) {
                    $this$getFilteredAttachments_u24lambda_u243_u24lambda_u242.add(this.getAttachmentFromCursor(cursor));
                }
                List list2 = list;
                return list2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<AttachmentMetaData> getAttachmentsFromUriList(@NotNull Context context, @NotNull List<? extends Uri> uriList) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(uriList, (String)"uriList");
        Iterable $this$mapNotNull$iv = uriList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AttachmentMetaData attachmentMetaData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Uri uri = (Uri)element$iv$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{"_display_name", "mime_type", "_size"};
            String[] columns = stringArray;
            stringArray = context.getContentResolver().query(uri, columns, null, null, null);
            if (stringArray != null) {
                Closeable closeable = (Closeable)stringArray;
                Throwable throwable = null;
                try {
                    AttachmentMetaData attachmentMetaData2;
                    Cursor cursor = (Cursor)closeable;
                    boolean bl3 = false;
                    if (cursor.moveToFirst()) {
                        AttachmentMetaData attachmentMetaData3;
                        int displayNameIndex = cursor.getColumnIndex("_display_name");
                        int fileSizeIndex = cursor.getColumnIndex("_size");
                        int mimeTypeIndex = cursor.getColumnIndex("mime_type");
                        String displayName = displayNameIndex != -1 && !cursor.isNull(displayNameIndex) ? cursor.getString(displayNameIndex) : null;
                        long fileSize = fileSizeIndex != -1 && !cursor.isNull(fileSizeIndex) ? cursor.getLong(fileSizeIndex) : 0L;
                        String mimeType = mimeTypeIndex != -1 && !cursor.isNull(mimeTypeIndex) ? cursor.getString(mimeTypeIndex) : context.getContentResolver().getType(uri);
                        AttachmentMetaData $this$getAttachmentsFromUriList_u24lambda_u246_u24lambda_u245_u24lambda_u244 = attachmentMetaData3 = new AttachmentMetaData(uri, this.getModelType(mimeType), mimeType, displayName, null, null, 48, null);
                        boolean bl4 = false;
                        $this$getAttachmentsFromUriList_u24lambda_u246_u24lambda_u245_u24lambda_u244.setSize(fileSize);
                        attachmentMetaData2 = attachmentMetaData3;
                    } else {
                        attachmentMetaData2 = null;
                    }
                    AttachmentMetaData attachmentMetaData4 = attachmentMetaData2;
                    attachmentMetaData = attachmentMetaData4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                attachmentMetaData = null;
            }
            if (attachmentMetaData == null) continue;
            AttachmentMetaData it$iv$iv = attachmentMetaData;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final AttachmentMetaData getAttachmentFromCursor(Cursor cursor) {
        AttachmentMetaData attachmentMetaData;
        int displayNameIndex = cursor.getColumnIndex("_display_name");
        int fileSizeIndex = cursor.getColumnIndex("_size");
        int mimeTypeIndex = cursor.getColumnIndex("mime_type");
        int durationIndex = cursor.getColumnIndex("duration");
        long id = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
        String displayName = displayNameIndex != -1 && !cursor.isNull(displayNameIndex) ? cursor.getString(displayNameIndex) : null;
        long fileSize = fileSizeIndex != -1 && !cursor.isNull(fileSizeIndex) ? cursor.getLong(fileSizeIndex) : 0L;
        String mimeType = mimeTypeIndex != -1 && !cursor.isNull(mimeTypeIndex) ? cursor.getString(mimeTypeIndex) : null;
        long duration = durationIndex != -1 && !cursor.isNull(fileSizeIndex) ? cursor.getLong(durationIndex) : 0L;
        AttachmentMetaData $this$getAttachmentFromCursor_u24lambda_u247 = attachmentMetaData = new AttachmentMetaData(this.getContentUri(mimeType, id), null, mimeType, null, null, null, 58, null);
        boolean bl = false;
        $this$getAttachmentFromCursor_u24lambda_u247.setType(this.getModelType(mimeType));
        $this$getAttachmentFromCursor_u24lambda_u247.setSize(fileSize);
        $this$getAttachmentFromCursor_u24lambda_u247.setTitle(displayName);
        $this$getAttachmentFromCursor_u24lambda_u247.setVideoLength(duration / (long)1000);
        return attachmentMetaData;
    }

    private final Uri getContentUri(String mimeType, long id) {
        Uri uri;
        if (this.isImage(mimeType)) {
            Uri uri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            uri = uri2;
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"EXTERNAL_CONTENT_URI");
        } else if (this.isVideo(mimeType)) {
            Uri uri3 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            uri = uri3;
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"EXTERNAL_CONTENT_URI");
        } else {
            Uri uri4 = MediaStore.Files.getContentUri((String)"external");
            uri = uri4;
            Intrinsics.checkNotNullExpressionValue((Object)uri4, (String)"getContentUri(...)");
        }
        Uri contentUri = uri;
        Uri uri5 = ContentUris.withAppendedId((Uri)contentUri, (long)id);
        Intrinsics.checkNotNullExpressionValue((Object)uri5, (String)"withAppendedId(...)");
        return uri5;
    }

    private final String getModelType(String mimeType) {
        return this.isImage(mimeType) ? "image" : (this.isVideo(mimeType) ? "video" : "file");
    }

    private final boolean isImage(String mimeType) {
        String string2 = mimeType;
        return string2 != null ? StringsKt.startsWith$default((String)string2, (String)"image", (boolean)false, (int)2, null) : false;
    }

    private final boolean isVideo(String mimeType) {
        String string2 = mimeType;
        return string2 != null ? StringsKt.startsWith$default((String)string2, (String)"video", (boolean)false, (int)2, null) : false;
    }

    private final File getUniqueCacheFolder(Context context) {
        File file;
        File it = file = new File(context.getCacheDir(), FILE_NAME_PREFIX + this.dateFormat.format(new Date().getTime()));
        boolean bl = false;
        it.mkdirs();
        return file;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/getstream/chat/android/ui/common/helper/internal/StorageHelper$Companion;", "", "()V", "FILE_NAME_PREFIX", "", "MILISECOND_IN_A_SECOND", "", "TIME_FORMAT", "stream-chat-android-ui-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

