/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.state.messages.composer;

import androidx.compose.runtime.internal.StabilityInferred;
import io.getstream.chat.android.client.utils.attachment.AttachmentUtilsKt;
import io.getstream.chat.android.models.AppSettings;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.common.state.messages.composer.ValidationError;
import io.getstream.chat.android.uiutils.extension.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\"\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lio/getstream/chat/android/ui/common/state/messages/composer/MessageValidator;", "", "appSettings", "Lio/getstream/chat/android/models/AppSettings;", "maxAttachmentCount", "", "canSendLinks", "", "maxMessageLength", "(Lio/getstream/chat/android/models/AppSettings;IZI)V", "getCanSendLinks", "()Z", "setCanSendLinks", "(Z)V", "getMaxMessageLength", "()I", "setMaxMessageLength", "(I)V", "validateAttachmentCount", "Lio/getstream/chat/android/ui/common/state/messages/composer/ValidationError;", "attachments", "", "Lio/getstream/chat/android/models/Attachment;", "validateCanSendLinks", "message", "", "validateFileAttachmentSize", "validateImageAttachmentSize", "validateMessage", "validateMessageLength", "Companion", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMessageValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageValidator.kt\nio/getstream/chat/android/ui/common/state/messages/composer/MessageValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n766#3:76\n857#3,2:77\n766#3:79\n857#3,2:80\n766#3:82\n857#3,2:83\n766#3:85\n857#3,2:86\n*S KotlinDebug\n*F\n+ 1 MessageValidator.kt\nio/getstream/chat/android/ui/common/state/messages/composer/MessageValidator\n*L\n52#1:76\n52#1:77,2\n53#1:79\n53#1:80,2\n59#1:82\n59#1:83,2\n60#1:85\n60#1:86,2\n*E\n"})
public final class MessageValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppSettings appSettings;
    private final int maxAttachmentCount;
    private boolean canSendLinks;
    private int maxMessageLength;
    public static final int $stable = 8;
    private static final int DEFAULT_MESSAGE_LENGTH = 5000;

    public MessageValidator(@NotNull AppSettings appSettings, int maxAttachmentCount, boolean canSendLinks, int maxMessageLength) {
        Intrinsics.checkNotNullParameter((Object)appSettings, (String)"appSettings");
        this.appSettings = appSettings;
        this.maxAttachmentCount = maxAttachmentCount;
        this.canSendLinks = canSendLinks;
        this.maxMessageLength = maxMessageLength;
    }

    public /* synthetic */ MessageValidator(AppSettings appSettings, int n, boolean bl, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        if ((n3 & 8) != 0) {
            n2 = 5000;
        }
        this(appSettings, n, bl, n2);
    }

    public final boolean getCanSendLinks() {
        return this.canSendLinks;
    }

    public final void setCanSendLinks(boolean bl) {
        this.canSendLinks = bl;
    }

    public final int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public final void setMaxMessageLength(int n) {
        this.maxMessageLength = n;
    }

    @NotNull
    public final List<ValidationError> validateMessage(@NotNull String message, @NotNull List<Attachment> attachments) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Object[] objectArray = new ValidationError[]{this.validateMessageLength(message), this.validateAttachmentCount(attachments), this.validateImageAttachmentSize(attachments), this.validateFileAttachmentSize(attachments), this.validateCanSendLinks(message)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final ValidationError validateMessageLength(String message) {
        ValidationError.MessageLengthExceeded messageLengthExceeded;
        Integer n;
        Integer n2 = message.length();
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = n = it > this.maxMessageLength ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            messageLengthExceeded = new ValidationError.MessageLengthExceeded(it, this.maxMessageLength);
        } else {
            messageLengthExceeded = null;
        }
        return messageLengthExceeded;
    }

    private final ValidationError validateAttachmentCount(List<Attachment> attachments) {
        ValidationError.AttachmentCountExceeded attachmentCountExceeded;
        Integer n;
        Integer n2 = ((Collection)attachments).size();
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = n = it > this.maxAttachmentCount ? n2 : null;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl2 = false;
            attachmentCountExceeded = new ValidationError.AttachmentCountExceeded(it, this.maxAttachmentCount);
        } else {
            attachmentCountExceeded = null;
        }
        return attachmentCountExceeded;
    }

    private final ValidationError validateImageAttachmentSize(List<Attachment> attachments) {
        ValidationError.AttachmentSizeExceeded attachmentSizeExceeded;
        List list;
        List list2;
        Attachment it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = attachments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Attachment)element$iv$iv;
            boolean bl = false;
            if (!AttachmentUtilsKt.isImage((Attachment)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Attachment)element$iv$iv;
            boolean bl = false;
            if (!((long)it.getFileSize() > this.appSettings.getApp().getImageUploadConfig().getSizeLimitInBytes())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it2 = list2 = (List)destination$iv$iv;
        boolean bl = false;
        List list3 = list = !it2.isEmpty() ? list2 : null;
        if (list != null) {
            it2 = list;
            boolean bl2 = false;
            attachmentSizeExceeded = new ValidationError.AttachmentSizeExceeded(it2, this.appSettings.getApp().getImageUploadConfig().getSizeLimitInBytes());
        } else {
            attachmentSizeExceeded = null;
        }
        return attachmentSizeExceeded;
    }

    private final ValidationError validateFileAttachmentSize(List<Attachment> attachments) {
        ValidationError.AttachmentSizeExceeded attachmentSizeExceeded;
        List list;
        List list2;
        Attachment it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = attachments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Attachment)element$iv$iv;
            boolean bl = false;
            if (!(!AttachmentUtilsKt.isImage((Attachment)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Attachment)element$iv$iv;
            boolean bl = false;
            if (!((long)it.getFileSize() > this.appSettings.getApp().getFileUploadConfig().getSizeLimitInBytes())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it2 = list2 = (List)destination$iv$iv;
        boolean bl = false;
        List list3 = list = !it2.isEmpty() ? list2 : null;
        if (list != null) {
            it2 = list;
            boolean bl2 = false;
            attachmentSizeExceeded = new ValidationError.AttachmentSizeExceeded(it2, this.appSettings.getApp().getFileUploadConfig().getSizeLimitInBytes());
        } else {
            attachmentSizeExceeded = null;
        }
        return attachmentSizeExceeded;
    }

    private final ValidationError validateCanSendLinks(String message) {
        ValidationError.ContainsLinksWhenNotAllowed containsLinksWhenNotAllowed;
        ValidationError.ContainsLinksWhenNotAllowed it = containsLinksWhenNotAllowed = ValidationError.ContainsLinksWhenNotAllowed.INSTANCE;
        boolean bl = false;
        return !this.canSendLinks && StringKt.containsLinks((String)message) ? containsLinksWhenNotAllowed : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/common/state/messages/composer/MessageValidator$Companion;", "", "()V", "DEFAULT_MESSAGE_LENGTH", "", "stream-chat-android-ui-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

