/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lio/getstream/chat/android/ui/common/utils/MediaStringUtil;", "", "()V", "convertFileSizeByteCount", "", "bytes", "", "convertVideoLength", "videoLengthInSeconds", "locale", "Ljava/util/Locale;", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=1)
public final class MediaStringUtil {
    @NotNull
    public static final MediaStringUtil INSTANCE = new MediaStringUtil();
    public static final int $stable;

    private MediaStringUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String convertVideoLength(long videoLengthInSeconds, @NotNull Locale locale) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (videoLengthInSeconds <= 0L) {
            string2 = "--:--:--";
        } else {
            long hours = videoLengthInSeconds / (long)3600;
            long minutes = videoLengthInSeconds % (long)3600 / (long)60;
            long seconds = videoLengthInSeconds % (long)60;
            String string3 = "%02d:%02d:%02d";
            Object[] objectArray = new Object[]{hours, minutes, seconds};
            String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        }
        return string2;
    }

    public static /* synthetic */ String convertVideoLength$default(long l, Locale locale, int n, Object object) {
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            locale = locale2;
        }
        return MediaStringUtil.convertVideoLength(l, locale);
    }

    @JvmStatic
    @NotNull
    public static final String convertFileSizeByteCount(long bytes) {
        Object object;
        if (bytes <= 0L) {
            object = "0 B";
        } else if (bytes < 1024L) {
            object = bytes + " B";
        } else {
            int exp = (int)(Math.log(bytes) / Math.log(1024.0));
            String pre = String.valueOf("KMGTPE".charAt(exp - 1));
            DecimalFormat df = new DecimalFormat("###.##");
            object = df.format((double)bytes / Math.pow(1024.0, exp)) + " " + pre + "B";
        }
        return object;
    }
}

