/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.FileProvider;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.common.StreamFileProvider;
import io.getstream.chat.android.ui.common.utils.StreamFileUtil;
import io.getstream.result.Error;
import io.getstream.result.Result;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalStreamChatApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0012J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0010J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/getstream/chat/android/ui/common/utils/StreamFileUtil;", "", "()V", "CACHED_FILE_PREFIX", "", "STREAM_CACHE_DIR_NAME", "clearStreamCache", "Lio/getstream/result/Result;", "", "context", "Landroid/content/Context;", "createFailureResultFromException", "Lio/getstream/result/Result$Failure;", "throwable", "", "createFileInCacheDir", "Ljava/io/File;", "fileName", "createFileInCacheDir$stream_chat_android_ui_common_release", "getFileFromCache", "Landroid/net/Uri;", "attachment", "Lio/getstream/chat/android/models/Attachment;", "getFileProviderAuthority", "getOrCreateStreamCacheDir", "getUriForFile", "file", "writeFileToShareableFile", "(Landroid/content/Context;Lio/getstream/chat/android/models/Attachment;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeImageToSharableFile", "bitmap", "Landroid/graphics/Bitmap;", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nStreamFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamFileUtil.kt\nio/getstream/chat/android/ui/common/utils/StreamFileUtil\n+ 2 Result.kt\nio/getstream/result/ResultKt\n*L\n1#1,281:1\n152#2,3:282\n*S KotlinDebug\n*F\n+ 1 StreamFileUtil.kt\nio/getstream/chat/android/ui/common/utils/StreamFileUtil\n*L\n109#1:282,3\n*E\n"})
public final class StreamFileUtil {
    @NotNull
    public static final StreamFileUtil INSTANCE = new StreamFileUtil();
    @NotNull
    private static final String STREAM_CACHE_DIR_NAME = "stream_cache";
    @NotNull
    private static final String CACHED_FILE_PREFIX = "TMP";
    public static final int $stable;

    private StreamFileUtil() {
    }

    private final String getFileProviderAuthority(Context context) {
        ComponentName compName = new ComponentName(context, StreamFileProvider.class.getName());
        ProviderInfo providerInfo = context.getPackageManager().getProviderInfo(compName, 0);
        Intrinsics.checkNotNullExpressionValue((Object)providerInfo, (String)"getProviderInfo(...)");
        ProviderInfo providerInfo2 = providerInfo;
        String string2 = providerInfo2.authority;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"authority");
        return string2;
    }

    @NotNull
    public final Uri getUriForFile(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Uri uri = FileProvider.getUriForFile((Context)context, (String)this.getFileProviderAuthority(context), (File)file);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getUriForFile(...)");
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Uri writeImageToSharableFile(@NotNull Context context, @NotNull Bitmap bitmap) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        try {
            File file = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
            if (file == null) {
                file = context.getCacheDir();
            }
            File file2 = new File(file, "share_image_" + System.currentTimeMillis() + ".png");
            Closeable closeable = new FileOutputStream(file2);
            Throwable throwable = null;
            try {
                FileOutputStream out = (FileOutputStream)closeable;
                boolean bl = false;
                bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)out);
                out.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            uri = this.getUriForFile(context, file2);
        }
        catch (IOException iOException) {
            uri = null;
        }
        return uri;
    }

    private final io.getstream.result.Result<File> getOrCreateStreamCacheDir(Context context) {
        io.getstream.result.Result result;
        try {
            File file;
            File streamCacheDir = file = new File(context.getCacheDir(), STREAM_CACHE_DIR_NAME);
            boolean bl = false;
            streamCacheDir.mkdirs();
            File file2 = file;
            result = (io.getstream.result.Result)new Result.Success((Object)file2);
        }
        catch (Exception e) {
            result = (io.getstream.result.Result)new Result.Failure((Error)new Error.ThrowableError("Could not get or create the Stream cache directory", (Throwable)e));
        }
        return result;
    }

    @NotNull
    public final io.getstream.result.Result<File> createFileInCacheDir$stream_chat_android_ui_common_release(@NotNull Context context, @NotNull String fileName) {
        io.getstream.result.Result result;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            io.getstream.result.Result result2;
            io.getstream.result.Result $this$flatMap$iv = this.getOrCreateStreamCacheDir(context);
            boolean $i$f$flatMap = false;
            io.getstream.result.Result result3 = $this$flatMap$iv;
            if (result3 instanceof Result.Success) {
                File it = (File)((Result.Success)$this$flatMap$iv).getValue();
                boolean bl = false;
                result2 = (io.getstream.result.Result)new Result.Success((Object)new File(it, fileName));
            } else if (result3 instanceof Result.Failure) {
                result2 = $this$flatMap$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            result = result2;
        }
        catch (Exception e) {
            result = (io.getstream.result.Result)new Result.Failure((Error)new Error.ThrowableError("Could not get or create the file.", (Throwable)e));
        }
        return result;
    }

    @NotNull
    public final io.getstream.result.Result<Unit> clearStreamCache(@NotNull Context context) {
        io.getstream.result.Result result;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            File directory = new File(context.getCacheDir(), STREAM_CACHE_DIR_NAME);
            FilesKt.deleteRecursively((File)directory);
            result = (io.getstream.result.Result)new Result.Success((Object)Unit.INSTANCE);
        }
        catch (Exception e) {
            result = (io.getstream.result.Result)new Result.Failure((Error)new Error.ThrowableError("Could clear the Stream cache directory", (Throwable)e));
        }
        return result;
    }

    @NotNull
    public final io.getstream.result.Result<Uri> getFileFromCache(@NotNull Context context, @NotNull Attachment attachment) {
        io.getstream.result.Result result;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        try {
            io.getstream.result.Result result2;
            io.getstream.result.Result getOrCreateCacheDirResult = this.getOrCreateStreamCacheDir(context);
            if (getOrCreateCacheDirResult instanceof Result.Failure) {
                result2 = getOrCreateCacheDirResult;
            } else if (getOrCreateCacheDirResult instanceof Result.Success) {
                boolean isFileCached;
                File streamCacheDir = (File)((Result.Success)getOrCreateCacheDirResult).getValue();
                String string2 = attachment.getUrl();
                if (string2 == null) {
                    string2 = attachment.getAssetUrl();
                }
                Integer attachmentHashCode = string2 != null ? Integer.valueOf(string2.hashCode()) : null;
                String fileName = CACHED_FILE_PREFIX + attachmentHashCode + attachment.getName();
                File file = new File(streamCacheDir, fileName);
                boolean bl = isFileCached = file.exists() && attachmentHashCode != null && file.length() == (long)attachment.getFileSize();
                result2 = isFileCached ? (io.getstream.result.Result)new Result.Success((Object)this.getUriForFile(context, file)) : (io.getstream.result.Result)new Result.Failure((Error)new Error.GenericError("No such file in cache."));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            result = result2;
        }
        catch (Exception e) {
            result = (io.getstream.result.Result)new Result.Failure((Error)new Error.ThrowableError("Cannot determine if the file has been cached.", (Throwable)e));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Object writeFileToShareableFile(@NotNull Context var1_1, @NotNull Attachment var2_2, @NotNull Continuation<? super io.getstream.result.Result<? extends Uri>> var3_3) {
        if (!(var3_3 instanceof writeFileToShareableFile.1)) ** GOTO lbl-1000
        var24_4 = var3_3;
        if ((var24_4.label & -2147483648) != 0) {
            var24_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ StreamFileUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.writeFileToShareableFile(null, null, (Continuation<? super io.getstream.result.Result<? extends Uri>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var25_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$a$-runCatching-StreamFileUtil$writeFileToShareableFile$runCatching$1 = false;
                getOrCreateCacheDirResult = StreamFileUtil.INSTANCE.getOrCreateStreamCacheDir(context);
                if (!(getOrCreateCacheDirResult instanceof Result.Failure)) ** GOTO lbl20
                v0 = getOrCreateCacheDirResult;
                ** GOTO lbl82
lbl20:
                // 1 sources

                if (getOrCreateCacheDirResult instanceof Result.Success == false) throw new NoWhenBranchMatchedException();
                streamCacheDir = (File)((Result.Success)getOrCreateCacheDirResult).getValue();
                v1 = attachment.getUrl();
                if (v1 == null) {
                    v1 = attachment.getAssetUrl();
                }
                if (!(file = new File(streamCacheDir, fileName = "TMP" + (attachmentHashCode = v1 != null ? Boxing.boxInt((int)v1.hashCode()) : null) + attachment.getName())).exists() || attachmentHashCode == null || file.length() != (long)attachment.getFileSize()) ** GOTO lbl28
                v0 = (io.getstream.result.Result)new Result.Success((Object)StreamFileUtil.INSTANCE.getUriForFile(context, file));
                ** GOTO lbl82
lbl28:
                // 1 sources

                v2 = attachment.getAssetUrl();
                if (v2 == null && (v2 = attachment.getUrl()) == null) {
                    return new Result.Failure((Error)new Error.GenericError("File URL cannot be null."));
                }
                fileUrl = v2;
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = file;
                $continuation.label = 1;
                v3 = ChatClient.Companion.instance().downloadFile(fileUrl).await((Continuation)$continuation);
                ** if (v3 != var25_6) goto lbl39
lbl38:
                // 1 sources

                return var25_6;
lbl39:
                // 1 sources

                ** GOTO lbl49
            }
            case 1: {
                $i$a$-runCatching-StreamFileUtil$writeFileToShareableFile$runCatching$1 = false;
                file = (File)$continuation.L$2;
                context = (Context)$continuation.L$1;
                this = (StreamFileUtil)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl49:
                    // 2 sources

                    if (!((response = (io.getstream.result.Result)v3) instanceof Result.Success)) ** GOTO lbl80
                    var12_17 = ((ResponseBody)((Result.Success)response).getValue()).byteStream();
                    var14_18 = null;
                    try {
                        inputStream = (InputStream)var12_17;
                        $i$a$-use-StreamFileUtil$writeFileToShareableFile$runCatching$1$1 = false;
                        var18_24 = new FileOutputStream(file);
                        var19_25 = null;
                        try {
                            outputStream = (FileOutputStream)var18_24;
                            $i$a$-use-StreamFileUtil$writeFileToShareableFile$runCatching$1$1$1 = false;
                            var20_27 = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
                        }
                        catch (Throwable var20_28) {
                            var19_25 = var20_28;
                            throw var20_28;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var18_24, (Throwable)var19_25);
                        }
                        var15_20 = var20_27;
                    }
                    catch (Throwable var15_21) {
                        var14_18 = var15_21;
                        throw var15_21;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var12_17, (Throwable)var14_18);
                    }
                    v0 = (io.getstream.result.Result)new Result.Success((Object)StreamFileUtil.INSTANCE.getUriForFile(context, file));
                    ** GOTO lbl82
lbl80:
                    // 1 sources

                    if (response instanceof Result.Failure == false) throw new NoWhenBranchMatchedException();
                    v0 = response;
lbl82:
                    // 4 sources

                    var5_8 = Result.constructor-impl(v0);
                }
                catch (Throwable var6_10) {
                    var5_8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var6_10));
                }
                runCatching = var5_8;
                v4 = (io.getstream.result.Result)(Result.isFailure-impl((Object)runCatching) != false ? null : runCatching);
                v5 = v4;
                if (v4 != null) return v5;
                v5 = (io.getstream.result.Result)this.createFailureResultFromException(Result.exceptionOrNull-impl((Object)runCatching));
                return v5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Result.Failure createFailureResultFromException(Throwable throwable) {
        Error error;
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            Throwable exception = throwable2;
            boolean bl = false;
            error = (Error)new Error.ThrowableError("Could not write to file.", exception);
        } else {
            error = (Error)new Error.GenericError("Could not write to file.");
        }
        Error error2 = error;
        return new Result.Failure(error2);
    }
}

