/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.common.utils;

import android.content.Context;
import android.content.res.Resources;
import android.text.Layout;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.MimeTypeMap;
import android.widget.TextView;
import androidx.annotation.NonNull;
import java.io.File;
import java.util.Locale;

public class Utils {
    public static final Locale locale = new Locale("en", "US", "POSIX");

    public static void showSoftKeyboard(@NonNull Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (!imm.isAcceptingText()) {
            imm.toggleSoftInput(2, 0);
        }
    }

    public static void showSoftKeyboard(@NonNull View view) {
        Utils.showSoftKeyboard(view.getContext());
    }

    public static void hideSoftKeyboard(@NonNull View view) {
        Context context = view.getContext();
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static String getMimeType(File file) {
        return Utils.getMimeType(file.getPath());
    }

    public static String getMimeType(String filePath) {
        String type = "";
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)filePath);
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return type;
    }

    public static abstract class TextViewLinkHandler
    extends LinkMovementMethod {
        public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
            int line;
            if (event.getAction() != 1) {
                return super.onTouchEvent(widget, buffer, event);
            }
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout2 = widget.getLayout();
            int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
            URLSpan[] link = (URLSpan[])buffer.getSpans(off, off, URLSpan.class);
            if (link.length != 0) {
                this.onLinkClick(link[0].getURL());
            }
            return true;
        }

        public abstract void onLinkClick(String var1);
    }
}

