/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.sdk.chat.audio.recording;

import android.content.Context;
import android.media.MediaMetadataRetriever;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.common.utils.StreamFileUtil;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import io.getstream.result.Error;
import io.getstream.result.Result;
import io.getstream.sdk.chat.audio.recording.MediaRecorderState;
import io.getstream.sdk.chat.audio.recording.RecordedMedia;
import io.getstream.sdk.chat.audio.recording.StreamMediaRecorder;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u0010*\u001a\u00020+H\u0016J\u0012\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010+H\u0002J\u0018\u00106\u001a\u0002022\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u00107\u001a\u0002022\u0006\u00108\u001a\u00020\u0006H\u0002J\b\u00109\u001a\u000202H\u0016J\u0010\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\u001cH\u0016J\u0010\u0010<\u001a\u0002022\u0006\u0010\u001d\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u0002022\u0006\u0010\u001f\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020\"H\u0016J\u0010\u0010B\u001a\u0002022\u0006\u0010C\u001a\u00020(H\u0016J\u0010\u0010D\u001a\u0002022\u0006\u0010E\u001a\u00020$H\u0016J\u0010\u0010F\u001a\u0002022\u0006\u0010G\u001a\u00020&H\u0016J\u001e\u0010H\u001a\b\u0012\u0004\u0012\u000202012\u0006\u0010*\u001a\u00020+2\u0006\u00108\u001a\u00020\u0006H\u0016J&\u0010H\u001a\b\u0012\u0004\u0012\u00020+012\u0006\u0010I\u001a\u00020J2\u0006\u00108\u001a\u00020\u00062\u0006\u0010K\u001a\u00020LH\u0016J\u000e\u0010M\u001a\b\u0012\u0004\u0012\u00020N01H\u0016J\b\u0010O\u001a\u000202H\u0002R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0017@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u0012\u0012\u0004\u0012\u00020.0-j\b\u0012\u0004\u0012\u00020.`/X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lio/getstream/sdk/chat/audio/recording/DefaultStreamMediaRecorder;", "Lio/getstream/sdk/chat/audio/recording/StreamMediaRecorder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "activeRecordingStartedAt", "", "Ljava/lang/Long;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "currentRecordingDurationJob", "Lkotlinx/coroutines/Job;", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "Lkotlin/Lazy;", "value", "Landroid/media/MediaRecorder;", "mediaRecorder", "setMediaRecorder", "(Landroid/media/MediaRecorder;)V", "Lio/getstream/sdk/chat/audio/recording/MediaRecorderState;", "mediaRecorderState", "setMediaRecorderState", "(Lio/getstream/sdk/chat/audio/recording/MediaRecorderState;)V", "onCurrentRecordingDurationChangedListener", "Lio/getstream/sdk/chat/audio/recording/StreamMediaRecorder$OnCurrentRecordingDurationChanged;", "onErrorListener", "Landroid/media/MediaRecorder$OnErrorListener;", "onInfoListener", "Landroid/media/MediaRecorder$OnInfoListener;", "onMaxAmplitudeSampledListener", "Lio/getstream/sdk/chat/audio/recording/StreamMediaRecorder$OnMaxAmplitudeSampled;", "onStartRecordingListener", "Lio/getstream/sdk/chat/audio/recording/StreamMediaRecorder$OnRecordingStarted;", "onStopRecordingListener", "Lio/getstream/sdk/chat/audio/recording/StreamMediaRecorder$OnRecordingStopped;", "onStreamMediaRecorderStateChangedListener", "Lio/getstream/sdk/chat/audio/recording/StreamMediaRecorder$OnMediaRecorderStateChange;", "pollingJob", "recordingFile", "Ljava/io/File;", "sampleData", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "deleteRecording", "Lio/getstream/result/Result;", "", "getAudioDurationInMs", "", "file", "initializeMediaRecorderForAudio", "pollMaxAmplitude", "amplitudePollingInterval", "release", "setOnCurrentRecordingDurationChangedListener", "onCurrentRecordingDurationChanged", "setOnErrorListener", "Lio/getstream/sdk/chat/audio/recording/StreamMediaRecorder$OnErrorListener;", "setOnInfoListener", "Lio/getstream/sdk/chat/audio/recording/StreamMediaRecorder$OnInfoListener;", "setOnMaxAmplitudeSampledListener", "onMaxAmplitudeSampled", "setOnMediaRecorderStateChangedListener", "onMediaRecorderStateChange", "setOnRecordingStartedListener", "onRecordingStarted", "setOnRecordingStoppedListener", "onRecordingStopped", "startAudioRecording", "recordingName", "", "override", "", "stopRecording", "Lio/getstream/sdk/chat/audio/recording/RecordedMedia;", "trackMaxDuration", "stream-chat-android-ui-common_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDefaultStreamMediaRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultStreamMediaRecorder.kt\nio/getstream/sdk/chat/audio/recording/DefaultStreamMediaRecorder\n+ 2 StreamLog.kt\nio/getstream/log/TaggedLogger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Result.kt\nio/getstream/result/Result\n+ 5 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,519:1\n303#2,4:520\n303#2,4:524\n259#2,4:535\n259#2,4:539\n303#2,4:543\n314#2,4:547\n259#2,4:551\n259#2,4:556\n259#2,4:560\n1#3:528\n118#4,6:529\n36#5:555\n*S KotlinDebug\n*F\n+ 1 DefaultStreamMediaRecorder.kt\nio/getstream/sdk/chat/audio/recording/DefaultStreamMediaRecorder\n*L\n62#1:520,4\n67#1:524,4\n221#1:535,4\n263#1:539,4\n288#1:543,4\n312#1:547,4\n315#1:551,4\n335#1:556,4\n359#1:560,4\n204#1:529,6\n330#1:555\n*E\n"})
public final class DefaultStreamMediaRecorder
implements StreamMediaRecorder {
    @NotNull
    private final Context context;
    @NotNull
    private MediaRecorderState mediaRecorderState;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Job pollingJob;
    @Nullable
    private Job currentRecordingDurationJob;
    @NotNull
    private final Lazy logger$delegate;
    @Nullable
    private MediaRecorder mediaRecorder;
    @Nullable
    private File recordingFile;
    @Nullable
    private Long activeRecordingStartedAt;
    @NotNull
    private ArrayList<Float> sampleData;
    @Nullable
    private MediaRecorder.OnErrorListener onErrorListener;
    @Nullable
    private MediaRecorder.OnInfoListener onInfoListener;
    @Nullable
    private StreamMediaRecorder.OnRecordingStarted onStartRecordingListener;
    @Nullable
    private StreamMediaRecorder.OnRecordingStopped onStopRecordingListener;
    @Nullable
    private StreamMediaRecorder.OnMaxAmplitudeSampled onMaxAmplitudeSampledListener;
    @Nullable
    private StreamMediaRecorder.OnMediaRecorderStateChange onStreamMediaRecorderStateChangedListener;
    @Nullable
    private StreamMediaRecorder.OnCurrentRecordingDurationChanged onCurrentRecordingDurationChangedListener;
    public static final int $stable = 8;

    public DefaultStreamMediaRecorder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.mediaRecorderState = MediaRecorderState.UNINITIALIZED;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO()));
        this.logger$delegate = StreamLogExtensionKt.taggedLogger((Object)this, (String)"Chat:DefaultStreamMediaRecorder");
        this.sampleData = new ArrayList();
    }

    private final void setMediaRecorderState(MediaRecorderState value) {
        this.mediaRecorderState = value;
        StreamMediaRecorder.OnMediaRecorderStateChange onMediaRecorderStateChange = this.onStreamMediaRecorderStateChangedListener;
        if (onMediaRecorderStateChange != null) {
            onMediaRecorderStateChange.onStateChanged(this.mediaRecorderState);
        }
        if (WhenMappings.$EnumSwitchMapping$0[this.mediaRecorderState.ordinal()] == 1) {
            this.activeRecordingStartedAt = System.currentTimeMillis();
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$d = false;
            if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.DEBUG;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "[onMediaRecorderState] #1; activeRecordingStartedAt: " + this.activeRecordingStartedAt;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string2, (String)string3, null, (int)8, null);
            }
            this.trackMaxDuration();
        } else {
            this.activeRecordingStartedAt = 0L;
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$d = false;
            if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                String string4 = this_$iv.getTag();
                Priority priority = Priority.DEBUG;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string5 = "[onMediaRecorderState] #2; activeRecordingStartedAt: " + this.activeRecordingStartedAt;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string4, (String)string5, null, (int)8, null);
            }
        }
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    private final void setMediaRecorder(MediaRecorder value) {
        if (value != null) {
            MediaRecorder.OnErrorListener it;
            MediaRecorder.OnErrorListener onErrorListener = this.onErrorListener;
            if (onErrorListener != null) {
                it = onErrorListener;
                boolean bl = false;
                value.setOnErrorListener(it);
            }
            MediaRecorder.OnInfoListener onInfoListener = this.onInfoListener;
            if (onInfoListener != null) {
                it = onInfoListener;
                boolean bl = false;
                value.setOnInfoListener((MediaRecorder.OnInfoListener)it);
            }
        }
        this.mediaRecorder = value;
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeMediaRecorderForAudio(Context context, File recordingFile) {
        void $this$initializeMediaRecorderForAudio_u24lambda_u244;
        MediaRecorder mediaRecorder;
        this.release();
        MediaRecorder mediaRecorder2 = mediaRecorder = Build.VERSION.SDK_INT < 31 ? new MediaRecorder() : new MediaRecorder(context);
        DefaultStreamMediaRecorder defaultStreamMediaRecorder = this;
        boolean bl = false;
        $this$initializeMediaRecorderForAudio_u24lambda_u244.setAudioSource(1);
        $this$initializeMediaRecorderForAudio_u24lambda_u244.setOutputFormat(6);
        $this$initializeMediaRecorderForAudio_u24lambda_u244.setAudioEncoder(3);
        $this$initializeMediaRecorderForAudio_u24lambda_u244.setOutputFile(recordingFile.getPath());
        $this$initializeMediaRecorderForAudio_u24lambda_u244.prepare();
        this.setMediaRecorderState(MediaRecorderState.PREPARED);
        defaultStreamMediaRecorder.setMediaRecorder(mediaRecorder);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<File> startAudioRecording(@NotNull String recordingName, long amplitudePollingInterval, boolean override) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)recordingName, (String)"recordingName");
        try {
            void this_$iv;
            void var7_7;
            result = StreamFileUtil.INSTANCE.createFileInCacheDir$stream_chat_android_ui_common_release(this.context, recordingName);
            boolean $i$f$onSuccess = false;
            void it$iv = var7_7 = this_$iv;
            boolean bl = false;
            void var10_13 = it$iv;
            if (var10_13 instanceof Result.Success) {
                File it = (File)((Result.Success)it$iv).getValue();
                boolean bl2 = false;
                this.recordingFile = it;
                this.initializeMediaRecorderForAudio(this.context, it);
                if (this.mediaRecorder == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                MediaRecorder mediaRecorder = this.mediaRecorder;
                if (mediaRecorder != null) {
                    mediaRecorder.start();
                }
                StreamMediaRecorder.OnRecordingStarted onRecordingStarted = this.onStartRecordingListener;
                if (onRecordingStarted != null) {
                    onRecordingStarted.onStarted();
                }
                this.setMediaRecorderState(MediaRecorderState.RECORDING);
                this.pollMaxAmplitude(amplitudePollingInterval);
                new Result.Success((Object)it);
            } else if (var10_13 instanceof Result.Failure) {
                // empty if block
            }
            result = var7_7;
        }
        catch (Exception exception) {
            this.release();
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string3 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string4 = "Could not start recording audio";
                streamLogger.log(priority, string3, string4, (Throwable)exception);
            }
            result = (Result)new Result.Failure((Error)new Error.ThrowableError("Could not start audio recording.", (Throwable)exception));
        }
        return result;
    }

    @Override
    @NotNull
    public Result<Unit> startAudioRecording(@NotNull File recordingFile, long amplitudePollingInterval) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)recordingFile, (String)"recordingFile");
        try {
            this.recordingFile = recordingFile;
            this.initializeMediaRecorderForAudio(this.context, recordingFile);
            if (this.mediaRecorder == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            MediaRecorder mediaRecorder = this.mediaRecorder;
            if (mediaRecorder != null) {
                mediaRecorder.start();
            }
            StreamMediaRecorder.OnRecordingStarted onRecordingStarted = this.onStartRecordingListener;
            if (onRecordingStarted != null) {
                onRecordingStarted.onStarted();
            }
            this.setMediaRecorderState(MediaRecorderState.RECORDING);
            this.pollMaxAmplitude(amplitudePollingInterval);
            result = (Result)new Result.Success((Object)Unit.INSTANCE);
        }
        catch (Exception exception) {
            this.release();
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string3 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string4 = "Could not start recording audio";
                streamLogger.log(priority, string3, string4, (Throwable)exception);
            }
            result = (Result)new Result.Failure((Error)new Error.ThrowableError("Could not start audio recording.", (Throwable)exception));
        }
        return result;
    }

    @Override
    @NotNull
    public Result<RecordedMedia> stopRecording() {
        Result result;
        try {
            String string2;
            StreamLogger streamLogger;
            Priority priority;
            String string3;
            long l;
            if (this.mediaRecorder == null) {
                String string4 = "Required value was null.";
                throw new IllegalArgumentException(string4.toString());
            }
            MediaRecorder mediaRecorder = this.mediaRecorder;
            if (mediaRecorder != null) {
                mediaRecorder.stop();
            }
            Long l2 = this.activeRecordingStartedAt;
            if (l2 != null) {
                long it = ((Number)l2).longValue();
                boolean bl2 = false;
                l = System.currentTimeMillis() - it;
            } else {
                l = 0L;
            }
            long calculatedDurationInMs = l;
            int parsedDurationInMs = this.getAudioDurationInMs(this.recordingFile);
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$d = false;
            if (this_$iv.getValidator().isLoggable(Priority.DEBUG, this_$iv.getTag())) {
                string3 = this_$iv.getTag();
                priority = Priority.DEBUG;
                streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                string2 = "[stopRecording] startedAt: " + this.activeRecordingStartedAt + ", calculatedDuration: " + calculatedDurationInMs + ", parsedDuration: " + parsedDurationInMs;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
            }
            int durationInMs = parsedDurationInMs > 0 ? parsedDurationInMs : (int)calculatedDurationInMs;
            StreamMediaRecorder.OnCurrentRecordingDurationChanged onCurrentRecordingDurationChanged = this.onCurrentRecordingDurationChangedListener;
            if (onCurrentRecordingDurationChanged != null) {
                onCurrentRecordingDurationChanged.onDurationChanged(durationInMs);
            }
            this.release();
            StreamMediaRecorder.OnRecordingStopped onRecordingStopped = this.onStopRecordingListener;
            if (onRecordingStopped != null) {
                onRecordingStopped.onStopped();
            }
            File file = this.recordingFile;
            String string5 = file != null ? file.getName() : null;
            if (string5 == null) {
                string5 = "Recording";
            }
            String bl = string5;
            File it = this.recordingFile;
            Pair[] bl2 = new Pair[]{TuplesKt.to((Object)"duration", (Object)Float.valueOf((float)durationInMs / 1000.0f)), TuplesKt.to((Object)"waveform_data", this.sampleData)};
            Map map2 = MapsKt.mapOf((Pair[])bl2);
            Attachment attachment = new Attachment(null, null, null, null, null, null, null, "audio/aac", 0, bl, null, "voiceRecording", null, null, null, null, null, null, it, null, map2, 783743, null);
            RecordedMedia recordedMedia = new RecordedMedia(durationInMs, attachment);
            TaggedLogger this_$iv2 = this.getLogger();
            boolean $i$f$v = false;
            if (this_$iv2.getValidator().isLoggable(Priority.VERBOSE, this_$iv2.getTag())) {
                string3 = this_$iv2.getTag();
                priority = Priority.VERBOSE;
                streamLogger = this_$iv2.getDelegate();
                boolean bl3 = false;
                string2 = "[stopRecording] succeed: " + recordedMedia;
                StreamLogger.DefaultImpls.log$default((StreamLogger)streamLogger, (Priority)priority, (String)string3, (String)string2, null, (int)8, null);
            }
            result = (Result)new Result.Success((Object)recordedMedia);
        }
        catch (Exception exception) {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string6 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string7 = "[stopRecording] failed: " + exception;
                streamLogger.log(priority, string6, string7, (Throwable)exception);
            }
            this.release();
            result = (Result)new Result.Failure((Error)new Error.ThrowableError("Could not Stop audio recording.", (Throwable)exception));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getAudioDurationInMs(File file) {
        int n;
        if (file == null) {
            return 0;
        }
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            Integer duration;
            String durationString;
            File $this$toUri$iv = file;
            boolean $i$f$toUri = false;
            retriever.setDataSource(Uri.fromFile((File)$this$toUri$iv).toString());
            String string2 = durationString = retriever.extractMetadata(9);
            Integer n2 = duration = string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null;
            n = n2 != null ? n2 : 0;
        }
        catch (Throwable e) {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string3 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string4 = "[getAudioDurationInMs] failed: " + e;
                streamLogger.log(priority, string3, string4, e);
            }
            n = 0;
        }
        finally {
            try {
                retriever.release();
            }
            catch (Throwable duration) {}
        }
        return n;
    }

    @Override
    @NotNull
    public Result<Unit> deleteRecording(@NotNull File recordingFile) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)recordingFile, (String)"recordingFile");
        try {
            recordingFile.delete();
            result = (Result)new Result.Success((Object)Unit.INSTANCE);
        }
        catch (Exception exception) {
            TaggedLogger this_$iv = this.getLogger();
            boolean $i$f$e = false;
            if (this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) {
                String string2 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "Could not delete audio recording";
                streamLogger.log(priority, string2, string3, (Throwable)exception);
            }
            result = (Result)new Result.Failure((Error)new Error.ThrowableError("Could not delete audio recording.", (Throwable)exception));
        }
        return result;
    }

    @Override
    public void release() {
        block1: {
            MediaRecorder mediaRecorder = this.mediaRecorder;
            if (mediaRecorder != null) {
                mediaRecorder.release();
            }
            this.setMediaRecorderState(MediaRecorderState.UNINITIALIZED);
            StreamMediaRecorder.OnRecordingStopped onRecordingStopped = this.onStopRecordingListener;
            if (onRecordingStopped == null) break block1;
            onRecordingStopped.onStopped();
        }
    }

    private final void pollMaxAmplitude(long amplitudePollingInterval) {
        this.sampleData.clear();
        Job job = this.pollingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.pollingJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, amplitudePollingInterval, null){
            int label;
            final /* synthetic */ DefaultStreamMediaRecorder this$0;
            final /* synthetic */ long $amplitudePollingInterval;
            {
                this.this$0 = $receiver;
                this.$amplitudePollingInterval = $amplitudePollingInterval;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void trackMaxDuration() {
        Job job = this.currentRecordingDurationJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.currentRecordingDurationJob = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultStreamMediaRecorder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                        // 3 sources

                        while (DefaultStreamMediaRecorder.access$getMediaRecorderState$p(this.this$0) == MediaRecorderState.RECORDING) {
                            activeRecordingStartedAt = DefaultStreamMediaRecorder.access$getActiveRecordingStartedAt$p(this.this$0);
                            currentDuration = activeRecordingStartedAt != null ? System.currentTimeMillis() - activeRecordingStartedAt : 0L;
                            v0 = DefaultStreamMediaRecorder.access$getOnCurrentRecordingDurationChangedListener$p(this.this$0);
                            if (v0 != null) {
                                v0.onDurationChanged(currentDuration);
                            }
                            this.label = 1;
                            v1 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                            if (v1 != var5_2) continue;
                            return var5_2;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl5
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void setOnErrorListener(@NotNull StreamMediaRecorder.OnErrorListener onErrorListener) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)onErrorListener, (String)"onErrorListener");
            MediaRecorder mediaRecorder = this.mediaRecorder;
            if (mediaRecorder == null) break block0;
            mediaRecorder.setOnErrorListener((arg_0, arg_1, arg_2) -> DefaultStreamMediaRecorder.setOnErrorListener$lambda$14(onErrorListener, this, arg_0, arg_1, arg_2));
        }
    }

    @Override
    public void setOnInfoListener(@NotNull StreamMediaRecorder.OnInfoListener onInfoListener) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)onInfoListener, (String)"onInfoListener");
            MediaRecorder mediaRecorder = this.mediaRecorder;
            if (mediaRecorder == null) break block0;
            mediaRecorder.setOnInfoListener((arg_0, arg_1, arg_2) -> DefaultStreamMediaRecorder.setOnInfoListener$lambda$15(onInfoListener, this, arg_0, arg_1, arg_2));
        }
    }

    @Override
    public void setOnRecordingStartedListener(@NotNull StreamMediaRecorder.OnRecordingStarted onRecordingStarted) {
        Intrinsics.checkNotNullParameter((Object)onRecordingStarted, (String)"onRecordingStarted");
        this.onStartRecordingListener = onRecordingStarted;
    }

    @Override
    public void setOnRecordingStoppedListener(@NotNull StreamMediaRecorder.OnRecordingStopped onRecordingStopped) {
        Intrinsics.checkNotNullParameter((Object)onRecordingStopped, (String)"onRecordingStopped");
        this.onStopRecordingListener = onRecordingStopped;
    }

    @Override
    public void setOnMaxAmplitudeSampledListener(@NotNull StreamMediaRecorder.OnMaxAmplitudeSampled onMaxAmplitudeSampled) {
        Intrinsics.checkNotNullParameter((Object)onMaxAmplitudeSampled, (String)"onMaxAmplitudeSampled");
        this.onMaxAmplitudeSampledListener = onMaxAmplitudeSampled;
    }

    @Override
    public void setOnMediaRecorderStateChangedListener(@NotNull StreamMediaRecorder.OnMediaRecorderStateChange onMediaRecorderStateChange) {
        Intrinsics.checkNotNullParameter((Object)onMediaRecorderStateChange, (String)"onMediaRecorderStateChange");
        this.onStreamMediaRecorderStateChangedListener = onMediaRecorderStateChange;
    }

    @Override
    public void setOnCurrentRecordingDurationChangedListener(@NotNull StreamMediaRecorder.OnCurrentRecordingDurationChanged onCurrentRecordingDurationChanged) {
        Intrinsics.checkNotNullParameter((Object)onCurrentRecordingDurationChanged, (String)"onCurrentRecordingDurationChanged");
        this.onCurrentRecordingDurationChangedListener = onCurrentRecordingDurationChanged;
    }

    private static final void setOnErrorListener$lambda$14(StreamMediaRecorder.OnErrorListener $onErrorListener, DefaultStreamMediaRecorder this$0, MediaRecorder mediaRecorder, int what, int extra) {
        Intrinsics.checkNotNullParameter((Object)$onErrorListener, (String)"$onErrorListener");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $onErrorListener.onError(this$0, what, extra);
    }

    private static final void setOnInfoListener$lambda$15(StreamMediaRecorder.OnInfoListener $onInfoListener, DefaultStreamMediaRecorder this$0, MediaRecorder mediaRecorder, int what, int extra) {
        Intrinsics.checkNotNullParameter((Object)$onInfoListener, (String)"$onInfoListener");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $onInfoListener.onInfo(this$0, what, extra);
    }

    public static final /* synthetic */ MediaRecorderState access$getMediaRecorderState$p(DefaultStreamMediaRecorder $this) {
        return $this.mediaRecorderState;
    }

    public static final /* synthetic */ TaggedLogger access$getLogger(DefaultStreamMediaRecorder $this) {
        return $this.getLogger();
    }

    public static final /* synthetic */ ArrayList access$getSampleData$p(DefaultStreamMediaRecorder $this) {
        return $this.sampleData;
    }

    public static final /* synthetic */ StreamMediaRecorder.OnMaxAmplitudeSampled access$getOnMaxAmplitudeSampledListener$p(DefaultStreamMediaRecorder $this) {
        return $this.onMaxAmplitudeSampledListener;
    }

    public static final /* synthetic */ Long access$getActiveRecordingStartedAt$p(DefaultStreamMediaRecorder $this) {
        return $this.activeRecordingStartedAt;
    }

    public static final /* synthetic */ StreamMediaRecorder.OnCurrentRecordingDurationChanged access$getOnCurrentRecordingDurationChangedListener$p(DefaultStreamMediaRecorder $this) {
        return $this.onCurrentRecordingDurationChangedListener;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaRecorderState.values().length];
            try {
                nArray[MediaRecorderState.RECORDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

