/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.channels.header;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import io.getstream.chat.android.core.internal.InternalStreamChatApi;
import io.getstream.chat.android.models.User;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.databinding.StreamUiChannelListHeaderViewBinding;
import io.getstream.chat.android.ui.font.TextStyle;
import io.getstream.chat.android.ui.font.TextStyleKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.chat.android.ui.utils.extensions.ViewGroupKt;
import io.getstream.chat.android.ui.widgets.avatar.UserAvatarView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002/0B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u001c\u001a\u00020\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100!J\u0014\u0010\"\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100!J\u000e\u0010#\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020$J\u0016\u0010%\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0007J\u000e\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020\u0010J\u0006\u0010-\u001a\u00020\u0010J\u0006\u0010.\u001a\u00020\u0010R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/getstream/chat/android/ui/feature/channels/header/ChannelListHeaderView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiChannelListHeaderViewBinding;", "configActionButton", "", "typedArray", "Landroid/content/res/TypedArray;", "configOfflineTitleContainer", "configOnlineTitle", "configUserAvatar", "configureSeparator", "getOfflineTitleTextStyle", "Lio/getstream/chat/android/ui/font/TextStyle;", "getOnlineTitleTextStyle", "getProgressBarTint", "Landroid/content/res/ColorStateList;", "init", "setOnActionButtonClickListener", "listener", "Lio/getstream/chat/android/ui/feature/channels/header/ChannelListHeaderView$ActionButtonClickListener;", "setOnTitleClickListener", "Lkotlin/Function0;", "setOnTitleLongClickListener", "setOnUserAvatarClickListener", "Lio/getstream/chat/android/ui/feature/channels/header/ChannelListHeaderView$UserAvatarClickListener;", "setOnUserAvatarLongClickListener", "setOnlineTitle", "title", "", "setUser", "user", "Lio/getstream/chat/android/models/User;", "showConnectingTitle", "showOfflineTitle", "showOnlineTitle", "ActionButtonClickListener", "UserAvatarClickListener", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nChannelListHeaderView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelListHeaderView.kt\nio/getstream/chat/android/ui/feature/channels/header/ChannelListHeaderView\n+ 2 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,293:1\n233#2,3:294\n283#3,2:297\n262#3,2:299\n283#3,2:301\n262#3,2:303\n262#3,2:305\n262#3,2:307\n262#3,2:309\n262#3,2:311\n262#3,2:313\n262#3,2:315\n262#3,2:317\n*S KotlinDebug\n*F\n+ 1 ChannelListHeaderView.kt\nio/getstream/chat/android/ui/feature/channels/header/ChannelListHeaderView\n*L\n79#1:294,3\n91#1:297,2\n104#1:299,2\n119#1:301,2\n207#1:303,2\n208#1:305,2\n237#1:307,2\n238#1:309,2\n239#1:311,2\n248#1:313,2\n249#1:315,2\n250#1:317,2\n*E\n"})
public final class ChannelListHeaderView
extends ConstraintLayout {
    @NotNull
    private final StreamUiChannelListHeaderViewBinding binding;

    public ChannelListHeaderView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context));
        StreamUiChannelListHeaderViewBinding streamUiChannelListHeaderViewBinding = StreamUiChannelListHeaderViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiChannelListHeaderViewBinding, (String)"inflate(...)");
        this.binding = streamUiChannelListHeaderViewBinding;
        this.init(null);
    }

    public ChannelListHeaderView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs);
        StreamUiChannelListHeaderViewBinding streamUiChannelListHeaderViewBinding = StreamUiChannelListHeaderViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiChannelListHeaderViewBinding, (String)"inflate(...)");
        this.binding = streamUiChannelListHeaderViewBinding;
        this.init(attrs);
    }

    public ChannelListHeaderView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr);
        StreamUiChannelListHeaderViewBinding streamUiChannelListHeaderViewBinding = StreamUiChannelListHeaderViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiChannelListHeaderViewBinding, (String)"inflate(...)");
        this.binding = streamUiChannelListHeaderViewBinding;
        this.init(attrs);
    }

    public ChannelListHeaderView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(ContextKt.createStreamThemeWrapper(context), attrs, defStyleAttr, defStyleRes);
        StreamUiChannelListHeaderViewBinding streamUiChannelListHeaderViewBinding = StreamUiChannelListHeaderViewBinding.inflate(ViewGroupKt.getStreamThemeInflater((ViewGroup)this), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamUiChannelListHeaderViewBinding, (String)"inflate(...)");
        this.binding = streamUiChannelListHeaderViewBinding;
        this.init(attrs);
    }

    private final void init(AttributeSet attrs) {
        Unit unit;
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ChannelListHeaderView, R.attr.streamUiChannelListHeaderStyle, R.style.StreamUi_ChannelListHeader);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray typedArray2 = $this$use$iv;
        boolean bl = false;
        this.configUserAvatar(typedArray2);
        this.configOnlineTitle(typedArray2);
        this.configOfflineTitleContainer(typedArray2);
        this.configActionButton(typedArray2);
        this.configureSeparator(typedArray2);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl2 = false;
        $this$use$iv.recycle();
    }

    /*
     * WARNING - void declaration
     */
    private final void configUserAvatar(TypedArray typedArray) {
        void $this$isInvisible$iv;
        UserAvatarView userAvatarView;
        boolean showAvatar = typedArray.getBoolean(R.styleable.ChannelListHeaderView_streamUiShowUserAvatar, true);
        UserAvatarView $this$configUserAvatar_u24lambda_u241 = userAvatarView = this.binding.userAvatarView;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)((Object)$this$configUserAvatar_u24lambda_u241));
        View view = (View)$this$configUserAvatar_u24lambda_u241;
        boolean value$iv = !showAvatar;
        boolean $i$f$setInvisible = false;
        $this$isInvisible$iv.setVisibility(value$iv ? 4 : 0);
        $this$configUserAvatar_u24lambda_u241.setClickable(showAvatar);
    }

    private final void configOnlineTitle(TypedArray typedArray) {
        TextView textView = this.binding.onlineTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"onlineTextView");
        TextStyleKt.setTextStyle(textView, this.getOnlineTitleTextStyle(typedArray));
    }

    /*
     * WARNING - void declaration
     */
    private final void configOfflineTitleContainer(TypedArray typedArray) {
        void value$iv;
        void $this$isVisible$iv;
        ProgressBar progressBar;
        TextView textView = this.binding.offlineTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"offlineTextView");
        TextStyleKt.setTextStyle(textView, this.getOfflineTitleTextStyle(typedArray));
        ProgressBar $this$configOfflineTitleContainer_u24lambda_u242 = progressBar = this.binding.offlineProgressBar;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$configOfflineTitleContainer_u24lambda_u242);
        View view = (View)$this$configOfflineTitleContainer_u24lambda_u242;
        boolean bl2 = typedArray.getBoolean(R.styleable.ChannelListHeaderView_streamUiShowOfflineProgressBar, true);
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv != false ? 0 : 8);
        $this$configOfflineTitleContainer_u24lambda_u242.setIndeterminateTintList(this.getProgressBarTint(typedArray));
    }

    private final ColorStateList getProgressBarTint(TypedArray typedArray) {
        ColorStateList colorStateList = typedArray.getColorStateList(R.styleable.ChannelListHeaderView_streamUiOfflineProgressBarTint);
        if (colorStateList == null) {
            colorStateList = ContextCompat.getColorStateList((Context)this.getContext(), (int)R.color.stream_ui_accent_blue);
        }
        return colorStateList;
    }

    /*
     * WARNING - void declaration
     */
    private final void configActionButton(TypedArray typedArray) {
        void $this$isInvisible$iv;
        ImageView imageView;
        ImageView $this$configActionButton_u24lambda_u243 = imageView = this.binding.actionButton;
        boolean bl = false;
        boolean showActionButton = typedArray.getBoolean(R.styleable.ChannelListHeaderView_streamUiShowActionButton, true);
        Intrinsics.checkNotNull((Object)$this$configActionButton_u24lambda_u243);
        View view = (View)$this$configActionButton_u24lambda_u243;
        boolean value$iv = !showActionButton;
        boolean $i$f$setInvisible = false;
        $this$isInvisible$iv.setVisibility(value$iv ? 4 : 0);
        $this$configActionButton_u24lambda_u243.setClickable(showActionButton);
        Drawable drawable2 = typedArray.getDrawable(R.styleable.ChannelListHeaderView_streamUiActionButtonIcon);
        if (drawable2 == null) {
            drawable2 = ContextCompat.getDrawable((Context)$this$configActionButton_u24lambda_u243.getContext(), (int)R.drawable.stream_ui_ic_pen);
        }
        Drawable drawable3 = drawable2;
        $this$configActionButton_u24lambda_u243.setImageDrawable(drawable3);
        ColorStateList colorStateList = typedArray.getColorStateList(R.styleable.ChannelListHeaderView_streamUiActionBackgroundTint);
        if (colorStateList == null) {
            colorStateList = ContextCompat.getColorStateList((Context)$this$configActionButton_u24lambda_u243.getContext(), (int)R.color.stream_ui_icon_button_background_selector);
        }
        $this$configActionButton_u24lambda_u243.setBackgroundTintList(colorStateList);
    }

    private final void configureSeparator(TypedArray typedArray) {
        View view;
        View $this$configureSeparator_u24lambda_u244 = view = this.binding.separator;
        boolean bl = false;
        Drawable drawable2 = typedArray.getDrawable(R.styleable.ChannelListHeaderView_streamUiChannelListSeparatorBackgroundDrawable);
        $this$configureSeparator_u24lambda_u244.setVisibility(drawable2 != null ? 0 : 8);
        $this$configureSeparator_u24lambda_u244.setBackground(drawable2);
    }

    private final TextStyle getOnlineTitleTextStyle(TypedArray typedArray) {
        TextStyle.Builder builder = new TextStyle.Builder(typedArray);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        TextStyle.Builder builder2 = builder.size(R.styleable.ChannelListHeaderView_streamUiOnlineTitleTextSize, ContextKt.getDimension(context, R.dimen.stream_ui_text_large));
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        return builder2.color(R.styleable.ChannelListHeaderView_streamUiOnlineTitleTextColor, ContextKt.getColorCompat(context2, R.color.stream_ui_text_color_primary)).font(R.styleable.ChannelListHeaderView_streamUiOnlineTitleFontAssets, R.styleable.ChannelListHeaderView_streamUiOnlineTitleTextFont).style(R.styleable.ChannelListHeaderView_streamUiOnlineTitleTextStyle, 1).build();
    }

    private final TextStyle getOfflineTitleTextStyle(TypedArray typedArray) {
        TextStyle.Builder builder = new TextStyle.Builder(typedArray);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        TextStyle.Builder builder2 = builder.size(R.styleable.ChannelListHeaderView_streamUiOfflineTitleTextSize, ContextKt.getDimension(context, R.dimen.stream_ui_text_large));
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        return builder2.color(R.styleable.ChannelListHeaderView_streamUiOfflineTitleTextColor, ContextKt.getColorCompat(context2, R.color.stream_ui_text_color_primary)).font(R.styleable.ChannelListHeaderView_streamUiOfflineTitleFontAssets, R.styleable.ChannelListHeaderView_streamUiOfflineTitleTextFont).style(R.styleable.ChannelListHeaderView_streamUiOfflineTitleTextStyle, 1).build();
    }

    public final void setUser(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        UserAvatarView userAvatarView = this.binding.userAvatarView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)userAvatarView), (String)"userAvatarView");
        UserAvatarView.setUser$default(userAvatarView, user, false, 2, null);
    }

    public final void setOnlineTitle(@NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.binding.onlineTextView.setText((CharSequence)title2);
    }

    public final void showOnlineTitle() {
        View $this$isVisible$iv;
        LinearLayout linearLayout = this.binding.offlineTitleContainer;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"offlineTitleContainer");
        View view = (View)linearLayout;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        TextView textView = this.binding.onlineTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"onlineTextView");
        $this$isVisible$iv = (View)textView;
        value$iv = true;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
    }

    public final void setOnTitleClickListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.binding.offlineTextView.setOnClickListener(arg_0 -> ChannelListHeaderView.setOnTitleClickListener$lambda$5(listener, arg_0));
        this.binding.onlineTextView.setOnClickListener(arg_0 -> ChannelListHeaderView.setOnTitleClickListener$lambda$6(listener, arg_0));
    }

    public final void setOnTitleLongClickListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.binding.offlineTextView.setOnLongClickListener(arg_0 -> ChannelListHeaderView.setOnTitleLongClickListener$lambda$7(listener, arg_0));
        this.binding.onlineTextView.setOnLongClickListener(arg_0 -> ChannelListHeaderView.setOnTitleLongClickListener$lambda$8(listener, arg_0));
    }

    public final void showOfflineTitle() {
        View $this$isVisible$iv;
        LinearLayout linearLayout = this.binding.offlineTitleContainer;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"offlineTitleContainer");
        View view = (View)linearLayout;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        ProgressBar progressBar = this.binding.offlineProgressBar;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"offlineProgressBar");
        $this$isVisible$iv = (View)progressBar;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        TextView textView = this.binding.onlineTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"onlineTextView");
        $this$isVisible$iv = (View)textView;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.binding.offlineTextView.setText((CharSequence)this.getResources().getString(R.string.stream_ui_channel_list_header_offline));
    }

    public final void showConnectingTitle() {
        View $this$isVisible$iv;
        LinearLayout linearLayout = this.binding.offlineTitleContainer;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"offlineTitleContainer");
        View view = (View)linearLayout;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        ProgressBar progressBar = this.binding.offlineProgressBar;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"offlineProgressBar");
        $this$isVisible$iv = (View)progressBar;
        value$iv = true;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        TextView textView = this.binding.onlineTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"onlineTextView");
        $this$isVisible$iv = (View)textView;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.binding.offlineTextView.setText((CharSequence)this.getResources().getString(R.string.stream_ui_channel_list_header_disconnected));
    }

    public final void setOnUserAvatarClickListener(@NotNull UserAvatarClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.binding.userAvatarView.setOnClickListener(arg_0 -> ChannelListHeaderView.setOnUserAvatarClickListener$lambda$9(listener, arg_0));
    }

    public final void setOnActionButtonClickListener(@NotNull ActionButtonClickListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.binding.actionButton.setOnClickListener(arg_0 -> ChannelListHeaderView.setOnActionButtonClickListener$lambda$10(listener, arg_0));
    }

    @InternalStreamChatApi
    public final void setOnUserAvatarLongClickListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.binding.userAvatarView.setOnLongClickListener(arg_0 -> ChannelListHeaderView.setOnUserAvatarLongClickListener$lambda$11(listener, arg_0));
    }

    private static final void setOnTitleClickListener$lambda$5(Function0 $listener, View it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.invoke();
    }

    private static final void setOnTitleClickListener$lambda$6(Function0 $listener, View it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.invoke();
    }

    private static final boolean setOnTitleLongClickListener$lambda$7(Function0 $listener, View it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.invoke();
        return true;
    }

    private static final boolean setOnTitleLongClickListener$lambda$8(Function0 $listener, View it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.invoke();
        return true;
    }

    private static final void setOnUserAvatarClickListener$lambda$9(UserAvatarClickListener $listener, View it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.onUserAvatarClick();
    }

    private static final void setOnActionButtonClickListener$lambda$10(ActionButtonClickListener $listener, View it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.onClick();
    }

    private static final boolean setOnUserAvatarLongClickListener$lambda$11(Function0 $listener, View it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        $listener.invoke();
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/getstream/chat/android/ui/feature/channels/header/ChannelListHeaderView$ActionButtonClickListener;", "", "onClick", "", "stream-chat-android-ui-components_release"})
    public static interface ActionButtonClickListener {
        public void onClick();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lio/getstream/chat/android/ui/feature/channels/header/ChannelListHeaderView$UserAvatarClickListener;", "", "onUserAvatarClick", "", "stream-chat-android-ui-components_release"})
    public static interface UserAvatarClickListener {
        public void onUserAvatarClick();
    }
}

