/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.channels.list.adapter.viewholder;

import android.annotation.SuppressLint;
import android.view.MotionEvent;
import android.view.View;
import io.getstream.chat.android.ui.feature.channels.list.ChannelListView;
import io.getstream.chat.android.ui.feature.channels.list.adapter.viewholder.BaseChannelListItemViewHolder;
import io.getstream.chat.android.ui.utils.extensions.IntKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.ClosedFloatingPointRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H&J\b\u0010\u0013\u001a\u00020\u0012H&J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H&J\b\u0010\u0016\u001a\u00020\u0003H&J\b\u0010\u0017\u001a\u00020\fH&J\b\u0010\u0018\u001a\u00020\fH&J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0007R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/SwipeViewHolder;", "Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/BaseChannelListItemViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "listener", "Lio/getstream/chat/android/ui/feature/channels/list/ChannelListView$SwipeListener;", "getListener", "()Lio/getstream/chat/android/ui/feature/channels/list/ChannelListView$SwipeListener;", "setListener", "(Lio/getstream/chat/android/ui/feature/channels/list/ChannelListView$SwipeListener;)V", "swiping", "", "getSwiping", "()Z", "setSwiping", "(Z)V", "getClosedX", "", "getOpenedX", "getSwipeDeltaRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "getSwipeView", "isSwipeEnabled", "isSwiped", "setSwipeListener", "", "view", "swipeListener", "Companion", "stream-chat-android-ui-components_release"})
public abstract class SwipeViewHolder
extends BaseChannelListItemViewHolder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private ChannelListView.SwipeListener listener;
    private boolean swiping;
    private static final float SWIPE_THRESHOLD = IntKt.dpToPxPrecise(16);

    public SwipeViewHolder(@NotNull View itemView) {
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        super(itemView);
    }

    @NotNull
    public abstract View getSwipeView();

    public abstract float getOpenedX();

    public abstract float getClosedX();

    @NotNull
    public abstract ClosedFloatingPointRange<Float> getSwipeDeltaRange();

    public abstract boolean isSwipeEnabled();

    public abstract boolean isSwiped();

    @Nullable
    protected final ChannelListView.SwipeListener getListener() {
        return this.listener;
    }

    protected final void setListener(@Nullable ChannelListView.SwipeListener swipeListener2) {
        this.listener = swipeListener2;
    }

    protected final boolean getSwiping() {
        return this.swiping;
    }

    protected final void setSwiping(boolean bl) {
        this.swiping = bl;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public final void setSwipeListener(@NotNull View view, @Nullable ChannelListView.SwipeListener swipeListener2) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Ref.FloatRef startX = new Ref.FloatRef();
        Ref.FloatRef startY = new Ref.FloatRef();
        Ref.FloatRef prevX = new Ref.FloatRef();
        Ref.BooleanRef wasSwiping = new Ref.BooleanRef();
        this.listener = swipeListener2;
        view.setOnTouchListener((arg_0, arg_1) -> SwipeViewHolder.setSwipeListener$lambda$0(this, startX, startY, prevX, wasSwiping, swipeListener2, arg_0, arg_1));
    }

    private static final boolean setSwipeListener$lambda$0(SwipeViewHolder this$0, Ref.FloatRef $startX, Ref.FloatRef $startY, Ref.FloatRef $prevX, Ref.BooleanRef $wasSwiping, ChannelListView.SwipeListener $swipeListener, View view, MotionEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$startX, (String)"$startX");
        Intrinsics.checkNotNullParameter((Object)$startY, (String)"$startY");
        Intrinsics.checkNotNullParameter((Object)$prevX, (String)"$prevX");
        Intrinsics.checkNotNullParameter((Object)$wasSwiping, (String)"$wasSwiping");
        if (!this$0.isSwipeEnabled()) {
            return false;
        }
        float rawX = event.getRawX();
        float rawY = event.getRawY();
        switch (event.getAction()) {
            case 0: {
                $startX.element = rawX;
                $startY.element = rawY;
                $prevX.element = $startX.element;
                bl = this$0.swiping = false;
                break;
            }
            case 2: {
                float totalDeltaX = rawX - $startX.element;
                float totalDeltaY = rawY - $startY.element;
                float lastMoveDeltaX = rawX - $prevX.element;
                $prevX.element = rawX;
                $wasSwiping.element = this$0.swiping;
                this$0.swiping = Math.abs(totalDeltaX) > Math.abs(totalDeltaY);
                if (!$wasSwiping.element && this$0.swiping) {
                    ChannelListView.SwipeListener swipeListener2 = $swipeListener;
                    if (swipeListener2 != null) {
                        swipeListener2.onSwipeStarted(this$0, this$0.getAbsoluteAdapterPosition(), Float.valueOf(rawX), Float.valueOf(rawY));
                    }
                } else if (this$0.swiping) {
                    ChannelListView.SwipeListener swipeListener3 = $swipeListener;
                    if (swipeListener3 != null) {
                        swipeListener3.onSwipeChanged(this$0, this$0.getAbsoluteAdapterPosition(), lastMoveDeltaX, totalDeltaX);
                    }
                } else if ($wasSwiping.element && !this$0.swiping) {
                    ChannelListView.SwipeListener swipeListener4 = $swipeListener;
                    if (swipeListener4 != null) {
                        swipeListener4.onSwipeCanceled(this$0, this$0.getAbsoluteAdapterPosition(), Float.valueOf(rawX), Float.valueOf(rawY));
                    }
                }
                bl = this$0.swiping;
                break;
            }
            case 1: {
                boolean shouldConsume = false;
                if ($wasSwiping.element) {
                    this$0.swiping = false;
                    $wasSwiping.element = false;
                    shouldConsume = Math.abs(rawX - $startX.element) > SWIPE_THRESHOLD;
                    ChannelListView.SwipeListener swipeListener5 = $swipeListener;
                    if (swipeListener5 != null) {
                        swipeListener5.onSwipeCompleted(this$0, this$0.getAbsoluteAdapterPosition(), Float.valueOf(rawX), Float.valueOf(rawY));
                    }
                }
                bl = shouldConsume;
                break;
            }
            case 3: {
                if ($wasSwiping.element) {
                    this$0.swiping = false;
                    $wasSwiping.element = false;
                    ChannelListView.SwipeListener swipeListener6 = $swipeListener;
                    if (swipeListener6 != null) {
                        swipeListener6.onSwipeCanceled(this$0, this$0.getAbsoluteAdapterPosition(), Float.valueOf(rawX), Float.valueOf(rawY));
                    }
                }
                bl = $wasSwiping.element;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/SwipeViewHolder$Companion;", "", "()V", "SWIPE_THRESHOLD", "", "stream-chat-android-ui-components_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

