/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.channels.list.adapter.viewholder.internal;

import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import io.getstream.chat.android.ui.feature.channels.list.ChannelListView;
import io.getstream.chat.android.ui.feature.channels.list.adapter.viewholder.SwipeViewHolder;
import io.getstream.chat.android.ui.feature.channels.list.adapter.viewholder.internal.ChannelItemSwipeListener;
import io.getstream.chat.android.ui.feature.channels.list.adapter.viewholder.internal.ChannelViewHolder;
import io.getstream.chat.android.ui.widgets.internal.ScrollPauseLinearLayoutManager;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001$B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\bH\u0016J1\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001bJ(\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J1\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001bJ1\u0010 \u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010!\u001a\u00020\u0012*\u00020\"2\u0006\u0010#\u001a\u00020\u0019H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener;", "Lio/getstream/chat/android/ui/feature/channels/list/ChannelListView$SwipeListener;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "layoutManager", "Lio/getstream/chat/android/ui/widgets/internal/ScrollPauseLinearLayoutManager;", "swipeStateByPosition", "", "", "Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener$SwipeState;", "multiSwipeEnabled", "", "(Landroidx/recyclerview/widget/RecyclerView;Lio/getstream/chat/android/ui/widgets/internal/ScrollPauseLinearLayoutManager;Ljava/util/Map;Z)V", "getLayoutManager", "()Lio/getstream/chat/android/ui/widgets/internal/ScrollPauseLinearLayoutManager;", "getRecyclerView", "()Landroidx/recyclerview/widget/RecyclerView;", "closeAllOtherPositions", "", "adapterPosition", "onRestoreSwipePosition", "viewHolder", "Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/SwipeViewHolder;", "onSwipeCanceled", "x", "", "y", "(Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/SwipeViewHolder;ILjava/lang/Float;Ljava/lang/Float;)V", "onSwipeChanged", "dX", "totalDeltaX", "onSwipeCompleted", "onSwipeStarted", "animateSwipeTo", "Landroid/view/View;", "value", "SwipeState", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nChannelItemSwipeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelItemSwipeListener.kt\nio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Any.kt\nio/getstream/chat/android/ui/common/extensions/internal/AnyKt\n*L\n1#1,149:1\n1313#2:150\n1314#2:152\n21#3:151\n*S KotlinDebug\n*F\n+ 1 ChannelItemSwipeListener.kt\nio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener\n*L\n130#1:150\n130#1:152\n135#1:151\n*E\n"})
public final class ChannelItemSwipeListener
implements ChannelListView.SwipeListener {
    @NotNull
    private final RecyclerView recyclerView;
    @NotNull
    private final ScrollPauseLinearLayoutManager layoutManager;
    @NotNull
    private final Map<Integer, SwipeState> swipeStateByPosition;
    private boolean multiSwipeEnabled;

    @JvmOverloads
    public ChannelItemSwipeListener(@NotNull RecyclerView recyclerView, @NotNull ScrollPauseLinearLayoutManager layoutManager, @NotNull Map<Integer, SwipeState> swipeStateByPosition, boolean multiSwipeEnabled) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
        Intrinsics.checkNotNullParameter(swipeStateByPosition, (String)"swipeStateByPosition");
        this.recyclerView = recyclerView;
        this.layoutManager = layoutManager;
        this.swipeStateByPosition = swipeStateByPosition;
        this.multiSwipeEnabled = multiSwipeEnabled;
    }

    public /* synthetic */ ChannelItemSwipeListener(RecyclerView recyclerView, ScrollPauseLinearLayoutManager scrollPauseLinearLayoutManager, Map map2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map2 = new LinkedHashMap();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(recyclerView, scrollPauseLinearLayoutManager, map2, bl);
    }

    @NotNull
    public final RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    @NotNull
    public final ScrollPauseLinearLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    @Override
    public void onSwipeStarted(@NotNull SwipeViewHolder viewHolder, int adapterPosition, @Nullable Float x, @Nullable Float y) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        this.layoutManager.setVerticalScrollEnabled(false);
    }

    @Override
    public void onSwipeChanged(@NotNull SwipeViewHolder viewHolder, int adapterPosition, float dX, float totalDeltaX) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        float projectedX = viewHolder.getSwipeView().getX() + dX;
        float clampedX = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(projectedX), viewHolder.getSwipeDeltaRange()))).floatValue();
        boolean bl = false;
        View swipeView = viewHolder.getSwipeView();
        if (!(swipeView.getX() == clampedX)) {
            swipeView.setX(clampedX);
        }
        viewHolder.itemView.setPressed(false);
    }

    @Override
    public void onSwipeCompleted(@NotNull SwipeViewHolder viewHolder, int adapterPosition, @Nullable Float x, @Nullable Float y) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        float snapValue = viewHolder.isSwiped() ? viewHolder.getOpenedX() : viewHolder.getClosedX();
        this.animateSwipeTo(viewHolder.getSwipeView(), snapValue);
        SwipeState swipeState = viewHolder.isSwiped() ? (SwipeState)SwipeState.Open.INSTANCE : (SwipeState)SwipeState.Closed.INSTANCE;
        Integer n = adapterPosition;
        this.swipeStateByPosition.put(n, swipeState);
        if (!this.multiSwipeEnabled && Intrinsics.areEqual((Object)swipeState, (Object)SwipeState.Open.INSTANCE)) {
            this.closeAllOtherPositions(adapterPosition);
        }
        this.layoutManager.setVerticalScrollEnabled(true);
    }

    @Override
    public void onSwipeCanceled(@NotNull SwipeViewHolder viewHolder, int adapterPosition, @Nullable Float x, @Nullable Float y) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        this.animateSwipeTo(viewHolder.getSwipeView(), viewHolder.getClosedX());
        Integer n = adapterPosition;
        this.swipeStateByPosition.put(n, SwipeState.Closed.INSTANCE);
        this.layoutManager.setVerticalScrollEnabled(true);
    }

    @Override
    public void onRestoreSwipePosition(@NotNull SwipeViewHolder viewHolder, int adapterPosition) {
        SwipeViewHolder swipeViewHolder;
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        SwipeViewHolder $this$onRestoreSwipePosition_u24lambda_u241 = swipeViewHolder = viewHolder;
        boolean bl = false;
        $this$onRestoreSwipePosition_u24lambda_u241.getSwipeView().setX(Intrinsics.areEqual((Object)this.swipeStateByPosition.get(adapterPosition), (Object)SwipeState.Open.INSTANCE) ? $this$onRestoreSwipePosition_u24lambda_u241.getOpenedX() : $this$onRestoreSwipePosition_u24lambda_u241.getClosedX());
    }

    private final void animateSwipeTo(View $this$animateSwipeTo, float value) {
        $this$animateSwipeTo.animate().x(value).setStartDelay(0L).setDuration(100L).start();
    }

    /*
     * WARNING - void declaration
     */
    private final void closeAllOtherPositions(int adapterPosition) {
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(this.swipeStateByPosition), (Function1)((Function1)new Function1<Map.Entry<? extends Integer, ? extends SwipeState>, Boolean>(adapterPosition){
            final /* synthetic */ int $adapterPosition;
            {
                this.$adapterPosition = $adapterPosition;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<Integer, ? extends SwipeState> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ((Number)it.getKey()).intValue() != this.$adapterPosition;
            }
        })), (Function1)closeAllOtherPositions.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChannelViewHolder channelViewHolder;
            void $this$safeCast$iv;
            Map.Entry swipeStateEntry = (Map.Entry)element$iv;
            boolean bl = false;
            this.swipeStateByPosition.put((Integer)swipeStateEntry.getKey(), SwipeState.Closed.INSTANCE);
            RecyclerView.ViewHolder viewHolder = this.recyclerView.findViewHolderForAdapterPosition(((Number)swipeStateEntry.getKey()).intValue());
            if (viewHolder == null) continue;
            RecyclerView.ViewHolder viewHolder2 = viewHolder;
            boolean $i$f$safeCast = false;
            Object v0 = $this$safeCast$iv;
            if (!(v0 instanceof ChannelViewHolder)) {
                v0 = null;
            }
            if ((channelViewHolder = (ChannelViewHolder)v0) == null) continue;
            ChannelViewHolder viewHolder3 = channelViewHolder;
            boolean bl2 = false;
            boolean viewCompletelyVisible = this.layoutManager.isViewPartiallyVisible(viewHolder3.itemView, true, false);
            boolean viewPartiallyVisible = this.layoutManager.isViewPartiallyVisible(viewHolder3.itemView, false, false);
            boolean onScreen = viewCompletelyVisible || viewPartiallyVisible;
            if (!onScreen) continue;
            this.animateSwipeTo(viewHolder3.getSwipeView(), viewHolder3.getClosedX());
        }
    }

    @JvmOverloads
    public ChannelItemSwipeListener(@NotNull RecyclerView recyclerView, @NotNull ScrollPauseLinearLayoutManager layoutManager, @NotNull Map<Integer, SwipeState> swipeStateByPosition) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
        Intrinsics.checkNotNullParameter(swipeStateByPosition, (String)"swipeStateByPosition");
        this(recyclerView, layoutManager, swipeStateByPosition, false, 8, null);
    }

    @JvmOverloads
    public ChannelItemSwipeListener(@NotNull RecyclerView recyclerView, @NotNull ScrollPauseLinearLayoutManager layoutManager) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutManager), (String)"layoutManager");
        this(recyclerView, layoutManager, null, false, 12, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener$SwipeState;", "", "()V", "Closed", "Open", "Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener$SwipeState$Closed;", "Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener$SwipeState$Open;", "stream-chat-android-ui-components_release"})
    public static abstract class SwipeState {
        private SwipeState() {
        }

        public /* synthetic */ SwipeState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener$SwipeState$Closed;", "Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener$SwipeState;", "()V", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class Closed
        extends SwipeState {
            @NotNull
            public static final Closed INSTANCE = new Closed();

            private Closed() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Closed";
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener$SwipeState$Open;", "Lio/getstream/chat/android/ui/feature/channels/list/adapter/viewholder/internal/ChannelItemSwipeListener$SwipeState;", "()V", "toString", "", "stream-chat-android-ui-components_release"})
        public static final class Open
        extends SwipeState {
            @NotNull
            public static final Open INSTANCE = new Open();

            private Open() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Open";
            }
        }
    }
}

