/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.android.ui.feature.gallery;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.activity.ComponentActivity;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import io.getstream.chat.android.models.Attachment;
import io.getstream.chat.android.ui.ChatUI;
import io.getstream.chat.android.ui.R;
import io.getstream.chat.android.ui.common.images.internal.StreamImageLoader;
import io.getstream.chat.android.ui.common.utils.StreamFileUtil;
import io.getstream.chat.android.ui.databinding.StreamUiActivityAttachmentGalleryBinding;
import io.getstream.chat.android.ui.feature.gallery.AttachmentGalleryItem;
import io.getstream.chat.android.ui.feature.gallery.AttachmentGalleryResultItem;
import io.getstream.chat.android.ui.feature.gallery.AttachmentGalleryResultItemKt;
import io.getstream.chat.android.ui.feature.gallery.internal.AttachmentGalleryPagerAdapter;
import io.getstream.chat.android.ui.feature.gallery.internal.AttachmentGalleryViewModel;
import io.getstream.chat.android.ui.feature.gallery.options.AttachmentGalleryOptionsViewStyle;
import io.getstream.chat.android.ui.feature.gallery.options.internal.AttachmentGalleryOptionsDialogFragment;
import io.getstream.chat.android.ui.feature.gallery.overview.internal.MediaAttachmentDialogFragment;
import io.getstream.chat.android.ui.utils.PermissionChecker;
import io.getstream.chat.android.ui.utils.extensions.ConstraintLayoutKt;
import io.getstream.chat.android.ui.utils.extensions.ContextKt;
import io.getstream.log.Priority;
import io.getstream.log.StreamLogExtensionKt;
import io.getstream.log.StreamLogger;
import io.getstream.log.TaggedLogger;
import io.getstream.result.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 T2\u00020\u0001:\u0006OPQRSTB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u001a\u00101\u001a\u00020+2\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010.H\u0002J\b\u00105\u001a\u00020+H\u0002J\b\u00106\u001a\u00020+H\u0002J\u0012\u00107\u001a\u00020+2\b\u00108\u001a\u0004\u0018\u000109H\u0014J\b\u0010:\u001a\u00020+H\u0014J\u0010\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020\u0013H\u0002J\b\u0010=\u001a\u00020+H\u0002J\u0010\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020@H\u0002J\b\u0010A\u001a\u00020+H\u0002J\b\u0010B\u001a\u00020+H\u0002J\u0016\u0010C\u001a\u00020+2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\b\u0010D\u001a\u00020+H\u0002J\b\u0010E\u001a\u00020+H\u0002J\b\u0010F\u001a\u00020+H\u0002J\u0010\u0010G\u001a\u00020+2\u0006\u0010H\u001a\u00020IH\u0002J\b\u0010J\u001a\u00020+H\u0002J\u0010\u0010K\u001a\u00020+2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010L\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\u000fH\u0002J\b\u0010N\u001a\u00020+H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0017\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u0017\u001a\u0004\b'\u0010(\u00a8\u0006U"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "adapter", "Lio/getstream/chat/android/ui/feature/gallery/internal/AttachmentGalleryPagerAdapter;", "attachmentGalleryItems", "", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryItem;", "attachmentGalleryResultItem", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "getAttachmentGalleryResultItem", "()Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "binding", "Lio/getstream/chat/android/ui/databinding/StreamUiActivityAttachmentGalleryBinding;", "deleteOptionEnabled", "", "handleSaveMedia", "Lio/getstream/chat/android/ui/feature/gallery/options/internal/AttachmentGalleryOptionsDialogFragment$AttachmentOptionHandler;", "initialIndex", "", "getInitialIndex", "()I", "initialIndex$delegate", "Lkotlin/Lazy;", "isFullScreen", "logger", "Lio/getstream/log/TaggedLogger;", "getLogger", "()Lio/getstream/log/TaggedLogger;", "logger$delegate", "permissionChecker", "Lio/getstream/chat/android/ui/utils/PermissionChecker;", "replyOptionEnabled", "saveMediaOptionEnabled", "shareMediaJob", "Lkotlinx/coroutines/Job;", "showInChatOptionEnabled", "viewModel", "Lio/getstream/chat/android/ui/feature/gallery/internal/AttachmentGalleryViewModel;", "getViewModel", "()Lio/getstream/chat/android/ui/feature/gallery/internal/AttachmentGalleryViewModel;", "viewModel$delegate", "enterFullScreenMode", "", "exitFullScreenMode", "getRelativeAttachmentDate", "", "createdAt", "Ljava/util/Date;", "launchShareActivity", "mediaUri", "Landroid/net/Uri;", "attachmentType", "observePageChanges", "obtainOptionsViewStyle", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onGalleryPageSelected", "position", "setNoSharingInProgressUi", "setResultAndFinish", "result", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult;", "setSharingInProgressUi", "setupAttachmentActionsButton", "setupGallery", "setupGalleryAdapter", "setupGalleryOverviewButton", "setupShareMediaButton", "shareImage", "attachment", "Lio/getstream/chat/android/models/Attachment;", "shareMedia", "shareVideo", "shouldShowOptionsButton", "isMine", "toastFailedShare", "AttachmentDeleteOptionHandler", "AttachmentDownloadOptionHandler", "AttachmentOptionResult", "AttachmentReplyOptionHandler", "AttachmentShowInChatOptionHandler", "Companion", "stream-chat-android-ui-components_release"})
@SourceDebugExtension(value={"SMAP\nAttachmentGalleryActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentGalleryActivity.kt\nio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 View.kt\nandroidx/core/view/ViewKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 TypedArray.kt\nio/getstream/chat/android/ui/utils/extensions/TypedArrayKt\n+ 7 StreamLog.kt\nio/getstream/log/TaggedLogger\n*L\n1#1,515:1\n75#2,13:516\n1549#3:529\n1620#3,3:530\n262#4,2:533\n262#4,2:536\n262#4,2:538\n262#4,2:540\n262#4,2:542\n1#5:535\n65#6,6:544\n259#7,4:550\n*S KotlinDebug\n*F\n+ 1 AttachmentGalleryActivity.kt\nio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity\n*L\n96#1:516,13\n140#1:529\n140#1:530,3\n326#1:533,2\n362#1:536,2\n363#1:538,2\n376#1:540,2\n377#1:542,2\n438#1:544,6\n446#1:550,4\n*E\n"})
public final class AttachmentGalleryActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private StreamUiActivityAttachmentGalleryBinding binding;
    @NotNull
    private final Lazy logger$delegate = StreamLogExtensionKt.taggedLogger((Object)((Object)this), (String)"Chat:AttachmentGalleryActivity");
    private boolean replyOptionEnabled = true;
    private boolean showInChatOptionEnabled = true;
    private boolean saveMediaOptionEnabled = true;
    private boolean deleteOptionEnabled = true;
    @Nullable
    private Job shareMediaJob;
    @NotNull
    private final Lazy initialIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
        final /* synthetic */ AttachmentGalleryActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Integer invoke() {
            return this.this$0.getIntent().getIntExtra("extra_key_initial_index", 0);
        }
    }));
    @NotNull
    private final Lazy viewModel$delegate;
    private AttachmentGalleryPagerAdapter adapter;
    @NotNull
    private final PermissionChecker permissionChecker;
    @NotNull
    private List<AttachmentGalleryItem> attachmentGalleryItems;
    private boolean isFullScreen;
    @NotNull
    private final AttachmentGalleryOptionsDialogFragment.AttachmentOptionHandler handleSaveMedia;
    @NotNull
    private static final String EXTRA_KEY_INITIAL_INDEX = "extra_key_initial_index";
    @NotNull
    public static final String EXTRA_ATTACHMENT_OPTION_RESULT = "extra_attachment_option_result";

    public AttachmentGalleryActivity() {
        ComponentActivity $this$viewModels_u24default$iv = (ComponentActivity)this;
        Function0 extrasProducer$iv = null;
        Object factoryProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = (Function0)new Function0<ViewModelProvider.Factory>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.$this_viewModels.getDefaultViewModelProviderFactory();
            }
        };
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(AttachmentGalleryViewModel.class), (Function0)new Function0<ViewModelStore>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                return this.$this_viewModels.getViewModelStore();
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, $this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_viewModels.getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        });
        this.permissionChecker = new PermissionChecker();
        this.attachmentGalleryItems = CollectionsKt.emptyList();
        this.handleSaveMedia = () -> AttachmentGalleryActivity.handleSaveMedia$lambda$8(this);
    }

    private final TaggedLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (TaggedLogger)lazy.getValue();
    }

    private final int getInitialIndex() {
        Lazy lazy = this.initialIndex$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final AttachmentGalleryViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (AttachmentGalleryViewModel)((Object)lazy.getValue());
    }

    private final AttachmentGalleryResultItem getAttachmentGalleryResultItem() {
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        AttachmentGalleryItem currentItem = this.attachmentGalleryItems.get(streamUiActivityAttachmentGalleryBinding.galleryViewPager.getCurrentItem());
        return AttachmentGalleryResultItemKt.toAttachmentGalleryResultItem(currentItem.getAttachment(), currentItem.getMessageId(), currentItem.getMessageId(), currentItem.getCid(), currentItem.getUser().getName(), currentItem.isMine());
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = StreamUiActivityAttachmentGalleryBinding.inflate(ContextKt.getStreamThemeInflater((Context)this));
        Intrinsics.checkNotNullExpressionValue((Object)streamUiActivityAttachmentGalleryBinding, (String)"inflate(...)");
        this.binding = streamUiActivityAttachmentGalleryBinding;
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding2 = this.binding;
        if (streamUiActivityAttachmentGalleryBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding2 = null;
        }
        this.setContentView((View)streamUiActivityAttachmentGalleryBinding2.getRoot());
        this.setupGalleryOverviewButton();
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding3 = this.binding;
        if (streamUiActivityAttachmentGalleryBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding3 = null;
        }
        streamUiActivityAttachmentGalleryBinding3.closeButton.setOnClickListener(arg_0 -> AttachmentGalleryActivity.onCreate$lambda$0(this, arg_0));
        Function1 function1 = (Function1)new Function1<List<? extends AttachmentGalleryItem>, Unit>((Object)this){

            public final void invoke(@NotNull List<AttachmentGalleryItem> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                AttachmentGalleryActivity.access$setupGallery((AttachmentGalleryActivity)((Object)this.receiver), p0);
            }
        };
        this.getViewModel().getAttachmentGalleryItemsLiveData().observe((LifecycleOwner)this, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    private final void setupGallery(List<AttachmentGalleryItem> attachmentGalleryItems) {
        if (attachmentGalleryItems.isEmpty()) {
            this.onBackPressed();
        } else {
            this.attachmentGalleryItems = attachmentGalleryItems;
            this.setupGalleryAdapter();
            this.setupShareMediaButton();
            this.setupAttachmentActionsButton();
            this.obtainOptionsViewStyle();
            this.observePageChanges();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupGalleryAdapter() {
        Collection<Attachment> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.attachmentGalleryItems;
        FragmentActivity fragmentActivity = (FragmentActivity)this;
        AttachmentGalleryActivity attachmentGalleryActivity = this;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AttachmentGalleryItem attachmentGalleryItem = (AttachmentGalleryItem)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAttachment());
        }
        collection = (List)destination$iv$iv;
        Function0 function0 = (Function0)new Function0<Unit>(this){
            final /* synthetic */ AttachmentGalleryActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AttachmentGalleryActivity.access$setFullScreen$p(this.this$0, !AttachmentGalleryActivity.access$isFullScreen$p(this.this$0));
                if (AttachmentGalleryActivity.access$isFullScreen$p(this.this$0)) {
                    AttachmentGalleryActivity.access$enterFullScreenMode(this.this$0);
                } else {
                    AttachmentGalleryActivity.access$exitFullScreenMode(this.this$0);
                }
            }
        };
        List list = collection;
        FragmentActivity fragmentActivity2 = fragmentActivity;
        attachmentGalleryActivity.adapter = new AttachmentGalleryPagerAdapter(fragmentActivity2, list, (Function0<Unit>)function0);
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        ViewPager2 viewPager2 = streamUiActivityAttachmentGalleryBinding.galleryViewPager;
        AttachmentGalleryPagerAdapter attachmentGalleryPagerAdapter = this.adapter;
        if (attachmentGalleryPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            attachmentGalleryPagerAdapter = null;
        }
        viewPager2.setAdapter((RecyclerView.Adapter)attachmentGalleryPagerAdapter);
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding2 = this.binding;
        if (streamUiActivityAttachmentGalleryBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding2 = null;
        }
        streamUiActivityAttachmentGalleryBinding2.galleryViewPager.setCurrentItem(this.getInitialIndex(), false);
    }

    private final void setupShareMediaButton() {
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        streamUiActivityAttachmentGalleryBinding.shareMediaButton.setOnClickListener(arg_0 -> AttachmentGalleryActivity.setupShareMediaButton$lambda$2(this, arg_0));
    }

    private final void shareMedia() {
        Attachment attachment;
        String string2;
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding;
        AttachmentGalleryPagerAdapter attachmentGalleryPagerAdapter = this.adapter;
        if (attachmentGalleryPagerAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            attachmentGalleryPagerAdapter = null;
        }
        if ((streamUiActivityAttachmentGalleryBinding = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        if (Intrinsics.areEqual((Object)(string2 = (attachment = attachmentGalleryPagerAdapter.getItem(streamUiActivityAttachmentGalleryBinding.galleryViewPager.getCurrentItem())).getType()), (Object)"image")) {
            this.shareImage(attachment);
        } else if (Intrinsics.areEqual((Object)string2, (Object)"video")) {
            this.shareVideo(attachment);
        } else {
            this.toastFailedShare();
        }
    }

    private final void shareImage(Attachment attachment) {
        String imageUrl2 = attachment.getImageUrl();
        if (imageUrl2 != null) {
            Job job = this.shareMediaJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.shareMediaJob = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), (CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, imageUrl2, attachment, null){
                int label;
                final /* synthetic */ AttachmentGalleryActivity this$0;
                final /* synthetic */ String $imageUrl;
                final /* synthetic */ Attachment $attachment;
                {
                    this.this$0 = $receiver;
                    this.$imageUrl = $imageUrl;
                    this.$attachment = $attachment;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = StreamImageLoader.Companion.instance();
                            v1 = this.this$0.getApplicationContext();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getApplicationContext(...)");
                            this.label = 1;
                            v2 = StreamImageLoader.DefaultImpls.loadAsBitmap$default((StreamImageLoader)v0, (Context)v1, (String)this.$imageUrl, null, (Continuation)((Continuation)this), (int)4, null);
                            if (v2 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl16:
                            // 2 sources

                            if ((var2_3 = (Bitmap)v2) != null) {
                                var4_4 = var2_3;
                                var5_5 = this.this$0;
                                bitmap = var4_4;
                                $i$a$-let-AttachmentGalleryActivity$shareImage$1$1 = false;
                                v3 = var5_5.getApplicationContext();
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getApplicationContext(...)");
                                var3_9 = StreamFileUtil.INSTANCE.writeImageToSharableFile(v3, bitmap);
                                if (var3_9 != null) {
                                    var4_4 = var3_9;
                                    var5_5 = this.this$0;
                                    var6_6 = this.$attachment;
                                    it = var4_4;
                                    $i$a$-let-AttachmentGalleryActivity$shareImage$1$2 = false;
                                    AttachmentGalleryActivity.access$launchShareActivity(var5_5, (Uri)it, var6_6.getType());
                                }
                            }
                            AttachmentGalleryActivity.access$setNoSharingInProgressUi(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else {
            this.toastFailedShare();
            this.setNoSharingInProgressUi();
        }
    }

    private final void shareVideo(Attachment attachment) {
        Job job = this.shareMediaJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.shareMediaJob = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), (CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, attachment, null){
            int label;
            final /* synthetic */ AttachmentGalleryActivity this$0;
            final /* synthetic */ Attachment $attachment;
            {
                this.this$0 = $receiver;
                this.$attachment = $attachment;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result<? extends Uri>>, Object>(this.this$0, this.$attachment, null){
                            int label;
                            final /* synthetic */ AttachmentGalleryActivity this$0;
                            final /* synthetic */ Attachment $attachment;
                            {
                                this.this$0 = $receiver;
                                this.$attachment = $attachment;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Context context = this.this$0.getApplicationContext();
                                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
                                        this.label = 1;
                                        Object object3 = StreamFileUtil.INSTANCE.writeFileToShareableFile(context, this.$attachment, (Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Result<? extends Uri>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((var3_4 = (result = (Result)v0)) instanceof Result.Success) {
                            AttachmentGalleryActivity.access$launchShareActivity(this.this$0, (Uri)((Result.Success)result).getValue(), this.$attachment.getType());
                        } else if (var3_4 instanceof Result.Failure) {
                            this.label = 2;
                            v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ AttachmentGalleryActivity this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            AttachmentGalleryActivity.access$toastFailedShare(this.this$0);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl25:
                        // 3 sources

                        this.label = 3;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ AttachmentGalleryActivity this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        AttachmentGalleryActivity.access$setNoSharingInProgressUi(this.this$0);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl33
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl33:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void launchShareActivity(Uri mediaUri, String attachmentType) {
        void $this$launchShareActivity_u24lambda_u243;
        String string2;
        String string3 = attachmentType;
        if (Intrinsics.areEqual((Object)string3, (Object)"image")) {
            string2 = "image/*";
        } else if (Intrinsics.areEqual((Object)string3, (Object)"video")) {
            string2 = "video/*";
        } else {
            this.toastFailedShare();
            return;
        }
        String type2 = string2;
        String string4 = string3 = new Intent("android.intent.action.SEND");
        Context context = (Context)this;
        boolean bl = false;
        $this$launchShareActivity_u24lambda_u243.setType(type2);
        $this$launchShareActivity_u24lambda_u243.putExtra("android.intent.extra.STREAM", (Parcelable)mediaUri);
        $this$launchShareActivity_u24lambda_u243.addFlags(1);
        ContextCompat.startActivity((Context)context, (Intent)Intent.createChooser((Intent)string3, (CharSequence)this.getString(R.string.stream_ui_attachment_gallery_share)), null);
    }

    private final void toastFailedShare() {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getApplicationContext().getString(R.string.stream_ui_attachment_gallery_share_error), (int)0).show();
    }

    private final void setupAttachmentActionsButton() {
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        streamUiActivityAttachmentGalleryBinding.attachmentActionsButton.setOnClickListener(arg_0 -> AttachmentGalleryActivity.setupAttachmentActionsButton$lambda$7(this, arg_0));
    }

    private final void observePageChanges() {
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        streamUiActivityAttachmentGalleryBinding.galleryViewPager.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback(this){
            final /* synthetic */ AttachmentGalleryActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPageSelected(int position) {
                AttachmentGalleryActivity.access$onGalleryPageSelected(this.this$0, position);
            }
        });
        this.onGalleryPageSelected(this.getInitialIndex());
    }

    private final void setResultAndFinish(AttachmentOptionResult result2) {
        Intent intent;
        Intent $this$setResultAndFinish_u24lambda_u249 = intent = new Intent();
        boolean bl = false;
        $this$setResultAndFinish_u24lambda_u249.putExtra(EXTRA_ATTACHMENT_OPTION_RESULT, (Parcelable)result2);
        this.setResult(-1, $this$setResultAndFinish_u24lambda_u249);
        this.finish();
    }

    /*
     * WARNING - void declaration
     */
    private final void onGalleryPageSelected(int position) {
        void $this$isVisible$iv;
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        Object[] objectArray = new Object[]{position + 1, this.attachmentGalleryItems.size()};
        streamUiActivityAttachmentGalleryBinding.mediaInformationTextView.setText((CharSequence)this.getString(R.string.stream_ui_attachment_gallery_count, objectArray));
        AttachmentGalleryItem currentItem = this.attachmentGalleryItems.get(position);
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding2 = this.binding;
        if (streamUiActivityAttachmentGalleryBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding2 = null;
        }
        streamUiActivityAttachmentGalleryBinding2.attachmentDateTextView.setText((CharSequence)this.getRelativeAttachmentDate(currentItem.getCreatedAt()));
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding3 = this.binding;
        if (streamUiActivityAttachmentGalleryBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding3 = null;
        }
        streamUiActivityAttachmentGalleryBinding3.userTextView.setText((CharSequence)currentItem.getUser().getName());
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding4 = this.binding;
        if (streamUiActivityAttachmentGalleryBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding4 = null;
        }
        ImageView imageView = streamUiActivityAttachmentGalleryBinding4.attachmentActionsButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"attachmentActionsButton");
        View view = (View)imageView;
        boolean value$iv = this.shouldShowOptionsButton(currentItem.isMine());
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
    }

    /*
     * WARNING - void declaration
     */
    private final String getRelativeAttachmentDate(Date createdAt) {
        String string2;
        Object object;
        String string3 = ((Object)DateUtils.getRelativeTimeSpanString((long)createdAt.getTime(), (long)System.currentTimeMillis(), (long)86400000L, (int)262144)).toString();
        if (((CharSequence)string3).length() > 0) {
            void p0;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string4 = String.valueOf((char)p0);
            Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
            String string5 = string4.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string5);
            object = string3;
            int n = 1;
            String string6 = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string2 = stringBuilder2.append(string6).toString();
        } else {
            string2 = string3;
        }
        String relativeDay = string2;
        object = new Object[]{relativeDay, ChatUI.getDateFormatter().formatTime(createdAt)};
        String string7 = this.getString(R.string.stream_ui_attachment_gallery_date, (Object[])object);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getString(...)");
        return string7;
    }

    private final void setupGalleryOverviewButton() {
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        streamUiActivityAttachmentGalleryBinding.galleryOverviewButton.setOnClickListener(arg_0 -> AttachmentGalleryActivity.setupGalleryOverviewButton$lambda$11(this, arg_0));
    }

    private final void enterFullScreenMode() {
        View $this$isVisible$iv;
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        StreamUiActivityAttachmentGalleryBinding $this$enterFullScreenMode_u24lambda_u2413 = streamUiActivityAttachmentGalleryBinding;
        boolean bl = false;
        ConstraintLayout constraintLayout = $this$enterFullScreenMode_u24lambda_u2413.toolbar;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"toolbar");
        View view = (View)constraintLayout;
        boolean value$iv = false;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        ConstraintLayout constraintLayout2 = $this$enterFullScreenMode_u24lambda_u2413.bottomBar;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"bottomBar");
        $this$isVisible$iv = (View)constraintLayout2;
        value$iv = false;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        $this$enterFullScreenMode_u24lambda_u2413.galleryViewPager.setBackgroundColor(ContextKt.getColorCompat((Context)this, R.color.stream_ui_literal_black));
        View $this$enterFullScreenMode_u24lambda_u2413_u24lambda_u2412 = view = new ConstraintSet();
        boolean bl2 = false;
        ViewPager2 viewPager2 = $this$enterFullScreenMode_u24lambda_u2413.galleryViewPager;
        Intrinsics.checkNotNullExpressionValue((Object)viewPager2, (String)"galleryViewPager");
        ConstraintLayoutKt.constrainViewToParentBySide((ConstraintSet)$this$enterFullScreenMode_u24lambda_u2413_u24lambda_u2412, (View)viewPager2, 3);
        ViewPager2 viewPager22 = $this$enterFullScreenMode_u24lambda_u2413.galleryViewPager;
        Intrinsics.checkNotNullExpressionValue((Object)viewPager22, (String)"galleryViewPager");
        ConstraintLayoutKt.constrainViewToParentBySide((ConstraintSet)$this$enterFullScreenMode_u24lambda_u2413_u24lambda_u2412, (View)viewPager22, 4);
        ViewPager2 viewPager23 = $this$enterFullScreenMode_u24lambda_u2413.galleryViewPager;
        Intrinsics.checkNotNullExpressionValue((Object)viewPager23, (String)"galleryViewPager");
        ConstraintLayoutKt.constrainViewToParentBySide((ConstraintSet)$this$enterFullScreenMode_u24lambda_u2413_u24lambda_u2412, (View)viewPager23, 6);
        ViewPager2 viewPager24 = $this$enterFullScreenMode_u24lambda_u2413.galleryViewPager;
        Intrinsics.checkNotNullExpressionValue((Object)viewPager24, (String)"galleryViewPager");
        ConstraintLayoutKt.constrainViewToParentBySide((ConstraintSet)$this$enterFullScreenMode_u24lambda_u2413_u24lambda_u2412, (View)viewPager24, 7);
        view.applyTo($this$enterFullScreenMode_u24lambda_u2413.getRoot());
    }

    private final void exitFullScreenMode() {
        View $this$isVisible$iv;
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        StreamUiActivityAttachmentGalleryBinding $this$exitFullScreenMode_u24lambda_u2415 = streamUiActivityAttachmentGalleryBinding;
        boolean bl = false;
        ConstraintLayout constraintLayout = $this$exitFullScreenMode_u24lambda_u2415.toolbar;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"toolbar");
        View view = (View)constraintLayout;
        boolean value$iv = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        ConstraintLayout constraintLayout2 = $this$exitFullScreenMode_u24lambda_u2415.bottomBar;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"bottomBar");
        $this$isVisible$iv = (View)constraintLayout2;
        value$iv = true;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        $this$exitFullScreenMode_u24lambda_u2415.galleryViewPager.setBackgroundColor(ContextKt.getColorCompat((Context)this, R.color.stream_ui_white_snow));
        View $this$exitFullScreenMode_u24lambda_u2415_u24lambda_u2414 = view = new ConstraintSet();
        boolean bl2 = false;
        int n = $this$exitFullScreenMode_u24lambda_u2415.galleryViewPager.getId();
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding2 = this.binding;
        if (streamUiActivityAttachmentGalleryBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding2 = null;
        }
        $this$exitFullScreenMode_u24lambda_u2415_u24lambda_u2414.connect(n, 3, streamUiActivityAttachmentGalleryBinding2.toolbar.getId(), 4, 0);
        int n2 = $this$exitFullScreenMode_u24lambda_u2415.galleryViewPager.getId();
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding3 = this.binding;
        if (streamUiActivityAttachmentGalleryBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding3 = null;
        }
        $this$exitFullScreenMode_u24lambda_u2415_u24lambda_u2414.connect(n2, 4, streamUiActivityAttachmentGalleryBinding3.bottomBar.getId(), 3, 0);
        ViewPager2 viewPager2 = $this$exitFullScreenMode_u24lambda_u2415.galleryViewPager;
        Intrinsics.checkNotNullExpressionValue((Object)viewPager2, (String)"galleryViewPager");
        ConstraintLayoutKt.constrainViewToParentBySide((ConstraintSet)$this$exitFullScreenMode_u24lambda_u2415_u24lambda_u2414, (View)viewPager2, 6);
        ViewPager2 viewPager22 = $this$exitFullScreenMode_u24lambda_u2415.galleryViewPager;
        Intrinsics.checkNotNullExpressionValue((Object)viewPager22, (String)"galleryViewPager");
        ConstraintLayoutKt.constrainViewToParentBySide((ConstraintSet)$this$exitFullScreenMode_u24lambda_u2415_u24lambda_u2414, (View)viewPager22, 7);
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding4 = this.binding;
        if (streamUiActivityAttachmentGalleryBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding4 = null;
        }
        view.applyTo(streamUiActivityAttachmentGalleryBinding4.getRoot());
    }

    private final void setSharingInProgressUi() {
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding;
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4;
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding2 = this.binding;
        if (streamUiActivityAttachmentGalleryBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding2 = null;
        }
        StreamUiActivityAttachmentGalleryBinding $this$setSharingInProgressUi_u24lambda_u2417 = streamUiActivityAttachmentGalleryBinding2;
        boolean bl = false;
        $this$setSharingInProgressUi_u24lambda_u2417.mediaInformationTextView.setText((CharSequence)this.getApplicationContext().getString(R.string.stream_ui_attachment_gallery_preview_preparing));
        $this$setSharingInProgressUi_u24lambda_u2417.progressBar.setVisibility(0);
        Drawable drawable5 = ContextCompat.getDrawable((Context)this.getApplicationContext(), (int)R.drawable.stream_ui_ic_clear);
        if (drawable5 != null && (drawable4 = drawable5.mutate()) != null) {
            Drawable drawable6;
            Drawable $this$setSharingInProgressUi_u24lambda_u2417_u24lambda_u2416 = drawable6 = drawable4;
            boolean bl2 = false;
            $this$setSharingInProgressUi_u24lambda_u2417_u24lambda_u2416.setTint(ContextCompat.getColor((Context)this.getApplicationContext(), (int)R.color.stream_ui_black));
            drawable3 = drawable6;
        } else {
            drawable3 = drawable2 = null;
        }
        if ((streamUiActivityAttachmentGalleryBinding = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        streamUiActivityAttachmentGalleryBinding.shareMediaButton.setImageDrawable(drawable2);
    }

    private final void setNoSharingInProgressUi() {
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        StreamUiActivityAttachmentGalleryBinding $this$setNoSharingInProgressUi_u24lambda_u2418 = streamUiActivityAttachmentGalleryBinding;
        boolean bl = false;
        $this$setNoSharingInProgressUi_u24lambda_u2418.progressBar.setVisibility(8);
        $this$setNoSharingInProgressUi_u24lambda_u2418.shareMediaButton.setImageDrawable(ContextCompat.getDrawable((Context)this.getApplicationContext(), (int)R.drawable.stream_ui_ic_share));
        Object[] objectArray = new Object[]{$this$setNoSharingInProgressUi_u24lambda_u2418.galleryViewPager.getCurrentItem() + 1, this.attachmentGalleryItems.size()};
        $this$setNoSharingInProgressUi_u24lambda_u2418.mediaInformationTextView.setText((CharSequence)this.getString(R.string.stream_ui_attachment_gallery_count, objectArray));
    }

    private final void obtainOptionsViewStyle() {
        block2: {
            try {
                TypedArray typedArray = ContextKt.createStreamThemeWrapper((Context)this).obtainStyledAttributes(null, R.styleable.AttachmentOptionsView, R.attr.streamUiAttachmentGalleryOptionsStyle, R.style.StreamUi_AttachmentGallery_Options);
                Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
                TypedArray $this$use$iv = typedArray;
                boolean $i$f$use = false;
                TypedArray it = $this$use$iv;
                boolean bl = false;
                AttachmentGalleryOptionsViewStyle style2 = AttachmentGalleryOptionsViewStyle.Companion.invoke((Context)this, it);
                this.replyOptionEnabled = style2.getReplyOptionEnabled();
                this.showInChatOptionEnabled = style2.getShowInChatOptionEnabled();
                this.saveMediaOptionEnabled = style2.getSaveMediaOptionEnabled();
                this.deleteOptionEnabled = style2.getDeleteOptionEnabled();
                $this$use$iv.recycle();
            }
            catch (Exception e) {
                TaggedLogger this_$iv = this.getLogger();
                boolean $i$f$e = false;
                if (!this_$iv.getValidator().isLoggable(Priority.ERROR, this_$iv.getTag())) break block2;
                String string2 = this_$iv.getTag();
                Priority priority = Priority.ERROR;
                StreamLogger streamLogger = this_$iv.getDelegate();
                boolean bl = false;
                String string3 = "Failed to obtain styles";
                streamLogger.log(priority, string2, string3, (Throwable)e);
            }
        }
    }

    private final boolean shouldShowOptionsButton(boolean isMine) {
        return this.replyOptionEnabled || this.showInChatOptionEnabled || this.saveMediaOptionEnabled || this.deleteOptionEnabled && isMine;
    }

    protected void onDestroy() {
        super.onDestroy();
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
        StreamFileUtil.INSTANCE.clearStreamCache(context);
    }

    private static final void onCreate$lambda$0(AttachmentGalleryActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onBackPressed();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void setupShareMediaButton$lambda$2(AttachmentGalleryActivity this$0, View it) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                if (this$0.shareMediaJob == null) break block4;
                Job job = this$0.shareMediaJob;
                boolean bl = job != null ? job.isCompleted() : false;
                if (!bl) break block5;
            }
            this$0.setSharingInProgressUi();
            this$0.shareMedia();
            return;
        }
        Job job = this$0.shareMediaJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this$0.setNoSharingInProgressUi();
    }

    private static final void setupAttachmentActionsButton$lambda$7$lambda$4(AttachmentGalleryActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setResultAndFinish(new AttachmentOptionResult.ShowInChat(this$0.getAttachmentGalleryResultItem()));
    }

    private static final void setupAttachmentActionsButton$lambda$7$lambda$5(AttachmentGalleryActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setResultAndFinish(new AttachmentOptionResult.Delete(this$0.getAttachmentGalleryResultItem()));
    }

    private static final void setupAttachmentActionsButton$lambda$7$lambda$6(AttachmentGalleryActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setResultAndFinish(new AttachmentOptionResult.Reply(this$0.getAttachmentGalleryResultItem()));
    }

    private static final void setupAttachmentActionsButton$lambda$7(AttachmentGalleryActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        AttachmentGalleryOptionsDialogFragment.Companion companion = AttachmentGalleryOptionsDialogFragment.Companion;
        AttachmentGalleryOptionsDialogFragment.AttachmentOptionHandler attachmentOptionHandler = () -> AttachmentGalleryActivity.setupAttachmentActionsButton$lambda$7$lambda$4(this$0);
        AttachmentGalleryOptionsDialogFragment.AttachmentOptionHandler attachmentOptionHandler2 = () -> AttachmentGalleryActivity.setupAttachmentActionsButton$lambda$7$lambda$5(this$0);
        AttachmentGalleryOptionsDialogFragment.AttachmentOptionHandler attachmentOptionHandler3 = () -> AttachmentGalleryActivity.setupAttachmentActionsButton$lambda$7$lambda$6(this$0);
        AttachmentGalleryOptionsDialogFragment.AttachmentOptionHandler attachmentOptionHandler4 = this$0.handleSaveMedia;
        List<AttachmentGalleryItem> list = this$0.attachmentGalleryItems;
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this$0.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        boolean bl = list.get(streamUiActivityAttachmentGalleryBinding.galleryViewPager.getCurrentItem()).isMine();
        companion.newInstance(attachmentOptionHandler, attachmentOptionHandler3, attachmentOptionHandler2, attachmentOptionHandler4, bl).show(this$0.getSupportFragmentManager(), "AttachmentOptionsDialogFragment");
    }

    private static final void handleSaveMedia$lambda$8(AttachmentGalleryActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        PermissionChecker permissionChecker = this$0.permissionChecker;
        StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = this$0.binding;
        if (streamUiActivityAttachmentGalleryBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            streamUiActivityAttachmentGalleryBinding = null;
        }
        ConstraintLayout constraintLayout = streamUiActivityAttachmentGalleryBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
        PermissionChecker.checkWriteStoragePermissions$default(permissionChecker, (View)constraintLayout, null, (Function0)new Function0<Unit>(this$0){
            final /* synthetic */ AttachmentGalleryActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AttachmentGalleryActivity.access$setResultAndFinish(this.this$0, new AttachmentOptionResult.Download(AttachmentGalleryActivity.access$getAttachmentGalleryResultItem(this.this$0)));
            }
        }, 2, null);
    }

    private static final void setupGalleryOverviewButton$lambda$11(AttachmentGalleryActivity this$0, View it) {
        MediaAttachmentDialogFragment mediaAttachmentDialogFragment;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        MediaAttachmentDialogFragment $this$setupGalleryOverviewButton_u24lambda_u2411_u24lambda_u2410 = mediaAttachmentDialogFragment = MediaAttachmentDialogFragment.Companion.newInstance();
        boolean bl = false;
        $this$setupGalleryOverviewButton_u24lambda_u2411_u24lambda_u2410.setMediaClickListener((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this$0, $this$setupGalleryOverviewButton_u24lambda_u2411_u24lambda_u2410){
            final /* synthetic */ AttachmentGalleryActivity this$0;
            final /* synthetic */ MediaAttachmentDialogFragment $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
                super(1);
            }

            public final void invoke(int it) {
                StreamUiActivityAttachmentGalleryBinding streamUiActivityAttachmentGalleryBinding = AttachmentGalleryActivity.access$getBinding$p(this.this$0);
                if (streamUiActivityAttachmentGalleryBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
                    streamUiActivityAttachmentGalleryBinding = null;
                }
                streamUiActivityAttachmentGalleryBinding.galleryViewPager.setCurrentItem(it, true);
                this.$this_apply.dismiss();
            }
        }));
        mediaAttachmentDialogFragment.show(this$0.getSupportFragmentManager(), null);
    }

    @JvmStatic
    @NotNull
    public static final Intent createIntent(@NotNull Context context, int initialIndex2) {
        return Companion.createIntent(context, initialIndex2);
    }

    public static final /* synthetic */ void access$setupGallery(AttachmentGalleryActivity $this, List attachmentGalleryItems) {
        $this.setupGallery(attachmentGalleryItems);
    }

    public static final /* synthetic */ void access$setFullScreen$p(AttachmentGalleryActivity $this, boolean bl) {
        $this.isFullScreen = bl;
    }

    public static final /* synthetic */ boolean access$isFullScreen$p(AttachmentGalleryActivity $this) {
        return $this.isFullScreen;
    }

    public static final /* synthetic */ void access$enterFullScreenMode(AttachmentGalleryActivity $this) {
        $this.enterFullScreenMode();
    }

    public static final /* synthetic */ void access$exitFullScreenMode(AttachmentGalleryActivity $this) {
        $this.exitFullScreenMode();
    }

    public static final /* synthetic */ void access$setNoSharingInProgressUi(AttachmentGalleryActivity $this) {
        $this.setNoSharingInProgressUi();
    }

    public static final /* synthetic */ void access$launchShareActivity(AttachmentGalleryActivity $this, Uri mediaUri, String attachmentType) {
        $this.launchShareActivity(mediaUri, attachmentType);
    }

    public static final /* synthetic */ void access$toastFailedShare(AttachmentGalleryActivity $this) {
        $this.toastFailedShare();
    }

    public static final /* synthetic */ void access$onGalleryPageSelected(AttachmentGalleryActivity $this, int position) {
        $this.onGalleryPageSelected(position);
    }

    public static final /* synthetic */ void access$setResultAndFinish(AttachmentGalleryActivity $this, AttachmentOptionResult result2) {
        $this.setResultAndFinish(result2);
    }

    public static final /* synthetic */ AttachmentGalleryResultItem access$getAttachmentGalleryResultItem(AttachmentGalleryActivity $this) {
        return $this.getAttachmentGalleryResultItem();
    }

    public static final /* synthetic */ StreamUiActivityAttachmentGalleryBinding access$getBinding$p(AttachmentGalleryActivity $this) {
        return $this.binding;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentDeleteOptionHandler;", "", "onClick", "", "result", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "stream-chat-android-ui-components_release"})
    public static interface AttachmentDeleteOptionHandler {
        public void onClick(@NotNull AttachmentGalleryResultItem var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentDownloadOptionHandler;", "", "onClick", "", "result", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "stream-chat-android-ui-components_release"})
    public static interface AttachmentDownloadOptionHandler {
        public void onClick(@NotNull AttachmentGalleryResultItem var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult;", "Landroid/os/Parcelable;", "result", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "(Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;)V", "getResult", "()Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "Delete", "Download", "Reply", "ShowInChat", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult$Delete;", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult$Download;", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult$Reply;", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult$ShowInChat;", "stream-chat-android-ui-components_release"})
    public static abstract class AttachmentOptionResult
    implements Parcelable {
        @NotNull
        private final AttachmentGalleryResultItem result;

        private AttachmentOptionResult(AttachmentGalleryResultItem result2) {
            this.result = result2;
        }

        @NotNull
        public AttachmentGalleryResultItem getResult() {
            return this.result;
        }

        public /* synthetic */ AttachmentOptionResult(AttachmentGalleryResultItem result2, DefaultConstructorMarker $constructor_marker) {
            this(result2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult$Delete;", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult;", "result", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "(Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;)V", "getResult", "()Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stream-chat-android-ui-components_release"})
        @Parcelize
        public static final class Delete
        extends AttachmentOptionResult {
            @NotNull
            private final AttachmentGalleryResultItem result;
            @NotNull
            public static final Parcelable.Creator<Delete> CREATOR;

            public Delete(@NotNull AttachmentGalleryResultItem result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                super(result2, null);
                this.result = result2;
            }

            @Override
            @NotNull
            public AttachmentGalleryResultItem getResult() {
                return this.result;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                this.result.writeToParcel(out, flags);
            }

            static {
                @Metadata(mv={1, 9, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Delete> {
                    @NotNull
                    public final Delete[] newArray(int size) {
                        return new Delete[size];
                    }

                    @NotNull
                    public final Delete createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new Delete((AttachmentGalleryResultItem)AttachmentGalleryResultItem.CREATOR.createFromParcel(parcel));
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult$Download;", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult;", "result", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "(Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;)V", "getResult", "()Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stream-chat-android-ui-components_release"})
        @Parcelize
        public static final class Download
        extends AttachmentOptionResult {
            @NotNull
            private final AttachmentGalleryResultItem result;
            @NotNull
            public static final Parcelable.Creator<Download> CREATOR;

            public Download(@NotNull AttachmentGalleryResultItem result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                super(result2, null);
                this.result = result2;
            }

            @Override
            @NotNull
            public AttachmentGalleryResultItem getResult() {
                return this.result;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                this.result.writeToParcel(out, flags);
            }

            static {
                @Metadata(mv={1, 9, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Download> {
                    @NotNull
                    public final Download[] newArray(int size) {
                        return new Download[size];
                    }

                    @NotNull
                    public final Download createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new Download((AttachmentGalleryResultItem)AttachmentGalleryResultItem.CREATOR.createFromParcel(parcel));
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult$Reply;", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult;", "result", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "(Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;)V", "getResult", "()Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stream-chat-android-ui-components_release"})
        @Parcelize
        public static final class Reply
        extends AttachmentOptionResult {
            @NotNull
            private final AttachmentGalleryResultItem result;
            @NotNull
            public static final Parcelable.Creator<Reply> CREATOR;

            public Reply(@NotNull AttachmentGalleryResultItem result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                super(result2, null);
                this.result = result2;
            }

            @Override
            @NotNull
            public AttachmentGalleryResultItem getResult() {
                return this.result;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                this.result.writeToParcel(out, flags);
            }

            static {
                @Metadata(mv={1, 9, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<Reply> {
                    @NotNull
                    public final Reply[] newArray(int size) {
                        return new Reply[size];
                    }

                    @NotNull
                    public final Reply createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new Reply((AttachmentGalleryResultItem)AttachmentGalleryResultItem.CREATOR.createFromParcel(parcel));
                    }
                }
                CREATOR = new Creator();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult$ShowInChat;", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentOptionResult;", "result", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "(Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;)V", "getResult", "()Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stream-chat-android-ui-components_release"})
        @Parcelize
        public static final class ShowInChat
        extends AttachmentOptionResult {
            @NotNull
            private final AttachmentGalleryResultItem result;
            @NotNull
            public static final Parcelable.Creator<ShowInChat> CREATOR;

            public ShowInChat(@NotNull AttachmentGalleryResultItem result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                super(result2, null);
                this.result = result2;
            }

            @Override
            @NotNull
            public AttachmentGalleryResultItem getResult() {
                return this.result;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(@NotNull Parcel out, int flags) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                this.result.writeToParcel(out, flags);
            }

            static {
                @Metadata(mv={1, 9, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<ShowInChat> {
                    @NotNull
                    public final ShowInChat[] newArray(int size) {
                        return new ShowInChat[size];
                    }

                    @NotNull
                    public final ShowInChat createFromParcel(@NotNull Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new ShowInChat((AttachmentGalleryResultItem)AttachmentGalleryResultItem.CREATOR.createFromParcel(parcel));
                    }
                }
                CREATOR = new Creator();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentReplyOptionHandler;", "", "onClick", "", "result", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "stream-chat-android-ui-components_release"})
    public static interface AttachmentReplyOptionHandler {
        public void onClick(@NotNull AttachmentGalleryResultItem var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$AttachmentShowInChatOptionHandler;", "", "onClick", "", "result", "Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryResultItem;", "stream-chat-android-ui-components_release"})
    public static interface AttachmentShowInChatOptionHandler {
        public void onClick(@NotNull AttachmentGalleryResultItem var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/getstream/chat/android/ui/feature/gallery/AttachmentGalleryActivity$Companion;", "", "()V", "EXTRA_ATTACHMENT_OPTION_RESULT", "", "EXTRA_KEY_INITIAL_INDEX", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "initialIndex", "", "stream-chat-android-ui-components_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Intent createIntent(@NotNull Context context, int initialIndex2) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent $this$createIntent_u24lambda_u240 = intent = new Intent(context, AttachmentGalleryActivity.class);
            boolean bl = false;
            $this$createIntent_u24lambda_u240.putExtra(AttachmentGalleryActivity.EXTRA_KEY_INITIAL_INDEX, initialIndex2);
            return intent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

